/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.rcp.actions;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.SnapshotHistoryService;
import org.eclipse.mat.ui.rcp.Messages;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.intro.config.IIntroContentProvider;
import org.eclipse.ui.intro.config.IIntroContentProviderSite;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.osgi.framework.Bundle;

public class SnapshotHistoryIntroContentProvider
implements IIntroContentProvider {
    private static final String DUMP_ICON = "../intro/css/icons/heapdump.gif";
    private static final String RESOURCE_ICON = "../intro/css/icons/resource.gif";
    private Image bulletImage;
    private boolean disposed;
    private FormText formText;

    public void init(IIntroContentProviderSite site) {
    }

    public void createContent(String id, PrintWriter out) {
        if (this.disposed) {
            return;
        }
        List lastFiles = SnapshotHistoryService.getInstance().getVisitedEntries();
        if (lastFiles == null) {
            out.print("<p class=\"status-text\">");
            out.print(Messages.SnapshotHistoryIntroContentProvider_PleaseWait);
            out.println("</p>");
        } else {
            if (!lastFiles.isEmpty()) {
                out.println("<ul id=\"snapshot_history\">");
                for (SnapshotHistoryService.Entry entry : lastFiles) {
                    String icon = "org.eclipse.mat.ui.editors.HeapEditor".equals(entry.getEditorId()) ? DUMP_ICON : RESOURCE_ICON;
                    out.print("<li><img src =\"");
                    out.print(icon);
                    out.print("\">");
                    out.print("<a class=\"topicList\" href=\"http://org.eclipse.ui.intro/runAction?pluginId=org.eclipse.mat.ui.rcp&amp;class=org.eclipse.mat.ui.rcp.actions.OpenEditorAction&amp;param=");
                    out.print(entry.getFilePath());
                    out.print("&amp;editorId=");
                    out.print(entry.getEditorId());
                    out.print("\">");
                    out.print(entry.getFilePath());
                    out.print("</a>");
                    out.println("</li>");
                }
            } else {
                out.print("<p class=\"status-text\">");
                out.print(Messages.SnapshotHistoryIntroContentProvider_HistoryIsEmpty);
                out.println("</p>");
            }
            out.println("</ul>");
        }
    }

    public void createContent(String id, Composite parent, FormToolkit toolkit) {
        if (this.disposed) {
            return;
        }
        List lastFiles = SnapshotHistoryService.getInstance().getVisitedEntries();
        if (this.formText == null) {
            this.formText = toolkit.createFormText(parent, true);
            this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    SnapshotHistoryIntroContentProvider.this.openHeapDump((String)e.getHref());
                }
            });
            this.bulletImage = this.createImage((IPath)new Path("intro/css/icons/arrow.gif"));
            if (this.bulletImage != null) {
                this.formText.setImage("bullet", this.bulletImage);
            }
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<form>");
        if (lastFiles == null) {
            buffer.append("<p>");
            buffer.append(Messages.SnapshotHistoryIntroContentProvider_PleaseWait);
            buffer.append("</p>");
        } else if (lastFiles.size() > 0) {
            for (SnapshotHistoryService.Entry entry : lastFiles) {
                String icon = "org.eclipse.mat.ui.editors.HeapEditor".equals(entry.getEditorId()) ? DUMP_ICON : RESOURCE_ICON;
                buffer.append("<li style=\"image\" value=\"bullet\">");
                buffer.append("<img src =\"").append(icon).append("\"/>");
                buffer.append("<a href=\"http://org.eclipse.ui.intro/runAction?standby=true&amp;pluginId=org.eclipse.mat.ui.rcp&amp;class=org.eclipse.mat.ui.rcp.actions.OpenEditorAction&amp;param=");
                buffer.append(entry.getFilePath());
                buffer.append("&amp;editorId=");
                buffer.append(entry.getEditorId());
                buffer.append("\">");
                buffer.append(entry.getFilePath());
                buffer.append("</a>");
                buffer.append("</li>");
            }
        } else {
            buffer.append("<p>");
            buffer.append(Messages.SnapshotHistoryIntroContentProvider_HistoryIsEmpty);
            buffer.append("</p>");
        }
        buffer.append("</form>");
        this.formText.setText(buffer.toString(), true, false);
    }

    private Image createImage(IPath path) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.mat.ui.rcp");
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url == null) {
            return null;
        }
        try {
            url = FileLocator.toFileURL((URL)url);
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            return desc.createImage();
        }
        catch (IOException e) {
            MemoryAnalyserPlugin.log((Throwable)e, (String)Messages.SnapshotHistoryIntroContentProvider_ErrorCreatingImage);
            return null;
        }
    }

    public void dispose() {
        if (this.bulletImage != null) {
            this.bulletImage.dispose();
            this.bulletImage = null;
        }
        this.disposed = true;
    }

    private void openHeapDump(final String href) {
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                IIntroURL introUrl = IntroURLFactory.createIntroURL((String)href);
                if (introUrl != null) {
                    introUrl.execute();
                    return;
                }
            }
        });
    }
}

