/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.jobs.ProgressProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogBlockedHandler;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Throttler;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.EventLoopProgressMonitor;
import org.eclipse.ui.internal.dialogs.WorkbenchDialogBlockedHandler;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.IJobBusyListener;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressMonitorFocusJobDialog;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.internal.progress.ProgressViewUpdater;
import org.eclipse.ui.internal.progress.StatusAdapterHelper;
import org.eclipse.ui.internal.progress.TaskInfo;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class ProgressManager
extends ProgressProvider
implements IProgressService {
    @Deprecated
    public static final QualifiedName PROPERTY_IN_DIALOG = IProgressConstants.PROPERTY_IN_DIALOG;
    private static final String ERROR_JOB = "errorstate.png";
    static final String ERROR_JOB_KEY = "ERROR_JOB";
    private static ProgressManager singleton;
    private final Set<Job> managedJobs = ConcurrentHashMap.newKeySet();
    private final Map<Object, Collection<IJobBusyListener>> familyListeners = Collections.synchronizedMap(new LinkedHashMap());
    private ListenerList<IJobProgressManagerListener> listeners = new ListenerList();
    final IJobChangeListener changeListener;
    static final String PROGRESS_VIEW_NAME = "org.eclipse.ui.views.ProgressView";
    static final String PROGRESS_FOLDER = "$nl$/icons/full/progress/";
    private static final String SLEEPING_JOB = "sleeping.png";
    private static final String WAITING_JOB = "waiting.png";
    private static final String BLOCKED_JOB = "lockedstate.png";
    public static final String SLEEPING_JOB_KEY = "SLEEPING_JOB";
    public static final String WAITING_JOB_KEY = "WAITING_JOB";
    public static final String BLOCKED_JOB_KEY = "LOCKED_JOB";
    final Map<Job, JobMonitor> runnableMonitors = new HashMap<Job, JobMonitor>();
    private Hashtable<Object, String> imageKeyTable = new Hashtable();
    private final Object pendingUpdatesMutex = new Object();
    private Map<JobInfo, Set<IJobProgressManagerListener>> pendingJobUpdates = new LinkedHashMap<JobInfo, Set<IJobProgressManagerListener>>();
    private Set<GroupInfo> pendingGroupUpdates = new LinkedHashSet<GroupInfo>();
    private Map<JobInfo, Set<IJobProgressManagerListener>> pendingJobRemoval = new LinkedHashMap<JobInfo, Set<IJobProgressManagerListener>>();
    private Set<GroupInfo> pendingGroupRemoval = new LinkedHashSet<GroupInfo>();
    private Map<JobInfo, Set<IJobProgressManagerListener>> pendingJobAddition = new LinkedHashMap<JobInfo, Set<IJobProgressManagerListener>>();
    private static final String IMAGE_KEY = "org.eclipse.ui.progress.images";
    private final Throttler uiRefreshThrottler;

    public static ProgressManager getInstance() {
        if (singleton == null) {
            singleton = new ProgressManager();
        }
        return singleton;
    }

    public static void shutdownProgressManager() {
        if (singleton == null) {
            return;
        }
        singleton.shutdown();
    }

    ProgressManager() {
        Dialog.setBlockedHandler((IDialogBlockedHandler)new WorkbenchDialogBlockedHandler());
        this.setUpImages();
        this.uiRefreshThrottler = new Throttler(Display.getDefault(), Duration.ofMillis(100L), this::notifyListeners);
        this.changeListener = this.createChangeListener();
        Job.getJobManager().setProgressProvider((ProgressProvider)this);
        Job.getJobManager().addJobChangeListener(this.changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners() {
        Map<JobInfo, Set<IJobProgressManagerListener>> localPendingJobAddition;
        Set<GroupInfo> localPendingGroupRemoval;
        Map<JobInfo, Set<IJobProgressManagerListener>> localPendingJobRemoval;
        Set<GroupInfo> localPendingGroupUpdates;
        Map<JobInfo, Set<IJobProgressManagerListener>> localPendingJobUpdates;
        Object object = this.pendingUpdatesMutex;
        synchronized (object) {
            localPendingJobUpdates = this.pendingJobUpdates;
            this.pendingJobUpdates = new LinkedHashMap<JobInfo, Set<IJobProgressManagerListener>>();
            localPendingGroupUpdates = this.pendingGroupUpdates;
            this.pendingGroupUpdates = new LinkedHashSet<GroupInfo>();
            localPendingJobRemoval = this.pendingJobRemoval;
            this.pendingJobRemoval = new LinkedHashMap<JobInfo, Set<IJobProgressManagerListener>>();
            localPendingGroupRemoval = this.pendingGroupRemoval;
            this.pendingGroupRemoval = new LinkedHashSet<GroupInfo>();
            localPendingJobAddition = this.pendingJobAddition;
            this.pendingJobAddition = new LinkedHashMap<JobInfo, Set<IJobProgressManagerListener>>();
        }
        localPendingJobAddition.entrySet().forEach(e -> ((Set)e.getValue()).forEach(listener -> listener.addJob((JobInfo)e.getKey())));
        localPendingJobUpdates.entrySet().stream().map(e -> ((JobInfo)e.getKey()).getGroupInfo()).filter(Objects::nonNull).forEach(localPendingGroupUpdates::add);
        localPendingJobUpdates.entrySet().forEach(e -> ((Set)e.getValue()).forEach(listener -> listener.refreshJobInfo((JobInfo)e.getKey())));
        localPendingGroupUpdates.forEach(groupInfo -> this.listeners.forEach(listener -> listener.refreshGroup((GroupInfo)groupInfo)));
        localPendingJobRemoval.entrySet().forEach(e -> ((Set)e.getValue()).forEach(listener -> listener.removeJob((JobInfo)e.getKey())));
        localPendingGroupRemoval.forEach(group -> this.listeners.forEach(listener -> listener.removeGroup((GroupInfo)group)));
    }

    private void setUpImages() {
        URL iconsRoot = ProgressManagerUtil.getIconsRoot();
        try {
            this.setUpImage(iconsRoot, SLEEPING_JOB, SLEEPING_JOB_KEY);
            this.setUpImage(iconsRoot, WAITING_JOB, WAITING_JOB_KEY);
            this.setUpImage(iconsRoot, BLOCKED_JOB, BLOCKED_JOB_KEY);
            ImageDescriptor errorImage = ImageDescriptor.createFromURL((URL)new URL(iconsRoot, ERROR_JOB));
            JFaceResources.getImageRegistry().put(ERROR_JOB_KEY, errorImage);
        }
        catch (MalformedURLException e) {
            ProgressManagerUtil.logException(e);
        }
    }

    private IJobChangeListener createChangeListener() {
        return new JobChangeAdapter(){

            public void aboutToRun(IJobChangeEvent event) {
                JobInfo info = ProgressManager.this.progressFor(event.getJob()).getJobInfo();
                ProgressManager.this.refreshJobInfo(info);
                for (IJobBusyListener next : ProgressManager.this.busyListenersForJob(event.getJob())) {
                    next.incrementBusy(event.getJob());
                }
            }

            public void done(IJobChangeEvent event) {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                for (IJobBusyListener next : ProgressManager.this.busyListenersForJob(event.getJob())) {
                    next.decrementBusy(event.getJob());
                }
                JobInfo info = ProgressManager.this.removeJob(event.getJob());
                StatusAdapter statusAdapter = null;
                if (event.getJobGroupResult() != null && event.getJobGroupResult().getSeverity() == 4) {
                    statusAdapter = new StatusAdapter(event.getJobGroupResult());
                } else if (event.getResult() != null && event.getResult().getSeverity() == 4 && (event.getJob() == null || event.getJob().getJobGroup() == null)) {
                    statusAdapter = new StatusAdapter(event.getResult());
                    statusAdapter.addAdapter(Job.class, event.getJob());
                }
                if (statusAdapter != null) {
                    if (event.getJob().getProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY) == Boolean.TRUE) {
                        statusAdapter.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
                        StatusAdapterHelper.getInstance().putStatusAdapter(info, statusAdapter);
                    }
                    StatusManager.getManager().handle(statusAdapter, 2);
                }
            }

            public void scheduled(IJobChangeEvent event) {
                boolean noDialog;
                this.updateFor(event);
                if (event.getJob().isUser() && !(noDialog = ProgressManager.this.shouldRunInBackground())) {
                    final IJobChangeEvent finalEvent = event;
                    WorkbenchJob showJob = new WorkbenchJob(ProgressMessages.ProgressManager_showInDialogName){

                        @Override
                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            ProgressManager.this.showInDialog(null, finalEvent.getJob());
                            return Status.OK_STATUS;
                        }
                    };
                    showJob.setSystem(true);
                    showJob.schedule();
                    return;
                }
            }

            private void updateFor(IJobChangeEvent event) {
                if (ProgressManager.this.managedJobs.contains(event.getJob())) {
                    ProgressManager.this.refreshJobInfo(ProgressManager.this.progressFor(event.getJob()).getJobInfo());
                } else {
                    ProgressManager.this.addJobInfo(ProgressManager.this.progressFor(event.getJob()).getJobInfo());
                }
            }

            public void awake(IJobChangeEvent event) {
                this.updateFor(event);
            }

            public void sleeping(IJobChangeEvent event) {
                if (ProgressManager.this.managedJobs.contains(event.getJob())) {
                    ProgressManager.this.sleepJobInfo(ProgressManager.this.progressFor(event.getJob()).getJobInfo());
                }
            }
        };
    }

    protected void sleepJobInfo(JobInfo info) {
        GroupInfo group = info.getGroupInfo();
        if (group != null) {
            this.sleepGroup(group, info);
        }
        for (IJobProgressManagerListener listener : this.listeners) {
            if (this.isNeverDisplaying(info.getJob(), listener.showsDebug())) continue;
            if (listener.showsDebug()) {
                listener.refreshJobInfo(info);
                continue;
            }
            listener.removeJob(info);
        }
    }

    private void sleepGroup(GroupInfo group, JobInfo info) {
        for (IJobProgressManagerListener listener : this.listeners) {
            if (this.isNeverDisplaying(info.getJob(), listener.showsDebug())) continue;
            if (listener.showsDebug() || group.isActive()) {
                listener.refreshGroup(group);
                continue;
            }
            listener.removeGroup(group);
        }
    }

    private void setUpImage(URL iconsRoot, String fileName, String key) throws MalformedURLException {
        JFaceResources.getImageRegistry().put(key, ImageDescriptor.createFromURL((URL)new URL(iconsRoot, fileName)));
    }

    public IProgressMonitor createMonitor(Job job) {
        return this.progressFor(job);
    }

    public IProgressMonitor getDefaultMonitor() {
        Display display;
        if (PlatformUI.isWorkbenchRunning() && !PlatformUI.getWorkbench().isStarting() && !(display = PlatformUI.getWorkbench().getDisplay()).isDisposed() && display.getThread() == Thread.currentThread()) {
            return new EventLoopProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        }
        return super.getDefaultMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobMonitor progressFor(Job job) {
        Map<Job, JobMonitor> map = this.runnableMonitors;
        synchronized (map) {
            return this.runnableMonitors.computeIfAbsent(job, j -> new JobMonitor((Job)j, new JobInfo((Job)j)));
        }
    }

    void addListener(IJobProgressManagerListener listener) {
        this.listeners.add((Object)listener);
    }

    void removeListener(IJobProgressManagerListener listener) {
        this.listeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshJobInfo(JobInfo info) {
        Object object = this.pendingUpdatesMutex;
        synchronized (object) {
            Predicate<IJobProgressManagerListener> predicate = listener -> !this.isNeverDisplaying(info.getJob(), listener.showsDebug());
            this.rememberListenersForJob(info, this.pendingJobUpdates, predicate);
        }
        this.uiRefreshThrottler.throttledExec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshGroup(GroupInfo info) {
        Object object = this.pendingUpdatesMutex;
        synchronized (object) {
            this.pendingGroupUpdates.add(info);
        }
        this.uiRefreshThrottler.throttledExec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo removeJob(Job job) {
        JobInfo info;
        Map<Job, JobMonitor> map = this.runnableMonitors;
        synchronized (map) {
            info = this.progressFor(job).getJobInfo();
            this.managedJobs.remove(job);
            Object object = this.pendingUpdatesMutex;
            synchronized (object) {
                Predicate<IJobProgressManagerListener> predicate = listener -> !this.isNeverDisplaying(info.getJob(), listener.showsDebug());
                this.rememberListenersForJob(info, this.pendingJobRemoval, predicate);
            }
            this.runnableMonitors.remove(job);
        }
        this.uiRefreshThrottler.throttledExec();
        return info;
    }

    @Deprecated
    public void removeJobInfo(JobInfo info) {
        this.removeJob(info.getJob());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(GroupInfo group) {
        Object object = this.pendingUpdatesMutex;
        synchronized (object) {
            this.pendingGroupRemoval.add(group);
        }
        this.uiRefreshThrottler.throttledExec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobInfo(JobInfo info) {
        GroupInfo group = info.getGroupInfo();
        if (group != null) {
            this.refreshGroup(group);
        }
        this.managedJobs.add(info.getJob());
        Object object = this.pendingUpdatesMutex;
        synchronized (object) {
            Predicate<IJobProgressManagerListener> predicate = listener -> !this.isCurrentDisplaying(info.getJob(), listener.showsDebug());
            this.rememberListenersForJob(info, this.pendingJobAddition, predicate);
        }
        this.uiRefreshThrottler.throttledExec();
    }

    private void rememberListenersForJob(JobInfo info, Map<JobInfo, Set<IJobProgressManagerListener>> listenersMap, Predicate<IJobProgressManagerListener> predicate) {
        Set localListeners = listenersMap.computeIfAbsent(info, k -> new LinkedHashSet());
        this.listeners.stream().filter(predicate).forEach(localListeners::add);
    }

    boolean isCurrentDisplaying(Job job, boolean debug) {
        return this.isNeverDisplaying(job, debug) || job.getState() == 1;
    }

    boolean isNeverDisplaying(Job job, boolean debug) {
        if (debug) {
            return false;
        }
        return job.isSystem();
    }

    public JobInfo[] getJobInfos(boolean debug) {
        return (JobInfo[])this.managedJobs.stream().filter(job -> !this.isCurrentDisplaying((Job)job, debug)).map(job -> this.progressFor((Job)job).getJobInfo()).toArray(JobInfo[]::new);
    }

    public JobTreeElement[] getRootElements(boolean debug) {
        return (JobTreeElement[])this.managedJobs.stream().filter(job -> !this.isCurrentDisplaying((Job)job, debug)).map(job -> {
            JobInfo jobInfo = this.progressFor((Job)job).getJobInfo();
            GroupInfo group = jobInfo.getGroupInfo();
            if (group == null) {
                return jobInfo;
            }
            return group;
        }).distinct().toArray(JobTreeElement[]::new);
    }

    public boolean hasJobInfos() {
        return !this.managedJobs.isEmpty();
    }

    Image getImage(ImageData source) {
        ImageData mask = source.getTransparencyMask();
        return new Image(null, source, mask);
    }

    ImageData[] getImageData(URL fileSystemPath, ImageLoader loader) {
        try {
            ImageData[] result;
            Throwable throwable = null;
            Object var5_5 = null;
            try (InputStream stream = fileSystemPath.openStream();){
                result = loader.load(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return result;
        }
        catch (IOException exception) {
            ProgressManagerUtil.logException(exception);
            return null;
        }
    }

    @Override
    public void busyCursorWhile(IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        ProgressMonitorJobsDialog dialog = new ProgressMonitorJobsDialog(ProgressManagerUtil.getDefaultParent());
        dialog.setOpenOnRun(false);
        InvocationTargetException[] invokes = new InvocationTargetException[1];
        InterruptedException[] interrupt = new InterruptedException[1];
        Runnable dialogWaitRunnable = () -> {
            try {
                try {
                    dialog.setOpenOnRun(false);
                    this.setUserInterfaceActive(false);
                    dialog.run(true, true, runnable);
                }
                catch (InvocationTargetException e1) {
                    invocationTargetExceptionArray[0] = e1;
                    this.setUserInterfaceActive(true);
                }
                catch (InterruptedException e2) {
                    interruptedExceptionArray[0] = e2;
                    this.setUserInterfaceActive(true);
                }
            }
            finally {
                this.setUserInterfaceActive(true);
            }
        };
        this.busyCursorWhile(dialogWaitRunnable, dialog);
        if (invokes[0] != null) {
            throw invokes[0];
        }
        if (interrupt[0] != null) {
            throw interrupt[0];
        }
    }

    private void busyCursorWhile(Runnable dialogWaitRunnable, ProgressMonitorJobsDialog dialog) {
        this.scheduleProgressMonitorJob(dialog);
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            return;
        }
        BusyIndicator.showWhile((Display)display, (Runnable)dialogWaitRunnable);
    }

    private void scheduleProgressMonitorJob(final ProgressMonitorJobsDialog dialog) {
        WorkbenchJob updateJob = new WorkbenchJob(ProgressMessages.ProgressManager_openJobName){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                ProgressManager.this.setUserInterfaceActive(true);
                if (ProgressManagerUtil.safeToOpen(dialog, null)) {
                    dialog.open();
                }
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.schedule(this.getLongOperationTime());
    }

    private void shutdown() {
        this.listeners.clear();
        Job.getJobManager().setProgressProvider(null);
        Job.getJobManager().removeJobChangeListener(this.changeListener);
    }

    public IProgressMonitor createProgressGroup() {
        return new GroupInfo();
    }

    public IProgressMonitor createMonitor(Job job, IProgressMonitor group, int ticks) {
        JobMonitor monitor = this.progressFor(job);
        if (group instanceof GroupInfo) {
            GroupInfo groupInfo = (GroupInfo)group;
            JobInfo jobInfo = monitor.getJobInfo();
            jobInfo.setGroupInfo(groupInfo);
            jobInfo.setTicks(ticks);
            groupInfo.addJobInfo(jobInfo);
        }
        return monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListenerToFamily(Object family, IJobBusyListener listener) {
        Map<Object, Collection<IJobBusyListener>> map = this.familyListeners;
        synchronized (map) {
            Collection<IJobBusyListener> currentListeners = this.familyListeners.get(family);
            if (currentListeners == null) {
                currentListeners = new LinkedHashSet<IJobBusyListener>();
                this.familyListeners.put(family, currentListeners);
            }
            currentListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(IJobBusyListener listener) {
        Map<Object, Collection<IJobBusyListener>> map = this.familyListeners;
        synchronized (map) {
            Iterator<Collection<IJobBusyListener>> familyListeners = this.familyListeners.values().iterator();
            while (familyListeners.hasNext()) {
                Collection<IJobBusyListener> currentListeners = familyListeners.next();
                currentListeners.remove(listener);
                if (!currentListeners.isEmpty()) continue;
                familyListeners.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<IJobBusyListener> busyListenersForJob(Job job) {
        if (job.isSystem()) {
            return Collections.emptyList();
        }
        Map<Object, Collection<IJobBusyListener>> map = this.familyListeners;
        synchronized (map) {
            if (this.familyListeners.isEmpty()) {
                return Collections.emptyList();
            }
            LinkedHashSet<IJobBusyListener> returnValue = new LinkedHashSet<IJobBusyListener>();
            for (Map.Entry<Object, Collection<IJobBusyListener>> entry : this.familyListeners.entrySet()) {
                if (!job.belongsTo(entry.getKey())) continue;
                Collection<IJobBusyListener> currentListeners = entry.getValue();
                returnValue.addAll(currentListeners);
            }
            return returnValue;
        }
    }

    @Override
    public void showInDialog(Shell shell, Job job) {
        if (this.shouldRunInBackground()) {
            return;
        }
        ProgressMonitorFocusJobDialog dialog = new ProgressMonitorFocusJobDialog(shell);
        dialog.show(job, shell);
    }

    @Override
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (!fork || !cancelable) {
            ProgressMonitorJobsDialog dialog = new ProgressMonitorJobsDialog(null);
            dialog.run(fork, cancelable, runnable);
            return;
        }
        this.busyCursorWhile(runnable);
    }

    @Override
    public void runInUI(IRunnableContext context, IRunnableWithProgress runnable, ISchedulingRule rule) throws InvocationTargetException, InterruptedException {
        RunnableWithStatus runnableWithStatus = new RunnableWithStatus(context, runnable, rule);
        Display display = Display.getDefault();
        display.syncExec(() -> BusyIndicator.showWhile((Display)display, (Runnable)runnableWithStatus));
        IStatus status = runnableWithStatus.getStatus();
        if (!status.isOK()) {
            Throwable exception = status.getException();
            if (exception instanceof InvocationTargetException) {
                throw (InvocationTargetException)exception;
            }
            if (exception instanceof InterruptedException) {
                throw (InterruptedException)exception;
            }
            throw new InterruptedException(exception.getMessage());
        }
    }

    @Override
    public int getLongOperationTime() {
        return 800;
    }

    @Override
    public void registerIconForFamily(ImageDescriptor icon, Object family) {
        String key = IMAGE_KEY + this.imageKeyTable.size();
        this.imageKeyTable.put(family, key);
        ImageRegistry registry = JFaceResources.getImageRegistry();
        if (registry.getDescriptor(key) == null) {
            registry.put(key, icon);
        }
    }

    @Override
    public Image getIconFor(Job job) {
        Enumeration<Object> families = this.imageKeyTable.keys();
        while (families.hasMoreElements()) {
            Object next = families.nextElement();
            if (!job.belongsTo(next)) continue;
            return JFaceResources.getImageRegistry().get(this.imageKeyTable.get(next));
        }
        return null;
    }

    private void setUserInterfaceActive(boolean active) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell[] shells = workbench.getDisplay().getShells();
        if (active) {
            Shell[] shellArray = shells;
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                if (!shell.isDisposed()) {
                    shell.setEnabled(active);
                }
                ++n2;
            }
        } else {
            int i = shells.length - 1;
            while (i >= 0) {
                if (!shells[i].isDisposed()) {
                    shells[i].setEnabled(active);
                }
                --i;
            }
        }
    }

    boolean checkForStaleness(Job job) {
        if (job.getState() == 0) {
            this.removeJob(job);
            return true;
        }
        return false;
    }

    private boolean shouldRunInBackground() {
        return WorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("RUN_IN_BACKGROUND");
    }

    public void setShowSystemJobs(boolean showSystem) {
        ProgressViewUpdater updater = ProgressViewUpdater.getSingleton();
        updater.debug = showSystem;
        updater.refreshAll();
    }

    public class JobMonitor
    implements IProgressMonitorWithBlocking {
        Job job;
        JobInfo info;
        String currentTaskName;
        Set<IProgressMonitorWithBlocking> monitors = Collections.emptySet();

        JobMonitor(Job newJob, JobInfo jobInfo) {
            this.job = newJob;
            this.info = jobInfo;
        }

        public JobInfo getJobInfo() {
            return this.info;
        }

        public void addProgressListener(IProgressMonitorWithBlocking monitor) {
            Assert.isNotNull((Object)monitor);
            LinkedHashSet<IProgressMonitorWithBlocking> newSet = new LinkedHashSet<IProgressMonitorWithBlocking>(this.monitors);
            newSet.add(monitor);
            this.monitors = Collections.unmodifiableSet(newSet);
            TaskInfo currentTask = this.info.getTaskInfo();
            if (currentTask != null) {
                monitor.beginTask(this.currentTaskName, currentTask.totalWork);
                monitor.internalWorked(currentTask.preWork);
            }
        }

        public void removeProgresListener(IProgressMonitorWithBlocking monitor) {
            LinkedHashSet<IProgressMonitorWithBlocking> newSet = new LinkedHashSet<IProgressMonitorWithBlocking>(this.monitors);
            newSet.remove(monitor);
            this.monitors = Collections.unmodifiableSet(newSet);
        }

        public void beginTask(String taskName, int totalWork) {
            this.info.beginTask(taskName, totalWork);
            ProgressManager.this.refreshJobInfo(this.info);
            this.currentTaskName = taskName;
            this.monitors.forEach(listener -> listener.beginTask(taskName, totalWork));
        }

        public void done() {
            this.info.clearTaskInfo();
            this.info.clearChildren();
            this.monitors.forEach(IProgressMonitor::done);
        }

        public void internalWorked(double work) {
            if (this.info.hasTaskInfo()) {
                this.info.addWork(work);
                ProgressManager.this.refreshJobInfo(this.info);
            }
            this.monitors.forEach(listener -> listener.internalWorked(work));
        }

        public boolean isCanceled() {
            return this.info.isCanceled();
        }

        public void setCanceled(boolean value) {
            if (value && !this.info.isCanceled()) {
                this.info.cancel();
                this.monitors.forEach(listener -> listener.setCanceled(value));
            }
        }

        public void setTaskName(String taskName) {
            if (!this.info.hasTaskInfo()) {
                this.beginTask(taskName, 100);
                return;
            }
            this.info.setTaskName(taskName);
            this.info.clearChildren();
            ProgressManager.this.refreshJobInfo(this.info);
            this.currentTaskName = taskName;
            this.monitors.forEach(listener -> listener.setTaskName(taskName));
        }

        public void subTask(String name) {
            if (name == null) {
                return;
            }
            this.info.clearChildren();
            this.info.addSubTask(name);
            ProgressManager.this.refreshJobInfo(this.info);
            this.monitors.forEach(listener -> listener.subTask(name));
        }

        public void worked(int work) {
            this.internalWorked(work);
        }

        public void clearBlocked() {
            this.info.setBlockedStatus(null);
            ProgressManager.this.refreshJobInfo(this.info);
            this.monitors.forEach(IProgressMonitorWithBlocking::clearBlocked);
        }

        public void setBlocked(IStatus reason) {
            this.info.setBlockedStatus(reason);
            ProgressManager.this.refreshJobInfo(this.info);
            this.monitors.forEach(listener -> listener.setBlocked(reason));
        }
    }

    private static class RunnableWithStatus
    implements Runnable {
        IStatus status = Status.OK_STATUS;
        private final IRunnableContext context;
        private final IRunnableWithProgress runnable;
        private final ISchedulingRule rule;

        public RunnableWithStatus(IRunnableContext context, IRunnableWithProgress runnable, ISchedulingRule rule) {
            this.context = context;
            this.runnable = runnable;
            this.rule = rule;
        }

        @Override
        public void run() {
            IJobManager manager = Job.getJobManager();
            try {
                try {
                    manager.beginRule(this.rule, this.getEventLoopMonitor());
                    this.context.run(false, false, this.runnable);
                }
                catch (InterruptedException | InvocationTargetException | OperationCanceledException e) {
                    this.status = new Status(4, "org.eclipse.ui", e.getMessage(), e);
                    manager.endRule(this.rule);
                }
            }
            finally {
                manager.endRule(this.rule);
            }
        }

        private IProgressMonitor getEventLoopMonitor() {
            if (PlatformUI.getWorkbench().isStarting()) {
                return new NullProgressMonitor();
            }
            return new EventLoopProgressMonitor((IProgressMonitor)new NullProgressMonitor()){

                @Override
                public void setBlocked(IStatus reason) {
                    Dialog.getBlockedHandler().showBlocked(ProgressManagerUtil.getDefaultParent(), (IProgressMonitor)this, reason, this.getTaskName());
                }
            };
        }

        public IStatus getStatus() {
            return this.status;
        }
    }
}

