/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.ExtractedMap;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.internal.collectionextract.WrapperCollectionExtractor;
import org.eclipse.mat.snapshot.model.IObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperMapExtractor
extends WrapperCollectionExtractor
implements IMapExtractor {
    public WrapperMapExtractor(String field) {
        super(field);
    }

    public WrapperMapExtractor(String field, ICollectionExtractor extractor) {
        super(field, extractor);
    }

    @Override
    public boolean hasCollisionRatio() {
        return true;
    }

    @Override
    public Double getCollisionRatio(IObject coll) throws SnapshotException {
        return this.extractMap(coll).getCollisionRatio();
    }

    @Override
    public Iterator<Map.Entry<IObject, IObject>> extractMapEntries(final IObject coll) {
        ExtractedMap em = this.extractMap(coll);
        final Iterator<Map.Entry<IObject, IObject>> it = em.iterator();
        return new Iterator<Map.Entry<IObject, IObject>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Map.Entry<IObject, IObject> next() {
                Map.Entry e = (Map.Entry)it.next();
                return new IMapExtractor.EntryObject(coll, (IObject)e.getKey(), (IObject)e.getValue());
            }
        };
    }
}

