/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.snapshot.HeapObjectArgumentFactory;
import org.eclipse.mat.internal.snapshot.SnapshotQueryContext;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IStructuredResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.descriptors.IAnnotatedObjectDescriptor;
import org.eclipse.mat.query.annotations.descriptors.IArgumentDescriptor;
import org.eclipse.mat.query.refined.RefinedResultBuilder;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.query.registry.ArgumentFactory;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.CommandLine;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotQuery {
    private final ISnapshot snapshot;
    private final QueryDescriptor query;
    private final ArgumentSet arguments;

    public static SnapshotQuery lookup(String name, ISnapshot snapshot) throws SnapshotException {
        QueryDescriptor query = QueryRegistry.instance().getQuery(name);
        if (query == null) {
            throw new SnapshotException(MessageUtil.format((String)Messages.SnapshotQuery_ErrorMsg_QueryNotAvailable, (Object[])new Object[]{name}));
        }
        SnapshotQueryContext context = new SnapshotQueryContext(snapshot);
        if (!query.accept((IQueryContext)context)) {
            throw new SnapshotException(query.explain((IQueryContext)context));
        }
        SnapshotQuery.checkSubjects(name, snapshot, query, (IQueryContext)context);
        ArgumentSet arguments = query.createNewArgumentSet((IQueryContext)context);
        return new SnapshotQuery(snapshot, arguments);
    }

    private static void checkSubjects(String name, ISnapshot snapshot, QueryDescriptor query, IQueryContext queryContext) throws SnapshotException {
        if (SnapshotQuery.unsuitableSubjects(query, queryContext)) {
            throw new SnapshotException(MessageUtil.format((String)Messages.SnapshotQuery_ErrorMsg_UnsuitableSubjects, (Object[])new Object[]{name, Arrays.asList(SnapshotQuery.extractSubjects(query))}));
        }
    }

    private static boolean unsuitableSubjects(QueryDescriptor query, IQueryContext queryContext) {
        boolean skip;
        String[] cls = SnapshotQuery.extractSubjects(query);
        if (cls != null) {
            ISnapshot snapshot = (ISnapshot)queryContext.get(ISnapshot.class, null);
            int count = 0;
            String[] stringArray = cls;
            int n = cls.length;
            int n2 = 0;
            while (n2 < n) {
                String cn = stringArray[n2];
                try {
                    Collection<IClass> ss = snapshot.getClassesByName(cn, false);
                    if (ss != null && !ss.isEmpty()) {
                        count += ss.size();
                        break;
                    }
                }
                catch (SnapshotException snapshotException) {}
                ++n2;
            }
            skip = count == 0;
        } else {
            skip = false;
        }
        return skip;
    }

    private static String[] extractSubjects(QueryDescriptor query) {
        Subject s;
        Subjects subjects = query.getCommandType().getAnnotation(Subjects.class);
        String[] cls = subjects != null ? subjects.value() : ((s = query.getCommandType().getAnnotation(Subject.class)) != null ? new String[]{s.value()} : (String[])null);
        return cls;
    }

    public static SnapshotQuery parse(String commandLine, ISnapshot snapshot) throws SnapshotException {
        SnapshotQueryContext context = new SnapshotQueryContext(snapshot);
        ArgumentSet arguments = CommandLine.parse((IQueryContext)context, (String)commandLine);
        return new SnapshotQuery(snapshot, arguments);
    }

    private SnapshotQuery(ISnapshot snapshot, ArgumentSet arguments) {
        this.snapshot = snapshot;
        this.query = arguments.getQueryDescriptor();
        this.arguments = arguments;
    }

    public IAnnotatedObjectDescriptor getDescriptor() {
        return this.query;
    }

    public List<? extends IArgumentDescriptor> getArguments() {
        return Collections.unmodifiableList(this.query.getArguments());
    }

    public SnapshotQuery setArgument(String name, Object value) throws SnapshotException {
        ArgumentDescriptor argument = this.query.getArgumentByName(name);
        if (argument == null) {
            throw new SnapshotException(MessageUtil.format((String)Messages.SnapshotQuery_ErrorMsg_UnkownArgument, (Object[])new Object[]{name, this.query.getIdentifier()}));
        }
        if (argument.getType() == Integer.TYPE && argument.getAdvice() == Argument.Advice.HEAP_OBJECT || argument.getType().isAssignableFrom(IObject.class) || argument.getType().isAssignableFrom(IHeapObjectArgument.class)) {
            boolean cfr_ignored_0 = value instanceof ArgumentFactory;
            if (value instanceof IObject) {
                value = HeapObjectArgumentFactory.build(this.snapshot, new int[]{((IObject)value).getObjectId()});
            } else if (value instanceof Integer) {
                value = HeapObjectArgumentFactory.build(this.snapshot, new int[]{(Integer)value});
            } else if (value instanceof int[]) {
                value = HeapObjectArgumentFactory.build(this.snapshot, (int[])value);
            } else if (value instanceof ArrayInt) {
                value = HeapObjectArgumentFactory.build(this.snapshot, ((ArrayInt)value).toArray());
            } else if (value instanceof IHeapObjectArgument) {
                value = HeapObjectArgumentFactory.build(this.snapshot, (IHeapObjectArgument)value);
            } else {
                throw new SnapshotException(MessageUtil.format((String)Messages.SnapshotQuery_ErrorMsg_UnsupportedTyp, (Object[])new Object[]{name, value.getClass().getName()}));
            }
        }
        this.arguments.setArgumentValue(argument, value);
        return this;
    }

    public SnapshotQuery set(String name, Object value) throws SnapshotException {
        return this.setArgument(name, value);
    }

    public IResult execute(IProgressListener listener) throws SnapshotException {
        QueryResult result = this.arguments.execute(listener);
        return result != null ? result.getSubject() : null;
    }

    public RefinedResultBuilder refine(IProgressListener listener) throws SnapshotException {
        IResult result = this.execute(listener);
        if (result == null) {
            throw new SnapshotException(MessageUtil.format((String)Messages.SnapshotQuery_ErrorMsg_NoResult, (Object[])new Object[]{this.arguments.getQueryDescriptor().getIdentifier()}));
        }
        return new RefinedResultBuilder((IQueryContext)new SnapshotQueryContext(this.snapshot), (IStructuredResult)result);
    }
}

