/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.oql.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.oql.ICompiler;
import org.eclipse.mat.parser.internal.oql.compiler.Attribute;
import org.eclipse.mat.parser.internal.oql.compiler.CompilerImpl;
import org.eclipse.mat.parser.internal.oql.compiler.Expression;
import org.eclipse.mat.parser.internal.oql.compiler.Query;
import org.eclipse.mat.parser.internal.oql.parser.OQLParserConstants;
import org.eclipse.mat.parser.internal.oql.parser.OQLParserTokenManager;
import org.eclipse.mat.parser.internal.oql.parser.ParseException;
import org.eclipse.mat.parser.internal.oql.parser.SimpleCharStream;
import org.eclipse.mat.parser.internal.oql.parser.Token;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQLParser
implements OQLParserConstants {
    ICompiler compiler;
    public OQLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private boolean jj_lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[33];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns = new JJCalls[6];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    static {
        OQLParser.jj_la1_init_0();
        OQLParser.jj_la1_init_1();
    }

    public void setCompiler(ICompiler compiler) {
        this.compiler = compiler;
    }

    public static void main(String[] args) throws ParseException {
        System.out.println("Reading from stdin");
        OQLParser p = new OQLParser(System.in);
        p.setCompiler(new CompilerImpl());
        Query q = p.ParseQueryFromInputLine();
        System.out.println(q);
        System.out.println("Parse Successfull");
    }

    protected boolean seeUnreservedKeyword(String keyword) {
        return this.getToken((int)1).kind == 30 && keyword.equals(this.getToken((int)1).image.toUpperCase(Locale.ENGLISH));
    }

    protected boolean seeUnreservedKeyword(String ... keywords) {
        int index = 0;
        while (index < keywords.length) {
            if (this.getToken((int)(index + 1)).kind != 30 || !keywords[index].equals(this.getToken((int)(index + 1)).image.toUpperCase(Locale.ENGLISH))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    protected boolean seeExclude(String ... keywords) {
        if (this.getToken((int)1).kind != 30) {
            return false;
        }
        String image = this.getToken((int)1).image.toUpperCase(Locale.ENGLISH);
        int index = 0;
        while (index < keywords.length) {
            if (keywords[index].equals(image)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    protected ParseException generateCustomParseException(String ... keywords) {
        Token currentToken = this.getToken(0);
        StringBuilder buf = new StringBuilder();
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            buf.append("\n\t\"").append(keyword).append('\"');
            ++n2;
        }
        String msg = MessageUtil.format((String)Messages.OQLParser_Encountered_X_at_line_X_column_X_Was_expecting_one_of_X, (Object[])new Object[]{currentToken.next.image, currentToken.next.beginLine, currentToken.next.beginColumn, buf.toString()});
        ParseException e = new ParseException(msg);
        e.currentToken = currentToken;
        return e;
    }

    public final Query ParseQuery() throws ParseException {
        Query q = this.SelectStatement();
        this.jj_consume_token(0);
        return q;
    }

    public final Query ParseQueryFromInputLine() throws ParseException {
        Query q = this.SelectStatement();
        this.jj_consume_token(39);
        return q;
    }

    public final Query SelectStatement() throws ParseException {
        Query q = new Query();
        try {
            if (!this.seeUnreservedKeyword("SELECT")) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jj_consume_token(30);
        }
        catch (ParseException parseException) {
            throw this.generateCustomParseException("SELECT");
        }
        this.SelectList(q);
        this.FromClause(q);
        if (this.jj_2_1(1)) {
            this.WhereClause(q);
        }
        if (this.jj_2_2(1)) {
            this.UnionClause(q);
        }
        return q;
    }

    public final void SelectList(Query q) throws ParseException {
        Query.SelectClause selectClause = new Query.SelectClause();
        ArrayList<Query.SelectItem> columns = new ArrayList<Query.SelectItem>();
        if (this.jj_2_3(1)) {
            if (this.seeUnreservedKeyword("DISTINCT")) {
                this.jj_consume_token(30);
                selectClause.setDistinct(true);
            } else if (this.seeUnreservedKeyword("AS", "RETAINED", "SET")) {
                this.jj_consume_token(30);
                this.jj_consume_token(30);
                this.jj_consume_token(30);
                selectClause.setRetainedSet(true);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                if (this.seeUnreservedKeyword("OBJECTS")) {
                    this.jj_consume_token(30);
                    Query.SelectItem a = this.SelectItem();
                    columns.add(a);
                    selectClause.setAsObjects(true);
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: 
                    case 30: 
                    case 45: {
                        Query.SelectItem a = this.SelectItem();
                        columns.add(a);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 41: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[0] = this.jj_gen;
                                    break block0;
                                }
                            }
                            this.jj_consume_token(41);
                            a = this.SelectItem();
                            columns.add(a);
                        }
                    }
                }
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        selectClause.setSelectList(columns);
        q.setSelectClause(selectClause);
    }

    public final Query.SelectItem SelectItem() throws ParseException {
        Object ex = null;
        Token t1 = null;
        Token t2 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: 
            case 45: {
                ex = this.PathExpression();
                break;
            }
            case 29: {
                ex = this.EnvVarPathExpression();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.seeUnreservedKeyword("AS")) {
            this.jj_consume_token(30);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    t1 = this.jj_consume_token(21);
                    break;
                }
                case 30: {
                    t2 = this.jj_consume_token(30);
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        String name = null;
        if (t1 != null) {
            name = t1.image.substring(1, t1.image.length() - 1);
        } else if (t2 != null) {
            name = t2.image;
        }
        return new Query.SelectItem(name, (Expression)ex);
    }

    public final Object PathExpression() throws ParseException {
        ArrayList<Object> elements = new ArrayList<Object>();
        Object ex = null;
        ex = this.ObjectFacet(true);
        elements.add(ex);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(42);
            ex = this.ObjectFacet(false);
            elements.add(ex);
        }
        return this.compiler.path(elements);
    }

    public final Object EnvVarPathExpression() throws ParseException {
        LinkedList<Object> elements = new LinkedList<Object>();
        Object ex = null;
        Token t_name = null;
        this.jj_consume_token(29);
        this.jj_consume_token(43);
        t_name = this.jj_consume_token(30);
        this.jj_consume_token(44);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(42);
            ex = this.ObjectFacet(false);
            elements.add(ex);
        }
        elements.addFirst(new Attribute(t_name.image, false, true));
        return this.compiler.path(elements);
    }

    public final Object ObjectFacet(boolean isFirstInPath) throws ParseException {
        Token t_native = null;
        Token t_name = null;
        List<Expression> parameters = null;
        Object ex = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 45: {
                t_native = this.jj_consume_token(45);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        t_name = this.jj_consume_token(30);
        if (this.jj_2_4(Integer.MAX_VALUE)) {
            parameters = this.ParameterList();
        }
        ex = parameters != null ? this.compiler.method(t_name.image, parameters, isFirstInPath) : new Attribute(t_name.image, t_native != null, false);
        return ex;
    }

    public final List<Expression> ParameterList() throws ParseException {
        ArrayList<Expression> parameters = new ArrayList<Expression>();
        Object expr = null;
        this.jj_consume_token(46);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 29: 
            case 30: 
            case 45: 
            case 46: 
            case 51: 
            case 52: {
                expr = this.SimpleExpression();
                parameters.add((Expression)expr);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 41: {
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(41);
                    expr = this.SimpleExpression();
                    parameters.add((Expression)expr);
                }
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        this.jj_consume_token(47);
        return parameters;
    }

    public final void FromClause(Query q) throws ParseException {
        Query.FromClause fromItem = new Query.FromClause();
        Query subSelect = null;
        boolean isObjects = false;
        Token t1 = null;
        Token t2 = null;
        try {
            if (!this.seeUnreservedKeyword("FROM")) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jj_consume_token(30);
        }
        catch (ParseException parseException) {
            throw this.generateCustomParseException("FROM");
        }
        if (this.seeUnreservedKeyword("OBJECTS")) {
            this.jj_consume_token(30);
            isObjects = true;
        }
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            t1 = this.jj_consume_token(22);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: 
            case 16: 
            case 21: 
            case 29: 
            case 30: {
                this.FromItem(fromItem);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                subSelect = this.SelectStatement();
                this.jj_consume_token(47);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (this.seeExclude("WHERE", "UNION")) {
            t2 = this.jj_consume_token(30);
        }
        fromItem.setSubSelect(subSelect);
        fromItem.setIncludeObjects(isObjects);
        fromItem.setIncludeSubClasses(t1 != null);
        if (t2 != null) {
            fromItem.setAlias(t2.image);
        }
        q.setFromClause(fromItem);
    }

    public final void FromItem(Query.FromClause fromClause) throws ParseException {
        Token t = null;
        Object expr = null;
        String className = null;
        long address = 0L;
        int objectId = 0;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                expr = this.EnvVarPathExpression();
                fromClause.setCall((Expression)expr);
                break;
            }
            case 30: {
                className = this.ClassName();
                fromClause.setClassName(className);
                break;
            }
            case 21: {
                t = this.jj_consume_token(21);
                fromClause.setClassNamePattern(t.image.substring(1, t.image.length() - 1));
                break;
            }
            case 16: {
                address = this.ObjectAddress();
                fromClause.addObjectAddress(address);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 41: {
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(41);
                    address = this.ObjectAddress();
                    fromClause.addObjectAddress(address);
                }
            }
            case 13: {
                objectId = this.ObjectId();
                fromClause.addObjectId(objectId);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 41: {
                            break;
                        }
                        default: {
                            this.jj_la1[12] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(41);
                    objectId = this.ObjectId();
                    fromClause.addObjectId(objectId);
                }
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String ClassName() throws ParseException {
        StringBuilder b = new StringBuilder();
        Token t = this.jj_consume_token(30);
        b.append(t.image);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(42);
            t = this.jj_consume_token(30);
            b.append(".").append(t.image);
        }
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 48: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block7;
                }
            }
            this.jj_consume_token(48);
            b.append("[]");
        }
        return b.toString();
    }

    public final long ObjectAddress() throws ParseException {
        Token t = null;
        t = this.jj_consume_token(16);
        return new BigInteger(t.image.substring(2), 16).longValue();
    }

    public final int ObjectId() throws ParseException {
        Token t = null;
        t = this.jj_consume_token(13);
        return Integer.parseInt(t.image);
    }

    public final void WhereClause(Query q) throws ParseException {
        if (!this.seeUnreservedKeyword("WHERE")) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(30);
        Object ex = this.ConditionalOrExpression();
        q.setWhereClause((Expression)ex);
    }

    public final Object ConditionalOrExpression() throws ParseException {
        ArrayList<Object> list = null;
        Object ex = this.ConditionalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 25: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(25);
            Object r = this.ConditionalAndExpression();
            if (list == null) {
                list = new ArrayList<Object>();
                list.add(ex);
            }
            list.add(r);
        }
        if (list != null) {
            ex = this.compiler.or(list.toArray());
        }
        return ex;
    }

    public final Object ConditionalAndExpression() throws ParseException {
        ArrayList<Object> list = null;
        Object ex = this.EqualityExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 26: {
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(26);
            Object r = this.EqualityExpression();
            if (list == null) {
                list = new ArrayList<Object>();
                list.add(ex);
            }
            list.add(r);
        }
        if (list != null) {
            ex = this.compiler.and(list.toArray());
        }
        return ex;
    }

    public final Object EqualityExpression() throws ParseException {
        Object ex;
        block8: {
            ex = this.RelationalExpression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 38: 
                    case 49: {
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 49: {
                        this.jj_consume_token(49);
                        Object r = this.RelationalExpression();
                        ex = this.compiler.equal(ex, r);
                        continue block7;
                    }
                    case 38: {
                        this.jj_consume_token(38);
                        Object r = this.RelationalExpression();
                        ex = this.compiler.notEqual(ex, r);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[19] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return ex;
    }

    public final Object RelationalExpression() throws ParseException {
        Object ex = this.SimpleExpression();
        if (this.jj_2_6(1)) {
            block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    this.jj_consume_token(33);
                    Object r = this.SimpleExpression();
                    ex = this.compiler.lessThan(ex, r);
                    break;
                }
                case 50: {
                    this.jj_consume_token(50);
                    Object r = this.SimpleExpression();
                    ex = this.compiler.greaterThan(ex, r);
                    break;
                }
                case 36: {
                    this.jj_consume_token(36);
                    Object r = this.SimpleExpression();
                    ex = this.compiler.lessThanOrEqual(ex, r);
                    break;
                }
                case 37: {
                    this.jj_consume_token(37);
                    Object r = this.SimpleExpression();
                    ex = this.compiler.greaterThanOrEqual(ex, r);
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    if (this.seeUnreservedKeyword("LIKE")) {
                        ex = this.LikeClause(ex, true);
                        break;
                    }
                    if (this.seeUnreservedKeyword("IN")) {
                        ex = this.InClause(ex, true);
                        break;
                    }
                    if (this.seeUnreservedKeyword("NOT")) {
                        ex = this.NotLikeInClause(ex);
                        break;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 28: {
                            this.jj_consume_token(28);
                            String r = this.ClassName();
                            ex = this.compiler.instanceOf(ex, r);
                            break block0;
                        }
                    }
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return ex;
    }

    public final Object NotLikeInClause(Object left) throws ParseException {
        Object ex;
        this.jj_consume_token(30);
        if (this.seeUnreservedKeyword("LIKE")) {
            ex = this.LikeClause(left, false);
        } else if (this.seeUnreservedKeyword("IN")) {
            ex = this.InClause(left, false);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return ex;
    }

    public final Object LikeClause(Object left, boolean isLike) throws ParseException {
        Token t1 = null;
        this.jj_consume_token(30);
        t1 = this.jj_consume_token(21);
        String pattern = t1.image.substring(1, t1.image.length() - 1);
        return isLike ? this.compiler.like(left, pattern) : this.compiler.notLike(left, pattern);
    }

    public final Object InClause(Object left, boolean isIn) throws ParseException {
        this.jj_consume_token(30);
        Object r = this.SimpleExpression();
        return isIn ? this.compiler.in(left, r) : this.compiler.notIn(left, r);
    }

    public final Object SimpleExpression() throws ParseException {
        Object ex;
        block8: {
            ex = this.MultiplicativeExpression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 51: 
                    case 52: {
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 51: {
                        this.jj_consume_token(51);
                        Object r = this.MultiplicativeExpression();
                        ex = this.compiler.plus(ex, r);
                        continue block7;
                    }
                    case 52: {
                        this.jj_consume_token(52);
                        Object r = this.MultiplicativeExpression();
                        ex = this.compiler.minus(ex, r);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[23] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return ex;
    }

    public final Object MultiplicativeExpression() throws ParseException {
        Object ex;
        block8: {
            ex = this.PrimaryExpression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 40: 
                    case 53: {
                        break;
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 40: {
                        this.jj_consume_token(40);
                        Object r = this.PrimaryExpression();
                        ex = this.compiler.multiply(ex, r);
                        continue block7;
                    }
                    case 53: {
                        this.jj_consume_token(53);
                        Object r = this.PrimaryExpression();
                        ex = this.compiler.divide(ex, r);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[25] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return ex;
    }

    public final Object PrimaryExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: 
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 27: 
            case 51: 
            case 52: {
                Object ex = this.Literal();
                return ex;
            }
            case 46: {
                Object ex;
                this.jj_consume_token(46);
                if (this.seeUnreservedKeyword("SELECT")) {
                    ex = this.SubQuery();
                } else {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 13: 
                        case 14: 
                        case 18: 
                        case 20: 
                        case 21: 
                        case 23: 
                        case 24: 
                        case 27: 
                        case 29: 
                        case 30: 
                        case 45: 
                        case 46: 
                        case 51: 
                        case 52: {
                            ex = this.ConditionalOrExpression();
                            break;
                        }
                        default: {
                            this.jj_la1[26] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                this.jj_consume_token(47);
                return ex;
            }
            case 30: 
            case 45: {
                Object ex = this.PathExpression();
                return ex;
            }
            case 29: {
                Object ex = this.EnvVarPathExpression();
                return ex;
            }
        }
        this.jj_la1[27] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object SubQuery() throws ParseException {
        Query q = this.SelectStatement();
        return this.compiler.subQuery(q);
    }

    public final Object Literal() throws ParseException {
        Object ex;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: 
            case 14: 
            case 18: 
            case 51: 
            case 52: {
                ex = this.NumberLiteral();
                break;
            }
            case 20: {
                Token t = this.jj_consume_token(20);
                ex = this.compiler.literal(Character.valueOf(t.image.charAt(1)));
                break;
            }
            case 21: {
                Token t = this.jj_consume_token(21);
                ex = this.compiler.literal(t.image.substring(1, t.image.length() - 1));
                break;
            }
            case 23: 
            case 24: {
                ex = this.BooleanLiteral();
                break;
            }
            case 27: {
                ex = this.NullLiteral();
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return ex;
    }

    public final Object NumberLiteral() throws ParseException {
        Object ex;
        Token unary = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 51: 
            case 52: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 51: {
                        unary = this.jj_consume_token(51);
                        break block0;
                    }
                    case 52: {
                        unary = this.jj_consume_token(52);
                        break block0;
                    }
                }
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                Token t = this.jj_consume_token(13);
                int anInt = Integer.parseInt(t.image);
                if (unary != null && "-".equals(unary.image)) {
                    anInt *= -1;
                }
                ex = this.compiler.literal(anInt);
                break;
            }
            case 14: {
                Token t = this.jj_consume_token(14);
                long aLong = Long.parseLong(t.image.substring(0, t.image.length() - 1));
                if (unary != null && "-".equals(unary.image)) {
                    aLong *= -1L;
                }
                ex = this.compiler.literal(aLong);
                break;
            }
            case 18: {
                Token t = this.jj_consume_token(18);
                float aFloat = Float.parseFloat(t.image);
                if (unary != null && "-".equals(unary.image)) {
                    aFloat *= -1.0f;
                }
                ex = this.compiler.literal(Float.valueOf(aFloat));
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return ex;
    }

    public final Object BooleanLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                return this.compiler.literal(Boolean.TRUE);
            }
            case 24: {
                this.jj_consume_token(24);
                return this.compiler.literal(Boolean.FALSE);
            }
        }
        this.jj_la1[32] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object NullLiteral() throws ParseException {
        this.jj_consume_token(27);
        return this.compiler.nullLiteral();
    }

    public final void UnionClause(Query q) throws ParseException {
        Query unionQuery = null;
        do {
            this.jj_consume_token(30);
            this.jj_consume_token(46);
            unionQuery = this.SelectStatement();
            this.jj_consume_token(47);
            q.addUnionQuery(unionQuery);
        } while (this.seeUnreservedKeyword("UNION"));
    }

    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            return true;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    private boolean jj_3_4() {
        return this.jj_scan_token(46);
    }

    private boolean jj_3R_18() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3_5() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_30() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        this.jj_lookingAhead = true;
        this.jj_semLA = this.seeUnreservedKeyword("DISTINCT");
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_17()) {
            this.jj_scanpos = xsp;
            this.jj_lookingAhead = true;
            this.jj_semLA = this.seeUnreservedKeyword("AS", "RETAINED", "SET");
            this.jj_lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_18()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_17() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_29() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_27() {
        return false;
    }

    private boolean jj_3_6() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_20()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_21()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_22()) {
                        this.jj_scanpos = xsp;
                        this.jj_lookingAhead = true;
                        this.jj_semLA = this.seeUnreservedKeyword("LIKE");
                        this.jj_lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_23()) {
                            this.jj_scanpos = xsp;
                            this.jj_lookingAhead = true;
                            this.jj_semLA = this.seeUnreservedKeyword("IN");
                            this.jj_lookingAhead = false;
                            if (!this.jj_semLA || this.jj_3R_24()) {
                                this.jj_scanpos = xsp;
                                this.jj_lookingAhead = true;
                                this.jj_semLA = this.seeUnreservedKeyword("NOT");
                                this.jj_lookingAhead = false;
                                if (!this.jj_semLA || this.jj_3R_25()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_26()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_28() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_26() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_25() {
        return this.jj_3R_31();
    }

    private boolean jj_3R_15() {
        this.jj_lookingAhead = true;
        this.jj_semLA = this.seeUnreservedKeyword("WHERE");
        this.jj_lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_27()) {
            return true;
        }
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_24() {
        return this.jj_3R_30();
    }

    private boolean jj_3_2() {
        return this.jj_3R_16();
    }

    private boolean jj_3R_23() {
        return this.jj_3R_29();
    }

    private boolean jj_3R_31() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_16() {
        Token xsp;
        if (this.jj_3R_28()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_28());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_1() {
        return this.jj_3R_15();
    }

    private boolean jj_3R_22() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3R_21() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_20() {
        return this.jj_scan_token(50);
    }

    private boolean jj_3R_19() {
        return this.jj_scan_token(33);
    }

    private static void jj_la1_init_0() {
        int[] nArray = new int[33];
        nArray[2] = 0x60000000;
        nArray[3] = 0x60000000;
        nArray[4] = 0x40200000;
        nArray[9] = 1773428736;
        nArray[10] = 1612783616;
        nArray[13] = 1612783616;
        nArray[16] = 0x2000000;
        nArray[17] = 0x4000000;
        nArray[21] = 0x10000000;
        nArray[26] = 1773428736;
        nArray[27] = 1773428736;
        nArray[28] = 162816000;
        nArray[31] = 286720;
        nArray[32] = 0x1800000;
        jj_la1_0 = nArray;
    }

    private static void jj_la1_init_1() {
        int[] nArray = new int[33];
        nArray[0] = 512;
        nArray[1] = 256;
        nArray[2] = 8192;
        nArray[3] = 8192;
        nArray[5] = 1024;
        nArray[6] = 1024;
        nArray[7] = 8192;
        nArray[8] = 512;
        nArray[9] = 1597440;
        nArray[10] = 16384;
        nArray[11] = 512;
        nArray[12] = 512;
        nArray[14] = 1024;
        nArray[15] = 65536;
        nArray[18] = 131136;
        nArray[19] = 131136;
        nArray[20] = 262194;
        nArray[22] = 0x180000;
        nArray[23] = 0x180000;
        nArray[24] = 0x200100;
        nArray[25] = 0x200100;
        nArray[26] = 1597440;
        nArray[27] = 1597440;
        nArray[28] = 0x180000;
        nArray[29] = 0x180000;
        nArray[30] = 0x180000;
        jj_la1_1 = nArray;
    }

    public OQLParser(InputStream stream) {
        this(stream, null);
    }

    public OQLParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new OQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 33) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 33) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public OQLParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new OQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 33) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 33) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public OQLParser(OQLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 33) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(OQLParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 33) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.jj_lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) continue block1;
                    ++i2;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[54];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i = 0;
        while (i < 33) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & 1 << j) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 54) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.add(this.jj_expentry);
            }
            ++i;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = this.jj_expentries.get(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 6) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                        }
                    }
                } while ((p = p.next) != null);
            }
            catch (LookaheadSuccess lookaheadSuccess) {}
            ++i;
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

