/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.registry;

import com.ibm.icu.text.BreakIterator;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.AnnotatedObjectDescriptor;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.CommandLine;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.report.internal.ReportPlugin;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryDescriptor
extends AnnotatedObjectDescriptor {
    protected final String category;
    protected final int sortOrder;
    protected final Class<? extends IQuery> subject;
    protected final List<QueryDescriptor> menuEntries;

    QueryDescriptor(String identifier, String name, String category, Class<? extends IQuery> subject, String usage, URL icon, String help, String helpUrl, Locale helpLocale) {
        super(identifier, name, usage, icon, help, helpUrl, helpLocale);
        if (name == null) {
            this.name = null;
            this.sortOrder = Integer.MAX_VALUE;
        } else {
            int p = name.indexOf(124);
            String name1 = p >= 0 ? name.substring(p + 1) : name;
            int sortOrder = 100;
            int end = p;
            while (end > 0 && !Character.isDigit(name.charAt(end - 1))) {
                --end;
            }
            int start = 0;
            while (start < end) {
                try {
                    sortOrder = Integer.parseInt(name.substring(start, end));
                    name1 = String.valueOf(name.substring(0, start)) + name1;
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    ++start;
                }
            }
            this.sortOrder = sortOrder;
            this.name = name1;
        }
        this.category = category;
        this.subject = subject;
        this.usage = usage;
        this.menuEntries = new ArrayList<QueryDescriptor>();
    }

    public String getCategory() {
        return this.category;
    }

    public Class<? extends IQuery> getCommandType() {
        return this.subject;
    }

    public ArgumentSet createNewArgumentSet(IQueryContext context) throws SnapshotException {
        return new ArgumentSet(this, context);
    }

    public String getShortDescription() {
        String description = null;
        if (this.help != null) {
            BreakIterator bb = BreakIterator.getSentenceInstance((Locale)this.helpLocale);
            bb.setText(this.help);
            int p = bb.next();
            if (p >= 0 && p <= 80) {
                description = this.help.substring(0, p).trim();
            } else if (this.help.length() > 80) {
                int q;
                bb = BreakIterator.getWordInstance((Locale)this.helpLocale);
                bb.setText(this.help);
                while ((q = bb.next()) <= 80 && q != -1) {
                    p = q;
                }
                description = p >= 0 && p <= 80 ? String.valueOf(this.help.substring(0, p)) + " ..." : String.valueOf(this.help.substring(0, 80)) + " ...";
            } else {
                description = this.help;
            }
        }
        return description;
    }

    public String toString() {
        return new StringBuilder(128).append(this.identifier).append(" (").append(this.subject.getName()).append(")").toString();
    }

    public boolean accept(IQueryContext context) {
        for (ArgumentDescriptor argument : this.arguments) {
            if (context.available(argument.getType(), argument.getAdvice()) || context.converts(argument.getType(), argument.getAdvice())) continue;
            if (ReportPlugin.getDefault().isDebugging()) {
                ReportPlugin.log(1, MessageUtil.format(Messages.QueryDescriptor_Error_IgnoringQuery, this.getIdentifier(), argument.getName()));
            }
            return false;
        }
        return true;
    }

    public String explain(IQueryContext context) {
        StringBuilder buf = new StringBuilder();
        for (ArgumentDescriptor argument : this.arguments) {
            if (context.available(argument.getType(), argument.getAdvice()) || context.converts(argument.getType(), argument.getAdvice())) continue;
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(MessageUtil.format(Messages.QueryDescriptor_Error_NotSupported, argument.toString()));
        }
        return buf.toString();
    }

    public ArgumentDescriptor getArgumentByName(String name) {
        for (ArgumentDescriptor argument : this.arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    public List<QueryDescriptor> getMenuEntries() {
        return Collections.unmodifiableList(this.menuEntries);
    }

    public boolean isShallow() {
        return false;
    }

    void addMenuEntry(String label, String category, String help, String helpUrl, URL icon, String options) {
        this.menuEntries.add(new ShallowQueryDescriptor(this, label, category, icon, help, helpUrl, options));
    }

    ArgumentDescriptor byFlag(String name) {
        for (ArgumentDescriptor d : this.arguments) {
            if (!name.equals(d.getFlag())) continue;
            return d;
        }
        return null;
    }

    static class ShallowQueryDescriptor
    extends QueryDescriptor {
        private String options;

        private ShallowQueryDescriptor(QueryDescriptor parent, String label, String category, URL icon, String help, String helpUrl, String options) {
            super(parent.identifier, label, category, parent.subject, parent.usage, icon, help, helpUrl, parent.helpLocale);
            this.options = options;
            this.arguments.addAll(parent.arguments);
        }

        public ArgumentSet createNewArgumentSet(IQueryContext contextProvider) throws SnapshotException {
            ArgumentSet answer = super.createNewArgumentSet(contextProvider);
            if (this.options.length() > 0) {
                CommandLine.fillIn(answer, this.options);
            }
            return answer;
        }

        public boolean isShallow() {
            return true;
        }
    }
}

