/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.editor;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.accessibility.AccessibleToolbarAdapter;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.CompositeHeapEditorPane;
import org.eclipse.mat.ui.editor.EditorPaneRegistry;
import org.eclipse.mat.ui.editor.IMultiPaneEditorContributor;
import org.eclipse.mat.ui.editor.LRUList;
import org.eclipse.mat.ui.editor.MultiPaneEditorContributor;
import org.eclipse.mat.ui.editor.MultiPaneEditorSelectionProvider;
import org.eclipse.mat.ui.editor.MultiPaneEditorSite;
import org.eclipse.mat.ui.editor.PaneConfiguration;
import org.eclipse.mat.ui.snapshot.ImageHelper;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.NavigatorState;
import org.eclipse.mat.ui.util.PaneState;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IWorkbenchPartOrientation;

public class MultiPaneEditor
extends EditorPart
implements IResourceChangeListener {
    public static final int PROP_ACTION_BAR = 0x1000001;
    public static final int PROP_FOLDER_IMAGE = 0x1000002;
    private LRUList<AbstractEditorPane> nestedPanes = new LRUList();
    private ToolBarManager toolbarMgr;
    private ToolBarManager toolbarMgrHelp;
    private CTabFolder container;
    private List<IMultiPaneEditorContributor> contributors = new ArrayList<IMultiPaneEditorContributor>();
    private Menu menu;
    private NavigatorState navigatorState;
    private File resource;
    private IQueryContext queryContext;

    public final void createPartControl(Composite parent) {
        Job job = this.createInitializationJob();
        if (job == null) {
            this.createPaneArea(parent);
        } else {
            this.createJobPane(parent, job);
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void createJobPane(final Composite parent, final Job job) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        final Form form = toolkit.createForm(parent);
        form.setText(Messages.MultiPaneEditor_Opening);
        RowLayout layout = new RowLayout(512);
        layout.marginLeft = 10;
        form.getBody().setLayout((Layout)layout);
        final Text text = new Text(form.getBody(), 64);
        text.setText(job.getName());
        final Button cancel = new Button(form.getBody(), 0x800000);
        cancel.setText(Messages.MultiPaneEditor_Cancel);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                cancel.setEnabled(false);
                job.cancel();
            }
        });
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                parent.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        switch (event.getResult().getSeverity()) {
                            case 0: {
                                form.dispose();
                                MultiPaneEditor.this.createPaneArea(parent);
                                parent.layout();
                                break;
                            }
                            case 8: {
                                IWorkbenchPage[] pages = MultiPaneEditor.this.getSite().getWorkbenchWindow().getPages();
                                int ii = 0;
                                while (ii < pages.length) {
                                    IEditorPart editorPart = pages[ii].findEditor(MultiPaneEditor.this.getEditorInput());
                                    if (editorPart != null) {
                                        pages[ii].closeEditor(editorPart, true);
                                    }
                                    ++ii;
                                }
                                break;
                            }
                            case 1: 
                            case 4: {
                                cancel.setEnabled(false);
                                form.setText(Messages.MultiPaneEditor_Failed_to_open);
                                text.setText(event.getResult().getMessage());
                            }
                        }
                    }
                });
            }
        });
        job.schedule();
    }

    protected Job createInitializationJob() {
        return null;
    }

    private final void createPaneArea(Composite parent) {
        Composite composite = new Composite(parent, 128);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        ToolBar toolbar = new ToolBar(composite, 0x800000);
        toolbar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleToolbarAdapter(toolbar));
        GridDataFactory.fillDefaults().grab(true, false).indent(0, 2).applyTo((Control)toolbar);
        this.toolbarMgr = new ToolBarManager(toolbar);
        toolbar = new ToolBar(composite, 0x800000);
        toolbar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleToolbarAdapter(toolbar));
        GridDataFactory.fillDefaults().grab(false, false).indent(0, 2).applyTo((Control)toolbar);
        this.toolbarMgrHelp = new ToolBarManager(toolbar);
        this.container = new CTabFolder(composite, 0x800880);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).indent(0, 0).applyTo((Control)this.container);
        this.container.setUnselectedImageVisible(true);
        this.container.setUnselectedCloseVisible(false);
        this.container.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newPageIndex = MultiPaneEditor.this.container.indexOf((CTabItem)e.item);
                MultiPaneEditor.this.pageChange(newPageIndex);
            }
        });
        this.container.addCTabFolder2Listener(new CTabFolder2Listener(){

            public void close(CTabFolderEvent event) {
                MultiPaneEditor.this.removePage(MultiPaneEditor.this.container.indexOf((CTabItem)event.item));
                MultiPaneEditor.this.updateToolbar();
            }

            public void maximize(CTabFolderEvent event) {
            }

            public void minimize(CTabFolderEvent event) {
            }

            public void restore(CTabFolderEvent event) {
            }

            public void showList(CTabFolderEvent event) {
                ArrayList<1> actions = new ArrayList<1>();
                CTabItem[] items = MultiPaneEditor.this.container.getItems();
                int ii = 0;
                while (ii < items.length) {
                    final int n = ii;
                    Action action = new Action(){

                        public void run() {
                            MultiPaneEditor.this.setActivePage(n);
                            MultiPaneEditor.this.pageChange(n);
                        }
                    };
                    action.setText(items[ii].isShowing() ? items[ii].getText() : String.valueOf(items[ii].getText()) + "*");
                    action.setToolTipText(items[ii].getToolTipText());
                    if (items[ii].getImage() != null) {
                        action.setImageDescriptor((ImageDescriptor)new ImageHelper.ImageImageDescriptor(items[ii].getImage()));
                    }
                    actions.add(action);
                    ++ii;
                }
                Collections.sort(actions, new Comparator<Action>(){

                    @Override
                    public int compare(Action a1, Action a2) {
                        return a1.getText().compareToIgnoreCase(a2.getText());
                    }
                });
                PopupMenu popupMenu = new PopupMenu();
                for (Action action : actions) {
                    popupMenu.add(action);
                }
                if (MultiPaneEditor.this.menu != null && !MultiPaneEditor.this.menu.isDisposed()) {
                    MultiPaneEditor.this.menu.dispose();
                }
                MultiPaneEditor.this.menu = popupMenu.createMenu(MultiPaneEditor.this.getEditorSite().getActionBars().getStatusLineManager(), (Control)MultiPaneEditor.this.container);
                MultiPaneEditor.this.menu.setVisible(true);
                event.doit = false;
            }
        });
        this.container.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MultiPaneEditor.this.nestedPanes.touch((AbstractEditorPane)e.item.getData());
            }
        });
        this.container.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                if (event.button != 3) {
                    return;
                }
                CTabItem item = MultiPaneEditor.this.container.getItem(new Point(event.x, event.y));
                if (item == null) {
                    return;
                }
                MultiPaneEditor.this.showPopupMenuFor(item);
            }
        });
        this.createContributors();
        this.createInitialPanes();
        if (this.getActivePage() == -1 && this.container.getItemCount() > 0) {
            this.pageChange(0);
        }
    }

    protected void createInitialPanes() {
    }

    private void createContributors() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.mat.ui.editorContributions");
        if (point != null) {
            HashMap<Integer, ArrayList<IMultiPaneEditorContributor>> seq2contributors = new HashMap<Integer, ArrayList<IMultiPaneEditorContributor>>();
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] confElements = extensions[i].getConfigurationElements();
                int jj = 0;
                while (jj < confElements.length) {
                    try {
                        String editorClass = confElements[jj].getAttribute("editorClass");
                        if (editorClass != null) {
                            boolean isApplicable = false;
                            Class<?> subject = ((Object)((Object)this)).getClass();
                            while (subject != EditorPart.class && !isApplicable) {
                                isApplicable = editorClass.equals(subject.getName());
                                subject = subject.getSuperclass();
                            }
                            if (isApplicable) {
                                String sequenceNrStr = confElements[jj].getAttribute("sequenceNr");
                                int sequenceNr = sequenceNrStr != null && sequenceNrStr.length() > 0 ? Integer.valueOf(sequenceNrStr) : Integer.MAX_VALUE;
                                IMultiPaneEditorContributor contributor = (IMultiPaneEditorContributor)confElements[jj].createExecutableExtension("class");
                                ArrayList<IMultiPaneEditorContributor> list = (ArrayList<IMultiPaneEditorContributor>)seq2contributors.get(sequenceNr);
                                if (list == null) {
                                    list = new ArrayList<IMultiPaneEditorContributor>();
                                    seq2contributors.put(sequenceNr, list);
                                }
                                list.add(contributor);
                            }
                        }
                    }
                    catch (CoreException e) {
                        MemoryAnalyserPlugin.log(e);
                    }
                    ++jj;
                }
                ++i;
            }
            ArrayList keys = new ArrayList(seq2contributors.keySet());
            Collections.sort(keys);
            for (Integer key : keys) {
                List contributors = (List)seq2contributors.get(key);
                for (IMultiPaneEditorContributor contributor : contributors) {
                    contributor.init(this);
                    this.contributors.add(contributor);
                }
            }
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        for (AbstractEditorPane editor : this.nestedPanes) {
            this.disposePart((IWorkbenchPart)editor);
        }
        this.nestedPanes.clear();
        for (IMultiPaneEditorContributor contributor : this.contributors) {
            contributor.dispose();
        }
        this.contributors.clear();
        if (this.toolbarMgr != null) {
            this.toolbarMgr.dispose();
        }
        this.toolbarMgr = null;
        if (this.toolbarMgrHelp != null) {
            this.toolbarMgrHelp.dispose();
        }
        this.toolbarMgrHelp = null;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        super.dispose();
    }

    public IEditorInput getPaneEditorInput() {
        return this.getEditorInput();
    }

    public void addNewPage(String paneId, Object argument, boolean isSingelton) {
        this.addNewPage(paneId, argument, isSingelton, true, null, null);
    }

    public void addNewPage(String paneId, Object argument, boolean isSingelton, boolean doFocus) {
        this.addNewPage(paneId, argument, isSingelton, doFocus, null, null);
    }

    public void addNewPage(String id, Object argument) {
        this.addNewPage(id, argument, false, true, null, null);
    }

    public void addNewPage(AbstractEditorPane pane, Object argument, String title, Image image) {
        try {
            int index = this.addPage(pane, this.getPaneEditorInput(), true);
            CTabItem item = this.getItem(index);
            item.setText(title != null ? title : pane.getTitle());
            item.setImage(image != null ? image : pane.getTitleImage());
            pane.initWithArgument(argument);
            this.setActivePage(index);
            this.pageChange(index);
        }
        catch (PartInitException e) {
            ErrorHelper.logThrowableAndShowMessage(e);
        }
    }

    public void addNewPage(String paneId, Object argument, boolean isSingelton, boolean doFocus, String title, Image image) {
        PaneConfiguration cfg = EditorPaneRegistry.instance().forPane(paneId);
        if (cfg == null) {
            return;
        }
        if (isSingelton) {
            int indexCount = this.getPageCount();
            int i = 0;
            while (i < indexCount) {
                AbstractEditorPane editor = this.getEditor(i);
                if (editor.configuration != null && editor.configuration.getId().equals(paneId)) {
                    editor.initWithArgument(argument);
                    this.setActivePage(i);
                    return;
                }
                ++i;
            }
        }
        this.doAddNewPage(cfg, argument, title, image, doFocus);
    }

    private void doAddNewPage(PaneConfiguration editor, Object argument, String title, Image image, boolean doFocus) {
        try {
            AbstractEditorPane part = editor.build();
            PaneState state = part instanceof CompositeHeapEditorPane ? new PaneState(PaneState.PaneType.COMPOSITE_PARENT, null, editor.getId(), false) : new PaneState(PaneState.PaneType.EDITOR, null, editor.getId(), argument == null);
            state.setImage(part.getTitleImage());
            part.setPaneState(state);
            int index = this.addPage(part, this.getPaneEditorInput(), true);
            CTabItem item = this.getItem(index);
            item.setText(title != null ? title : part.getTitle());
            item.setImage(image != null ? image : part.getTitleImage());
            part.initWithArgument(argument);
            if (doFocus) {
                this.setActivePage(index);
                this.pageChange(index);
            }
        }
        catch (CoreException e) {
            ErrorHelper.logThrowableAndShowMessage(e);
        }
    }

    private int addPage(AbstractEditorPane editor, IEditorInput input, boolean isClosable) throws PartInitException {
        int index = this.getPageCount();
        this.addPage(index, editor, input, isClosable);
        return index;
    }

    private void addPage(int index, AbstractEditorPane pane, IEditorInput input, boolean isClosable) throws PartInitException {
        MultiPaneEditorSite site = new MultiPaneEditorSite(this, pane);
        pane.init(site, input);
        Composite parent2 = new Composite((Composite)this.container, this.getOrientation(pane));
        parent2.setLayout((Layout)new FillLayout());
        pane.createPartControl(parent2);
        final CTabItem item = new CTabItem(this.container, isClosable ? 64 : 0, index);
        item.setData((Object)pane);
        item.setControl((Control)parent2);
        this.nestedPanes.add(pane);
        pane.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propertyId) {
                MultiPaneEditor.this.handlePropertyChange(item, propertyId);
            }
        });
        this.navigatorState.paneAdded(pane.getPaneState());
    }

    private void handlePropertyChange(CTabItem item, int propertyId) {
        if (propertyId == 1) {
            IEditorPart editor = (IEditorPart)item.getData();
            item.setText(editor.getTitle());
            String tooltip = editor.getTitleToolTip();
            if (tooltip != null) {
                item.setToolTipText(tooltip);
            }
        } else if (propertyId == 0x1000001) {
            this.updateToolbar();
        } else if (propertyId == 0x1000002) {
            IEditorPart editor = (IEditorPart)item.getData();
            item.setImage(editor.getTitleImage());
        } else {
            this.firePropertyChange(propertyId);
        }
    }

    private int getOrientation(IEditorPart editor) {
        if (editor instanceof IWorkbenchPartOrientation) {
            return ((IWorkbenchPartOrientation)editor).getOrientation();
        }
        return this.getOrientation();
    }

    protected void disposePart(final IWorkbenchPart part) {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() {
                part.dispose();
            }

            public void handleException(Throwable e) {
            }
        });
    }

    private void removePage(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            throw new IndexOutOfBoundsException();
        }
        CTabItem item = this.getItem(pageIndex);
        AbstractEditorPane pane = this.getEditor(pageIndex);
        Control paneComposite = item.getControl();
        this.nestedPanes.remove(pane);
        AbstractEditorPane lastPane = this.nestedPanes.peek();
        if (pane.getPaneState() != null) {
            this.navigatorState.paneRemoved(pane.getPaneState());
        }
        item.dispose();
        this.disposePart((IWorkbenchPart)pane);
        if (paneComposite != null) {
            paneComposite.dispose();
        }
        if (lastPane != null) {
            CTabItem[] items = this.container.getItems();
            int ii = 0;
            while (ii < items.length) {
                if (items[ii].getData() == lastPane) {
                    if (this.getActivePage() == ii) break;
                    this.setActivePage(ii);
                    this.pageChange(ii);
                    break;
                }
                ++ii;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        site.setSelectionProvider((ISelectionProvider)new MultiPaneEditorSelectionProvider(this));
        this.navigatorState = new NavigatorState();
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            this.resource = file.getLocation().toFile();
            this.setPartName(file.getName());
            return;
        } else if (input instanceof IPathEditorInput) {
            IPath path = ((IPathEditorInput)input).getPath();
            this.resource = path.toFile();
            this.setPartName(path.lastSegment());
            return;
        } else {
            if (!(input instanceof IURIEditorInput)) throw new PartInitException(MessageUtil.format((String)Messages.MultiPaneEditor_UnsupportedEditorInput, (Object[])new Object[]{input.getClass().getName()}));
            URI uri = ((IURIEditorInput)input).getURI();
            if (!"file".equals(uri.getScheme())) throw new PartInitException(MessageUtil.format((String)Messages.MultiPaneEditor_UnsupportedScheme, (Object[])new Object[]{uri.toASCIIString()}));
            Path path = new Path(uri.getPath());
            this.resource = path.toFile();
            this.setPartName(path.lastSegment());
        }
    }

    public NavigatorState getNavigatorState() {
        return this.navigatorState;
    }

    public boolean isDirty() {
        for (AbstractEditorPane editor : this.nestedPanes) {
            if (!editor.isDirty()) continue;
            return true;
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void setFocus() {
        this.setFocus(this.getActivePage());
    }

    private void setFocus(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            return;
        }
        AbstractEditorPane editor = this.getEditor(pageIndex);
        if (editor != null) {
            editor.setFocus();
        }
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        if (event.getType() == 2) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage[] pages = MultiPaneEditor.this.getSite().getWorkbenchWindow().getPages();
                    int i = 0;
                    while (i < pages.length) {
                        if (((FileEditorInput)MultiPaneEditor.this.getEditorInput()).getFile().getProject().equals((Object)event.getResource())) {
                            IEditorPart editorPart = pages[i].findEditor(MultiPaneEditor.this.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                        }
                        ++i;
                    }
                }
            });
        }
    }

    protected void pageChange(int newPageIndex) {
        Control control = this.getControl(newPageIndex);
        if (control != null) {
            control.setVisible(true);
        }
        AbstractEditorPane pane = this.getEditor(newPageIndex);
        pane.setFocus();
        this.updateToolbar();
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor != null && contributor instanceof MultiPaneEditorContributor) {
            ((MultiPaneEditorContributor)contributor).setActivePage(pane);
        }
    }

    protected void showPopupMenuFor(final CTabItem item) {
        Display display = item.getDisplay();
        Menu menu = new Menu((Decorations)display.getActiveShell(), 8);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(Messages.MultiPaneEditor_Close);
        menuItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MultiPaneEditor.this.removePage(MultiPaneEditor.this.container.getSelectionIndex());
                MultiPaneEditor.this.updateToolbar();
            }
        });
        menuItem = new MenuItem(menu, 8);
        menuItem.setText(Messages.MultiPaneEditor_CloseOthers);
        menuItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = 0;
                while (index < MultiPaneEditor.this.container.getItemCount()) {
                    CTabItem tabItem = MultiPaneEditor.this.container.getItem(index);
                    if (tabItem == item) {
                        ++index;
                        continue;
                    }
                    MultiPaneEditor.this.removePage(index);
                }
            }
        });
        menuItem = new MenuItem(menu, 8);
        menuItem.setText(Messages.MultiPaneEditor_CloseAll);
        menuItem.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index = 0;
                while (index < MultiPaneEditor.this.container.getItemCount()) {
                    MultiPaneEditor.this.removePage(index);
                }
                MultiPaneEditor.this.updateToolbar();
            }
        });
        menu.setVisible(true);
        while (!menu.isDisposed() && menu.isVisible()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        menu.dispose();
    }

    public void updateToolbar() {
        this.toolbarMgr.removeAll();
        this.toolbarMgrHelp.removeAll();
        ToolbarMgr mgr = new ToolbarMgr((IToolBarManager)this.toolbarMgr, (IToolBarManager)this.toolbarMgrHelp);
        for (IMultiPaneEditorContributor contributor : this.contributors) {
            contributor.contributeToToolbar(mgr);
        }
        AbstractEditorPane activeEditor = this.getActiveEditor();
        if (activeEditor != null) {
            mgr.add((IContributionItem)new Separator());
            activeEditor.contributeToToolBar(mgr);
        }
        this.toolbarMgr.update(false);
        this.toolbarMgrHelp.update(false);
        if (activeEditor != null) {
            activeEditor.getEditorSite().getActionBars().updateActionBars();
        }
    }

    public ToolBarManager getToolBarManager() {
        return this.toolbarMgr;
    }

    public AbstractEditorPane getActiveEditor() {
        int index = this.getActivePage();
        if (index != -1) {
            return this.getEditor(index);
        }
        return null;
    }

    private int getActivePage() {
        if (this.container != null && !this.container.isDisposed()) {
            return this.container.getSelectionIndex();
        }
        return -1;
    }

    public void bringPageToTop(PaneState state) {
        CTabItem[] cTabItemArray = this.container.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (((AbstractEditorPane)item.getData()).getPaneState() == state) {
                this.setActivePage(this.container.indexOf(item));
                break;
            }
            ++n2;
        }
    }

    public void initWithAnotherArgument(PaneState parent, PaneState child) {
        AbstractEditorPane pane = this.getEditor(parent);
        if (pane != null) {
            pane.initWithArgument(child);
        }
    }

    public void closePage(PaneState state) {
        CTabItem[] cTabItemArray = this.container.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (((AbstractEditorPane)item.getData()).getPaneState() == state) {
                this.removePage(this.container.indexOf(item));
                break;
            }
            ++n2;
        }
    }

    private Control getControl(int pageIndex) {
        return this.getItem(pageIndex).getControl();
    }

    protected AbstractEditorPane getEditor(int pageIndex) {
        CTabItem item = this.getItem(pageIndex);
        return item != null ? (AbstractEditorPane)item.getData() : null;
    }

    public AbstractEditorPane getEditor(PaneState state) {
        CTabItem[] cTabItemArray = this.container.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            AbstractEditorPane pane = (AbstractEditorPane)item.getData();
            if (pane.getPaneState() == state) {
                return pane;
            }
            ++n2;
        }
        return null;
    }

    private CTabItem getItem(int pageIndex) {
        return this.container.getItem(pageIndex);
    }

    private int getPageCount() {
        if (this.container != null && !this.container.isDisposed()) {
            return this.container.getItemCount();
        }
        return 0;
    }

    private void setActivePage(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            throw new IndexOutOfBoundsException();
        }
        this.container.setSelection(pageIndex);
    }

    public boolean isDisposed() {
        return this.container.isDisposed();
    }

    public File getResourceFile() {
        return this.resource;
    }

    public IQueryContext getQueryContext() {
        return this.queryContext;
    }

    protected void setQueryContext(IQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    private static class ToolbarMgr
    implements IToolBarManager {
        private IToolBarManager delegate;
        private IToolBarManager help;

        public ToolbarMgr(IToolBarManager delegate, IToolBarManager help) {
            this.delegate = delegate;
            this.help = help;
        }

        public void add(IAction action) {
            this.delegate.add(action);
        }

        public void add(IContributionItem item) {
            this.delegate.add(item);
        }

        public void appendToGroup(String groupName, IAction action) {
            if ("help".equals(groupName)) {
                this.help.add(action);
            } else {
                this.delegate.appendToGroup(groupName, action);
            }
        }

        public void appendToGroup(String groupName, IContributionItem item) {
            if ("help".equals(groupName)) {
                this.help.add(item);
            } else {
                this.delegate.appendToGroup(groupName, item);
            }
        }

        public IContributionItem find(String id) {
            return this.delegate.find(id);
        }

        public IContributionItem[] getItems() {
            return this.delegate.getItems();
        }

        public IContributionManagerOverrides getOverrides() {
            return this.delegate.getOverrides();
        }

        public void insertAfter(String id, IAction action) {
            this.delegate.insertAfter(id, action);
        }

        public void insertAfter(String id, IContributionItem item) {
            this.delegate.insertAfter(id, item);
        }

        public void insertBefore(String id, IAction action) {
            this.delegate.insertBefore(id, action);
        }

        public void insertBefore(String id, IContributionItem item) {
            this.delegate.insertBefore(id, item);
        }

        public boolean isDirty() {
            return this.delegate.isDirty();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public void markDirty() {
            this.delegate.markDirty();
        }

        public void prependToGroup(String groupName, IAction action) {
            if ("help".equals(groupName)) {
                if (this.help.isEmpty()) {
                    this.help.add(action);
                } else {
                    this.help.insertBefore(this.help.getItems()[0].getId(), action);
                }
            } else {
                this.delegate.prependToGroup(groupName, action);
            }
        }

        public void prependToGroup(String groupName, IContributionItem item) {
            if ("help".equals(groupName)) {
                if (this.help.isEmpty()) {
                    this.help.add(item);
                } else {
                    this.help.insertBefore(this.help.getItems()[0].getId(), item);
                }
            } else {
                this.delegate.prependToGroup(groupName, item);
            }
        }

        public IContributionItem remove(IContributionItem item) {
            return this.delegate.remove(item);
        }

        public IContributionItem remove(String id) {
            return this.delegate.remove(id);
        }

        public void removeAll() {
            this.delegate.removeAll();
        }

        public void update(boolean force) {
            this.delegate.update(force);
        }
    }
}

