/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.internal.query.arguments.TextEditor;
import org.eclipse.mat.util.PatternUtil;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class ImageTextEditor
extends TextEditor {
    private ControlDecoration field;
    private ImageHyperlink button;

    public ImageTextEditor(Composite parent, IQueryContext context, ArgumentDescriptor descriptor, TableItem item, final TextEditor.DecoratorType decorator) {
        super(parent, context, descriptor, item, decorator);
        this.text.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ImageTextEditor.this.fireFocusEvent(decorator.getHelpText());
            }

            public void focusLost(FocusEvent e) {
                if (decorator.equals((Object)TextEditor.DecoratorType.PATTERN)) {
                    ImageTextEditor.this.text.setText(PatternUtil.smartFix((String)ImageTextEditor.this.text.getText(), (boolean)false));
                }
            }
        });
    }

    protected void createContents() {
        Font font = this.item.getFont();
        Color bg = this.item.getBackground();
        this.setFont(font);
        this.setBackground(bg);
        this.text = new Text((Composite)this, 16384);
        this.text.setFont(font);
        this.field = new ControlDecoration((Control)this.text, 1);
        this.field.setImage(this.decorator.getImage());
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    ImageTextEditor.this.editingDone();
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImageTextEditor.this.editingDone();
            }
        });
        this.createHelpControl(this);
        this.setLayout(new ButtonEditorLayout());
    }

    protected void editingDone() {
        this.value = this.text.getText().trim();
        if (this.decorator.equals((Object)TextEditor.DecoratorType.PATTERN)) {
            this.value = PatternUtil.smartFix((String)this.value.toString(), (boolean)false);
        }
        this.fireValueChangedEvent(this.value, this);
    }

    private void createHelpControl(Composite parent) {
        this.button = new ImageHyperlink(parent, 0x1000000){
            {
                this.marginHeight = 0;
            }
        };
        this.button.setImage(MemoryAnalyserPlugin.getImage("icons/help.png"));
        this.button.setFont(this.item.getFont());
        this.button.setBackground(this.item.getBackground());
        this.button.setToolTipText(JFaceResources.getString((String)"helpToolTip"));
        this.button.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/org.eclipse.mat.ui.help/reference/selectingqueries.html#ref_queryarguments__" + ImageTextEditor.this.decorator.getHelpLink());
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.field.dispose();
    }

    private class ButtonEditorLayout
    extends Layout {
        private static final int IMAGE_MARGIN = 17;

        private ButtonEditorLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point size = ImageTextEditor.this.button.computeSize(-1, -1, force);
            if (ImageTextEditor.this.text != null) {
                ImageTextEditor.this.text.setBounds(17, 0, bounds.width - size.x - 17, bounds.height);
            }
            ImageTextEditor.this.button.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point contentsSize = ImageTextEditor.this.text.computeSize(-1, -1, force);
            Point buttonSize = ImageTextEditor.this.button.computeSize(-1, -1, force);
            Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
            return result;
        }
    }
}

