/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes.oql;

import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.ClassNameExtractor;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.ClassesSuggestionProvider;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.CommentScanner;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.OQLContentAssistantProcessor;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.OQLScanner;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.swt.graphics.Color;

public class OQLTextViewerConfiguration
extends SourceViewerConfiguration {
    private ISnapshot snapshot;
    private Color comment;
    private Color keyword;

    public OQLTextViewerConfiguration(ISnapshot snapshot, Color comment, Color keyword) {
        this.snapshot = snapshot;
        this.comment = comment;
        this.keyword = keyword;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__oql_select", "__oql_from", "__oql_where", "__oql_union"};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant cAssist = new ContentAssistant();
        ClassNameExtractor classNameExtr = new ClassNameExtractor();
        ClassesSuggestionProvider classSuggestions = null;
        try {
            classSuggestions = new ClassesSuggestionProvider(this.snapshot);
        }
        catch (SnapshotException e) {
            ErrorHelper.logThrowable(e);
        }
        OQLContentAssistantProcessor fromProcessor = new OQLContentAssistantProcessor(classSuggestions, classNameExtr);
        cAssist.setContentAssistProcessor((IContentAssistProcessor)fromProcessor, "__oql_from");
        cAssist.setContentAssistProcessor((IContentAssistProcessor)fromProcessor, "__dftl_partition_content_type");
        cAssist.enableAutoActivation(true);
        cAssist.setAutoActivationDelay(500);
        cAssist.setProposalPopupOrientation(21);
        cAssist.setContextInformationPopupOrientation(21);
        return cAssist;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)new OQLScanner(this.keyword));
        reconciler.setDamager((IPresentationDamager)dr, "__oql_select");
        reconciler.setRepairer((IPresentationRepairer)dr, "__oql_select");
        reconciler.setDamager((IPresentationDamager)dr, "__oql_from");
        reconciler.setRepairer((IPresentationRepairer)dr, "__oql_from");
        reconciler.setDamager((IPresentationDamager)dr, "__oql_where");
        reconciler.setRepairer((IPresentationRepairer)dr, "__oql_where");
        reconciler.setDamager((IPresentationDamager)dr, "__oql_union");
        reconciler.setRepairer((IPresentationRepairer)dr, "__oql_union");
        dr = new DefaultDamagerRepairer((ITokenScanner)new CommentScanner(this.comment));
        reconciler.setDamager((IPresentationDamager)dr, "__oql_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__oql_comment");
        return reconciler;
    }
}

