/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.snapshot.IOQLQuery;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQLParseException;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.AbstractPaneJob;
import org.eclipse.mat.ui.editor.CompositeHeapEditorPane;
import org.eclipse.mat.ui.editor.EditorPaneRegistry;
import org.eclipse.mat.ui.snapshot.panes.oql.OQLTextViewerConfiguration;
import org.eclipse.mat.ui.snapshot.panes.oql.textPartitioning.OQLPartitionScanner;
import org.eclipse.mat.ui.snapshot.panes.oql.textPartitioning.PatchedFastPartitioner;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.PaneState;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public class OQLPane
extends CompositeHeapEditorPane {
    private SourceViewer queryViewer;
    private StyledText queryString;
    private Color commentCol;
    private Color keywordCol;
    private Action executeAction;
    private Action copyQueryStringAction;
    private Action contentAssistAction;

    public void createPartControl(Composite parent) {
        SashForm sash = new SashForm(parent, 66048);
        this.queryViewer = new SourceViewer((Composite)sash, null, 66);
        this.queryString = this.queryViewer.getTextWidget();
        this.queryString.setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        ITheme current = themeManager.getCurrentTheme();
        ColorRegistry colorRegistry = current.getColorRegistry();
        this.commentCol = colorRegistry.get("org.eclipse.mat.ui.oql_comment");
        this.keywordCol = colorRegistry.get("org.eclipse.mat.ui.oql_keyword");
        IDocument d = this.createDocument();
        d.set(Messages.OQLPane_F1ForHelp);
        this.queryViewer.setDocument(d);
        this.queryViewer.configure((SourceViewerConfiguration)new OQLTextViewerConfiguration(this.getSnapshot(), this.commentCol, this.keywordCol));
        this.queryString.selectAll();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.queryString, "org.eclipse.mat.ui.help.oql");
        this.queryString.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 && (e.stateMask & SWT.MOD1) != 0) {
                    OQLPane.this.executeAction.run();
                    e.doit = false;
                } else if (e.keyCode == 32 && (e.stateMask & 0x40000) != 0) {
                    OQLPane.this.contentAssistAction.run();
                } else if (e.keyCode == 0x100000E) {
                    OQLPane.this.executeAction.run();
                    e.doit = false;
                }
            }
        });
        this.queryString.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                IActionBars actionBars = OQLPane.this.getEditor().getEditorSite().getActionBars();
                actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)OQLPane.this.copyQueryStringAction);
                actionBars.updateActionBars();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.queryString.setFocus();
        this.createContainer((Composite)sash);
        sash.setWeights(new int[]{1, 4});
        this.makeActions();
        this.hookContextMenu();
    }

    public void dispose() {
    }

    private IDocument createDocument() {
        Document doc = new Document();
        PatchedFastPartitioner partitioner = new PatchedFastPartitioner((IPartitionTokenScanner)new OQLPartitionScanner(), new String[]{"__dftl_partition_content_type", "__oql_select", "__oql_from", "__oql_where", "__oql_union", "__oql_comment"});
        partitioner.connect((IDocument)doc);
        doc.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        return doc;
    }

    private ISnapshot getSnapshot() {
        IQueryContext context = this.getEditor().getQueryContext();
        ISnapshot snapshot = (ISnapshot)context.get(ISnapshot.class, null);
        return snapshot;
    }

    private void makeActions() {
        this.executeAction = new ExecuteQueryAction();
        IWorkbenchWindow window = this.getEditorSite().getWorkbenchWindow();
        ActionFactory.IWorkbenchAction globalAction = ActionFactory.COPY.create(window);
        this.copyQueryStringAction = new Action(){

            public void run() {
                OQLPane.this.queryString.copy();
            }
        };
        this.copyQueryStringAction.setAccelerator(globalAction.getAccelerator());
        this.contentAssistAction = new Action(){

            public void run() {
                OQLPane.this.queryViewer.doOperation(13);
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    protected int findInText(String query, int line, int column) {
        charAt = 0;
        if (true) ** GOTO lbl6
        block0: while (true) {
            if ((c = query.charAt(charAt++)) != '\n') ** GOTO lbl-1000
            --line;
            while (line > 1) lbl-1000:
            // 2 sources

            {
                if (charAt < query.length()) continue block0;
            }
            break;
        }
        while (column > 1 && charAt < query.length()) {
            if ((c = query.charAt(charAt++)) == '\t') {
                column -= 8;
                continue;
            }
            --column;
        }
        return charAt;
    }

    private void hookContextMenu() {
    }

    public void contributeToToolBar(IToolBarManager manager) {
        manager.add((IAction)this.executeAction);
        super.contributeToToolBar(manager);
    }

    public void initWithArgument(Object param) {
        if (param instanceof String) {
            this.queryViewer.getDocument().set((String)param);
            this.executeAction.run();
        } else if (param instanceof QueryResult) {
            QueryResult queryResult = (QueryResult)param;
            this.initQueryResult(queryResult, null);
        } else if (param instanceof PaneState) {
            this.queryViewer.getDocument().set(((PaneState)param).getIdentifier());
            new ExecuteQueryAction((PaneState)param).run();
        }
    }

    private void initQueryResult(QueryResult queryResult, PaneState state) {
        IOQLQuery.Result subject = (IOQLQuery.Result)queryResult.getSubject();
        this.queryViewer.getDocument().set(subject.getOQLQuery());
        AbstractEditorPane pane = EditorPaneRegistry.instance().createNewPane((IResult)subject, this.getClass());
        if (state == null) {
            for (PaneState child : this.getPaneState().getChildren()) {
                if (!this.queryString.getText().equals(child.getIdentifier())) continue;
                state = child;
                break;
            }
            if (state == null) {
                state = new PaneState(PaneState.PaneType.COMPOSITE_CHILD, this.getPaneState(), this.queryString.getText(), true);
                state.setImage(this.getTitleImage());
            }
        }
        pane.setPaneState(state);
        this.createResultPane(pane, queryResult);
    }

    public void setFocus() {
        this.queryString.setFocus();
    }

    public void createExceptionPane(Exception cause, String queryString) throws PartInitException {
        StringBuilder buf = new StringBuilder(256);
        buf.append(Messages.OQLPane_ExecutedQuery);
        buf.append(queryString);
        Throwable t = null;
        if (cause instanceof SnapshotException) {
            buf.append(Messages.OQLPane_ProblemReported);
            buf.append(cause.getMessage());
            t = cause.getCause();
        } else {
            t = cause;
        }
        if (t != null) {
            buf.append("\n\n");
            StringWriter w = new StringWriter();
            PrintWriter o = new PrintWriter(w);
            t.printStackTrace(o);
            o.flush();
            buf.append(w.toString());
        }
        try {
            AbstractEditorPane pane = EditorPaneRegistry.instance().createNewPane("TextViewPane");
            if (pane == null) {
                throw new PartInitException(Messages.OQLPane_PaneNotFound);
            }
            this.createResultPane(pane, buf.toString());
        }
        catch (CoreException e) {
            throw new PartInitException(ErrorHelper.createErrorStatus(e));
        }
    }

    public String getTitle() {
        return "OQL";
    }

    public Image getTitleImage() {
        return MemoryAnalyserPlugin.getImage("$nl$/icons/oql.gif");
    }

    public AbstractEditorPane getEmbeddedPane() {
        return super.getEmbeddedPane();
    }

    private class ExecuteQueryAction
    extends Action {
        private PaneState state;

        public ExecuteQueryAction() {
            this(null);
        }

        public ExecuteQueryAction(PaneState state) {
            this.state = state;
            this.setText(Messages.OQLPane_ExecuteQuery);
            this.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/execute_query.gif"));
        }

        public void run() {
            try {
                String query = OQLPane.this.queryString.getSelectionText();
                Point queryRange = OQLPane.this.queryString.getSelectionRange();
                if ("".equals(query)) {
                    query = OQLPane.this.queryString.getText();
                    queryRange = new Point(0, OQLPane.this.queryString.getCharCount());
                }
                try {
                    SnapshotFactory.createQuery((String)query);
                    new OQLJob(OQLPane.this, query, this.state).schedule();
                }
                catch (OQLParseException e) {
                    int start = OQLPane.this.findInText(query, e.getLine(), e.getColumn());
                    StyleRange style2 = new StyleRange();
                    style2.start = start + queryRange.x;
                    style2.length = queryRange.y - start;
                    style2.foreground = JFaceResources.getColorRegistry().get("ERROR_COLOR");
                    style2.underline = true;
                    style2.underlineStyle = 3;
                    OQLPane.this.queryString.replaceStyleRanges(0, OQLPane.this.queryString.getCharCount(), new StyleRange[]{style2});
                    OQLPane.this.createExceptionPane((Exception)((Object)e), query);
                }
                catch (Exception e) {
                    OQLPane.this.createExceptionPane(e, query);
                }
            }
            catch (PartInitException e1) {
                ErrorHelper.logThrowableAndShowMessage(e1, Messages.OQLPane_ErrorExecutingQuery);
            }
        }
    }

    class OQLJob
    extends AbstractPaneJob {
        String queryString;
        PaneState state;

        public OQLJob(AbstractEditorPane pane, String queryString, PaneState state) {
            super(queryString.toString(), pane);
            this.queryString = queryString;
            this.state = state;
            this.setUser(true);
        }

        protected IStatus doRun(IProgressMonitor monitor) {
            try {
                QueryDescriptor descriptor = QueryRegistry.instance().getQuery("oql");
                ArgumentSet argumentSet = descriptor.createNewArgumentSet(OQLPane.this.getEditor().getQueryContext());
                argumentSet.setArgumentValue("queryString", (Object)this.queryString);
                final QueryResult result = argumentSet.execute((IProgressListener)new ProgressMonitorWrapper(monitor));
                OQLPane.this.queryString.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        OQLPane.this.initQueryResult(result, OQLJob.this.state);
                    }
                });
            }
            catch (Exception e) {
                OQLPane.this.queryString.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            OQLPane.this.createExceptionPane(e, OQLJob.this.queryString);
                        }
                        catch (PartInitException pie) {
                            ErrorHelper.logThrowable(pie);
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }
}

