/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes.oql.textPartitioning;

import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class PatchedFastPartitioner
extends FastPartitioner {
    public PatchedFastPartitioner(IPartitionTokenScanner scanner, String[] legalContentTypes) {
        super(scanner, legalContentTypes);
    }

    public ITypedRegion getPartition(int offset) {
        this.checkInitialization();
        if (this.fDocument.getLength() <= offset) {
            try {
                Position[] category = this.getPositions();
                if (category.length > 0) {
                    TypedPosition previous = (TypedPosition)category[category.length - 1];
                    if (previous.includes(offset - 1)) {
                        return new TypedRegion(previous.getOffset(), previous.getLength(), previous.getType());
                    }
                    int endOffset = previous.getOffset() + previous.getLength();
                    return new TypedRegion(endOffset, this.fDocument.getLength() - endOffset, "__dftl_partition_content_type");
                }
                return new TypedRegion(0, this.fDocument.getLength(), "__dftl_partition_content_type");
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                return new TypedRegion(0, this.fDocument.getLength(), "__dftl_partition_content_type");
            }
        }
        return super.getPartition(offset);
    }
}

