/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.parser.IIndexBuilder;
import org.eclipse.mat.parser.internal.GarbageCleaner;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.ParserPlugin;
import org.eclipse.mat.parser.internal.PreliminaryIndexImpl;
import org.eclipse.mat.parser.internal.SnapshotImpl;
import org.eclipse.mat.parser.internal.SnapshotImplBuilder;
import org.eclipse.mat.parser.internal.oql.OQLQueryImpl;
import org.eclipse.mat.parser.internal.util.ParserRegistry;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.XGCRootInfo;
import org.eclipse.mat.parser.model.XSnapshotInfo;
import org.eclipse.mat.snapshot.IOQLQuery;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.snapshot.SnapshotFormat;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotFactoryImpl
implements SnapshotFactory.Implementation {
    private Map<File, SnapshotEntry> snapshotCache = new HashMap<File, SnapshotEntry>();

    public ISnapshot openSnapshot(File file, Map<String, String> args, IProgressListener listener) throws SnapshotException {
        ISnapshot answer = null;
        SnapshotEntry entry = this.snapshotCache.get(file);
        if (entry != null && (answer = (ISnapshot)entry.snapshot.get()) != null) {
            SnapshotEntry snapshotEntry = entry;
            snapshotEntry.usageCount = snapshotEntry.usageCount + 1;
            return answer;
        }
        String name = file.getAbsolutePath();
        int p = name.lastIndexOf(46);
        String prefix = p >= 0 ? name.substring(0, p + 1) : String.valueOf(name) + ".";
        String snapshot_identifier = args.get("snapshot_identifier");
        if (snapshot_identifier != null) {
            prefix = String.valueOf(prefix) + snapshot_identifier + ".";
        }
        try {
            File indexFile = new File(String.valueOf(prefix) + "index");
            if (indexFile.exists()) {
                if (file.lastModified() <= indexFile.lastModified()) {
                    answer = SnapshotImpl.readFromFile(file, prefix, listener);
                } else {
                    String message = MessageUtil.format((String)Messages.SnapshotFactoryImpl_ReparsingHeapDumpAsIndexOutOfDate, (Object[])new Object[]{file.getPath(), new Date(file.lastModified()), indexFile.getPath(), new Date(indexFile.lastModified())});
                    listener.sendUserMessage(IProgressListener.Severity.INFO, message, null);
                    listener.subTask(Messages.SnapshotFactoryImpl_ReparsingHeapDumpWithOutOfDateIndex);
                }
            }
        }
        catch (IOException ignore_and_reparse) {
            String text = ignore_and_reparse.getMessage() != null ? ignore_and_reparse.getMessage() : ignore_and_reparse.getClass().getName();
            String message = MessageUtil.format((String)Messages.SnapshotFactoryImpl_Error_ReparsingHeapDump, (Object[])new Object[]{text});
            listener.sendUserMessage(IProgressListener.Severity.WARNING, message, (Throwable)ignore_and_reparse);
            listener.subTask(message);
        }
        if (answer == null) {
            this.deleteIndexFiles(file, prefix, listener);
            answer = this.parse(file, prefix, args, listener);
        }
        entry = new SnapshotEntry(1, answer);
        this.snapshotCache.put(file, entry);
        return answer;
    }

    public synchronized void dispose(ISnapshot snapshot) {
        Iterator<SnapshotEntry> iter = this.snapshotCache.values().iterator();
        while (iter.hasNext()) {
            SnapshotEntry entry = iter.next();
            ISnapshot s = (ISnapshot)entry.snapshot.get();
            if (s == null) {
                iter.remove();
                continue;
            }
            if (s != snapshot) continue;
            SnapshotEntry snapshotEntry = entry;
            snapshotEntry.usageCount = snapshotEntry.usageCount - 1;
            if (entry.usageCount == 0) {
                snapshot.dispose();
                iter.remove();
            }
            return;
        }
        if (snapshot != null) {
            snapshot.dispose();
        }
    }

    public IOQLQuery createQuery(String queryString) throws SnapshotException {
        return new OQLQueryImpl(queryString);
    }

    public List<SnapshotFormat> getSupportedFormats() {
        ArrayList<SnapshotFormat> answer = new ArrayList<SnapshotFormat>();
        for (ParserRegistry.Parser parser : ParserPlugin.getDefault().getParserRegistry().delegates()) {
            answer.add(parser.getSnapshotFormat());
        }
        return answer;
    }

    private final ISnapshot parse(File file, String prefix, Map<String, String> args, IProgressListener listener) throws SnapshotException {
        ParserRegistry registry = ParserPlugin.getDefault().getParserRegistry();
        List<ParserRegistry.Parser> parsers = registry.matchParser(file.getName());
        if (parsers.isEmpty()) {
            parsers.addAll(registry.delegates());
        }
        ArrayList<IOException> errors = new ArrayList<IOException>();
        for (ParserRegistry.Parser parser : parsers) {
            IIndexBuilder indexBuilder = parser.create(IIndexBuilder.class, "indexBuilder");
            if (indexBuilder == null) continue;
            try {
                String snapshot_identifier;
                indexBuilder.init(file, prefix);
                XSnapshotInfo snapshotInfo = new XSnapshotInfo();
                snapshotInfo.setPath(file.getAbsolutePath());
                snapshotInfo.setPrefix(prefix);
                snapshotInfo.setProperty("$heapFormat", (Serializable)((Object)parser.getId()));
                if (Boolean.parseBoolean(args.get("keep_unreachable_objects"))) {
                    snapshotInfo.setProperty("keep_unreachable_objects", Integer.valueOf(2048));
                }
                if ((snapshot_identifier = args.get("snapshot_identifier")) != null) {
                    snapshotInfo.setProperty("$runtimeId", (Serializable)((Object)snapshot_identifier));
                }
                PreliminaryIndexImpl idx = new PreliminaryIndexImpl(snapshotInfo);
                indexBuilder.fill(idx, listener);
                if (ParserPlugin.getDefault().isDebugging()) {
                    this.validateIndices(idx, listener);
                }
                SnapshotImplBuilder builder = new SnapshotImplBuilder(idx.getSnapshotInfo());
                int[] purgedMapping = GarbageCleaner.clean(idx, builder, args, listener);
                indexBuilder.clean(purgedMapping, listener);
                SnapshotImpl snapshot = builder.create(parser, listener);
                snapshot.calculateDominatorTree(listener);
                return snapshot;
            }
            catch (IOException ioe) {
                errors.add(ioe);
                indexBuilder.cancel();
            }
            catch (Exception e) {
                indexBuilder.cancel();
                throw SnapshotException.rethrow((Throwable)e);
            }
        }
        if (errors.size() > 1) {
            MultiStatus status = new MultiStatus("org.eclipse.mat.parser", 0, MessageUtil.format((String)Messages.SnapshotFactoryImpl_ErrorOpeningHeapDump, (Object[])new Object[]{file.getName()}), null);
            for (IOException error : errors) {
                status.add((IStatus)new Status(4, "org.eclipse.mat.parser", 0, error.getLocalizedMessage(), (Throwable)error));
            }
            CoreException ce = new CoreException((IStatus)status);
            throw new SnapshotException(MessageUtil.format((String)Messages.SnapshotFactoryImpl_Error_OpeningHeapDump, (Object[])new Object[]{file.getName()}), (Throwable)ce);
        }
        if (errors.size() == 1) {
            throw new SnapshotException(MessageUtil.format((String)Messages.SnapshotFactoryImpl_Error_OpeningHeapDump, (Object[])new Object[]{file.getName()}), (Throwable)errors.get(0));
        }
        throw new SnapshotException(MessageUtil.format((String)Messages.SnapshotFactoryImpl_Error_NoParserRegistered, (Object[])new Object[]{file.getName()}));
    }

    private void validateIndices(PreliminaryIndexImpl pidx, IProgressListener listener) {
        int maxIndex = pidx.identifiers.size();
        listener.beginTask(Messages.SnapshotFactoryImpl_ValidatingIndices, maxIndex / 1000 + 1);
        long prevAddress = -1L;
        int nObjs = 0;
        int nObjsFromClass = 0;
        int nCls = 0;
        int i = 0;
        while (i < maxIndex) {
            String desc;
            int clsId;
            String desc2;
            String desc3;
            long addr;
            if (i % 1000 == 0) {
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                listener.worked(1);
            }
            if (prevAddress == (addr = pidx.identifiers.get(i))) {
                desc3 = this.objDesc(pidx, i);
                int j = pidx.identifiers.reverse(addr);
                desc2 = this.objDesc(pidx, j);
                listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_IndexAddressHasSameAddressAsPrevious, (Object[])new Object[]{i, desc3, SnapshotFactoryImpl.format(addr), desc2}), null);
            }
            if (prevAddress > addr) {
                desc3 = this.objDesc(pidx, i);
                listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_IndexAddressIsSmallerThanPrevious, (Object[])new Object[]{i, desc3, SnapshotFactoryImpl.format(addr), SnapshotFactoryImpl.format(prevAddress)}), null);
            }
            prevAddress = addr;
            int j = pidx.identifiers.reverse(addr);
            if (i != j) {
                String desc1 = this.objDesc(pidx, i);
                desc2 = this.objDesc(pidx, j);
                listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_IndexAddressFoundAtOtherID, (Object[])new Object[]{i, SnapshotFactoryImpl.format(addr), j, desc1, desc2}), null);
            }
            if ((clsId = pidx.object2classId.get(i)) < 0) {
                listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_ClassIDNotFound, (Object[])new Object[]{i, SnapshotFactoryImpl.format(addr), clsId}), null);
            } else {
                ClassImpl ci = (ClassImpl)pidx.classesById.get(clsId);
                if (ci == null) {
                    listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_ClassImplNotFound, (Object[])new Object[]{i, SnapshotFactoryImpl.format(addr), clsId}), null);
                }
            }
            int[] outs = pidx.outbound.get(i);
            if (outs == null) {
                desc = this.objDesc(pidx, i);
                listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_NoOutbounds, (Object[])new Object[]{i, SnapshotFactoryImpl.format(addr), desc}), null);
            } else if (outs.length == 0) {
                desc = this.objDesc(pidx, i);
                listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_EmptyOutbounds, (Object[])new Object[]{i, SnapshotFactoryImpl.format(addr), desc}), null);
            } else {
                int k = 0;
                while (k < outs.length) {
                    if (outs[k] < 0 || outs[k] >= maxIndex) {
                        String desc4 = this.objDesc(pidx, i);
                        listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_InvalidOutbound, (Object[])new Object[]{i, SnapshotFactoryImpl.format(addr), desc4, k, outs[k]}), null);
                    }
                    ++k;
                }
                if (outs[0] != clsId) {
                    long address = outs[0] >= 0 && outs[0] < maxIndex ? pidx.identifiers.get(outs[0]) : -1L;
                    String desc5 = this.objDesc(pidx, i);
                    listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_InvalidFirstOutbound, (Object[])new Object[]{i, SnapshotFactoryImpl.format(addr), desc5, outs[0], SnapshotFactoryImpl.format(address), clsId}), null);
                }
            }
            ClassImpl ci = (ClassImpl)pidx.classesById.get(i);
            if (ci == null) {
                ++nObjs;
                long size = pidx.array2size.getSize(i);
                if (size < 0L) {
                    ci = (ClassImpl)pidx.classesById.get(clsId);
                    listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_IndexAddressNegativeArraySize, (Object[])new Object[]{i, SnapshotFactoryImpl.format(addr), size, ci.getTechnicalName()}), null);
                }
            } else {
                int clsId2;
                int id;
                ++nCls;
                long addr2 = ci.getObjectAddress();
                if (addr != addr2) {
                    listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_ClassIndexAddressNotEqualClassObjectAddress, (Object[])new Object[]{i, SnapshotFactoryImpl.format(addr), SnapshotFactoryImpl.format(addr2), ci.getTechnicalName()}), null);
                }
                if (i != (id = ci.getObjectId())) {
                    listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_ClassIndexNotEqualClassObjectID, (Object[])new Object[]{i, SnapshotFactoryImpl.format(addr), id, ci.getTechnicalName()}), null);
                }
                if (clsId != (clsId2 = ci.getClassId())) {
                    listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_ClassIndexAddressTypeIDNotEqualClassImplClassId, (Object[])new Object[]{i, SnapshotFactoryImpl.format(addr), clsId, clsId2, ci.getTechnicalName()}), null);
                }
                long ldrAddr = ci.getClassLoaderAddress();
                int ldr = ci.getClassLoaderId();
                if (ldr < 0) {
                    listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_ClassIndexAddressNoLoaderID, (Object[])new Object[]{i, SnapshotFactoryImpl.format(addr), clsId, ldr, SnapshotFactoryImpl.format(ldrAddr), ci.getTechnicalName()}), null);
                }
                nObjsFromClass += ci.getNumberOfObjects();
            }
            ++i;
        }
        if (nObjsFromClass != nObjs + nCls) {
            listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_ObjectsFoundButClassesHadObjectsAndClassesInTotal, (Object[])new Object[]{nObjs, nCls, nObjsFromClass}), null);
        }
        listener.subTask(Messages.SnapshotFactoryImpl_ValidatingGCRoots);
        IteratorInt it = pidx.gcRoots.keys();
        while (it.hasNext()) {
            int idx = it.next();
            if (idx < 0 || idx >= maxIndex) {
                listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_GCRootIDOutOfRange, (Object[])new Object[]{idx, maxIndex}), null);
                continue;
            }
            ListIterator it2 = ((List)pidx.gcRoots.get(idx)).listIterator();
            while (it2.hasNext()) {
                XGCRootInfo ifo = (XGCRootInfo)((Object)it2.next());
                int objid = ifo.getObjectId();
                if (objid == idx) continue;
                listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_GCRootIDDoesNotMatchIndex, (Object[])new Object[]{objid, idx}), null);
            }
        }
        int[] nArray = pidx.thread2objects2roots.getAllKeys();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int thrd = nArray[n2];
            if (thrd < 0 || thrd >= maxIndex) {
                listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_GCThreadIDOutOfRange, (Object[])new Object[]{thrd, maxIndex}), null);
            } else {
                HashMapIntObject l = (HashMapIntObject)pidx.thread2objects2roots.get(thrd);
                int[] nArray2 = l.getAllKeys();
                int n3 = nArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    int idx = nArray2[n4];
                    if (idx < 0 || idx >= maxIndex) {
                        listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_GCThreadRootIDOutOfRange, (Object[])new Object[]{thrd, idx, maxIndex}), null);
                    } else {
                        for (XGCRootInfo ifo : (List)l.get(idx)) {
                            int objid = ifo.getObjectId();
                            if (objid == idx) continue;
                            listener.sendUserMessage(IProgressListener.Severity.ERROR, MessageUtil.format((String)Messages.SnapshotFactoryImpl_GCThreadRootIDDoesNotMatchIndex, (Object[])new Object[]{thrd, objid, idx}), null);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        listener.done();
    }

    private static String format(long address) {
        return "0x" + Long.toHexString(address);
    }

    private String objDesc(PreliminaryIndexImpl pidx, int newObjId) {
        String clsInfo;
        if (newObjId >= 0) {
            ClassImpl classInfo = (ClassImpl)pidx.classesById.get(newObjId);
            if (classInfo != null) {
                clsInfo = MessageUtil.format((String)Messages.SnapshotFactoryImpl_ObjDescClass, (Object[])new Object[]{classInfo.getName()});
            } else {
                int clsId = pidx.object2classId.get(newObjId);
                if (clsId >= 0 && clsId < pidx.identifiers.size()) {
                    long clsAddr = pidx.identifiers.get(clsId);
                    classInfo = (ClassImpl)pidx.classesById.get(clsId);
                    clsInfo = classInfo != null ? MessageUtil.format((String)Messages.SnapshotFactoryImpl_ObjDescObjType, (Object[])new Object[]{classInfo.getName(), SnapshotFactoryImpl.format(clsAddr)}) : MessageUtil.format((String)Messages.SnapshotFactoryImpl_ObjDescObjTypeAddress, (Object[])new Object[]{SnapshotFactoryImpl.format(clsAddr)});
                } else {
                    clsInfo = "";
                }
            }
        } else {
            clsInfo = "";
        }
        return clsInfo;
    }

    private void deleteIndexFiles(File file, String prefix, IProgressListener listener) {
        Pattern logPattern;
        Pattern threadPattern;
        Pattern indexPattern;
        String fragment;
        File[] files;
        File prefixFile = new File(prefix);
        File directory = prefixFile.getParentFile();
        if (directory == null) {
            directory = new File(".");
        }
        if ((files = directory.listFiles(new FileFilter(fragment = prefixFile.getName(), indexPattern = Pattern.compile("([A-Za-z0-9]+\\.)?index$"), threadPattern = Pattern.compile("threads$"), logPattern = Pattern.compile("inbound\\.index.*\\.log$")){
            private final /* synthetic */ String val$fragment;
            private final /* synthetic */ Pattern val$indexPattern;
            private final /* synthetic */ Pattern val$threadPattern;
            private final /* synthetic */ Pattern val$logPattern;
            {
                this.val$fragment = string;
                this.val$indexPattern = pattern;
                this.val$threadPattern = pattern2;
                this.val$logPattern = pattern3;
            }

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return false;
                }
                String name = f.getName();
                return name.startsWith(this.val$fragment) && (this.val$indexPattern.matcher(name.substring(this.val$fragment.length())).matches() || this.val$threadPattern.matcher(name.substring(this.val$fragment.length())).matches() || this.val$logPattern.matcher(name.substring(this.val$fragment.length())).matches());
            }
        })) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                boolean deleted = f.delete();
                if (!deleted) {
                    listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.SnapshotFactoryImpl_UnableToDeleteIndexFile, (Object[])new Object[]{f.toString()}), null);
                }
                ++n2;
            }
        }
    }

    private static class SnapshotEntry {
        private int usageCount;
        private WeakReference<ISnapshot> snapshot;

        public SnapshotEntry(int usageCount, ISnapshot snapshot) {
            this.usageCount = usageCount;
            this.snapshot = new WeakReference<ISnapshot>(snapshot);
        }
    }
}

