/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.ui.IconLabels;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.ErrorLogHandler;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryAnalyserPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.mat.ui";
    public static final String EDITOR_ID = "org.eclipse.mat.ui.editors.HeapEditor";
    private static final String PREFIX = "$nl$/icons/";
    private static final String HEAPPREFIX = "$nl$/icons/heapobjects/";
    private static MemoryAnalyserPlugin plugin;
    private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>(20);
    private Map<URI, ImageDescriptor> imagePathCache = new HashMap<URI, ImageDescriptor>(20);
    private IExtensionTracker tracker;
    private Logger logger;
    private ErrorLogHandler errorLogHandler;
    private boolean useParentHandlers;
    private Map<Image, String> imageTextMap = new HashMap<Image, String>(20);
    private Map<ImageDescriptor, String> descriptorTextMap = new HashMap<ImageDescriptor, String>(20);

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.tracker = new ExtensionTracker(Platform.getExtensionRegistry());
        this.logger = Logger.getLogger("org.eclipse.mat");
        this.useParentHandlers = this.logger.getUseParentHandlers();
        this.logger.setUseParentHandlers(false);
        this.errorLogHandler = new ErrorLogHandler();
        this.logger.addHandler(this.errorLogHandler);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.tracker.close();
        for (Image image : this.imageCache.values()) {
            image.dispose();
        }
        this.imageCache.clear();
        this.imageTextMap.clear();
        this.descriptorTextMap.clear();
        this.logger.removeHandler(this.errorLogHandler);
        this.logger.setUseParentHandlers(this.useParentHandlers);
        this.logger = null;
        this.errorLogHandler = null;
        super.stop(context);
    }

    public static MemoryAnalyserPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return MemoryAnalyserPlugin.getDefault().getPluginImageDescriptor(path);
    }

    public static Image getImage(String name) {
        return MemoryAnalyserPlugin.getDefault().getImage(MemoryAnalyserPlugin.getImageDescriptor(name));
    }

    private ImageDescriptor getPluginImageDescriptor(String path) {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
        if (descriptor != null) {
            this.descriptorTextMap.put(descriptor, this.getIconString(path));
        }
        return descriptor;
    }

    public Image getImage(ImageDescriptor descriptor) {
        Image image = this.imageCache.get(descriptor);
        if (image == null && descriptor != null) {
            image = descriptor.createImage();
            this.imageCache.put(descriptor, image);
            this.imageTextMap.put(image, this.descriptorTextMap.get(descriptor));
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(URL path) {
        URI pathKey;
        try {
            pathKey = path.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            pathKey = null;
        }
        ImageDescriptor descriptor = this.imagePathCache.get(pathKey);
        if (descriptor == null) {
            descriptor = ImageDescriptor.createFromURL((URL)path);
            this.imagePathCache.put(pathKey, descriptor);
            this.descriptorTextMap.put(descriptor, this.getIconString(path));
        }
        return descriptor;
    }

    public Image getImage(URL path) {
        return this.getImage(this.getImageDescriptor(path));
    }

    public ImageDescriptor getImageDescriptor(QueryDescriptor query) {
        URL url = query != null ? query.getIcon() : null;
        return url != null ? this.getImageDescriptor(url) : null;
    }

    public Image getImage(QueryDescriptor query) {
        ImageDescriptor imageDescriptor = this.getImageDescriptor(query);
        return imageDescriptor == null ? null : this.getImage(imageDescriptor);
    }

    private String getIconString(URL url) {
        return this.getIconString(url.getPath());
    }

    private String getIconString(String path) {
        File imageFile = new File(path);
        String[] iconPath = MemoryAnalyserPlugin.parseIconPath(imageFile);
        String iconKey = MemoryAnalyserPlugin.buildIconKey(iconPath);
        String iconLabel = IconLabels.getString(iconKey);
        return iconLabel;
    }

    private static String[] parseIconPath(File imageFile) {
        String[] iconPath = null;
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(imageFile.getName().split("\\.")[0]);
        while (imageFile != null) {
            if ((imageFile = imageFile.getParentFile()) == null) continue;
            String fileName = imageFile.getName();
            if (fileName.equals("icons")) {
                iconPath = pathList.toArray(new String[0]);
                imageFile = null;
                continue;
            }
            pathList.add(0, fileName);
        }
        return iconPath;
    }

    private static String buildIconKey(String[] iconPath) {
        if (iconPath == null) {
            return "IconLabelUnknown";
        }
        StringBuffer propertyBuf = new StringBuffer("IconLabel");
        String[] stringArray = iconPath;
        int n = iconPath.length;
        int n2 = 0;
        while (n2 < n) {
            String pathStr = stringArray[n2];
            propertyBuf.append('-');
            propertyBuf.append(pathStr);
            ++n2;
        }
        return propertyBuf.toString();
    }

    public String getImageText(Image image) {
        String text = this.imageTextMap.get(image);
        return text == null ? IconLabels.getString("IconLabelUnknown") : text;
    }

    public IExtensionTracker getExtensionTracker() {
        return this.tracker;
    }

    public static void log(IStatus status) {
        MemoryAnalyserPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        MemoryAnalyserPlugin.log(e, Messages.MemoryAnalyserPlugin_InternalError);
    }

    public static void log(Throwable e, String message) {
        MemoryAnalyserPlugin.log((IStatus)new Status(4, PLUGIN_ID, message, e));
    }

    public static void main(String[] args) {
        String unknownIconProperty = "# Icon label property to be used for an unknown icon:\r\nIconLabelUnknown=" + MemoryAnalyserPlugin.buildIconLabel(null) + "\r\n";
        String[] iconDirs = new String[]{"..\\org.eclipse.mat.api\\META-INF\\icons", "..\\org.eclipse.mat.ui\\icons"};
        try {
            TreeMap<String, String> iconMap = new TreeMap<String, String>();
            String[] stringArray = iconDirs;
            int n = iconDirs.length;
            int n2 = 0;
            while (n2 < n) {
                String iconDir = stringArray[n2];
                File iconDirFile = new File(iconDir);
                if (iconDirFile.isDirectory()) {
                    MemoryAnalyserPlugin.generateIconProps(iconDirFile, iconMap);
                } else {
                    System.out.println("Input is not a directory: " + iconDir);
                }
                ++n2;
            }
            File iconLabelsFile = new File("icon_labels.properties");
            PrintStream iconLabelsStream = null;
            iconLabelsStream = new PrintStream((OutputStream)new FileOutputStream(iconLabelsFile), false, "ISO-8859-1");
            MemoryAnalyserPlugin.printPropertyLine(iconLabelsStream, "# NLS_MESSAGEFORMAT_NONE\r\n# NLS_ENCODING=UNICODE\r\n# \r\n");
            MemoryAnalyserPlugin.printPropertyLine(iconLabelsStream, "# This file is automatically generated by org.eclipse.mat.ui.MemoryAnalyserPlugin.main().\r\n# Refer to the documentation/comments for this method for usage instructions.\r\n# \r\n# Any manual modifications to this file will need to be reapplied if the file is regenerated.\r\n# Therefore it is preferable if such modifications are kept to a minimum, or preferably\r\n# achieved by amending the label generation code in MemoryAnalyserPlugin.buildIconLabel().\r\n# \r\n");
            MemoryAnalyserPlugin.printPropertyLine(iconLabelsStream, unknownIconProperty);
            MemoryAnalyserPlugin.printPropertyLine(iconLabelsStream, "# Automatically generated icon label properties:");
            for (Map.Entry entry : iconMap.entrySet()) {
                iconLabelsStream.print((String)entry.getKey());
                iconLabelsStream.print('=');
                MemoryAnalyserPlugin.printPropertyLine(iconLabelsStream, (String)entry.getValue());
            }
            iconLabelsStream.close();
            System.out.println("Icon label properties written to file: " + iconLabelsFile.getAbsolutePath());
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace(System.out);
        }
    }

    private static void printPropertyLine(PrintStream stream, String line) {
        stream.print(line);
        stream.print("\r\n");
    }

    private static void generateIconProps(File iconDir, Map<String, String> iconMap) {
        File[] fileList;
        File[] fileArray = fileList = iconDir.listFiles();
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.isHidden()) {
                if (file.isDirectory()) {
                    MemoryAnalyserPlugin.generateIconProps(file, iconMap);
                } else {
                    String[] iconPath = MemoryAnalyserPlugin.parseIconPath(file);
                    String key = MemoryAnalyserPlugin.buildIconKey(iconPath);
                    String label = MemoryAnalyserPlugin.buildIconLabel(iconPath);
                    iconMap.put(key, label);
                }
            }
            ++n2;
        }
    }

    private static String buildIconLabel(String[] iconPath) {
        String[] iconName;
        if (iconPath == null) {
            return "unknown icon";
        }
        StringBuffer labelBuf = new StringBuffer();
        String[] stringArray = iconName = iconPath[iconPath.length - 1].split("_");
        int n = iconName.length;
        int n2 = 0;
        while (n2 < n) {
            String nameElem = stringArray[n2];
            if (nameElem.equals("obj")) {
                nameElem = "object";
            }
            if (nameElem.equals("frgmt")) {
                nameElem = "fragment";
            }
            if (nameElem.equals("frgmts")) {
                nameElem = "fragments";
            }
            if (nameElem.equals("attr")) {
                nameElem = "attribute";
            }
            if (nameElem.equals("ext")) {
                nameElem = "extension";
            }
            if (nameElem.equals("mpaths")) {
                nameElem = "merge paths";
            }
            labelBuf.append(nameElem);
            labelBuf.append(' ');
            ++n2;
        }
        int ipath = iconPath.length - 2;
        while (ipath >= 1) {
            labelBuf.append(iconPath[ipath]);
            labelBuf.append(' ');
            --ipath;
        }
        return labelBuf.toString();
    }

    public static interface ISharedImages {
        public static final String HEAP = "$nl$/icons/heapobjects/heapdump16.gif";
        public static final String HEAP_INFO = "$nl$/icons/heapdump_details.gif";
        public static final String OPEN_SNAPSHOT = "$nl$/icons/open_snapshot.gif";
        public static final String CONSOLE = "$nl$/icons/console.gif";
        public static final String CONSOLE_PLUS = "$nl$/icons/console_plus.gif";
        public static final String CONSOLE_REMOVE = "$nl$/icons/remove_console.gif";
        public static final String COPY = "$nl$/icons/copy.gif";
        public static final String PLUS = "$nl$/icons/plus.gif";
        public static final String EXPERT_SYSTEM = "$nl$/icons/expert.gif";
        public static final String REFRESH = "$nl$/icons/refresh.gif";
        public static final String THREAD = "$nl$/icons/thread.gif";
        public static final String RETAINED_SET = "$nl$/icons/retainedSet.gif";
        public static final String PACKAGE = "$nl$/icons/package.gif";
        public static final String SYNCED = "$nl$/icons/synced.gif";
        public static final String SYNCED_DISABLED = "$nl$/icons/synced_disabled.gif";
        public static final String ID = "$nl$/icons/id.gif";
        public static final String SIZE = "$nl$/icons/size.gif";
        public static final String CLASS = "$nl$/icons/heapobjects/class.gif";
        public static final String CLASS_MIXED = "$nl$/icons/heapobjects/class_mixed.gif";
        public static final String CLASS_OLD = "$nl$/icons/heapobjects/class_old.gif";
        public static final String SUPERCLASS = "$nl$/icons/heapobjects/superclass.gif";
        public static final String NOTEPAD = "$nl$/icons/notepad.gif";
        public static final String ARGUMENTS_WIZARD = "$nl$/icons/fill_arguments_wiz.gif";
        public static final String QUERY = "$nl$/icons/query_browser.gif";
        public static final String QUERY_DISABLED = "$nl$/icons/query_disabled.gif";
        public static final String OQL = "$nl$/icons/oql.gif";
        public static final String IMPORT_REPORT = "$nl$/icons/import_report.gif";
        public static final String EXPORT_MENU = "$nl$/icons/export.gif";
        public static final String EXPORT_HTML = "$nl$/icons/export_html.gif";
        public static final String EXPORT_CSV = "$nl$/icons/export_csv.gif";
        public static final String EXPORT_TXT = "$nl$/icons/export_txt.gif";
        public static final String REFRESHING = "$nl$/icons/refreshing.gif";
        public static final String CALCULATOR = "$nl$/icons/calculator.gif";
        public static final String FILTER = "$nl$/icons/filter.gif";
        public static final String GROUPING = "$nl$/icons/grouping.gif";
        public static final String COMPARE = "$nl$/icons/compare.gif";
        public static final String PERCENTAGE = "$nl$/icons/percentage.gif";
        public static final String INFO = "$nl$/icons/info.gif";
        public static final String HELP = "$nl$/icons/help.png";
        public static final String FIND = "$nl$/icons/find.gif";
        public static final String EXECUTE_QUERY = "$nl$/icons/execute_query.gif";
        public static final String SHOW_AS_HISTOGRAM = "$nl$/icons/as_histogram.gif";
        public static final String EXPLORE = "$nl$/icons/explore.gif";
        public static final String SHOW_PANE = "$nl$/icons/show_pane.gif";
        public static final String CLOSE_PANE = "$nl$/icons/close_pane.gif";
        public static final String CLOSE_BRANCH = "$nl$/icons/close_branch.gif";
        public static final String PINNED = "$nl$/icons/pinned.gif";
        public static final String MOVE_UP = "$nl$/icons/move_up.gif";
        public static final String MOVE_DOWN = "$nl$/icons/move_down.gif";
        public static final String REMOVE = "$nl$/icons/remove.gif";
        public static final String REMOVE_ALL = "$nl$/icons/removeall.gif";
        public static final String SELECT_COLUMN = "$nl$/icons/select_table.gif";
    }
}

