/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.snapshot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.QueueInt;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.SnapshotImpl;
import org.eclipse.mat.snapshot.IMultiplePathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.MultiplePathsFromGCRootsClassRecord;
import org.eclipse.mat.snapshot.MultiplePathsFromGCRootsRecord;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplePathsFromGCRootsComputerImpl
implements IMultiplePathsFromGCRootsComputer {
    int[] objectIds;
    Object[] paths;
    SnapshotImpl snapshot;
    IIndexReader.IOne2ManyIndex outboundIndex;
    private BitField excludeInstances;
    private Map<IClass, Set<String>> excludeMap;
    private boolean pathsCalculated;
    private static final int NOT_VISITED = -2;
    private static final int NO_PARENT = -1;

    public MultiplePathsFromGCRootsComputerImpl(int[] objectIds, Map<IClass, Set<String>> excludeMap, SnapshotImpl snapshot) throws SnapshotException {
        this.snapshot = snapshot;
        this.objectIds = objectIds;
        this.excludeMap = excludeMap;
        this.outboundIndex = snapshot.getIndexManager().outbound;
        if (excludeMap != null) {
            this.initExcludeInstances();
        }
    }

    private void initExcludeInstances() throws SnapshotException {
        this.excludeInstances = new BitField(this.snapshot.getIndexManager().o2address().size());
        for (IClass clazz : this.excludeMap.keySet()) {
            int[] objects;
            int[] nArray = objects = clazz.getObjectIds();
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                int objId = nArray[n2];
                this.excludeInstances.set(objId);
                ++n2;
            }
        }
    }

    private void computePaths(IProgressListener progressListener) throws SnapshotException {
        ArrayList<int[]> pathsList = new ArrayList<int[]>();
        int[] parent = this.bfs(progressListener);
        int i = 0;
        while (i < this.objectIds.length) {
            int[] path = this.getPathFromBFS(this.objectIds[i], parent);
            if (path != null) {
                pathsList.add(path);
            }
            ++i;
        }
        this.pathsCalculated = true;
        this.paths = pathsList.toArray();
    }

    public MultiplePathsFromGCRootsRecord[] getPathsByGCRoot(IProgressListener progressListener) throws SnapshotException {
        if (!this.pathsCalculated) {
            this.computePaths(progressListener);
        }
        MultiplePathsFromGCRootsRecord dummy = new MultiplePathsFromGCRootsRecord(-1, -1, (ISnapshot)this.snapshot);
        int i = 0;
        while (i < this.paths.length) {
            dummy.addPath((int[])this.paths[i]);
            ++i;
        }
        return dummy.nextLevel();
    }

    public Object[] getAllPaths(IProgressListener progressListener) throws SnapshotException {
        if (!this.pathsCalculated) {
            this.computePaths(progressListener);
        }
        return this.paths;
    }

    public MultiplePathsFromGCRootsClassRecord[] getPathsGroupedByClass(boolean startFromTheGCRoots, IProgressListener progressListener) throws SnapshotException {
        if (!this.pathsCalculated) {
            this.computePaths(progressListener);
        }
        MultiplePathsFromGCRootsClassRecord dummy = new MultiplePathsFromGCRootsClassRecord(null, -1, startFromTheGCRoots, (ISnapshot)this.snapshot);
        int i = 0;
        while (i < this.paths.length) {
            dummy.addPath((int[])this.paths[i]);
            ++i;
        }
        return dummy.nextLevel();
    }

    private boolean refersOnlyThroughExcluded(int referrerId, int referentId) throws SnapshotException {
        if (!this.excludeInstances.get(referrerId)) {
            return false;
        }
        IObject referrerObject = this.snapshot.getObject(referrerId);
        Set<String> excludeFields = this.excludeMap.get(referrerObject.getClazz());
        if (excludeFields == null) {
            return true;
        }
        long referentAddr = this.snapshot.mapIdToAddress(referentId);
        List refs = referrerObject.getOutboundReferences();
        for (NamedReference reference : refs) {
            if (referentAddr != reference.getObjectAddress() || excludeFields.contains(reference.getName())) continue;
            return false;
        }
        return true;
    }

    private int[] bfs(IProgressListener progressListener) throws SnapshotException {
        int[] gcRoots;
        int numObjects = this.snapshot.getSnapshotInfo().getNumberOfObjects();
        boolean skipReferences = this.excludeMap != null;
        int[] parent = new int[numObjects];
        Arrays.fill(parent, -2);
        boolean[] toBeChecked = new boolean[numObjects];
        int count = 0;
        int[] nArray = this.objectIds;
        int n = this.objectIds.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (!toBeChecked[i]) {
                ++count;
            }
            toBeChecked[i] = true;
            ++n2;
        }
        QueueInt fifo = new QueueInt(numObjects / 8);
        int[] nArray2 = gcRoots = this.snapshot.getGCRoots();
        int n3 = gcRoots.length;
        int n4 = 0;
        while (n4 < n3) {
            int root = nArray2[n4];
            fifo.put(root);
            parent[root] = -1;
            ++n4;
        }
        int countVisitedObjects = 0;
        int reportFrequency = Math.max(10, numObjects / 1000);
        progressListener.beginTask(Messages.MultiplePathsFromGCRootsComputerImpl_FindingPaths, 1000);
        while (fifo.size() > 0 && count > 0) {
            int[] outbound;
            int objectId = fifo.get();
            if (toBeChecked[objectId]) {
                --count;
            }
            int[] nArray3 = outbound = this.outboundIndex.get(objectId);
            int n5 = outbound.length;
            int n6 = 0;
            while (n6 < n5) {
                int child = nArray3[n6];
                if (!(parent[child] != -2 || skipReferences && this.refersOnlyThroughExcluded(objectId, child))) {
                    parent[child] = objectId;
                    fifo.put(child);
                }
                ++n6;
            }
            if (++countVisitedObjects % reportFrequency != 0) continue;
            if (progressListener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            progressListener.worked(1);
        }
        progressListener.done();
        return parent;
    }

    private int[] getPathFromBFS(int objectId, int[] parent) {
        if (parent[objectId] == -2) {
            return null;
        }
        ArrayInt path = new ArrayInt();
        while (objectId != -1) {
            path.add(objectId);
            objectId = parent[objectId];
        }
        return path.toArray();
    }
}

