/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.CopyUtils;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstalledIUGroup;
import org.eclipse.equinox.internal.p2.ui.model.ProfileSnapshots;
import org.eclipse.equinox.internal.p2.ui.model.RollbackProfileElement;
import org.eclipse.equinox.internal.p2.ui.viewers.DeferredQueryContentProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.internal.p2.ui.viewers.IUComparator;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDetailsLabelProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementComparer;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementLabelProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.operations.ProfileModificationJob;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.ui.ICopyable;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.about.InstallationPage;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.statushandlers.StatusManager;

public class RevertProfilePage
extends InstallationPage
implements ICopyable {
    private static final int REVERT_ID = 1024;
    private static final int DELETE_ID = 1025;
    TableViewer configsViewer;
    TreeViewer configContentsViewer;
    IUDetailsLabelProvider labelProvider;
    IAction revertAction;
    Button revertButton;
    Button deleteButton;
    String profileId;
    AbstractContributionFactory factory;
    Text detailsArea;
    InstalledIUGroup installedIUGroup;
    ProvisioningUI ui;

    public void createPageButtons(Composite parent) {
        if (this.profileId == null) {
            return;
        }
        this.deleteButton = this.createButton(parent, 1025, ProvUIMessages.RevertProfilePage_Delete);
        this.deleteButton.setToolTipText(ProvUIMessages.RevertProfilePage_DeleteTooltip);
        this.deleteButton.setEnabled(this.computeDeleteEnablement());
        this.revertButton = this.createButton(parent, 1024, this.revertAction.getText());
        this.revertButton.setToolTipText(this.revertAction.getToolTipText());
        this.revertButton.setEnabled(this.revertAction.isEnabled());
    }

    public void createControl(Composite parent) {
        this.profileId = this.getProvisioningUI().getProfileId();
        if (this.profileId == null) {
            IStatus status = this.getProvisioningUI().getPolicy().getNoProfileChosenStatus();
            if (status != null) {
                ProvUI.reportStatus(status, 1);
            }
            Text text = new Text(parent, 72);
            text.setLayoutData((Object)new GridData(4, 4, true, true));
            text.setText(ProvUIMessages.RevertProfilePage_NoProfile);
            this.setControl((Control)text);
            return;
        }
        this.initializeDialogUnits((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.equinox.p2.ui.revert_configuration_wizard_context");
        SashForm sashForm = new SashForm(parent, 512);
        sashForm.setLayout((Layout)new GridLayout());
        GridData gd = new GridData(4, 4, true, true);
        sashForm.setLayoutData((Object)gd);
        this.createConfigurationsSection((Composite)sashForm);
        this.createContentsSection((Composite)sashForm);
        this.setControl((Control)sashForm);
        this.createRevertAction();
    }

    private void createConfigurationsSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(ProvUIMessages.RevertDialog_ConfigsLabel);
        this.configsViewer = new TableViewer(composite, 68354);
        ProvElementContentProvider provider = new ProvElementContentProvider(){

            @Override
            protected void finishedFetchingElements(Object o) {
                Object element = RevertProfilePage.this.configsViewer.getElementAt(0);
                if (element != null) {
                    RevertProfilePage.this.configsViewer.setSelection((ISelection)new StructuredSelection(element));
                }
            }
        };
        this.setConfigsColumns(this.configsViewer);
        provider.setFetchInBackground(true);
        this.configsViewer.setContentProvider((IContentProvider)provider);
        this.configsViewer.setLabelProvider((IBaseLabelProvider)new ProvElementLabelProvider());
        this.configsViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object o1, Object o2) {
                if (o1 instanceof RollbackProfileElement && o2 instanceof RollbackProfileElement) {
                    long timestamp2;
                    long timestamp1 = ((RollbackProfileElement)o1).getTimestamp();
                    if (timestamp1 > (timestamp2 = ((RollbackProfileElement)o2).getTimestamp())) {
                        return -1;
                    }
                    return 1;
                }
                return o2.toString().compareTo(o1.toString());
            }
        });
        this.configsViewer.setInput(this.getInput());
        this.configsViewer.addSelectionChangedListener(event -> this.handleSelectionChanged(event.getStructuredSelection()));
        CopyUtils.activateCopy(this, this.configsViewer.getControl());
        gd = new GridData(4, 4, true, true);
        this.configsViewer.getControl().setLayoutData((Object)gd);
    }

    private void setConfigsColumns(TableViewer tableViewer) {
        tableViewer.getTable().setHeaderVisible(true);
        TableViewerColumn column = new TableViewerColumn(tableViewer, 0);
        TableColumn tc = column.getColumn();
        tc.setResizable(true);
        tc.setText(ProvUIMessages.RevertProfilePage_ProfileTimestampColumn);
        tc.setWidth(175);
        column = new TableViewerColumn(tableViewer, 0);
        tc = column.getColumn();
        tc.setResizable(true);
        tc.setText(ProvUIMessages.RevertProfilePage_ProfileTagColumn);
        tc.setWidth(200);
        column.setEditingSupport((EditingSupport)new TagEditingSuport(tableViewer, this.ui));
    }

    private void createContentsSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 0);
        label.setText(ProvUIMessages.RevertDialog_ConfigContentsLabel);
        this.configContentsViewer = new TreeViewer(composite, 68354);
        IUComparator comparator = new IUComparator(0);
        comparator.useColumnConfig(ProvUI.getIUColumnConfig());
        this.configContentsViewer.setComparator((ViewerComparator)comparator);
        this.configContentsViewer.setComparer((IElementComparer)new ProvElementComparer());
        this.configContentsViewer.setContentProvider((IContentProvider)new DeferredQueryContentProvider());
        this.setTreeColumns(this.configContentsViewer.getTree());
        this.labelProvider = new IUDetailsLabelProvider();
        this.configContentsViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        gd = new GridData(1808);
        this.configContentsViewer.getControl().setLayoutData((Object)gd);
        CopyUtils.activateCopy(this, this.configContentsViewer.getControl());
    }

    private void createRevertAction() {
        this.revertAction = new Action(){

            public void run() {
                int result = MessageDialog.open((int)3, (Shell)RevertProfilePage.this.getShell(), (String)ProvUIMessages.RevertDialog_Title, (String)ProvUIMessages.RevertDialog_ConfirmRestartMessage, (int)0, (String[])new String[]{ProvUIMessages.RevertProfilePage_RevertLabel, ProvUIMessages.RevertDialog_CancelButtonLabel});
                if (result != 0) {
                    return;
                }
                boolean finish = RevertProfilePage.this.revert();
                if (finish) {
                    RevertProfilePage.this.getPageContainer().closeModalContainers();
                }
            }
        };
        this.revertAction.setText(ProvUIMessages.RevertProfilePage_RevertLabel);
        this.revertAction.setToolTipText(ProvUIMessages.RevertProfilePage_RevertTooltip);
    }

    private Object getInput() {
        ProfileSnapshots element = new ProfileSnapshots(this.profileId, this.getProvisioningUI().getSession());
        return element;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1024: {
                this.revertAction.run();
                break;
            }
            case 1025: {
                this.deleteSelectedSnapshots();
            }
        }
    }

    protected void handleSelectionChanged(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            if (selection.size() == 1) {
                Object selected = selection.getFirstElement();
                if (selected instanceof RollbackProfileElement) {
                    Object[] elements = this.configContentsViewer.getExpandedElements();
                    this.configContentsViewer.getTree().setRedraw(false);
                    this.configContentsViewer.setInput(selected);
                    this.configContentsViewer.setExpandedElements(elements);
                    this.configContentsViewer.getTree().setRedraw(true);
                    boolean isNotCurrentProfile = !((RollbackProfileElement)selected).isCurrentProfile();
                    this.revertAction.setEnabled(isNotCurrentProfile);
                    if (this.revertButton != null) {
                        this.revertButton.setEnabled(isNotCurrentProfile);
                    }
                    if (this.deleteButton != null) {
                        this.deleteButton.setEnabled(isNotCurrentProfile);
                    }
                    return;
                }
            } else {
                this.revertAction.setEnabled(false);
                if (this.revertButton != null) {
                    this.revertButton.setEnabled(false);
                }
                this.configContentsViewer.setInput(null);
                this.deleteButton.setEnabled(this.computeDeleteEnablement());
                return;
            }
        }
        this.configContentsViewer.setInput(null);
        this.revertAction.setEnabled(false);
        if (this.revertButton != null) {
            this.revertButton.setEnabled(false);
        }
        if (this.deleteButton != null) {
            this.deleteButton.setEnabled(this.computeDeleteEnablement());
        }
    }

    boolean computeDeleteEnablement() {
        boolean okToDelete = true;
        for (Object selected : this.configsViewer.getStructuredSelection()) {
            if (selected instanceof RollbackProfileElement && !((RollbackProfileElement)selected).isCurrentProfile()) continue;
            okToDelete = false;
            break;
        }
        return okToDelete;
    }

    private void setTreeColumns(Tree tree) {
        IUColumnConfig[] columns = ProvUI.getIUColumnConfig();
        tree.setHeaderVisible(true);
        int i = 0;
        while (i < columns.length) {
            TreeColumn tc = new TreeColumn(tree, 0, i);
            tc.setResizable(true);
            tc.setText(columns[i].getColumnTitle());
            tc.setWidth(columns[i].getWidthInPixels((Control)tree));
            ++i;
        }
    }

    private IProfile getSelectedSnapshot() {
        Object selected = this.configsViewer.getStructuredSelection().getFirstElement();
        if (selected != null && selected instanceof RollbackProfileElement) {
            return ((RollbackProfileElement)selected).getProfileSnapshot((IProgressMonitor)new NullProgressMonitor());
        }
        return null;
    }

    boolean revert() {
        IProfile snapshot = this.getSelectedSnapshot();
        if (snapshot == null) {
            return false;
        }
        IProvisioningPlan[] plan = new IProvisioningPlan[1];
        IRunnableWithProgress runnable = monitor -> {
            IProfileRegistry registry = ProvUI.getProfileRegistry(this.getSession());
            IPlanner planner = (IPlanner)this.getSession().getProvisioningAgent().getService(IPlanner.SERVICE_NAME);
            IProfile currentProfile = registry.getProfile(this.profileId);
            iProvisioningPlanArray[0] = planner.getDiffPlan(currentProfile, snapshot, monitor);
        };
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            ProvUI.handleException(e.getCause(), null, 3);
        }
        catch (InterruptedException interruptedException) {}
        if (dialog.getProgressMonitor().isCanceled()) {
            return false;
        }
        boolean reverted = false;
        if (plan[0] != null) {
            if (plan[0].getStatus().isOK()) {
                ProfileModificationJob op = new ProfileModificationJob(ProvUIMessages.RevertDialog_RevertOperationLabel, this.getSession(), this.profileId, plan[0], new ProvisioningContext(this.getSession().getProvisioningAgent()));
                op.setRestartPolicy(3);
                this.getProvisioningUI().schedule((ProvisioningJob)op, 3);
                reverted = true;
            } else if (plan[0].getStatus().getSeverity() != 8) {
                ProvUI.reportStatus(plan[0].getStatus(), 3);
            }
        }
        return reverted;
    }

    @Override
    public void copyToClipboard(Control activeControl) {
        String text = "";
        if (activeControl == this.configContentsViewer.getControl()) {
            text = CopyUtils.getIndentedClipboardText(this.configContentsViewer.getStructuredSelection().toArray(), this.labelProvider);
        } else if (activeControl == this.configsViewer.getControl()) {
            Object[] elements = this.configsViewer.getStructuredSelection().toArray();
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof RollbackProfileElement) {
                    if (i > 0) {
                        buffer.append(CopyUtils.NEWLINE);
                    }
                    buffer.append(((RollbackProfileElement)elements[i]).getLabel(elements[i]));
                }
                ++i;
            }
            text = buffer.toString();
        } else {
            return;
        }
        if (text.isEmpty()) {
            return;
        }
        Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
        clipboard.setContents(new Object[]{text}, new Transfer[]{TextTransfer.getInstance()});
        clipboard.dispose();
    }

    void deleteSelectedSnapshots() {
        String confirmMessage;
        IStructuredSelection selection = this.configsViewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        String title = selection.size() == 1 ? ProvUIMessages.RevertProfilePage_DeleteSingleConfigurationTitle : ProvUIMessages.RevertProfilePage_DeleteMultipleConfigurationsTitle;
        String string = confirmMessage = selection.size() == 1 ? ProvUIMessages.RevertProfilePage_ConfirmDeleteSingleConfig : ProvUIMessages.RevertProfilePage_ConfirmDeleteMultipleConfigs;
        if (MessageDialog.open((int)3, (Shell)this.configsViewer.getControl().getShell(), (String)title, (String)confirmMessage, (int)0, (String[])new String[]{ProvUIMessages.RevertProfilePage_Delete, ProvUIMessages.RevertProfilePage_CancelButtonLabel}) == 0) {
            for (Object selected : selection) {
                if (!(selected instanceof RollbackProfileElement) || ((RollbackProfileElement)selected).isCurrentProfile()) continue;
                RollbackProfileElement snapshot = (RollbackProfileElement)selected;
                IProfileRegistry registry = ProvUI.getProfileRegistry(this.getSession());
                if (registry == null) continue;
                try {
                    registry.removeProfile(this.profileId, snapshot.getTimestamp());
                }
                catch (ProvisionException e) {
                    ProvUI.handleException(e, null, 3);
                }
            }
            this.configsViewer.refresh();
        }
    }

    ProvisioningSession getSession() {
        return this.getProvisioningUI().getSession();
    }

    ProvisioningUI getProvisioningUI() {
        if (this.ui == null) {
            this.ui = ProvisioningUI.getDefaultUI();
            return this.ui;
        }
        return this.ui;
    }

    protected IStructuredSelection getSelection() {
        return this.configsViewer.getStructuredSelection();
    }

    public void setProvisioningUI(ProvisioningUI value) {
        this.ui = value;
    }

    private static class TagEditingSuport
    extends EditingSupport {
        private ProvisioningUI ui;

        public TagEditingSuport(TableViewer viewer, ProvisioningUI ui) {
            super((ColumnViewer)viewer);
            this.ui = ui;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)((TableViewer)this.getViewer()).getTable());
        }

        protected boolean canEdit(Object element) {
            return element instanceof RollbackProfileElement;
        }

        protected Object getValue(Object element) {
            if (element instanceof RollbackProfileElement) {
                return ((RollbackProfileElement)element).getProfileTag() != null ? ((RollbackProfileElement)element).getProfileTag() : "";
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof RollbackProfileElement && value instanceof String) {
                IStatus status;
                RollbackProfileElement ele = (RollbackProfileElement)element;
                ele.setProfileTag((String)value);
                IProfileRegistry registry = ProvUI.getProfileRegistry(this.ui.getSession());
                if (registry != null && !(status = ((String)value).length() > 0 ? registry.setProfileStateProperty(ele.getProfileId(), ele.getTimestamp(), "org.eclipse.equinox.p2.state.tag", (String)value) : registry.removeProfileStateProperties(ele.getProfileId(), ele.getTimestamp(), Collections.singleton("org.eclipse.equinox.p2.state.tag"))).isOK()) {
                    StatusManager.getManager().handle(status);
                }
                this.getViewer().update(element, null);
            }
        }
    }
}

