/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.threads;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.inspections.threads.NameValuePair;
import org.eclipse.mat.inspections.threads.ThreadInfoImpl;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.query.results.ListResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.IThreadInfo;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IStackFrame;
import org.eclipse.mat.snapshot.model.IThreadStack;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="thread_details")
@Icon(value="/META-INF/icons/threads.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingthreads.html")
public class ThreadInfoQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument threadIds;

    public Result execute(IProgressListener listener) throws Exception {
        InspectionAssert.heapFormatIsNot(this.snapshot, "phd");
        Result spec = new Result(Messages.ThreadInfoQuery_ThreadDetails);
        ArrayList<ThreadInfoImpl> infos = new ArrayList<ThreadInfoImpl>();
        Iterator iterator = this.threadIds.iterator();
        while (iterator.hasNext()) {
            int[] ids;
            int[] nArray = ids = (int[])iterator.next();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                infos.add(this.processThread(id, spec, listener));
                ++n2;
            }
        }
        return spec;
    }

    private ThreadInfoImpl processThread(int threadId, Result parent, IProgressListener listener) throws SnapshotException {
        CompositeResult requests;
        CompositeResult details;
        ThreadInfoImpl tInfo = ThreadInfoImpl.build(this.snapshot.getObject(threadId), true, listener);
        SectionSpec spec = new SectionSpec(MessageUtil.format((String)Messages.ThreadInfoQuery_ThreadLabel, (Object[])new Object[]{tInfo.getName()}));
        parent.add(spec, tInfo);
        QuerySpec properties = new QuerySpec(Messages.ThreadInfoQuery_ThreadProperties);
        properties.set("html.show_table_header", Boolean.FALSE.toString());
        properties.setCommand("list_objects 0x" + Long.toHexString(tInfo.getThreadObject().getObjectAddress()));
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        for (Column column : tInfo.getUsedColumns()) {
            Object value = tInfo.getValue(column);
            String f = value == null ? "" : (column.getFormatter() != null ? column.getFormatter().format(value) : String.valueOf(value));
            pairs.add(new NameValuePair(column.getLabel(), f));
        }
        properties.setResult((IResult)new ListResult(NameValuePair.class, pairs, new String[]{"name", "value"}));
        spec.add((Spec)properties);
        QuerySpec stackResult = this.getStackTraceAsSpec(threadId);
        if (stackResult != null) {
            spec.add((Spec)stackResult);
        }
        if ((details = tInfo.getDetails()) != null && !details.isEmpty()) {
            for (CompositeResult.Entry rInfo : details.getResultEntries()) {
                QuerySpec tasks = new QuerySpec(rInfo.getName());
                tasks.setResult(rInfo.getResult());
                spec.add((Spec)tasks);
            }
        }
        if ((requests = tInfo.getRequests()) != null && !requests.isEmpty()) {
            SectionSpec rSpec = new SectionSpec(Messages.ThreadInfoQuery_Requests);
            spec.add((Spec)rSpec);
            for (CompositeResult.Entry rInfo : requests.getResultEntries()) {
                QuerySpec thread = new QuerySpec(rInfo.getName());
                IResult res = rInfo.getResult();
                if (res instanceof CompositeResult || res instanceof Spec) {
                    thread.set("html.show_heading", Boolean.FALSE.toString());
                    thread.set("rendering.pattern", "overview_details");
                }
                thread.setResult(rInfo.getResult());
                rSpec.add((Spec)thread);
            }
        }
        return tInfo;
    }

    private QuerySpec getStackTraceAsSpec(int threadId) throws SnapshotException {
        IThreadStack stack = this.snapshot.getThreadStack(threadId);
        if (stack == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        IObject threadObject = this.snapshot.getObject(threadId);
        builder.append(threadObject.getClassSpecificName()).append("\r\n");
        IStackFrame[] iStackFrameArray = stack.getStackFrames();
        int n = iStackFrameArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStackFrame frame = iStackFrameArray[n2];
            builder.append("  ").append(frame.getText()).append("\r\n");
            ++n2;
        }
        return new QuerySpec(Messages.ThreadInfoQuery_ThreadStack, (IResult)new TextResult(builder.toString()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Result
    extends SectionSpec {
        List<IThreadInfo> infos = new ArrayList<IThreadInfo>();

        private Result(String name) {
            super(name);
        }

        void add(SectionSpec child, ThreadInfoImpl tInfo) {
            this.add((Spec)child);
            this.infos.add(tInfo);
        }

        public List<IThreadInfo> getThreads() {
            return this.infos;
        }
    }
}

