/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.quickaccess.PerspectiveElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;

public class PerspectiveProvider
extends QuickAccessProvider {
    private QuickAccessElement[] cachedElements;
    private Map<String, PerspectiveElement> idToElement = new HashMap<String, PerspectiveElement>();

    @Override
    public String getId() {
        return "org.eclipse.ui.perspectives";
    }

    @Override
    public QuickAccessElement getElementForId(String id) {
        this.getElements();
        return this.idToElement.get(id);
    }

    @Override
    public QuickAccessElement[] getElements() {
        if (this.cachedElements == null) {
            IPerspectiveDescriptor[] perspectives = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
            this.cachedElements = new QuickAccessElement[perspectives.length];
            int i = 0;
            while (i < perspectives.length) {
                if (!WorkbenchActivityHelper.filterItem(perspectives[i])) {
                    PerspectiveElement perspectiveElement = new PerspectiveElement(perspectives[i], this);
                    this.idToElement.put(perspectiveElement.getId(), perspectiveElement);
                }
                ++i;
            }
            this.cachedElements = this.idToElement.values().toArray(new QuickAccessElement[this.idToElement.size()]);
        }
        return this.cachedElements;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_ETOOL_DEF_PERSPECTIVE");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.QuickAccess_Perspectives;
    }

    @Override
    protected void doReset() {
        this.cachedElements = null;
        this.idToElement.clear();
    }
}

