/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.internal.collectionextract.MapCollectionExtractorBase;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.MessageUtil;

public abstract class HashedMapCollectionExtractorBase
extends MapCollectionExtractorBase {
    protected final String arrayField;

    public HashedMapCollectionExtractorBase(String arrayField, String keyField, String valueField) {
        super(keyField, valueField);
        this.arrayField = arrayField;
    }

    public boolean hasFillRatio() {
        return true;
    }

    public Double getFillRatio(IObject coll) throws SnapshotException {
        Integer size = this.getSize(coll);
        Integer cap = this.getCapacity(coll);
        if (size != null && cap != null) {
            double sz = size.doubleValue();
            double cp = cap.doubleValue();
            if (sz == 0.0 && cp == 0.0) {
                return 1.0;
            }
            return sz / cp;
        }
        return 1.0;
    }

    public boolean hasCollisionRatio() {
        return this.hasSize();
    }

    public Double getCollisionRatio(IObject coll) throws SnapshotException {
        Integer size = this.getSize(coll);
        if (size == null || size <= 0) {
            return 0.0;
        }
        return (double)(size - this.getNumberOfNotNullElements(coll)) / (double)size.intValue();
    }

    protected IObjectArray extractBackingArray(IObject coll) throws SnapshotException {
        Object obj = coll.resolveValue(this.arrayField);
        if (obj instanceof IObjectArray) {
            return (IObjectArray)obj;
        }
        if (obj != null) {
            String desc = obj instanceof IObject ? ((IObject)obj).getTechnicalName() : obj.toString();
            String msg = MessageUtil.format((String)Messages.CollectionUtil_BadBackingArray, (Object[])new Object[]{this.arrayField, coll.getTechnicalName(), desc});
            throw new SnapshotException(msg);
        }
        IObject next = ExtractionUtils.followOnlyOutgoingReferencesExceptLast(this.arrayField, coll);
        if (next == null) {
            return null;
        }
        return ExtractionUtils.getOnlyArrayField(next);
    }

    protected int getMapSize(IObject collection, int[] objects) throws SnapshotException {
        int count = 0;
        ISnapshot snapshot = collection.getSnapshot();
        BitField seen = new BitField(snapshot.getSnapshotInfo().getNumberOfObjects());
        ArrayInt extra = new ArrayInt();
        int[] nArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (!(snapshot.isClass(i) || seen.get(i) || snapshot.getClassOf(i).getName().equals("java.lang.Object"))) {
                extra.clear();
                extra.add(i);
                seen.set(i);
                int k = 0;
                while (k < extra.size()) {
                    int j = extra.get(k);
                    while (j >= 0) {
                        ++count;
                        j = this.resolveNextSameField(snapshot, j, seen, extra);
                    }
                    ++k;
                }
            }
            ++n2;
        }
        return count;
    }

    int resolveNextSameField(ISnapshot snapshot, int sourceId, BitField seen, ArrayInt extra) throws SnapshotException {
        int ret = -1;
        IClass c1 = snapshot.getClassOf(sourceId);
        int[] nArray = snapshot.getOutboundReferentIds(sourceId);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClass c2;
            int i = nArray[n2];
            if (!snapshot.isArray(i) && !snapshot.isClass(i) && c1.equals(c2 = snapshot.getClassOf(i)) && !seen.get(i)) {
                seen.set(i);
                if (ret == -1) {
                    ret = i;
                } else {
                    extra.add(i);
                }
            }
            ++n2;
        }
        return ret;
    }

    protected void collectEntriesFromTable(ArrayInt entries, int collectionId, int entryId, ISnapshot snapshot) throws SnapshotException {
        while (entryId >= 0) {
            Object o;
            if (snapshot.isClass(entryId)) {
                return;
            }
            if (snapshot.getClassOf(entryId).getName().equals("java.lang.Object")) {
                return;
            }
            IInstance entry = (IInstance)snapshot.getObject(entryId);
            boolean nextFieldProcessed = false;
            int nextEntryId = -1;
            for (Field field : entry.getFields()) {
                if (nextFieldProcessed || !"next".equals(field.getName())) continue;
                nextFieldProcessed = true;
                if (field.getValue() == null) continue;
                nextEntryId = ((ObjectReference)field.getValue()).getObjectId();
            }
            if (nextEntryId == -1 && snapshot.getClassOf(entryId).getName().equals("java.util.concurrent.ConcurrentHashMap$TreeBin") && (o = entry.resolveValue("first")) instanceof IInstance) {
                entry = (IInstance)o;
                entryId = entry.getObjectId();
                continue;
            }
            entries.add(entryId);
            entryId = nextEntryId;
        }
    }
}

