/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.actions.ImportReportAction;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.actions.ExecuteQueryAction;
import org.eclipse.mat.ui.snapshot.editor.HeapEditor;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GettingStartedWizard
extends Wizard {
    public static final String HIDE_WIZARD_KEY = "hideGettingStartedWizard";
    Action action;
    HeapEditor editor;
    ChoicePage choicePage;
    PackagePage packagePage;
    OpenReportsPage openReportsPage;

    public GettingStartedWizard(HeapEditor editor) {
        this.editor = editor;
        this.setWindowTitle(Messages.GettingStartedWizard_GettingStartedWizard);
    }

    public void addPages() {
        this.choicePage = new ChoicePage();
        this.addPage((IWizardPage)this.choicePage);
        this.packagePage = new PackagePage();
        this.addPage((IWizardPage)this.packagePage);
        this.openReportsPage = new OpenReportsPage();
        this.addPage((IWizardPage)this.openReportsPage);
    }

    public boolean canFinish() {
        return this.action != null;
    }

    public boolean performFinish() {
        IPreferenceStore prefs = MemoryAnalyserPlugin.getDefault().getPreferenceStore();
        prefs.setValue(HIDE_WIZARD_KEY, !this.choicePage.askAgain.getSelection());
        if (this.action != null) {
            this.action.run();
        }
        return true;
    }

    public boolean performCancel() {
        IPreferenceStore prefs = MemoryAnalyserPlugin.getDefault().getPreferenceStore();
        prefs.setValue(HIDE_WIZARD_KEY, !this.choicePage.askAgain.getSelection());
        return true;
    }

    private static class ChoicePage
    extends WizardPage
    implements Listener {
        private Button componentReport;
        private Button leakReport;
        private Button openReports;
        private Button askAgain;
        private static String space = " ";
        private static String fullStop = ".";

        public ChoicePage() {
            super("");
            this.setTitle(Messages.GettingStartedWizard_GettingStarted);
            this.setDescription(Messages.GettingStartedWizard_ChooseOneOfReports);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            Composite choices = new Composite(composite, 0);
            FormLayout formLayout = new FormLayout();
            choices.setLayout((Layout)formLayout);
            composite.setLayout((Layout)formLayout);
            this.leakReport = new Button(choices, 16);
            this.leakReport.setText(Messages.GettingStartedWizard_LeakSuspectReport);
            this.leakReport.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
            this.leakReport.addListener(13, (Listener)this);
            this.leakReport.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = String.valueOf(Messages.GettingStartedWizard_LeakSuspectReport) + fullStop + space + Messages.GettingStartedWizard_LeakSuspectReportDescription;
                }
            });
            this.componentReport = new Button(choices, 16);
            this.componentReport.setText(Messages.GettingStartedWizard_ComponentReport);
            this.componentReport.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
            this.componentReport.addListener(13, (Listener)this);
            this.componentReport.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = String.valueOf(Messages.GettingStartedWizard_ComponentReport) + fullStop + space + Messages.GettingStartedWizard_ComponentReportDescription;
                }
            });
            this.openReports = new Button(choices, 16);
            this.openReports.setText(Messages.GettingStartedWizard_ReOpenExistingReports);
            this.openReports.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
            this.openReports.addListener(13, (Listener)this);
            this.openReports.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = String.valueOf(Messages.GettingStartedWizard_ReOpenExistingReports) + fullStop + space + Messages.GettingStartedWizard_ExistingReportsLocation;
                }
            });
            Label leakDescription = new Label(choices, 64);
            leakDescription.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = space;
                }
            });
            leakDescription.setText(Messages.GettingStartedWizard_LeakSuspectReportDescription);
            leakDescription.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
            Label componentDescription = new Label(choices, 64);
            componentDescription.setText(Messages.GettingStartedWizard_ComponentReportDescription);
            componentDescription.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
            componentDescription.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = space;
                }
            });
            Label openDescription = new Label(choices, 64);
            openDescription.setText(Messages.GettingStartedWizard_ExistingReportsLocation);
            openDescription.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
            openDescription.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = space;
                }
            });
            FormData data = new FormData();
            this.leakReport.setLayoutData((Object)data);
            data = new FormData(450, -1);
            data.top = new FormAttachment((Control)this.leakReport, 10, -1);
            leakDescription.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)leakDescription, 10, -1);
            this.componentReport.setLayoutData((Object)data);
            data = new FormData(450, -1);
            data.top = new FormAttachment((Control)this.componentReport, 10, -1);
            componentDescription.setLayoutData((Object)data);
            data = new FormData();
            data.top = new FormAttachment((Control)componentDescription, 10, -1);
            this.openReports.setLayoutData((Object)data);
            data = new FormData(450, -1);
            data.top = new FormAttachment((Control)this.openReports, 10, -1);
            openDescription.setLayoutData((Object)data);
            choices.pack();
            this.askAgain = new Button(composite, 32);
            this.askAgain.setSelection(true);
            this.askAgain.setText(Messages.GettingStartedWizard_ShowThisDialog);
            this.askAgain.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
            IPreferenceStore prefs = MemoryAnalyserPlugin.getDefault().getPreferenceStore();
            this.askAgain.setSelection(!prefs.getBoolean(GettingStartedWizard.HIDE_WIZARD_KEY));
            data = new FormData();
            data.top = new FormAttachment((Control)choices, 20, -1);
            this.askAgain.setLayoutData((Object)data);
            composite.pack();
            this.setControl((Control)composite);
        }

        public boolean canFlipToNextPage() {
            return this.componentReport.getSelection() || this.openReports.getSelection();
        }

        public IWizardPage getNextPage() {
            if (this.componentReport.getSelection()) {
                return this.getWizard().packagePage;
            }
            if (this.openReports.getSelection()) {
                this.getWizard().openReportsPage.loadReportList();
                return this.getWizard().openReportsPage;
            }
            return null;
        }

        public void handleEvent(Event event) {
            if (event.widget == this.componentReport) {
                this.getWizard().action = null;
            } else if (event.widget == this.openReports) {
                this.getWizard().action = null;
            } else if (event.widget == this.leakReport) {
                this.getWizard().action = new ExecuteQueryAction((MultiPaneEditor)this.getWizard().editor, "default_report org.eclipse.mat.api:suspects");
            }
            this.getWizard().getContainer().updateButtons();
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.getWizard().action = null;
            }
            super.setVisible(visible);
        }

        public GettingStartedWizard getWizard() {
            return (GettingStartedWizard)super.getWizard();
        }
    }

    private static class OpenReportsPage
    extends WizardPage {
        TableViewer viewer;

        public OpenReportsPage() {
            super("");
            this.setTitle(Messages.GettingStartedWizard_ReOpenReport);
            this.setDescription(Messages.GettingStartedWizard_ReOpenExistingReport);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            TableColumnLayout layout = new TableColumnLayout();
            composite.setLayout((Layout)layout);
            this.viewer = new TableViewer(composite, 67588);
            TableColumn column = new TableColumn(this.viewer.getTable(), 0);
            column.setText(Messages.GettingStartedWizard_Report);
            layout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(100, true));
            this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((File)element).getName();
                }
            });
            this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){
                File[] fileList;

                public Object[] getElements(Object inputElement) {
                    return this.fileList;
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    if (newInput instanceof ISnapshot) {
                        try {
                            ISnapshot snapshot = (ISnapshot)newInput;
                            String prefix = snapshot.getSnapshotInfo().getPath();
                            int p = prefix.lastIndexOf(File.separatorChar);
                            if (p >= 0) {
                                prefix = prefix.substring(p + 1);
                            }
                            if ((p = prefix.lastIndexOf(46)) >= 0) {
                                prefix = prefix.substring(0, p);
                            }
                            final String fragment = prefix;
                            final Pattern regex = Pattern.compile(".*\\.zip$");
                            this.fileList = new File(snapshot.getSnapshotInfo().getPath()).getParentFile().listFiles(new FilenameFilter(){

                                public boolean accept(File dir, String name) {
                                    return name.startsWith(fragment) && regex.matcher(name).matches();
                                }
                            });
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            // empty catch block
                        }
                    }
                }
            });
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    OpenReportsPage.this.getWizard().action = new ImportReportAction(OpenReportsPage.this.getWizard().editor, (File)((IStructuredSelection)event.getSelection()).getFirstElement());
                    OpenReportsPage.this.getWizard().getContainer().updateButtons();
                }
            });
            this.setControl((Control)composite);
        }

        public void loadReportList() {
            this.viewer.setInput((Object)this.getWizard().editor.getSnapshotInput().getSnapshot());
        }

        public boolean canFlipToNextPage() {
            return false;
        }

        public GettingStartedWizard getWizard() {
            return (GettingStartedWizard)super.getWizard();
        }
    }

    private static class PackagePage
    extends WizardPage
    implements ModifyListener {
        public PackagePage() {
            super("");
            this.setTitle(Messages.GettingStartedWizard_SelectClasses);
            this.setDescription(Messages.GettingStartedWizard_SpecifyRegularExpression);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().applyTo(composite);
            Label label = new Label(composite, 0);
            label.setText(Messages.GettingStartedWizard_Package);
            Text regex = new Text(composite, 2048);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)regex);
            regex.addModifyListener((ModifyListener)this);
            this.setControl((Control)composite);
        }

        public void modifyText(ModifyEvent event) {
            try {
                String text = ((Text)event.widget).getText();
                if (!"".equals(text)) {
                    Pattern.compile(text);
                    this.getWizard().action = new ExecuteQueryAction((MultiPaneEditor)this.getWizard().editor, "component_report " + text);
                }
                if (this.getErrorMessage() != null) {
                    this.setErrorMessage(null);
                }
            }
            catch (PatternSyntaxException e) {
                this.setErrorMessage(e.getMessage());
                this.getWizard().action = null;
            }
            this.getWizard().getContainer().updateButtons();
        }

        public boolean canFlipToNextPage() {
            return false;
        }

        public GettingStartedWizard getWizard() {
            return (GettingStartedWizard)super.getWizard();
        }
    }
}

