/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.rcp;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.editor.PathEditorInput;
import org.eclipse.mat.ui.rcp.ApplicationActionBarAdvisor;
import org.eclipse.mat.ui.rcp.Messages;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setInitialSize(new Point(1024, 756));
        configurer.setShowCoolBar(false);
        configurer.setShowStatusLine(true);
        configurer.setShowProgressIndicator(true);
        configurer.setTitle(Messages.ApplicationWorkbenchWindowAdvisor_Eclipse_Memory_Analyzer);
    }

    public void postWindowOpen() {
        super.postWindowOpen();
        try {
            Path path;
            String[] args = Platform.getApplicationArgs();
            if (args.length > 0 && (path = new Path(args[0])).toFile().exists()) {
                IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                IEditorDescriptor descriptor = registry.getDefaultEditor(path.toOSString());
                IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)new PathEditorInput((IPath)path), (String)descriptor.getId(), (boolean)true);
            }
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
    }

    public void openIntro() {
        IPreferenceStore prefs = MemoryAnalyserPlugin.getDefault().getPreferenceStore();
        if (!prefs.getBoolean("hide_welcome_screen")) {
            boolean isStandby = PlatformUI.getWorkbench().getIntroManager().isIntroStandby(PlatformUI.getWorkbench().getIntroManager().getIntro());
            PlatformUI.getWorkbench().getIntroManager().showIntro(this.getWindowConfigurer().getWindow(), isStandby);
        }
    }
}

