/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.lang.reflect.Modifier;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.IClassSpecificNameResolver;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.model.PrettyPrinter;
import org.eclipse.mat.snapshot.registry.ClassSpecificNameResolverRegistry;

public class CommonNameResolver {

    @Subject(value="java.lang.reflect.AccessibleObject")
    public static class AccessibleObjectResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject ref;
            StringBuilder r = new StringBuilder();
            ISnapshot snapshot = obj.getSnapshot();
            Object val = obj.resolveValue("modifiers");
            if (val instanceof Integer) {
                r.append(Modifier.toString((Integer)val));
                if (r.length() > 0) {
                    r.append(' ');
                }
            }
            if ((ref = (IObject)obj.resolveValue("clazz")) == null) {
                return null;
            }
            this.addClassName(snapshot, ref.getObjectAddress(), r);
            return r.toString();
        }

        protected void addClassName(ISnapshot snapshot, long addr, StringBuilder r) throws SnapshotException {
            ObjectReference or = new ObjectReference(snapshot, addr);
            IObject ox = or.getObject();
            if (ox instanceof IClass) {
                IClass cls = (IClass)ox;
                r.append(cls.getName());
            }
        }
    }

    @Subjects(value={"java.util.concurrent.atomic.AtomicBoolean"})
    public static class AtomicBooleanResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject heapObject) throws SnapshotException {
            Integer value = (Integer)heapObject.resolveValue("value");
            return value != null ? Boolean.toString(value != 0) : null;
        }
    }

    @Subjects(value={"java.util.concurrent.atomic.AtomicReference"})
    public static class AtomicReferenceValueResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject heapObject) throws SnapshotException {
            IObject value = (IObject)heapObject.resolveValue("value");
            return value != null ? ClassSpecificNameResolverRegistry.resolve(value) : null;
        }
    }

    @Subjects(value={"java.util.concurrent.atomic.AtomicStampedReference"})
    public static class AtomicStampedReferenceValueResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject heapObject) throws SnapshotException {
            IObject value = (IObject)heapObject.resolveValue("pair.reference");
            return value != null ? ClassSpecificNameResolverRegistry.resolve(value) : null;
        }
    }

    @Subject(value="byte[]")
    public static class ByteArrayResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject heapObject) throws SnapshotException {
            IPrimitiveArray arr = (IPrimitiveArray)heapObject;
            byte[] value = (byte[])arr.getValueArray(0, Math.min(arr.getLength(), 1024));
            if (value == null) {
                return null;
            }
            StringBuilder r = new StringBuilder(value.length);
            int i = 0;
            while (i < value.length) {
                if (value[i] < 32 || value[i] > 126) {
                    r.append('.');
                } else {
                    r.append((char)value[i]);
                }
                ++i;
            }
            return r.toString();
        }
    }

    @Subject(value="char[]")
    public static class CharArrayResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject heapObject) throws SnapshotException {
            IPrimitiveArray charArray = (IPrimitiveArray)heapObject;
            return PrettyPrinter.arrayAsString(charArray, 0, charArray.getLength(), 1024);
        }
    }

    @Subjects(value={"java.lang.Class"})
    public static class ClassTypeResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject object) throws SnapshotException {
            if (object instanceof IClass) {
                return null;
            }
            IObject nameString = (IObject)object.resolveValue("name");
            if (nameString == null) {
                return null;
            }
            return nameString.getClassSpecificName();
        }
    }

    @Subject(value="java.lang.reflect.Constructor")
    public static class ConstructorResolver
    extends AccessibleObjectResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject ref;
            StringBuilder r = new StringBuilder();
            ISnapshot snapshot = obj.getSnapshot();
            Object val = obj.resolveValue("modifiers");
            if (val instanceof Integer) {
                r.append(Modifier.toString((Integer)val));
                if (r.length() > 0) {
                    r.append(' ');
                }
            }
            if ((ref = (IObject)obj.resolveValue("clazz")) == null) {
                return null;
            }
            this.addClassName(snapshot, ref.getObjectAddress(), r);
            r.append('(');
            ref = (IObject)obj.resolveValue("parameterTypes");
            if (ref instanceof IObjectArray) {
                IObjectArray orefa = (IObjectArray)ref;
                long[] refs = orefa.getReferenceArray();
                int i = 0;
                while (i < orefa.getLength()) {
                    if (i > 0) {
                        r.append(',');
                    }
                    long addr = refs[i];
                    this.addClassName(snapshot, addr, r);
                    ++i;
                }
            }
            r.append(')');
            return r.toString();
        }
    }

    @Subject(value="java.lang.Enum")
    public static class EnumResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject heapObject) throws SnapshotException {
            IObject value = (IObject)heapObject.resolveValue("name");
            return value != null ? ClassSpecificNameResolverRegistry.resolve(value) : null;
        }
    }

    @Subject(value="java.lang.ProcessEnvironment$ExternalData")
    public static class ExternalDataResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject heapObject) throws SnapshotException {
            IObject value = (IObject)heapObject.resolveValue("str");
            return value != null ? ClassSpecificNameResolverRegistry.resolve(value) : null;
        }
    }

    @Subject(value="java.lang.reflect.Field")
    public static class FieldResolver
    extends AccessibleObjectResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject ref;
            StringBuilder r = new StringBuilder();
            ISnapshot snapshot = obj.getSnapshot();
            Object val = obj.resolveValue("modifiers");
            if (val instanceof Integer) {
                r.append(Modifier.toString((Integer)val));
                if (r.length() > 0) {
                    r.append(' ');
                }
            }
            if ((ref = (IObject)obj.resolveValue("type")) != null) {
                this.addClassName(snapshot, ref.getObjectAddress(), r);
                r.append(' ');
            }
            if ((ref = (IObject)obj.resolveValue("clazz")) != null) {
                this.addClassName(snapshot, ref.getObjectAddress(), r);
                r.append('.');
            }
            if ((ref = (IObject)obj.resolveValue("name")) == null) {
                return null;
            }
            r.append(ref.getClassSpecificName());
            return r.toString();
        }
    }

    @Subject(value="java.net.Inet6Address$Inet6AddressHolder")
    public static class Inet6AddressHolderResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject object) throws SnapshotException {
            Object host = object.resolveValue("hostName");
            String hostname = host instanceof IObject ? ((IObject)host).getClassSpecificName() : null;
            Object address = object.resolveValue("ipaddress");
            if (address instanceof IPrimitiveArray) {
                IPrimitiveArray p = (IPrimitiveArray)address;
                Object vals = p.getValueArray();
                if (vals instanceof byte[]) {
                    byte[] b = (byte[])vals;
                    try {
                        if (hostname != null) {
                            Object os = object.resolveValue("scope_id_set");
                            Object oid = object.resolveValue("scope_id");
                            if (os instanceof Boolean && ((Boolean)os).booleanValue() && oid instanceof Integer) {
                                Inet6Address in = Inet6Address.getByAddress(hostname, b, (Integer)oid);
                                return String.valueOf(in.getHostName()) + "/" + ((InetAddress)in).getHostAddress();
                            }
                            InetAddress in = InetAddress.getByAddress(hostname, b);
                            return String.valueOf(in.getHostName()) + "/" + in.getHostAddress();
                        }
                        InetAddress in = InetAddress.getByAddress(b);
                        return in.getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {}
                }
            } else if (hostname != null) {
                return hostname;
            }
            return null;
        }
    }

    @Subject(value="java.net.Inet6Address")
    public static class Inet6AddressResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject object) throws SnapshotException {
            Object holder = object.resolveValue("holder6");
            if (holder instanceof IObject) {
                return ((IObject)holder).getClassSpecificName();
            }
            return null;
        }
    }

    @Subject(value="java.net.InetAddress$InetAddressHolder")
    public static class InetAddressHolderResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject object) throws SnapshotException {
            Object host = object.resolveValue("hostName");
            String hostname = host instanceof IObject ? ((IObject)host).getClassSpecificName() : null;
            Object address = object.resolveValue("address");
            if (address instanceof Integer) {
                int addr = (Integer)address;
                byte[] b = new byte[]{(byte)(addr >>> 24), (byte)(addr >>> 16), (byte)(addr >>> 8), (byte)(addr >>> 0)};
                try {
                    if (hostname != null) {
                        InetAddress in = InetAddress.getByAddress(hostname, b);
                        return String.valueOf(in.getHostName()) + "/" + in.getHostAddress();
                    }
                    InetAddress in = InetAddress.getByAddress(b);
                    return in.getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {}
            } else if (hostname != null) {
                return hostname;
            }
            return null;
        }
    }

    @Subject(value="java.net.InetAddress")
    public static class InetAddressResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject object) throws SnapshotException {
            Object holder = object.resolveValue("holder");
            if (holder instanceof IObject) {
                return ((IObject)holder).getClassSpecificName();
            }
            return null;
        }
    }

    @Subject(value="java.net.InetSocketAddress$InetSocketAddressHolder")
    public static class InetSocketAddressHolderResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject object) throws SnapshotException {
            String hostname;
            StringBuilder res = new StringBuilder();
            Object addr = object.resolveValue("addr");
            String addrname = addr instanceof IObject ? ((IObject)addr).getClassSpecificName() : null;
            Object host = object.resolveValue("host");
            String string = hostname = host instanceof IObject ? ((IObject)host).getClassSpecificName() : null;
            if (addrname != null && addrname.indexOf(47) >= 0) {
                int slash = addrname.indexOf(47);
                if (addrname.substring(slash + 1).indexOf(58) >= 0) {
                    res.append(addrname.substring(0, slash + 1));
                    res.append('[');
                    res.append(addrname.substring(slash + 1));
                    res.append(']');
                } else {
                    res.append(addrname);
                }
            } else if (hostname != null) {
                res.append(hostname);
                if (addrname != null) {
                    res.append('/');
                    if (addrname.indexOf(58) >= 0) {
                        res.append('[').append(addrname).append(']');
                    } else {
                        res.append(addrname);
                    }
                }
            } else if (addrname != null) {
                if (addrname.indexOf(58) >= 0) {
                    res.append('[').append(addrname).append(']');
                } else {
                    res.append(addrname);
                }
            }
            res.append(':');
            Object port = object.resolveValue("port");
            if (port instanceof Integer) {
                res.append(port);
            }
            if (res.length() > 1) {
                return res.toString();
            }
            return null;
        }
    }

    @Subject(value="java.net.InetSocketAddress")
    public static class InetSocketAddressResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject object) throws SnapshotException {
            Object holder = object.resolveValue("holder");
            if (holder instanceof IObject) {
                return ((IObject)holder).getClassSpecificName();
            }
            return null;
        }
    }

    @Subject(value="java.lang.invoke.MemberName")
    public static class MemberNameResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject heapObject) throws SnapshotException {
            StringBuilder buf = new StringBuilder();
            IObject value = (IObject)heapObject.resolveValue("name");
            if (value != null) {
                IObject cvalue = (IObject)heapObject.resolveValue("clazz");
                if (cvalue instanceof IClass) {
                    IClass cls = (IClass)cvalue;
                    buf.append(cls.getName()).append('.');
                }
                buf.append(ClassSpecificNameResolverRegistry.resolve(value));
                return buf.toString();
            }
            return null;
        }
    }

    @Subject(value="java.lang.reflect.Method")
    public static class MethodResolver
    extends AccessibleObjectResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject ref;
            StringBuilder r = new StringBuilder();
            ISnapshot snapshot = obj.getSnapshot();
            Object val = obj.resolveValue("modifiers");
            if (val instanceof Integer) {
                r.append(Modifier.toString((Integer)val));
                if (r.length() > 0) {
                    r.append(' ');
                }
            }
            if ((ref = (IObject)obj.resolveValue("returnType")) != null) {
                this.addClassName(snapshot, ref.getObjectAddress(), r);
                r.append(' ');
            }
            if ((ref = (IObject)obj.resolveValue("clazz")) != null) {
                this.addClassName(snapshot, ref.getObjectAddress(), r);
                r.append('.');
            }
            if ((ref = (IObject)obj.resolveValue("name")) == null) {
                return null;
            }
            r.append(ref.getClassSpecificName());
            r.append('(');
            ref = (IObject)obj.resolveValue("parameterTypes");
            if (ref instanceof IObjectArray) {
                IObjectArray orefa = (IObjectArray)ref;
                long[] refs = orefa.getReferenceArray();
                int i = 0;
                while (i < orefa.getLength()) {
                    if (i > 0) {
                        r.append(',');
                    }
                    long addr = refs[i];
                    this.addClassName(snapshot, addr, r);
                    ++i;
                }
            }
            r.append(')');
            return r.toString();
        }
    }

    @Subjects(value={"java.lang.Module", "java.lang.Package"})
    public static class ModuleResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject name = (IObject)obj.resolveValue("name");
            return name != null ? name.getClassSpecificName() : null;
        }
    }

    @Subject(value="sun.nio.ch.SocketChannelImpl")
    public static class SocketChannelImpl
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject object) throws SnapshotException {
            String v;
            String v2;
            StringBuilder sb = new StringBuilder();
            Object state = object.resolveValue("state");
            if (state instanceof Integer) {
                IClass cls = object.getClazz();
                Object s1 = cls.resolveValue("ST_UNINITIALIZED");
                Object s2 = cls.resolveValue("ST_UNCONNECTED");
                Object s3 = cls.resolveValue("ST_PENDING");
                Object s4 = cls.resolveValue("ST_CONNECTED");
                Object s5 = cls.resolveValue("ST_KILLPENDING");
                Object s6 = cls.resolveValue("ST_KILLED");
                if (state.equals(s1)) {
                    sb.append("uninitialized");
                } else if (state.equals(s2)) {
                    sb.append("unconnected");
                } else if (state.equals(s3)) {
                    sb.append("pending");
                } else if (state.equals(s4)) {
                    sb.append("connected");
                } else if (state.equals(s5)) {
                    sb.append("kill pending");
                } else if (state.equals(s6)) {
                    sb.append("killed");
                }
                if (sb.length() > 0) {
                    sb.append(' ');
                }
            }
            sb.append("local=");
            Object localAddress = object.resolveValue("localAddress");
            if (localAddress instanceof IObject && (v2 = ((IObject)localAddress).getClassSpecificName()) != null) {
                sb.append(v2);
            }
            sb.append(" remoteAddress=");
            Object remoteAddress = object.resolveValue("remoteAddress");
            if (remoteAddress instanceof IObject && (v = ((IObject)remoteAddress).getClassSpecificName()) != null) {
                sb.append(v);
            }
            return sb.toString();
        }
    }

    @Subject(value="java.lang.StackTraceElement")
    public static class StackTraceElementResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject cls = (IObject)obj.resolveValue("declaringClass");
            IObject methodName = (IObject)obj.resolveValue("methodName");
            if (cls == null || methodName == null) {
                return null;
            }
            int line = (Integer)obj.resolveValue("lineNumber");
            IObject fn = (IObject)obj.resolveValue("fileName");
            String ln = line == -2 ? "(Compiled Code)" : (line == -3 ? "(Native Method)" : (line == -1 ? "" : (line == 0 ? "" : Integer.toString(line))));
            String name = fn == null ? (line > 0 ? String.valueOf(cls.getClassSpecificName()) + "." + methodName.getClassSpecificName() + "() " + ln : String.valueOf(cls.getClassSpecificName()) + "." + methodName.getClassSpecificName() + "()") : (line > 0 ? String.valueOf(cls.getClassSpecificName()) + "." + methodName.getClassSpecificName() + "() (" + fn.getClassSpecificName() + ":" + ln + ")" : String.valueOf(cls.getClassSpecificName()) + "." + methodName.getClassSpecificName() + "() (" + fn.getClassSpecificName() + ")");
            return name;
        }
    }

    @Subjects(value={"java.lang.StringBuffer", "java.lang.StringBuilder"})
    public static class StringBufferResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            Integer count = (Integer)obj.resolveValue("count");
            if (count == null) {
                return null;
            }
            if (count == 0) {
                return "";
            }
            IPrimitiveArray charArray = (IPrimitiveArray)obj.resolveValue("value");
            if (charArray == null) {
                return null;
            }
            if (charArray.getType() == 8) {
                return PrettyPrinter.objectAsString(obj, 1024);
            }
            return PrettyPrinter.arrayAsString(charArray, 0, count, 1024);
        }
    }

    @Subject(value="java.lang.String")
    public static class StringResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            return PrettyPrinter.objectAsString(obj, 1024);
        }
    }

    @Subject(value="java.lang.ThreadGroup")
    public static class ThreadGroupResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject object) throws SnapshotException {
            IObject nameString = (IObject)object.resolveValue("name");
            if (nameString == null) {
                return null;
            }
            return nameString.getClassSpecificName();
        }
    }

    @Subject(value="java.lang.Thread")
    public static class ThreadResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject name = (IObject)obj.resolveValue("name");
            return name != null ? name.getClassSpecificName() : null;
        }
    }

    @Subject(value="java.net.URI")
    public static class URIResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject ref;
            IObject query;
            IObject path;
            IObject authority;
            String val;
            StringBuilder builder = new StringBuilder();
            IObject string = (IObject)obj.resolveValue("string");
            if (string != null && (val = string.getClassSpecificName()) != null) {
                return val;
            }
            IObject protocol = (IObject)obj.resolveValue("scheme");
            if (protocol != null) {
                builder.append(protocol.getClassSpecificName());
                builder.append(":");
            }
            if ((authority = (IObject)obj.resolveValue("authority")) != null) {
                builder.append("//");
                builder.append(authority.getClassSpecificName());
            }
            if ((path = (IObject)obj.resolveValue("path")) != null) {
                builder.append(path.getClassSpecificName());
            }
            if ((query = (IObject)obj.resolveValue("query")) != null) {
                builder.append("?");
                builder.append(query.getClassSpecificName());
            }
            if ((ref = (IObject)obj.resolveValue("ref")) != null) {
                builder.append("#");
                builder.append(ref.getClassSpecificName());
            }
            return builder.length() > 0 ? builder.toString() : null;
        }
    }

    @Subject(value="java.net.URL")
    public static class URLResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject obj) throws SnapshotException {
            IObject ref;
            IObject query;
            IObject path;
            IObject authority;
            StringBuilder builder = new StringBuilder();
            IObject protocol = (IObject)obj.resolveValue("protocol");
            if (protocol != null) {
                builder.append(protocol.getClassSpecificName());
                builder.append(":");
            }
            if ((authority = (IObject)obj.resolveValue("authority")) != null) {
                builder.append("//");
                builder.append(authority.getClassSpecificName());
            }
            if ((path = (IObject)obj.resolveValue("path")) != null) {
                builder.append(path.getClassSpecificName());
            }
            if ((query = (IObject)obj.resolveValue("query")) != null) {
                builder.append("?");
                builder.append(query.getClassSpecificName());
            }
            if ((ref = (IObject)obj.resolveValue("ref")) != null) {
                builder.append("#");
                builder.append(ref.getClassSpecificName());
            }
            return builder.length() > 0 ? builder.toString() : null;
        }
    }

    @Subjects(value={"java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Boolean", "java.util.concurrent.atomic.AtomicInteger", "java.util.concurrent.atomic.AtomicLong"})
    public static class ValueResolver
    implements IClassSpecificNameResolver {
        @Override
        public String resolve(IObject heapObject) throws SnapshotException {
            Object value = heapObject.resolveValue("value");
            return value != null ? String.valueOf(value) : null;
        }
    }
}

