/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.inspections.ReferenceQuery;
import org.eclipse.mat.inspections.collectionextract.CollectionExtractionUtils;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.refined.RefinedResultBuilder;
import org.eclipse.mat.query.refined.RefinedTable;
import org.eclipse.mat.query.refined.TotalsRow;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.report.ITestResult;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.ExcludedReferencesDescriptor;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQLParseException;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.model.ThreadToLocalReference;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.PieFactory;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.util.HTMLUtils;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SilentProgressListener;
import org.eclipse.mat.util.Units;

@CommandName(value="component_report")
@Icon(value="/META-INF/icons/component_report.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/reference/inspections/component_report.html")
public class ComponentReportQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public boolean aggressive;
    private static final String HTML_BREAK = "<br>";
    private static final String UNFINALIZED_REFERENCE = "<" + GCRootInfo.getTypeAsString(1024) + ">";
    private String oqlretained;

    public IResult execute(IProgressListener listener) throws Exception {
        ReferenceMessages msg2;
        SectionSpec componentReport = new SectionSpec(MessageUtil.format((String)Messages.ComponentReportQuery_ComponentReport, (Object[])new Object[]{this.objects.getLabel()}));
        Ticks ticks = new Ticks(listener, componentReport.getName(), 16);
        int[] retained = this.calculateRetainedSize(ticks);
        ticks.tick();
        Histogram histogram = this.snapshot.getHistogram(retained, ticks);
        for (ClassHistogramRecord cr : histogram.getClassHistogramRecords()) {
            long retsize = this.snapshot.getMinRetainedSize(cr.getObjectIds(), listener);
            cr.setRetainedHeapSize(retsize);
        }
        if (ticks.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        ticks.tick();
        long totalSize = this.snapshot.getHeapSize(retained);
        ticks.tick();
        this.addOverview(componentReport, totalSize, retained, histogram, ticks);
        SectionSpec possibleWaste = new SectionSpec(Messages.ComponentReportQuery_PossibleMemoryWaste);
        componentReport.add((Spec)possibleWaste);
        try {
            this.addDuplicateStrings(possibleWaste, totalSize, histogram, ticks);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.addEmptyCollections(possibleWaste, totalSize, histogram, ticks);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.addCollectionFillRatios(possibleWaste, totalSize, histogram, ticks);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.addZeroLengthArrays(possibleWaste, totalSize, histogram, ticks);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.addArrayFillRatios(possibleWaste, totalSize, histogram, ticks);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.addPrimitiveArrays(possibleWaste, totalSize, histogram, ticks);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        SectionSpec miscellaneous = new SectionSpec(Messages.ComponentReportQuery_Miscellaneous);
        componentReport.add((Spec)miscellaneous);
        try {
            msg2 = new SoftReferenceMessages();
            this.addReferenceStatistic(miscellaneous, histogram, ticks, "java.lang.ref.SoftReference", msg2);
        }
        catch (UnsupportedOperationException msg2) {
            // empty catch block
        }
        try {
            msg2 = new WeakReferenceMessages();
            this.addReferenceStatistic(miscellaneous, histogram, ticks, "java.lang.ref.WeakReference", msg2);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.addFinalizerStatistic(miscellaneous, retained, ticks);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.addHashMapsCollisionRatios(miscellaneous, totalSize, histogram, ticks);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        ticks.delegate.done();
        return componentReport;
    }

    private int[] calculateRetainedSize(Ticks ticks) throws SnapshotException {
        boolean useoql;
        int[] retained = null;
        ArrayList<ExcludedReferencesDescriptor> excludes = new ArrayList<ExcludedReferencesDescriptor>();
        this.addExcludes(excludes, "java.lang.ref.Finalizer", "referent");
        this.addExcludes(excludes, "java.lang.Runtime", UNFINALIZED_REFERENCE);
        this.addExcludes(excludes, "java.lang.ref.PhantomReference", "referent");
        this.addExcludes(excludes, "java.lang.ref.WeakReference", "referent");
        this.addExcludes(excludes, "java.lang.ref.SoftReference", "referent");
        int[] ids = this.objects.getIds(ticks);
        String label = this.objects.getLabel().toLowerCase(Locale.ENGLISH);
        boolean bl = useoql = label.startsWith("select * ") || label.startsWith("select objects ");
        if (excludes.isEmpty()) {
            retained = this.snapshot.getRetainedSet(ids, ticks);
        } else {
            int n;
            int retlen = -1;
            long hs = 0L;
            if (useoql) {
                int[] retained1 = this.snapshot.getRetainedSet(ids, (IProgressListener)new SilentProgressListener((IProgressListener)ticks));
                retlen = retained1.length;
                int[] nArray = retained1;
                n = retained1.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    hs += this.snapshot.mapIdToAddress(i);
                    ++n2;
                }
                retained1 = null;
            }
            retained = this.snapshot.getRetainedSet(ids, excludes.toArray(new ExcludedReferencesDescriptor[0]), (IProgressListener)ticks);
            if (useoql) {
                if (retained.length != retlen) {
                    useoql = false;
                } else {
                    long hs1 = 0L;
                    int[] nArray = retained;
                    int n3 = retained.length;
                    n = 0;
                    while (n < n3) {
                        int i = nArray[n];
                        hs1 += this.snapshot.mapIdToAddress(i);
                        ++n;
                    }
                    if (hs != hs1) {
                        useoql = false;
                    }
                }
            }
        }
        if (useoql) {
            String oql0 = this.objects.getLabel().trim();
            if (oql0.endsWith(";")) {
                oql0 = oql0.substring(0, oql0.length() - 1);
            }
            String oql = String.valueOf(oql0.substring(0, 6)) + " as retained set" + oql0.substring(6);
            try {
                SnapshotFactory.createQuery(oql);
                this.oqlretained = oql;
            }
            catch (OQLParseException oQLParseException) {
            }
            catch (SnapshotException snapshotException) {
                // empty catch block
            }
        }
        return retained;
    }

    private void addExcludes(List<ExcludedReferencesDescriptor> excludes, String className, String ... fields) throws SnapshotException {
        Collection<IClass> finalizer = this.snapshot.getClassesByName(className, true);
        if (finalizer != null) {
            int count = 0;
            for (IClass c : finalizer) {
                count += c.getNumberOfObjects();
            }
            ArrayInt objectIds = new ArrayInt(count);
            for (IClass c : finalizer) {
                objectIds.addAll(c.getObjectIds());
            }
            excludes.add(new ExcludedReferencesDescriptor(objectIds.toArray(), fields));
        }
    }

    private void addOverview(SectionSpec componentReport, long totalSize, int[] retained, Histogram histogram, Ticks listener) throws Exception {
        SectionSpec overview = new SectionSpec(Messages.ComponentReportQuery_Overview);
        overview.set("html.show_heading", Boolean.FALSE.toString());
        this.addOverviewNumbers(retained, histogram, overview, totalSize);
        listener.tick();
        this.addOverviewPie(overview, totalSize);
        listener.tick();
        this.addTopConsumer(overview, retained, listener);
        listener.tick();
        this.addRetainedSet(overview, histogram);
        listener.tick();
        componentReport.add((Spec)overview);
    }

    private void addOverviewNumbers(int[] retained, Histogram histogram, SectionSpec overview, long totalSize) {
        int noOfClasses = histogram.getClassHistogramRecords().size();
        int noOfObjects = retained.length;
        int noOfClassLoaders = histogram.getClassLoaderHistogramRecords().size();
        StringBuilder buf = new StringBuilder();
        buf.append(Messages.ComponentReportQuery_Size).append(" <strong>").append(Units.Storage.of((long)totalSize).format(totalSize)).append("</strong> ");
        buf.append(Messages.ComponentReportQuery_Classes).append(" <strong>").append(Units.Plain.of((long)noOfClasses).format((long)noOfClasses)).append("</strong> ");
        buf.append(Messages.ComponentReportQuery_Objects).append(" <strong>").append(Units.Plain.of((long)noOfObjects).format((long)noOfObjects)).append("</strong> ");
        buf.append(Messages.ComponentReportQuery_ClassLoader).append(" <strong>").append(Units.Plain.of((long)noOfClassLoaders).format((long)noOfClassLoaders)).append("</strong>");
        QuerySpec spec = new QuerySpec(Messages.ComponentReportQuery_Details, (IResult)new TextResult(buf.toString(), true));
        spec.set("html.show_heading", Boolean.FALSE.toString());
        overview.add((Spec)spec);
    }

    private void addOverviewPie(SectionSpec overview, long totalSize) {
        PieFactory pie = new PieFactory(this.snapshot);
        pie.addSlice(-1, this.objects.getLabel(), totalSize, totalSize);
        QuerySpec spec = new QuerySpec(Messages.ComponentReportQuery_Distribution, (IResult)pie.build());
        spec.set("html.show_heading", Boolean.FALSE.toString());
        overview.add((Spec)spec);
    }

    private void addTopConsumer(SectionSpec componentReport, int[] retained, IProgressListener listener) throws Exception {
        IResult result = SnapshotQuery.lookup("top_consumers_html", this.snapshot).setArgument("objects", retained).execute(listener);
        QuerySpec topConsumers = new QuerySpec(Messages.ComponentReportQuery_TopConsumers);
        topConsumers.set("html.separate_file", Boolean.TRUE.toString());
        topConsumers.set("html.collapsed", Boolean.FALSE.toString());
        topConsumers.setResult(result);
        if (this.oqlretained != null) {
            String cmd = "top_consumers_html " + this.oqlretained + ";";
            topConsumers.setCommand(cmd);
        }
        componentReport.add((Spec)topConsumers);
    }

    private void addRetainedSet(SectionSpec componentReport, Histogram histogram) {
        QuerySpec retainedSet = new QuerySpec(Messages.ComponentReportQuery_RetainedSet);
        retainedSet.set("html.separate_file", Boolean.TRUE.toString());
        retainedSet.setResult((IResult)histogram);
        try {
            String objectLabel = this.objects.getLabel();
            if (!objectLabel.startsWith("[")) {
                String command = "customized_retained_set";
                command = String.valueOf(command) + " " + objectLabel;
                command = String.valueOf(command) + " -x java.lang.ref.Finalizer:referent";
                command = String.valueOf(command) + " java.lang.Runtime:" + UNFINALIZED_REFERENCE;
                command = String.valueOf(command) + " java.lang.ref.PhantomReference:referent";
                command = String.valueOf(command) + " java.lang.ref.WeakReference:referent";
                command = String.valueOf(command) + " java.lang.ref.SoftReference:referent";
                SnapshotQuery.parse(command, this.snapshot);
                retainedSet.setCommand(command);
            }
        }
        catch (SnapshotException snapshotException) {
            // empty catch block
        }
        componentReport.add((Spec)retainedSet);
    }

    private String escapeHTMLAttribute(String msg) {
        return HTMLUtils.escapeText((String)msg).replaceAll("\"", "&quote;").replaceAll("'", "&apos;");
    }

    private List<ClassHistogramRecord> sorted(Collection<ClassHistogramRecord> c) {
        ArrayList<ClassHistogramRecord> l = new ArrayList<ClassHistogramRecord>(c);
        l.sort(Histogram.COMPARATOR_FOR_LABEL);
        l.sort(Histogram.reverseComparator(Histogram.COMPARATOR_FOR_RETAINEDHEAPSIZE));
        return l;
    }

    private void addDuplicateStrings(SectionSpec componentReport, long totalSize, Histogram histogram, Ticks listener) throws Exception {
        InspectionAssert.heapFormatIsNot(this.snapshot, "DTFJ-PHD");
        Random random = new Random(this.snapshot.getSnapshotInfo().getUsedHeapSize());
        SectionSpec duplicateStrings = new SectionSpec(Messages.ComponentReportQuery_DuplicateStrings);
        StringBuilder comment = new StringBuilder();
        boolean commentWarn = false;
        SectionSpec detailsSpec = new SectionSpec(Messages.ComponentReportQuery_Details);
        detailsSpec.set("html.collapsed", Boolean.TRUE.toString());
        for (ClassHistogramRecord record : this.sorted(histogram.getClassHistogramRecords())) {
            if (listener.isCanceled()) break;
            if (!"char[]".equals(record.getLabel()) && !"byte[]".equals(record.getLabel())) continue;
            int[] objectIds = record.getObjectIds();
            if ("byte[]".equals(record.getLabel())) {
                ArrayInt ai = new ArrayInt();
                int i = 0;
                while (i < objectIds.length) {
                    int parent = this.snapshot.getImmediateDominatorId(objectIds[i]);
                    if (parent >= 0 && this.snapshot.getClassOf(parent).getName().equals("java.lang.String")) {
                        ai.add(objectIds[i]);
                    }
                    ++i;
                }
                if (ai.isEmpty()) continue;
                objectIds = ai.toArray();
            }
            long threshold = totalSize / 20L;
            int LIMIT = 100;
            if (objectIds.length > 100) {
                int[] copy = new int[100];
                int i = 0;
                int j = 0;
                while (i < objectIds.length) {
                    if (random.nextInt(objectIds.length - i) < 100 - j) {
                        copy[j++] = objectIds[i];
                    }
                    ++i;
                }
                threshold = threshold * (long)copy.length / (long)objectIds.length * (long)copy.length / (long)objectIds.length;
                objectIds = copy;
            }
            RefinedResultBuilder builder = SnapshotQuery.lookup("group_by_value", this.snapshot).setArgument("objects", objectIds).refine(listener);
            int dupcount = 10;
            builder.setFilter(1, ">=" + dupcount);
            builder.setInlineRetainedSizeCalculation(true);
            RefinedTable table = (RefinedTable)builder.build();
            TotalsRow totals = new TotalsRow();
            table.calculateTotals(table.getRows(), totals, (IProgressListener)listener);
            boolean foundStrings = false;
            int rowId = 0;
            while (rowId < table.getRowCount() && rowId < 5) {
                Object row = table.getRow(rowId);
                String value = table.getFormattedColumnValue(row, 0);
                if (value.length() > 50) {
                    value = String.valueOf(value.substring(0, 50)) + "...";
                }
                String size = table.getFormattedColumnValue(row, 2);
                if (!foundStrings) {
                    foundStrings = true;
                    comment.append(HTMLUtils.escapeText((String)MessageUtil.format((String)Messages.ComponentReportQuery_Msg_FoundOccurrences, (Object[])new Object[]{table.getRowCount(), totals.getLabel(2), record.getLabel(), dupcount})));
                    comment.append("<p>").append(Messages.ComponentReportQuery_TopElementsInclude).append("</p><ul title=\"").append(this.escapeHTMLAttribute(Messages.ComponentReportQuery_TopElementsInclude)).append("\">");
                }
                comment.append("<li>").append(table.getFormattedColumnValue(row, 1));
                comment.append(" &times; <strong>").append(HTMLUtils.escapeText((String)value)).append("</strong> ");
                comment.append(MessageUtil.format((String)Messages.ComponentReportQuery_Label_Bytes, (Object[])new Object[]{size})).append("</li>");
                ++rowId;
            }
            if (foundStrings) {
                comment.append("</ul>");
            }
            long bigwasted = 0L;
            int rowId2 = 0;
            while (rowId2 < table.getRowCount()) {
                Object row = table.getRow(rowId2);
                long sizel = Math.abs((Long)table.getColumnValue(row, 4));
                bigwasted += sizel;
                ++rowId2;
            }
            boolean warn = bigwasted > threshold;
            commentWarn |= warn;
            QuerySpec spec = new QuerySpec(record.getLabel());
            if (warn) {
                spec.set("html.is_important", Boolean.TRUE.toString());
            }
            spec.setResult((IResult)table);
            IObject o = this.snapshot.getObject(record.getClassId());
            if (o instanceof IClass) {
                this.addCommand(spec, "group_by_value", objectIds, (IClass)o);
            }
            detailsSpec.add((Spec)spec);
        }
        if (detailsSpec.getChildren().isEmpty()) {
            return;
        }
        if (comment.length() == 0) {
            comment.append(Messages.ComponentReportQuery_NoExcessiveDuplicateStrings);
        }
        QuerySpec spec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(comment.toString(), true));
        spec.set("rendering.pattern", "overview_details");
        if (commentWarn) {
            spec.set("html.is_important", Boolean.TRUE.toString());
            duplicateStrings.setStatus(ITestResult.Status.WARNING);
        }
        duplicateStrings.add((Spec)spec);
        duplicateStrings.add((Spec)detailsSpec);
        componentReport.add((Spec)duplicateStrings);
        listener.tick();
    }

    private void addCommand(QuerySpec spec, String command, int[] suspects, IClass clazz) {
        if (suspects.length > 0 && suspects.length <= 30) {
            try {
                StringBuilder sb = new StringBuilder(command);
                int[] nArray = suspects;
                int n = suspects.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    sb.append(" 0x").append(Long.toHexString(this.snapshot.mapIdToAddress(i)));
                    ++n2;
                }
                spec.setCommand(sb.toString());
            }
            catch (SnapshotException sb) {}
        } else if (this.oqlretained != null) {
            String oql = "select * from objects (" + this.oqlretained + ") m where m.@clazz.@objectAddress = " + clazz.getObjectAddress() + "L";
            String cmd = String.valueOf(command) + " " + oql + ";";
            spec.setCommand(cmd);
        }
    }

    private void addEmptyCollections(SectionSpec componentReport, long totalSize, Histogram histogram, Ticks listener) throws Exception {
        boolean warn;
        if (!this.aggressive) {
            InspectionAssert.heapFormatIsNot(this.snapshot, "DTFJ-PHD");
        }
        long threshold = totalSize / 20L;
        SectionSpec overview = new SectionSpec(Messages.ComponentReportQuery_EmptyCollections);
        StringBuilder comment = new StringBuilder();
        SectionSpec collectionbySizeSpec = new SectionSpec(Messages.ComponentReportQuery_Details);
        collectionbySizeSpec.set("html.collapsed", Boolean.TRUE.toString());
        for (ClassHistogramRecord record : this.sorted(histogram.getClassHistogramRecords())) {
            if (listener.isCanceled()) break;
            IClass clazz = (IClass)this.snapshot.getObject(record.getClassId());
            ICollectionExtractor extractor = CollectionExtractionUtils.findCollectionExtractor(clazz.getName());
            if (extractor == null || !extractor.hasSize()) continue;
            RefinedResultBuilder builder = SnapshotQuery.lookup("collections_grouped_by_size", this.snapshot).setArgument("objects", record.getObjectIds()).refine(listener);
            builder.setInlineRetainedSizeCalculation(true);
            RefinedTable refinedTable = (RefinedTable)builder.build();
            Boolean warn2 = false;
            int count = refinedTable.getRowCount();
            int rowId = 0;
            while (rowId < count && rowId < 10) {
                Object row = refinedTable.getRow(rowId);
                int collectionSize = (Integer)refinedTable.getColumnValue(row, 0);
                if (collectionSize == 0) {
                    long size = Math.abs((Long)refinedTable.getColumnValue(row, 3));
                    if (size <= threshold) break;
                    int numberOfObjects = (Integer)refinedTable.getColumnValue(row, 1);
                    String retainedSize = refinedTable.getFormattedColumnValue(row, 3);
                    if (comment.length() == 0) {
                        comment.append(HTMLUtils.escapeText((String)Messages.ComponentReportQuery_DetectedEmptyCollections)).append("<ul title=\"").append(this.escapeHTMLAttribute(Messages.ComponentReportQuery_DetectedEmptyCollections)).append("\">");
                    }
                    comment.append("<li>");
                    comment.append(MessageUtil.format((String)Messages.ComponentReportQuery_Msg_InstancesRetainBytes, (Object[])new Object[]{numberOfObjects, HTMLUtils.escapeText((String)clazz.getName()), HTMLUtils.escapeText((String)retainedSize)}));
                    comment.append("</li>");
                    warn2 = true;
                    break;
                }
                ++rowId;
            }
            QuerySpec bySizeSpec = new QuerySpec(clazz.getName());
            if (warn2.booleanValue()) {
                bySizeSpec.set("html.is_important", Boolean.TRUE.toString());
            }
            bySizeSpec.setResult((IResult)refinedTable);
            this.addCommand(bySizeSpec, "collections_grouped_by_size", record.getObjectIds(), clazz);
            collectionbySizeSpec.add((Spec)bySizeSpec);
        }
        listener.tick();
        if (collectionbySizeSpec.getChildren().isEmpty()) {
            return;
        }
        boolean bl = warn = comment.length() != 0;
        if (!warn) {
            comment.append(Messages.ComponentReportQuery_Msg_NoExcessiveEmptyCollectionsFound);
        } else {
            comment.append("</ul>");
            overview.setStatus(ITestResult.Status.WARNING);
        }
        QuerySpec spec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(comment.toString(), true));
        spec.set("rendering.pattern", "overview_details");
        if (warn) {
            spec.set("html.is_important", Boolean.TRUE.toString());
        }
        overview.add((Spec)spec);
        overview.add((Spec)collectionbySizeSpec);
        componentReport.add((Spec)overview);
    }

    private void addZeroLengthArrays(SectionSpec componentReport, long totalSize, Histogram histogram, Ticks listener) throws Exception {
        boolean warn;
        if (!this.aggressive) {
            InspectionAssert.heapFormatIsNot(this.snapshot, "DTFJ-PHD");
        }
        long threshold = totalSize / 20L;
        SectionSpec overview = new SectionSpec(Messages.ComponentReportQuery_ZeroLengthArrays);
        StringBuilder comment = new StringBuilder();
        SectionSpec arraybySizeSpec = new SectionSpec(Messages.ComponentReportQuery_Details);
        arraybySizeSpec.set("html.collapsed", Boolean.TRUE.toString());
        for (ClassHistogramRecord record : this.sorted(histogram.getClassHistogramRecords())) {
            if (listener.isCanceled()) break;
            IClass clazz = (IClass)this.snapshot.getObject(record.getClassId());
            if (!clazz.isArrayType()) continue;
            RefinedResultBuilder builder = SnapshotQuery.lookup("arrays_grouped_by_size", this.snapshot).setArgument("objects", record.getObjectIds()).refine(listener);
            builder.setInlineRetainedSizeCalculation(true);
            RefinedTable refinedTable = (RefinedTable)builder.build();
            Boolean warn2 = false;
            int count = refinedTable.getRowCount();
            int rowId = 0;
            while (rowId < count && rowId < 10) {
                Object row = refinedTable.getRow(rowId);
                int arraySize = (Integer)refinedTable.getColumnValue(row, 0);
                if (arraySize <= 0) {
                    long size = Math.abs((Long)refinedTable.getColumnValue(row, 4));
                    if (size <= threshold) break;
                    int numberOfObjects = (Integer)refinedTable.getColumnValue(row, 1);
                    String retainedSize = refinedTable.getFormattedColumnValue(row, 3);
                    if (comment.length() == 0) {
                        comment.append(HTMLUtils.escapeText((String)Messages.ComponentReportQuery_DetectedZeroLengthArray)).append("<ul title=\"").append(this.escapeHTMLAttribute(Messages.ComponentReportQuery_DetectedZeroLengthArray)).append("\">");
                    }
                    String cn = clazz.getName();
                    String an = String.valueOf(cn.substring(0, cn.length() - 1)) + arraySize + cn.substring(cn.length() - 1);
                    comment.append("<li>");
                    comment.append(MessageUtil.format((String)Messages.ComponentReportQuery_Msg_InstancesRetainBytes, (Object[])new Object[]{numberOfObjects, HTMLUtils.escapeText((String)an), HTMLUtils.escapeText((String)retainedSize)}));
                    comment.append("</li>");
                    warn2 = true;
                    break;
                }
                ++rowId;
            }
            QuerySpec bySizeSpec = new QuerySpec(clazz.getName());
            if (warn2.booleanValue()) {
                bySizeSpec.set("html.is_important", Boolean.TRUE.toString());
            }
            bySizeSpec.setResult((IResult)refinedTable);
            this.addCommand(bySizeSpec, "arrays_grouped_by_size", record.getObjectIds(), clazz);
            arraybySizeSpec.add((Spec)bySizeSpec);
        }
        listener.tick();
        if (arraybySizeSpec.getChildren().isEmpty()) {
            return;
        }
        boolean bl = warn = comment.length() != 0;
        if (!warn) {
            comment.append(Messages.ComponentReportQuery_NoExcessiveUsageZeroLengthArray);
        } else {
            comment.append("</ul>");
            overview.setStatus(ITestResult.Status.WARNING);
        }
        QuerySpec spec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(comment.toString(), true));
        spec.set("rendering.pattern", "overview_details");
        if (warn) {
            spec.set("html.is_important", Boolean.TRUE.toString());
        }
        overview.add((Spec)spec);
        overview.add((Spec)arraybySizeSpec);
        componentReport.add((Spec)overview);
    }

    private void addPrimitiveArrays(SectionSpec componentReport, long totalSize, Histogram histogram, Ticks listener) throws Exception {
        boolean warn;
        InspectionAssert.heapFormatIsNot(this.snapshot, "DTFJ-PHD");
        long threshold = totalSize / 20L;
        SectionSpec overview = new SectionSpec(Messages.ComponentReportQuery_PrimitiveArraysWithAConstantValue);
        StringBuilder comment = new StringBuilder();
        SectionSpec primitiveArrayWithAConstantValue = new SectionSpec(Messages.ComponentReportQuery_Details);
        primitiveArrayWithAConstantValue.set("html.collapsed", Boolean.TRUE.toString());
        for (ClassHistogramRecord record : this.sorted(histogram.getClassHistogramRecords())) {
            if (listener.isCanceled()) break;
            IClass clazz = (IClass)this.snapshot.getObject(record.getClassId());
            boolean prim = false;
            String[] stringArray = IPrimitiveArray.TYPE;
            int n = IPrimitiveArray.TYPE.length;
            int n2 = 0;
            while (n2 < n) {
                String aname = stringArray[n2];
                if (clazz.getName().equals(aname)) {
                    prim = true;
                    break;
                }
                ++n2;
            }
            if (!prim) continue;
            RefinedResultBuilder builder = SnapshotQuery.lookup("primitive_arrays_with_a_constant_value", this.snapshot).setArgument("objects", record.getObjectIds()).refine(listener);
            builder.setInlineRetainedSizeCalculation(true);
            RefinedTable refinedTable = (RefinedTable)builder.build();
            TotalsRow totals = new TotalsRow();
            refinedTable.calculateTotals(refinedTable.getRows(), totals, (IProgressListener)listener);
            boolean warn2 = false;
            int count = refinedTable.getRowCount();
            long totalSizeArrays = 0L;
            int totalNumberObjects = 0;
            int rowId = 0;
            while (rowId < count) {
                Object row = refinedTable.getRow(rowId);
                long size = Math.abs((Long)refinedTable.getColumnValue(row, 4));
                totalSizeArrays += size;
                int numberOfObjects = (Integer)refinedTable.getColumnValue(row, 2);
                totalNumberObjects += numberOfObjects;
                if (size > threshold) {
                    int length = (Integer)refinedTable.getColumnValue(row, 0);
                    String value = refinedTable.getFormattedColumnValue(row, 1);
                    String retainedSize = refinedTable.getFormattedColumnValue(row, 3);
                    String cn = clazz.getName();
                    String an = String.valueOf(cn.substring(0, cn.length() - 1)) + length + cn.substring(cn.length() - 1) + " {" + value + "}";
                    this.primitiveArrayComment(comment, numberOfObjects, retainedSize, an);
                    warn2 = true;
                }
                ++rowId;
            }
            if (totalSizeArrays > threshold) {
                String retainedSize = totals.getLabel(3);
                this.primitiveArrayComment(comment, totalNumberObjects, retainedSize, clazz.getName());
                warn2 = true;
            }
            QuerySpec bySizeSpec = new QuerySpec(clazz.getName());
            bySizeSpec.setResult((IResult)refinedTable);
            if (warn2) {
                bySizeSpec.set("html.is_important", Boolean.TRUE.toString());
            }
            this.addCommand(bySizeSpec, "primitive_arrays_with_a_constant_value", record.getObjectIds(), clazz);
            primitiveArrayWithAConstantValue.add((Spec)bySizeSpec);
        }
        listener.tick();
        if (primitiveArrayWithAConstantValue.getChildren().isEmpty()) {
            return;
        }
        boolean bl = warn = comment.length() != 0;
        if (!warn) {
            comment.append(Messages.ComponentReportQuery_NoExcessivePrimitiveArrays);
        } else {
            comment.append("</ul>");
            overview.setStatus(ITestResult.Status.WARNING);
        }
        QuerySpec spec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(comment.toString(), true));
        spec.set("rendering.pattern", "overview_details");
        if (warn) {
            spec.set("html.is_important", Boolean.TRUE.toString());
        }
        overview.add((Spec)spec);
        overview.add((Spec)primitiveArrayWithAConstantValue);
        componentReport.add((Spec)overview);
    }

    private void primitiveArrayComment(StringBuilder comment, int numberOfObjects, String retainedSize, String an) {
        if (comment.length() == 0) {
            comment.append(HTMLUtils.escapeText((String)Messages.ComponentReportQuery_DetectedTheFollowingPrimitiveArray)).append("<ul title=\"").append(this.escapeHTMLAttribute(Messages.ComponentReportQuery_DetectedTheFollowingPrimitiveArray)).append("\">");
        }
        comment.append("<li>");
        comment.append(MessageUtil.format((String)Messages.ComponentReportQuery_Msg_InstancesRetainBytes, (Object[])new Object[]{numberOfObjects, HTMLUtils.escapeText((String)an), HTMLUtils.escapeText((String)retainedSize)}));
        comment.append("</li>");
    }

    private void addCollectionFillRatios(SectionSpec componentReport, long totalSize, Histogram histogram, Ticks listener) throws Exception {
        boolean warn2;
        if (!this.aggressive) {
            InspectionAssert.heapFormatIsNot(this.snapshot, "DTFJ-PHD");
        }
        long threshold = totalSize / 20L;
        SectionSpec overview = new SectionSpec(Messages.ComponentReportQuery_CollectionFillRatios);
        StringBuilder comment = new StringBuilder();
        SectionSpec detailsSpec = new SectionSpec(Messages.ComponentReportQuery_Details);
        detailsSpec.set("html.collapsed", Boolean.TRUE.toString());
        for (ClassHistogramRecord record : this.sorted(histogram.getClassHistogramRecords())) {
            if (listener.isCanceled()) break;
            IClass clazz = (IClass)this.snapshot.getObject(record.getClassId());
            ICollectionExtractor extractor = CollectionExtractionUtils.findCollectionExtractor(clazz.getName());
            if (extractor == null || !extractor.hasSize() || !extractor.hasFillRatio() && !extractor.hasCapacity() && !extractor.hasExtractableContents()) continue;
            RefinedResultBuilder builder = SnapshotQuery.lookup("collection_fill_ratio", this.snapshot).setArgument("objects", record.getObjectIds()).refine(listener);
            builder.setInlineRetainedSizeCalculation(true);
            RefinedTable refinedTable = (RefinedTable)builder.build();
            boolean warn = false;
            int count = refinedTable.getRowCount();
            int rowId = 0;
            while (rowId < count) {
                Object row = refinedTable.getRow(rowId);
                double fillRatio = (Double)refinedTable.getColumnValue(row, 0);
                if (fillRatio > 0.0 && fillRatio < 0.21) {
                    int retainedCol = 4;
                    long size = Math.abs((Long)refinedTable.getColumnValue(row, retainedCol));
                    if (size <= threshold) break;
                    int numberOfObjects = (Integer)refinedTable.getColumnValue(row, 1);
                    String retainedSize = refinedTable.getFormattedColumnValue(row, retainedCol);
                    if (comment.length() == 0) {
                        comment.append(HTMLUtils.escapeText((String)Messages.ComponentReportQuery_Msg_DetectedCollectionFillRatios)).append("<ul title=\"").append(this.escapeHTMLAttribute(Messages.ComponentReportQuery_Msg_DetectedCollectionFillRatios)).append("\">");
                    }
                    comment.append("<li>");
                    comment.append(MessageUtil.format((String)Messages.ComponentReportQuery_Msg_InstancesRetainBytes, (Object[])new Object[]{numberOfObjects, HTMLUtils.escapeText((String)clazz.getName()), HTMLUtils.escapeText((String)retainedSize)}));
                    comment.append("</li>");
                    warn = true;
                    break;
                }
                ++rowId;
            }
            QuerySpec spec = new QuerySpec(clazz.getName());
            if (warn) {
                spec.set("html.is_important", Boolean.TRUE.toString());
            }
            spec.setResult((IResult)refinedTable);
            this.addCommand(spec, "collection_fill_ratio", record.getObjectIds(), clazz);
            detailsSpec.add((Spec)spec);
        }
        listener.tick();
        if (detailsSpec.getChildren().isEmpty()) {
            return;
        }
        boolean bl = warn2 = comment.length() != 0;
        if (!warn2) {
            comment.append(Messages.ComponentReportQuery_Msg_NoLowFillRatiosFound);
        } else {
            comment.append("</ul>");
            overview.setStatus(ITestResult.Status.WARNING);
        }
        QuerySpec commentSpec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(comment.toString(), true));
        commentSpec.set("rendering.pattern", "overview_details");
        if (warn2) {
            commentSpec.set("html.is_important", Boolean.TRUE.toString());
        }
        overview.add((Spec)commentSpec);
        overview.add((Spec)detailsSpec);
        componentReport.add((Spec)overview);
    }

    private void addArrayFillRatios(SectionSpec componentReport, long totalSize, Histogram histogram, Ticks listener) throws Exception {
        boolean warn2;
        if (!this.aggressive) {
            InspectionAssert.heapFormatIsNot(this.snapshot, "DTFJ-PHD");
        }
        long threshold = totalSize / 20L;
        SectionSpec overview = new SectionSpec(Messages.ComponentReportQuery_ArrayFillRatios);
        StringBuilder comment = new StringBuilder();
        SectionSpec detailsSpec = new SectionSpec(Messages.ComponentReportQuery_Details);
        detailsSpec.set("html.collapsed", Boolean.TRUE.toString());
        for (ClassHistogramRecord record : this.sorted(histogram.getClassHistogramRecords())) {
            if (listener.isCanceled()) break;
            IClass clazz = (IClass)this.snapshot.getObject(record.getClassId());
            if (!clazz.isArrayType()) continue;
            RefinedResultBuilder builder = SnapshotQuery.lookup("array_fill_ratio", this.snapshot).setArgument("objects", record.getObjectIds()).refine(listener);
            builder.setInlineRetainedSizeCalculation(true);
            RefinedTable refinedTable = (RefinedTable)builder.build();
            int count = refinedTable.getRowCount();
            if (count == 0) continue;
            boolean warn = false;
            int rowId = 0;
            while (rowId < count) {
                Object row = refinedTable.getRow(rowId);
                double fillRatio = (Double)refinedTable.getColumnValue(row, 0);
                if (fillRatio >= 0.0 && fillRatio < 0.21) {
                    int retainedCol = 4;
                    long size = Math.abs((Long)refinedTable.getColumnValue(row, retainedCol));
                    if (size <= threshold) break;
                    int numberOfObjects = (Integer)refinedTable.getColumnValue(row, 1);
                    String retainedSize = refinedTable.getFormattedColumnValue(row, retainedCol);
                    if (comment.length() == 0) {
                        comment.append(HTMLUtils.escapeText((String)Messages.ComponentReportQuery_DetectedTheFollowingArraysWithLowFillRatios)).append("<ul title=\"").append(this.escapeHTMLAttribute(Messages.ComponentReportQuery_DetectedTheFollowingArraysWithLowFillRatios)).append("\">");
                    }
                    comment.append("<li>");
                    comment.append(MessageUtil.format((String)Messages.ComponentReportQuery_Msg_InstancesRetainBytes, (Object[])new Object[]{numberOfObjects, HTMLUtils.escapeText((String)clazz.getName()), HTMLUtils.escapeText((String)retainedSize)}));
                    comment.append("</li>");
                    warn = true;
                    break;
                }
                ++rowId;
            }
            QuerySpec spec = new QuerySpec(clazz.getName());
            spec.setResult((IResult)refinedTable);
            this.addCommand(spec, "array_fill_ratio", record.getObjectIds(), clazz);
            detailsSpec.add((Spec)spec);
            if (!warn) continue;
            spec.set("html.is_important", Boolean.TRUE.toString());
        }
        listener.tick();
        if (detailsSpec.getChildren().isEmpty()) {
            return;
        }
        boolean bl = warn2 = comment.length() != 0;
        if (!warn2) {
            comment.append(Messages.ComponentReportQuery_NoArraysWithLowFillRatios);
        } else {
            comment.append("</ul>");
            overview.setStatus(ITestResult.Status.WARNING);
        }
        QuerySpec commentSpec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(comment.toString(), true));
        commentSpec.set("rendering.pattern", "overview_details");
        if (warn2) {
            commentSpec.set("html.is_important", Boolean.TRUE.toString());
        }
        overview.add((Spec)commentSpec);
        overview.add((Spec)detailsSpec);
        componentReport.add((Spec)overview);
    }

    private void addHashMapsCollisionRatios(SectionSpec componentReport, long totalSize, Histogram histogram, Ticks listener) throws Exception {
        boolean warn2;
        if (!this.aggressive) {
            InspectionAssert.heapFormatIsNot(this.snapshot, "DTFJ-PHD");
        }
        SectionSpec overview = new SectionSpec(Messages.ComponentReportQuery_MapCollisionRatios);
        StringBuilder comment = new StringBuilder();
        SectionSpec detailsSpec = new SectionSpec(Messages.ComponentReportQuery_Details);
        detailsSpec.set("html.collapsed", Boolean.TRUE.toString());
        for (ClassHistogramRecord record : this.sorted(histogram.getClassHistogramRecords())) {
            if (listener.isCanceled()) break;
            IClass clazz = (IClass)this.snapshot.getObject(record.getClassId());
            ICollectionExtractor extractor = CollectionExtractionUtils.findCollectionExtractor(clazz.getName());
            if (extractor == null || !(extractor instanceof IMapExtractor) || !((IMapExtractor)extractor).hasCollisionRatio()) continue;
            int[] objectIds = record.getObjectIds();
            if (objectIds.length > 20000) {
                int[] copy = new int[20000];
                System.arraycopy(objectIds, 0, copy, 0, copy.length);
                objectIds = copy;
            }
            RefinedResultBuilder builder = SnapshotQuery.lookup("map_collision_ratio", this.snapshot).setArgument("objects", objectIds).refine(listener);
            builder.setInlineRetainedSizeCalculation(true);
            RefinedTable refinedTable = (RefinedTable)builder.build();
            boolean warn = false;
            int count = refinedTable.getRowCount();
            int rowId = 0;
            while (rowId < count) {
                Object row = refinedTable.getRow(rowId);
                double collisionRato = (Double)refinedTable.getColumnValue(row, 0);
                if (collisionRato > 0.8) {
                    int numberOfObjects = (Integer)refinedTable.getColumnValue(row, 1);
                    String retainedSize = refinedTable.getFormattedColumnValue(row, 3);
                    if (comment.length() == 0) {
                        comment.append(HTMLUtils.escapeText((String)Messages.ComponentReportQuery_Msg_DetectedCollisionRatios)).append("<ul title=\"").append(this.escapeHTMLAttribute(Messages.ComponentReportQuery_Msg_DetectedCollisionRatios)).append("\">");
                    }
                    comment.append("<li>");
                    comment.append(MessageUtil.format((String)Messages.ComponentReportQuery_Msg_InstancesRetainBytes, (Object[])new Object[]{numberOfObjects, HTMLUtils.escapeText((String)clazz.getName()), HTMLUtils.escapeText((String)retainedSize)}));
                    comment.append("</li>");
                    warn = true;
                    break;
                }
                ++rowId;
            }
            QuerySpec spec = new QuerySpec(clazz.getName());
            if (warn) {
                spec.set("html.is_important", Boolean.TRUE.toString());
            }
            spec.setResult((IResult)refinedTable);
            this.addCommand(spec, "map_collision_ratio", record.getObjectIds(), clazz);
            detailsSpec.add((Spec)spec);
        }
        listener.tick();
        if (detailsSpec.getChildren().isEmpty()) {
            return;
        }
        boolean bl = warn2 = comment.length() != 0;
        if (!warn2) {
            comment.append(Messages.ComponentReportQuery_Msg_NoCollisionRatiosFound);
        } else {
            comment.append("</ul>");
            overview.setStatus(ITestResult.Status.WARNING);
        }
        QuerySpec commentSpec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(comment.toString(), true));
        commentSpec.set("rendering.pattern", "overview_details");
        if (warn2) {
            commentSpec.set("html.is_important", Boolean.TRUE.toString());
        }
        overview.add((Spec)commentSpec);
        overview.add((Spec)detailsSpec);
        componentReport.add((Spec)overview);
    }

    private void addReferenceStatistic(SectionSpec componentReport, Histogram histogram, Ticks ticks, String className, ReferenceMessages messages) throws SnapshotException {
        Object object;
        Collection<IClass> classes = this.snapshot.getClassesByName(className, true);
        if (classes == null || classes.isEmpty()) {
            this.addEmptyResult(componentReport, messages.ReferenceStatistics, messages.Msg_NoReferencesFound);
            return;
        }
        SetInt softRefClassIds = new SetInt(classes.size());
        for (IClass c : classes) {
            softRefClassIds.add(c.getObjectId());
        }
        ArrayList<ClassHistogramRecord> softRefs = new ArrayList<ClassHistogramRecord>();
        long numObjects = 0L;
        long heapSize = 0L;
        ArrayInt instanceSet = new ArrayInt();
        SetInt referentSet = new SetInt();
        block7: for (ClassHistogramRecord record : this.sorted(histogram.getClassHistogramRecords())) {
            if (ticks.isCanceled()) break;
            if (!softRefClassIds.contains(record.getClassId())) continue;
            softRefs.add(record);
            numObjects += record.getNumberOfObjects();
            heapSize += record.getUsedHeapSize();
            instanceSet.addAll(record.getObjectIds());
            object = record.getObjectIds();
            int n = ((int[])object).length;
            int n2 = 0;
            while (n2 < n) {
                int objectId = object[n2];
                IInstance obj = (IInstance)this.snapshot.getObject(objectId);
                try {
                    ObjectReference ref = ReferenceQuery.getReferent(obj);
                    if (ref != null) {
                        referentSet.add(ref.getObjectId());
                    }
                }
                catch (SnapshotException ref) {
                    // empty catch block
                }
                if (ticks.isCanceled()) continue block7;
                ++n2;
            }
        }
        ticks.tick();
        if (instanceSet.isEmpty()) {
            this.addEmptyResult(componentReport, messages.ReferenceStatistics, messages.NoAliveReferences);
            return;
        }
        Histogram softRefHistogram = new Histogram(messages.HistogramOfReferences, softRefs, null, numObjects, heapSize, 0L);
        CompositeResult referents = ReferenceQuery.execute(instanceSet, referentSet, this.snapshot, messages.ReferenceStatQuery_Label_Referenced, messages.ReferenceStatQuery_Label_Retained, messages.ReferenceStatQuery_Label_StronglyRetainedReferents, "referent", ticks);
        StringBuilder comment = new StringBuilder();
        comment.append(MessageUtil.format((String)messages.Msg_ReferencesFound, (Object[])new Object[]{instanceSet.size(), referentSet.size()})).append(HTML_BREAK);
        Histogram onlySoftlyReachable = (Histogram)((CompositeResult.Entry)referents.getResultEntries().get(1)).getResult();
        numObjects = 0L;
        heapSize = 0L;
        object = onlySoftlyReachable.getClassHistogramRecords().iterator();
        while (object.hasNext()) {
            ClassHistogramRecord r = (ClassHistogramRecord)object.next();
            numObjects += r.getNumberOfObjects();
            heapSize += r.getUsedHeapSize();
        }
        comment.append(MessageUtil.format((String)messages.Msg_ReferencesRetained, (Object[])new Object[]{numObjects, Units.Storage.of((long)heapSize).format(heapSize)})).append(HTML_BREAK);
        Histogram stronglyReachableReferents = (Histogram)((CompositeResult.Entry)referents.getResultEntries().get(2)).getResult();
        numObjects = 0L;
        heapSize = 0L;
        for (ClassHistogramRecord r : stronglyReachableReferents.getClassHistogramRecords()) {
            numObjects += r.getNumberOfObjects();
            heapSize += r.getUsedHeapSize();
        }
        if (numObjects >= 1L) {
            comment.append("<strong>").append(MessageUtil.format((String)Messages.ComponentReportQuery_PossibleMemoryLeak, (Object[])new Object[0])).append("</strong> ");
        }
        comment.append(MessageUtil.format((String)messages.Msg_ReferencesStronglyRetained, (Object[])new Object[]{numObjects, Units.Storage.of((long)heapSize).format(heapSize)}));
        SectionSpec overview = new SectionSpec(messages.ReferenceStatistics);
        QuerySpec commentSpec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(comment.toString(), true));
        commentSpec.set("rendering.pattern", "overview_details");
        overview.add((Spec)commentSpec);
        QuerySpec child = new QuerySpec(softRefHistogram.getLabel(), (IResult)softRefHistogram);
        child.set("derived_data_column", "_default_=" + RetainedSizeDerivedData.APPROXIMATE.getCode());
        overview.add((Spec)child);
        for (CompositeResult.Entry entry : referents.getResultEntries()) {
            child = new QuerySpec(entry.getName(), entry.getResult());
            overview.add((Spec)child);
        }
        if (numObjects >= 1L) {
            int maxsuspectspertype = 1000;
            int maxpaths = 10;
            double factor = 0.6;
            for (ClassHistogramRecord cr : stronglyReachableReferents.getClassHistogramRecords()) {
                IResult result;
                SetInt referents1 = new SetInt();
                int[] nArray = cr.getObjectIds();
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int r = nArray[n3];
                    referents1.add(r);
                    ++n3;
                }
                ArrayInt ai = new ArrayInt();
                for (int objectId : instanceSet) {
                    block25: {
                        IInstance obj = (IInstance)this.snapshot.getObject(objectId);
                        ObjectReference ref = ReferenceQuery.getReferent(obj);
                        if (ref != null) {
                            try {
                                if (!referents1.contains(ref.getObjectId())) break block25;
                                ai.add(obj.getObjectId());
                            }
                            catch (SnapshotException e) {
                                continue;
                            }
                        }
                    }
                    if (ticks.isCanceled()) break;
                }
                if ((result = SnapshotQuery.lookup("reference_leak", this.snapshot).setArgument("objects", ai.toArray()).setArgument("maxpaths", maxpaths).setArgument("maxobjs", maxsuspectspertype).setArgument("factor", factor).execute(ticks)) instanceof CompositeResult) {
                    CompositeResult cr1 = (CompositeResult)result;
                    List entries = cr1.getResultEntries();
                    if (entries.size() != 1 || !(((CompositeResult.Entry)entries.get(0)).getResult() instanceof TextResult)) {
                        overview.setStatus(ITestResult.Status.WARNING);
                        commentSpec.set("html.is_important", Boolean.TRUE.toString());
                        QuerySpec child1 = new QuerySpec(MessageUtil.format((String)Messages.ComponentReportQuery_ExampleLeakDetails, (Object[])new Object[]{cr.getLabel()}), (IResult)cr1);
                        child1.set("html.collapsed", Boolean.TRUE.toString());
                        if (ai.size() <= 30) {
                            try {
                                StringBuilder sb = new StringBuilder("reference_leak");
                                sb.append(" -maxpaths ").append(maxpaths);
                                sb.append(" -maxobjs ").append(maxsuspectspertype);
                                sb.append(" -factor ").append(factor);
                                int[] nArray2 = ai.toArray();
                                int n4 = nArray2.length;
                                int n5 = 0;
                                while (n5 < n4) {
                                    int i = nArray2[n5];
                                    sb.append(" 0x").append(Long.toHexString(this.snapshot.mapIdToAddress(i)));
                                    ++n5;
                                }
                                child1.setCommand(sb.toString());
                            }
                            catch (SnapshotException sb) {
                                // empty catch block
                            }
                        }
                        overview.add((Spec)child1);
                        continue;
                    }
                    IResult tr = ((CompositeResult.Entry)entries.get(0)).getResult();
                    QuerySpec child1 = new QuerySpec(MessageUtil.format((String)Messages.ComponentReportQuery_ReferentResult, (Object[])new Object[]{cr.getLabel()}), tr);
                    child1.set("html.collapsed", Boolean.TRUE.toString());
                    overview.add((Spec)child1);
                    continue;
                }
                QuerySpec child1 = new QuerySpec(MessageUtil.format((String)Messages.ComponentReportQuery_ReferentResult, (Object[])new Object[]{cr.getLabel()}), result);
                child1.set("html.collapsed", Boolean.TRUE.toString());
                overview.add((Spec)child1);
            }
        }
        componentReport.add((Spec)overview);
    }

    private void addFinalizerStatistic(SectionSpec componentReport, int[] retained, Ticks ticks) throws SnapshotException {
        IInstance obj;
        int objectId;
        int n;
        int n2;
        int[] nArray;
        boolean foundSomeFinalizers = false;
        Collection<IClass> classes = this.snapshot.getClassesByName("java.lang.ref.Finalizer", true);
        if (classes == null) {
            classes = Collections.emptyList();
        }
        boolean useBits = retained.length > Math.max(100000, this.snapshot.getSnapshotInfo().getNumberOfObjects() / 53);
        SetInt retainedSet = null;
        BitField retainedIds = null;
        if (useBits) {
            retainedIds = new BitField(this.snapshot.getSnapshotInfo().getNumberOfObjects());
        } else {
            retainedSet = new SetInt(Math.max((retained.length + 2) / 3 * 4, retained.length));
        }
        int ii = 0;
        while (ii < retained.length) {
            if (useBits) {
                retainedIds.set(retained[ii]);
            } else {
                retainedSet.add(retained[ii]);
            }
            ++ii;
        }
        SetInt finalizers = new SetInt();
        block1: for (IClass c : classes) {
            nArray = c.getObjectIds();
            n2 = nArray.length;
            n = 0;
            while (n < n2) {
                objectId = nArray[n];
                if (ticks.isCanceled()) continue block1;
                obj = (IInstance)this.snapshot.getObject(objectId);
                foundSomeFinalizers = true;
                ObjectReference ref = ReferenceQuery.getReferent(obj);
                if (ref != null) {
                    int referentId = ref.getObjectId();
                    if (useBits ? retainedIds.get(referentId) : retainedSet.contains(referentId)) {
                        finalizers.add(referentId);
                    }
                }
                ++n;
            }
        }
        if (!foundSomeFinalizers && (classes = this.snapshot.getClassesByName("java.lang.Runtime", false)) != null) {
            block3: for (IClass c : classes) {
                nArray = c.getObjectIds();
                n2 = nArray.length;
                n = 0;
                while (n < n2) {
                    objectId = nArray[n];
                    if (ticks.isCanceled()) continue block3;
                    obj = (IInstance)this.snapshot.getObject(objectId);
                    for (NamedReference nr : obj.getOutboundReferences()) {
                        if (!(nr instanceof ThreadToLocalReference)) continue;
                        ThreadToLocalReference pr = (ThreadToLocalReference)nr;
                        GCRootInfo[] gCRootInfoArray = pr.getGcRootInfo();
                        int n3 = gCRootInfoArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            GCRootInfo rootInfo = gCRootInfoArray[n4];
                            if (rootInfo.getType() == 1024) {
                                foundSomeFinalizers = true;
                                int referentId = rootInfo.getObjectId();
                                if (useBits ? retainedIds.get(referentId) : retainedSet.contains(referentId)) {
                                    finalizers.add(referentId);
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n;
                }
            }
        }
        int[] nArray2 = this.snapshot.getGCRoots();
        objectId = nArray2.length;
        int n5 = 0;
        while (n5 < objectId) {
            GCRootInfo[] ifo;
            int root = nArray2[n5];
            GCRootInfo[] gCRootInfoArray = ifo = this.snapshot.getGCRootInfo(root);
            int n6 = ifo.length;
            int n7 = 0;
            while (n7 < n6) {
                GCRootInfo rootInfo = gCRootInfoArray[n7];
                if (rootInfo.getType() == 1024 || rootInfo.getType() == 512) {
                    foundSomeFinalizers = true;
                    int referentId = rootInfo.getObjectId();
                    if (!(useBits ? retainedIds.get(referentId) : retainedSet.contains(referentId))) break;
                    finalizers.add(referentId);
                    break;
                }
                ++n7;
            }
            ++n5;
        }
        if (!foundSomeFinalizers) {
            this.addEmptyResult(componentReport, Messages.ComponentReportQuery_FinalizerStatistics, Messages.ComponentReportQuery_Msg_NoFinalizerObjects);
            return;
        }
        if (finalizers.isEmpty()) {
            this.addEmptyResult(componentReport, Messages.ComponentReportQuery_FinalizerStatistics, Messages.ComponentReportQuery_Msg_NoFinalizerFound);
            return;
        }
        SectionSpec overview = new SectionSpec(Messages.ComponentReportQuery_FinalizerStatistics);
        StringBuilder comment = new StringBuilder();
        comment.append(MessageUtil.format((String)Messages.ComponentReportQuery_Msg_TotalFinalizerMethods, (Object[])new Object[]{finalizers.size()}));
        QuerySpec commentSpec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(comment.toString(), true));
        commentSpec.set("rendering.pattern", "overview_details");
        overview.add((Spec)commentSpec);
        Histogram histogram = this.snapshot.getHistogram(finalizers.toArray(), ticks);
        if (ticks.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        histogram.setLabel(Messages.ComponentReportQuery_HistogramFinalizeMethod);
        overview.add((Spec)new QuerySpec(histogram.getLabel(), (IResult)histogram));
        componentReport.add((Spec)overview);
    }

    private void addEmptyResult(SectionSpec report, String sectionLabel, String message) {
        SectionSpec section = new SectionSpec(sectionLabel);
        QuerySpec commentSpec = new QuerySpec(Messages.ComponentReportQuery_Comment, (IResult)new TextResult(message, true));
        commentSpec.set("rendering.pattern", "overview_details");
        section.add((Spec)commentSpec);
        report.add((Spec)section);
    }

    private static abstract class ReferenceMessages {
        public String ReferenceStatistics;
        public String Msg_NoReferencesFound;
        public String NoAliveReferences;
        public String HistogramOfReferences;
        public String ReferenceStatQuery_Label_Referenced;
        public String ReferenceStatQuery_Label_Retained;
        public String ReferenceStatQuery_Label_StronglyRetainedReferents;
        public String Msg_ReferencesFound;
        public String Msg_ReferencesRetained;
        public String Msg_ReferencesStronglyRetained;

        private ReferenceMessages() {
        }
    }

    private static class SoftReferenceMessages
    extends ReferenceMessages {
        private SoftReferenceMessages() {
            this.ReferenceStatistics = Messages.ComponentReportQuery_SoftReferenceStatistics;
            this.Msg_NoReferencesFound = Messages.ComponentReportQuery_Msg_NoSoftReferencesFound;
            this.NoAliveReferences = Messages.ComponentReportQuery_Msg_NoAliveSoftReferences;
            this.HistogramOfReferences = Messages.ComponentReportQuery_HistogramOfSoftReferences;
            this.ReferenceStatQuery_Label_Referenced = Messages.SoftReferenceStatQuery_Label_Referenced;
            this.ReferenceStatQuery_Label_Retained = Messages.SoftReferenceStatQuery_Label_Retained;
            this.ReferenceStatQuery_Label_StronglyRetainedReferents = Messages.SoftReferenceStatQuery_Label_StronglyRetainedReferents;
            this.Msg_ReferencesFound = Messages.ComponentReportQuery_Msg_SoftReferencesFound;
            this.Msg_ReferencesRetained = Messages.ComponentReportQuery_Msg_SoftReferencesRetained;
            this.Msg_ReferencesStronglyRetained = Messages.ComponentReportQuery_Msg_SoftReferencesStronglyRetained;
        }
    }

    private static class Ticks
    implements IProgressListener {
        IProgressListener delegate;

        public Ticks(IProgressListener delegate, String task, int totalTicks) {
            this.delegate = delegate;
            this.delegate.beginTask(task, totalTicks);
        }

        public void tick() {
            this.delegate.worked(1);
        }

        public void beginTask(String name, int totalWork) {
            this.delegate.subTask(name);
        }

        public void subTask(String name) {
            this.delegate.subTask(name);
        }

        public void done() {
        }

        public boolean isCanceled() {
            return this.delegate.isCanceled();
        }

        public void sendUserMessage(IProgressListener.Severity severity, String message, Throwable exception) {
            this.delegate.sendUserMessage(severity, message, exception);
        }

        public void setCanceled(boolean value) {
            this.delegate.setCanceled(true);
        }

        public void worked(int work) {
        }
    }

    private static class WeakReferenceMessages
    extends ReferenceMessages {
        private WeakReferenceMessages() {
            this.ReferenceStatistics = Messages.ComponentReportQuery_WeakReferenceStatistics;
            this.Msg_NoReferencesFound = Messages.ComponentReportQuery_Msg_NoWeakReferencesFound;
            this.NoAliveReferences = Messages.ComponentReportQuery_Msg_NoAliveWeakReferences;
            this.HistogramOfReferences = Messages.ComponentReportQuery_HistogramOfWeakReferences;
            this.ReferenceStatQuery_Label_Referenced = Messages.WeakReferenceStatQuery_Label_Referenced;
            this.ReferenceStatQuery_Label_Retained = Messages.WeakReferenceStatQuery_Label_Retained;
            this.ReferenceStatQuery_Label_StronglyRetainedReferents = Messages.WeakReferenceStatQuery_Label_StronglyRetainedReferents;
            this.Msg_ReferencesFound = Messages.ComponentReportQuery_Msg_WeakReferencesFound;
            this.Msg_ReferencesRetained = Messages.ComponentReportQuery_Msg_WeakReferencesRetained;
            this.Msg_ReferencesStronglyRetained = Messages.ComponentReportQuery_Msg_WeakReferencesStronglyRetained;
        }
    }
}

