/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.internal.collectionextract.TreeMapCollectionExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.ObjectReference;

public class TreeMapArrayCollectionExtractor
extends TreeMapCollectionExtractor {
    public TreeMapArrayCollectionExtractor(String sizeField, String keyField, String valueField) {
        super(sizeField, keyField, valueField);
    }

    @Override
    public Iterator<Map.Entry<IObject, IObject>> extractMapEntries(IObject coll) {
        return new MapArrayEntryIterator(coll.getSnapshot(), coll, super.extractMapEntries(coll));
    }

    private class MapArrayEntryIterator
    implements Iterator<Map.Entry<IObject, IObject>> {
        ISnapshot snapshot;
        private IObject coll;
        Iterator<Map.Entry<IObject, IObject>> it;
        IObjectArray keys;
        IObjectArray values;
        int i = 0;
        int len = 0;
        IMapExtractor.EntryObject saved = null;

        MapArrayEntryIterator(ISnapshot snapshot, IObject coll, Iterator<Map.Entry<IObject, IObject>> it) {
            this.it = it;
            this.snapshot = snapshot;
            this.coll = coll;
        }

        @Override
        public boolean hasNext() {
            if (this.saved != null) {
                return true;
            }
            this.saved = this.getNext(true);
            return this.saved != null;
        }

        @Override
        public Map.Entry<IObject, IObject> next() {
            IMapExtractor.EntryObject ret = this.saved;
            if (ret != null) {
                this.saved = null;
                return ret;
            }
            ret = this.getNext(false);
            return ret;
        }

        private IMapExtractor.EntryObject getNext(boolean test) {
            IMapExtractor.EntryObject ret = null;
            while (true) {
                if (this.i < this.len) {
                    try {
                        long keyAddress = this.keys.getReferenceArray(this.i, 1)[0];
                        long valueAddress = this.values.getReferenceArray(this.i, 1)[0];
                        ++this.i;
                        if (keyAddress == 0L || valueAddress == 0L) continue;
                        ObjectReference keyRef = new ObjectReference(this.snapshot, keyAddress);
                        ObjectReference valueRef = new ObjectReference(this.snapshot, valueAddress);
                        ret = new IMapExtractor.EntryObject(this.coll, keyRef.getObject(), valueRef.getObject());
                        return ret;
                    }
                    catch (SnapshotException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (test && !this.it.hasNext()) {
                    return null;
                }
                Map.Entry<IObject, IObject> e = this.it.next();
                this.keys = (IObjectArray)e.getKey();
                this.values = (IObjectArray)e.getValue();
                this.len = this.keys.getLength();
                this.i = 0;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

