/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.index;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.ArrayIntCompressed;
import org.eclipse.mat.collect.ArrayLong;
import org.eclipse.mat.collect.ArrayLongBig;
import org.eclipse.mat.collect.ArrayLongCompressed;
import org.eclipse.mat.collect.ArrayUtils;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.HashMapIntLong;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.collect.IteratorLong;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexReader;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.snapshot.RetainedSizeCache;
import org.eclipse.mat.parser.io.BitInputStream;
import org.eclipse.mat.parser.io.BitOutputStream;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

public abstract class IndexWriter {
    public static final int PAGE_SIZE_INT = 1000000;
    public static final int PAGE_SIZE_LONG = 500000;
    private static final boolean TEST = false;
    private static final int TESTSCALE = 0;
    private static final int FORMAT1_MAX_SIZE = Integer.MAX_VALUE;
    private static final long MAX_OLD_HEADER_VALUE = 0xFFFFFFFFL;
    private static final long INBOUND_MAX_KEY1 = Integer.MAX_VALUE;
    private static final Logger logger = Logger.getLogger(RetainedSizeCache.class.getName());

    public static long[] copyOf(long[] original, int newLength) {
        long[] copy = Arrays.copyOf(original, newLength);
        return copy;
    }

    private static int newCapacity(int oldCapacity, int minCapacity) {
        int newCapacity = oldCapacity * 3 >>> 1;
        if (newCapacity < minCapacity && (newCapacity = minCapacity * 3 >>> 1) < minCapacity) {
            newCapacity = 0x7FFFFFF7;
        }
        return newCapacity;
    }

    public static int mostSignificantBit(int x) {
        int length = 0;
        if ((x & 0xFFFF0000) != 0) {
            length += 16;
            x >>= 16;
        }
        if ((x & 0xFF00) != 0) {
            length += 8;
            x >>= 8;
        }
        if ((x & 0xF0) != 0) {
            length += 4;
            x >>= 4;
        }
        if ((x & 0xC) != 0) {
            length += 2;
            x >>= 2;
        }
        if ((x & 2) != 0) {
            ++length;
            x >>= 1;
        }
        if ((x & 1) != 0) {
            ++length;
        }
        return length - 1;
    }

    public static int mostSignificantBit(long x) {
        long lead = x >>> 32;
        return lead == 0L ? IndexWriter.mostSignificantBit((int)x) : 32 + IndexWriter.mostSignificantBit((int)lead);
    }

    static ExecutorService singleThreadedExecutor(String name) {
        boolean poolSize = true;
        boolean timeoutSeconds = true;
        RejectedExecutionHandler blockingSubmitToQueue = (r, executor) -> {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException("thread interrupted while waiting to submit", e);
            }
        };
        return new ThreadPoolExecutor(1, 1, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> new Thread(r, name), blockingSubmitToQueue);
    }

    static class ArrayIntLongCompressed
    extends ArrayIntCompressed {
        final ArrayLongCompressed base;

        ArrayIntLongCompressed(ArrayLongCompressed b) {
            super(b.toByteArray());
            this.base = b;
        }

        ArrayIntLongCompressed(ArrayIntCompressed b) {
            super(b.toByteArray());
            this.base = new ArrayLongCompressed(b.toByteArray());
        }

        long getPos(int offset) {
            return this.base.get(offset);
        }
    }

    public static class Identifier
    implements IIndexReader.IOne2LongIndex {
        long[] identifiers;
        int size;
        ArrayLongBig collect;

        public void add(long id) {
            int s;
            long minCapacity;
            int newCapacity;
            if (this.collect == null) {
                this.collect = new ArrayLongBig();
            }
            if ((long)(newCapacity = Math.min((int)(minCapacity = (long)(this.size + (s = this.collect.length()) + 1)), 0x7FFFFFF7)) < minCapacity) {
                throw new OutOfMemoryError(MessageUtil.format((String)Messages.IndexWriter_Error_ArrayLength, (Object[])new Object[]{minCapacity, newCapacity}));
            }
            this.collect.add(id);
        }

        public void sort() {
            if (this.collect != null) {
                if (this.identifiers == null) {
                    this.size = this.collect.length();
                    this.identifiers = this.collect.toArray();
                    this.collect = null;
                } else {
                    int s = this.collect.length();
                    long minCapacity = this.size + s;
                    int newCapacity = Math.min((int)minCapacity, 0x7FFFFFF7);
                    if ((long)newCapacity < minCapacity) {
                        throw new OutOfMemoryError(MessageUtil.format((String)Messages.IndexWriter_Error_ArrayLength, (Object[])new Object[]{minCapacity, newCapacity}));
                    }
                    this.identifiers = IndexWriter.copyOf(this.identifiers, newCapacity);
                    int i = 0;
                    while (i < s) {
                        this.identifiers[this.size + i] = this.collect.get(i);
                        ++i;
                    }
                    this.size += s;
                    this.collect = null;
                }
            }
            Arrays.parallelSort(this.identifiers, 0, this.size);
        }

        @Override
        public int size() {
            return this.size + (this.collect != null ? this.collect.length() : 0);
        }

        @Override
        public long get(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
            }
            return index < this.size || this.collect == null ? this.identifiers[index] : this.collect.get(index - this.size);
        }

        @Override
        public int reverse(long val) {
            int a = 0;
            int c = this.size();
            while (a < c) {
                int b = a + c >>> 1;
                long probeVal = this.get(b);
                if (val < probeVal) {
                    c = b;
                    continue;
                }
                if (probeVal < val) {
                    a = b + 1;
                    continue;
                }
                return b;
            }
            return -1 - a;
        }

        public IteratorLong iterator() {
            return new IteratorLong(){
                int index = 0;

                public boolean hasNext() {
                    return this.index < this.size();
                }

                public long next() {
                    return this.get(this.index++);
                }
            };
        }

        @Override
        public long[] getNext(int index, int length) {
            long[] answer = new long[length];
            int ii = 0;
            while (ii < length) {
                answer[ii] = this.get(index + ii);
                ++ii;
            }
            return answer;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void delete() {
            this.identifiers = null;
            this.collect = null;
        }

        @Override
        public void unload() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static class InboundWriter {
        int size;
        File indexFile;
        int[] header;
        byte[] header2;
        int bitLength;
        int pageSize;
        BitOutputStream[] segments;
        long[] segmentSizes;

        public InboundWriter(int size, File indexFile) throws IOException {
            this.size = size;
            this.indexFile = indexFile;
            int requiredSegments = size / 500000 + 1;
            int segments = 1;
            while (segments < requiredSegments) {
                segments <<= 1;
            }
            this.bitLength = IndexWriter.mostSignificantBit(size) + 1;
            this.pageSize = size / segments + 1;
            this.segments = new BitOutputStream[segments];
            this.segmentSizes = new long[segments];
        }

        public void log(int objectIndex, int refIndex, boolean isPseudo) throws IOException {
            int segment = objectIndex / this.pageSize;
            if (this.segments[segment] == null) {
                File segmentFile = new File(String.valueOf(this.indexFile.getAbsolutePath()) + segment + ".log");
                this.segments[segment] = new BitOutputStream(new FileOutputStream(segmentFile));
            }
            this.segments[segment].writeBit(isPseudo ? 1 : 0);
            this.segments[segment].writeInt(objectIndex, this.bitLength);
            this.segments[segment].writeInt(refIndex, this.bitLength);
            int n = segment;
            this.segmentSizes[n] = this.segmentSizes[n] + 1L;
        }

        void setHeader(int index, long val) {
            this.header[index] = (int)val;
            byte hi = (byte)(val >> 32);
            if ((hi != 0 || val > 0xFFFFFFFFL) && this.header2 == null) {
                this.header2 = new byte[this.header.length];
            }
            if (this.header2 != null) {
                this.header2[index] = hi;
            }
        }

        private long getHeader(int index) {
            return (this.header2 != null ? ((long)this.header2[index] & 0xFFL) << 32 : 0L) | (long)this.header[index] & 0xFFFFFFFFL;
        }

        public IIndexReader.IOne2ManyObjectsIndex flush(IProgressListener monitor, KeyWriter keyWriter) throws IOException {
            this.close();
            this.header = new int[this.size];
            DataOutputStream index = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.indexFile), 262144));
            IntIndexStreamer body = new IntIndexStreamer();
            body.openStream(index, 0L);
            boolean bodyopen = true;
            try {
                int segment = 0;
                while (segment < this.segments.length) {
                    if (monitor.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    File segmentFile = new File(String.valueOf(this.indexFile.getAbsolutePath()) + segment + ".log");
                    int startIndex = segment * this.pageSize;
                    this.processGiantSegmentFile(monitor, keyWriter, body, segmentFile, this.segmentSizes[segment], segment, startIndex);
                    ++segment;
                }
                long divider = body.closeStream();
                bodyopen = false;
                IIndexReader.IOne2OneIndex headerIndex = null;
                headerIndex = this.header2 != null ? new PosIndexStreamer().writeTo2(index, divider, new IteratorLong(){
                    int i;

                    public boolean hasNext() {
                        return this.i < header.length;
                    }

                    public long next() {
                        long ret = this.getHeader(this.i++);
                        return ret;
                    }
                }) : new IntIndexStreamer().writeTo(index, divider, this.header);
                index.writeLong(divider);
                index.flush();
                index.close();
                index = null;
                IndexReader.InboundReader inboundReader = new IndexReader.InboundReader(this.indexFile, headerIndex, body.getReader(null));
                return inboundReader;
            }
            finally {
                this.header = null;
                this.header2 = null;
                try {
                    if (index != null) {
                        index.close();
                    }
                    if (bodyopen) {
                        body.closeStream();
                    }
                }
                catch (IOException iOException) {}
                if (monitor.isCanceled()) {
                    this.cancel();
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private void processGiantSegmentFile(IProgressListener monitor, KeyWriter keyWriter, IntIndexStreamer body, File segmentFile, long segmentSize, int segment, int startIndex) throws IOException {
            SUBSIZE = 8000000;
            if (!segmentFile.exists()) {
                return;
            }
            if (segmentSize < 8000000L) {
                this.processSegmentFile(monitor, keyWriter, body, segmentFile, (int)segmentSize, segment);
                return;
            }
            segmentIn = new BitInputStream(new FileInputStream(segmentFile));
            try {
                counts = new int[this.pageSize];
                ii = 0L;
                while (ii < segmentSize) {
                    segmentIn.readBit();
                    objIndex = segmentIn.readInt(this.bitLength);
                    segmentIn.readInt(this.bitLength);
                    v0 = objIndex - startIndex;
                    counts[v0] = counts[v0] + 1;
                    ++ii;
                }
            }
            finally {
                segmentIn.close();
            }
            if (monitor.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            subsegment = new int[this.pageSize];
            subsegSize = 8000000;
            subsegs = -1;
            jj = 0;
            while (jj < counts.length) {
                if (counts[jj] > 0 && (long)subsegSize + (long)counts[jj] > 8000000L) {
                    subsegSize = 0;
                }
                subsegSize += counts[jj];
                subsegment[jj] = ++subsegs;
                ++jj;
            }
            if (++subsegs <= 1) {
                this.processSegmentFile(monitor, keyWriter, body, segmentFile, (int)segmentSize, segment);
                return;
            }
            subsegments = new BitOutputStream[subsegs];
            subsegmentSizes = new int[subsegs];
            try {
                try {
                    ss = 0;
                    while (ss < subsegs) {
                        subsegmentFile = new File(String.valueOf(this.indexFile.getAbsolutePath()) + segment + "." + ss + ".log");
                        subsegments[ss] = new BitOutputStream(new FileOutputStream(subsegmentFile));
                        ++ss;
                    }
                    segmentIn = new BitInputStream(new FileInputStream(segmentFile));
                    try {
                        ii = 0L;
                        while (ii < segmentSize) {
                            if (ii % 1000L == 0L && monitor.isCanceled()) {
                                throw new IProgressListener.OperationCanceledException();
                            }
                            isPseudo = segmentIn.readBit() == 1;
                            objectIndex = segmentIn.readInt(this.bitLength);
                            refIndex = segmentIn.readInt(this.bitLength);
                            subseg = subsegment[objectIndex - startIndex];
                            subsegments[subseg].writeBit(isPseudo != false ? 1 : 0);
                            subsegments[subseg].writeInt(objectIndex, this.bitLength);
                            subsegments[subseg].writeInt(refIndex, this.bitLength);
                            v1 = subseg;
                            subsegmentSizes[v1] = subsegmentSizes[v1] + 1;
                            ++ii;
                        }
                    }
                    catch (Throwable var23_27) {
                        segmentIn.close();
                        throw var23_27;
                    }
                    segmentIn.close();
                }
                finally {
                    ss = 0;
                    ** while (ss < subsegs)
                }
lbl-1000:
                // 1 sources

                {
                    if (subsegments[ss] != null) {
                        subsegments[ss].close();
                    }
                    ++ss;
                    continue;
                }
lbl85:
                // 1 sources

                if (!segmentFile.delete()) {
                    IndexWriter.access$1().log(Level.WARNING, Messages.SnapshotFactoryImpl_UnableToDeleteIndexFile, segmentFile.toString());
                }
                segmentFile = null;
                ss = 0;
                while (ss < subsegs) {
                    subsegmentFile = new File(String.valueOf(this.indexFile.getAbsolutePath()) + segment + "." + ss + ".log");
                    this.processSegmentFile(monitor, keyWriter, body, subsegmentFile, subsegmentSizes[ss], segment);
                    ++ss;
                }
            }
            finally {
                ss = 0;
                ** while (ss < subsegs)
            }
lbl-1000:
            // 1 sources

            {
                subsegmentFile = new File(String.valueOf(this.indexFile.getAbsolutePath()) + segment + "." + ss + ".log");
                if (subsegmentFile.exists() && !subsegmentFile.delete()) {
                    IndexWriter.access$1().log(Level.WARNING, Messages.SnapshotFactoryImpl_UnableToDeleteIndexFile, subsegmentFile.toString());
                }
                ++ss;
                continue;
            }
lbl103:
            // 1 sources

        }

        private void processSegmentFile(IProgressListener monitor, KeyWriter keyWriter, IntIndexStreamer body, File segmentFile, int segmentSize, int segment) throws IOException {
            int[] refIndex;
            int[] objIndex;
            if (!segmentFile.exists()) {
                return;
            }
            BitInputStream segmentIn = new BitInputStream(new FileInputStream(segmentFile));
            try {
                objIndex = new int[segmentSize];
                refIndex = new int[segmentSize];
                int ii = 0;
                while (ii < segmentSize) {
                    boolean isPseudo = segmentIn.readBit() == 1;
                    objIndex[ii] = segmentIn.readInt(this.bitLength);
                    refIndex[ii] = segmentIn.readInt(this.bitLength);
                    if (isPseudo) {
                        refIndex[ii] = -1 - refIndex[ii];
                    }
                    ++ii;
                }
            }
            finally {
                segmentIn.close();
                segmentIn = null;
            }
            if (monitor.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            if (!segmentFile.delete()) {
                logger.log(Level.WARNING, Messages.SnapshotFactoryImpl_UnableToDeleteIndexFile, segmentFile.toString());
            }
            segmentFile = null;
            this.processSegment(monitor, keyWriter, body, objIndex, refIndex);
        }

        private void processSegment(IProgressListener monitor, KeyWriter keyWriter, IntIndexStreamer body, int[] objIndex, int[] refIndex) throws IOException {
            ArrayUtils.sort((int[])objIndex, (int[])refIndex);
            int start = 0;
            int previous = -1;
            int ii = 0;
            while (ii <= objIndex.length) {
                if (ii == 0) {
                    start = ii;
                    previous = objIndex[ii];
                } else if (ii == objIndex.length || previous != objIndex[ii]) {
                    if (monitor.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    this.setHeader(previous, body.size + 1L);
                    this.processObject(keyWriter, body, previous, refIndex, start, ii);
                    if (ii < objIndex.length) {
                        previous = objIndex[ii];
                        start = ii;
                    }
                }
                ++ii;
            }
        }

        private void processObject(KeyWriter keyWriter, IntIndexStreamer body, int objectId, int[] refIndex, int fromIndex, int toIndex) throws IOException {
            BitField duplicates;
            Arrays.sort(refIndex, fromIndex, toIndex);
            int endPseudo = fromIndex;
            int pseudos = 0;
            if (toIndex - fromIndex > 100000) {
                duplicates = new BitField(this.size);
                int jj = fromIndex;
                while (jj < toIndex) {
                    if (refIndex[jj] >= 0) break;
                    ++endPseudo;
                    refIndex[jj] = -refIndex[jj] - 1;
                    ++jj;
                }
                jj = endPseudo - 1;
                while (jj >= fromIndex) {
                    if (!duplicates.get(refIndex[jj])) {
                        body.add(refIndex[jj]);
                        duplicates.set(refIndex[jj]);
                        ++pseudos;
                    }
                    --jj;
                }
                jj = endPseudo;
                while (jj < toIndex) {
                    if (!(jj != fromIndex && refIndex[jj - 1] == refIndex[jj] || duplicates.get(refIndex[jj]))) {
                        body.add(refIndex[jj]);
                    }
                    ++jj;
                }
            } else {
                duplicates = new SetInt(toIndex - fromIndex);
                int jj = fromIndex;
                while (jj < toIndex) {
                    if (refIndex[jj] >= 0) break;
                    ++endPseudo;
                    refIndex[jj] = -refIndex[jj] - 1;
                    ++jj;
                }
                jj = endPseudo - 1;
                while (jj >= fromIndex) {
                    if (duplicates.add(refIndex[jj])) {
                        body.add(refIndex[jj]);
                        ++pseudos;
                    }
                    --jj;
                }
                jj = endPseudo;
                while (jj < toIndex) {
                    if (!(jj != fromIndex && refIndex[jj - 1] == refIndex[jj] || duplicates.contains(refIndex[jj]))) {
                        body.add(refIndex[jj]);
                    }
                    ++jj;
                }
            }
            if (endPseudo > fromIndex) {
                long h = this.getHeader(objectId);
                if (h > Integer.MAX_VALUE) {
                    keyWriter.storeKey(objectId, (Serializable)new long[]{h - 1L, pseudos});
                } else {
                    keyWriter.storeKey(objectId, (Serializable)new int[]{this.header[objectId] - 1, pseudos});
                }
            }
        }

        public synchronized void cancel() {
            try {
                try {
                    this.close();
                    if (this.segments != null) {
                        int ii = 0;
                        while (ii < this.segments.length) {
                            File file = new File(String.valueOf(this.indexFile.getAbsolutePath()) + ii + ".log");
                            if (!file.delete()) {
                                logger.log(Level.WARNING, Messages.SnapshotFactoryImpl_UnableToDeleteIndexFile, file.toString());
                            }
                            ++ii;
                        }
                    }
                }
                catch (IOException iOException) {
                    if (!this.indexFile.delete()) {
                        logger.log(Level.WARNING, Messages.SnapshotFactoryImpl_UnableToDeleteIndexFile, this.indexFile.toString());
                    }
                }
            }
            finally {
                if (!this.indexFile.delete()) {
                    logger.log(Level.WARNING, Messages.SnapshotFactoryImpl_UnableToDeleteIndexFile, this.indexFile.toString());
                }
            }
        }

        public synchronized void close() throws IOException {
            if (this.segments != null) {
                int ii = 0;
                while (ii < this.segments.length) {
                    if (this.segments[ii] != null) {
                        this.segments[ii].flush();
                        this.segments[ii].close();
                        this.segments[ii] = null;
                    }
                    ++ii;
                }
            }
        }

        public File getIndexFile() {
            return this.indexFile;
        }
    }

    public static class IntArray1NSortedWriter
    extends IntArray1NWriter {
        public IntArray1NSortedWriter(int size, File indexFile) throws IOException {
            super(size, indexFile);
        }

        @Override
        protected void set(int index, int[] values, int offset, int length) throws IOException {
            long bodyPos = this.body.size + 1L;
            this.setHeader(index, bodyPos);
            this.body.addAll(values, offset, length);
        }

        @Override
        protected IIndexReader.IOne2ManyIndex createReader(IIndexReader.IOne2OneIndex headerIndex, IIndexReader.IOne2OneIndex bodyIndex) throws IOException {
            return new IndexReader.IntIndex1NSortedReader(this.indexFile, headerIndex, bodyIndex);
        }
    }

    public static class IntArray1NUncompressedCollector {
        int[][] elements;
        File indexFile;

        public IntArray1NUncompressedCollector(int size, File indexFile) throws IOException {
            this.elements = new int[size][];
            this.indexFile = indexFile;
        }

        public void log(int classId, int methodId) {
            if (this.elements[classId] == null) {
                this.elements[classId] = new int[]{methodId};
            } else {
                int[] newChildren = new int[this.elements[classId].length + 1];
                System.arraycopy(this.elements[classId], 0, newChildren, 0, this.elements[classId].length);
                newChildren[this.elements[classId].length] = methodId;
                this.elements[classId] = newChildren;
            }
        }

        public File getIndexFile() {
            return this.indexFile;
        }

        public IIndexReader.IOne2ManyIndex flush() throws IOException {
            IntArray1NSortedWriter writer = new IntArray1NSortedWriter(this.elements.length, this.indexFile);
            int ii = 0;
            while (ii < this.elements.length) {
                if (this.elements[ii] != null) {
                    writer.log(ii, this.elements[ii]);
                }
                ++ii;
            }
            return writer.flush();
        }
    }

    public static class IntArray1NWriter {
        private static final int TASK_BUFFER_SIZE = 1024;
        private static final int TASK_BUFFER_MAX_OBJECTS = 10000;
        private static final int TASK_BUFFER_MAX_MEMORY = 20000;
        int[] header;
        byte[] header2;
        File indexFile;
        DataOutputStream out;
        IntIndexStreamer body;
        CopyOnWriteArrayList<ArrayListSetTask> allTasks = new CopyOnWriteArrayList();
        ThreadLocal<ArrayListSetTask> threadTaskQueue = ThreadLocal.withInitial(new Supplier<ArrayListSetTask>(){

            @Override
            public ArrayListSetTask get() {
                ArrayListSetTask newList = new ArrayListSetTask(1024);
                allTasks.add(newList);
                return newList;
            }
        });

        public IntArray1NWriter(int size, File indexFile) throws IOException {
            this.header = new int[size];
            this.header2 = new byte[size];
            this.indexFile = indexFile;
            this.out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.body = new IntIndexStreamer();
            this.body.openStream(this.out, 0L);
        }

        public void log(Identifier identifier, int index, ArrayLong references) throws IOException {
            this.log((IIndexReader.IOne2LongIndex)identifier, index, references);
        }

        public void log(IIndexReader.IOne2LongIndex identifier, int index, ArrayLong references) throws IOException {
            long pseudo = references.firstElement();
            references.sort();
            int[] objectIds = new int[references.size()];
            int length = 1;
            long current = 0L;
            long last = references.firstElement() - 1L;
            int ii = 0;
            while (ii < objectIds.length) {
                int objectId;
                current = references.get(ii);
                if (last != current && (objectId = identifier.reverse(current)) >= 0) {
                    int jj = current == pseudo ? 0 : length++;
                    objectIds[jj] = objectId;
                }
                last = current;
                ++ii;
            }
            this.set(index, objectIds, 0, length);
        }

        public void log(int index, ArrayInt references) throws IOException {
            this.set(index, references.toArray(), 0, references.size());
        }

        public void log(int index, int[] values) throws IOException {
            this.set(index, values, 0, values.length);
        }

        void setHeader(int index, long val) {
            this.header[index] = (int)val;
            this.header2[index] = (byte)(val >> 32);
        }

        private long getHeader(int index) {
            return ((long)this.header2[index] & 0xFFL) << 32 | (long)this.header[index] & 0xFFFFFFFFL;
        }

        protected void set(int index, int[] values, int offset, int length) throws IOException {
            ArrayListSetTask tasks = this.threadTaskQueue.get();
            tasks.add(new SetTask(index, values, offset, length));
            long memsize = tasks.memcount;
            long objcount = tasks.objcount;
            if (tasks.size() >= 1024 || memsize > 10000L || objcount > 20000L) {
                this.publishTasks(tasks);
                tasks.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void publishTasks(ArrayListSetTask tasks) throws IOException {
            IntIndexStreamer intIndexStreamer = this.body;
            synchronized (intIndexStreamer) {
                for (SetTask t : tasks) {
                    long bodyPos = this.body.addAllWithLengthFirst(t.values, t.offset, t.length);
                    this.setHeader(t.index, bodyPos);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IIndexReader.IOne2ManyIndex flush() throws IOException {
            IntIndexStreamer intIndexStreamer = this.body;
            synchronized (intIndexStreamer) {
                for (ArrayListSetTask list : this.allTasks) {
                    this.publishTasks(list);
                    list.clear();
                }
            }
            long divider = this.body.closeStream();
            IIndexReader.IOne2OneIndex headerIndex = null;
            boolean usesHeader2 = false;
            int i = 0;
            while (i < this.header2.length) {
                if (this.header2[i] != 0) {
                    usesHeader2 = true;
                    break;
                }
                ++i;
            }
            headerIndex = usesHeader2 ? new PosIndexStreamer().writeTo2(this.out, divider, new IteratorLong(){
                int i;

                public boolean hasNext() {
                    return this.i < header.length;
                }

                public long next() {
                    long ret = this.getHeader(this.i++);
                    return ret;
                }
            }) : new IntIndexStreamer().writeTo(this.out, divider, this.header);
            this.out.writeLong(divider);
            this.out.close();
            this.out = null;
            return this.createReader(headerIndex, this.body.getReader(null));
        }

        protected IIndexReader.IOne2ManyIndex createReader(IIndexReader.IOne2OneIndex headerIndex, IIndexReader.IOne2OneIndex bodyIndex) throws IOException {
            return new IndexReader.IntIndex1NReader(this.indexFile, headerIndex, bodyIndex);
        }

        public void cancel() {
            try {
                try {
                    if (this.out != null) {
                        this.out.close();
                        if (this.body != null) {
                            this.body.closeStream();
                        }
                        this.body = null;
                        this.out = null;
                    }
                }
                catch (IOException iOException) {
                    if (this.indexFile.exists() && !this.indexFile.delete()) {
                        logger.log(Level.WARNING, Messages.SnapshotFactoryImpl_UnableToDeleteIndexFile, this.indexFile.toString());
                    }
                }
            }
            finally {
                if (this.indexFile.exists() && !this.indexFile.delete()) {
                    logger.log(Level.WARNING, Messages.SnapshotFactoryImpl_UnableToDeleteIndexFile, this.indexFile.toString());
                }
            }
        }

        public File getIndexFile() {
            return this.indexFile;
        }

        private static class ArrayListSetTask
        extends ArrayList<SetTask> {
            private static final long serialVersionUID = 1L;
            long objcount;
            long memcount;

            public ArrayListSetTask(int n) {
                super(n);
            }

            @Override
            public boolean add(SetTask t) {
                this.objcount += (long)t.length;
                this.memcount += (long)t.values.length;
                return super.add(t);
            }

            @Override
            public void clear() {
                this.objcount = 0L;
                this.memcount = 0L;
                super.clear();
            }
        }

        private static class SetTask {
            final int index;
            final int[] values;
            final int offset;
            final int length;

            public SetTask(int index, int[] values, int offset, int length) {
                this.index = index;
                this.values = values;
                this.offset = offset;
                this.length = length;
            }
        }
    }

    static abstract class IntIndex<V> {
        int pageSize;
        long size;
        Pages<V> pages;

        protected IntIndex() {
        }

        protected IntIndex(int size) {
            this.init(size, 1000000);
        }

        protected void init(int size, int pageSize) {
            this.size = size;
            this.pageSize = pageSize;
            this.pages = new Pages(size / pageSize + 1);
        }

        void init(long size, int pageSize) {
            this.size = size;
            this.pageSize = pageSize;
            this.pages = new Pages((int)(size / (long)pageSize) + 1);
        }

        public int get(int index) {
            return this.get0(index);
        }

        int get(long index) {
            if (index == (long)((int)index)) {
                return this.get((int)index);
            }
            return this.get0(index);
        }

        private int get0(long index) {
            int page = this.page(index);
            int pageIndex = this.offset(index);
            ArrayIntCompressed array = this.getPage(page);
            return array.get(pageIndex);
        }

        long getPos(int index) {
            return (long)this.get(index) & 0xFFFFFFFFL;
        }

        private int page(int index) {
            return index / this.pageSize;
        }

        private int offset(int index) {
            return index % this.pageSize;
        }

        int page(long index) {
            return (int)(index / (long)this.pageSize);
        }

        int offset(long index) {
            return (int)(index % (long)this.pageSize);
        }

        public int[] getNext(int index, int length) {
            return this.getNext0(index, length);
        }

        int[] getNext(long index, int length) {
            if (index == (long)((int)index)) {
                return this.getNext((int)index, length);
            }
            return this.getNext0(index, length);
        }

        private int[] getNext0(long index, int length) {
            int[] answer = new int[length];
            if (length == 0) {
                return answer;
            }
            int page = this.page(index);
            int pageIndex = this.offset(index);
            ArrayIntCompressed array = this.getPage(page);
            int ii = 0;
            while (ii < length) {
                answer[ii] = array.get(pageIndex++);
                if (pageIndex >= this.pageSize && ii + 1 < length) {
                    array = this.getPage(++page);
                    pageIndex = 0;
                }
                ++ii;
            }
            return answer;
        }

        public int[] getAll(int[] index) {
            int[] answer = new int[index.length];
            int page = -1;
            ArrayIntCompressed array = null;
            int ii = 0;
            while (ii < answer.length) {
                int p = this.page(index[ii]);
                if (p != page) {
                    page = p;
                    array = this.getPage(page);
                }
                answer[ii] = array.get(this.offset(index[ii]));
                ++ii;
            }
            return answer;
        }

        public void set(int index, int value) {
            ArrayIntCompressed array = this.getPage(this.page(index));
            array.set(this.offset(index), value);
        }

        protected abstract ArrayIntCompressed getPage(int var1);

        public synchronized void unload() {
            this.pages = new Pages(this.page(this.size) + 1);
        }

        public int size() {
            if (this.size > Integer.MAX_VALUE) {
                throw new IllegalStateException();
            }
            return (int)Math.min(Integer.MAX_VALUE, this.size);
        }

        public IteratorInt iterator() {
            return new IntIndexIterator(this);
        }
    }

    public static class IntIndexCollector
    extends IntIndex<ArrayIntCompressed>
    implements IIndexReader.IOne2OneIndex {
        final int mostSignificantBit;
        final int size;
        final int pageSize = 1000000;
        final ConcurrentHashMap<Integer, ArrayIntCompressed> pages = new ConcurrentHashMap();

        public IntIndexCollector(int size, int mostSignificantBit) {
            this.size = size;
            this.mostSignificantBit = mostSignificantBit;
        }

        @Override
        protected ArrayIntCompressed getPage(int page) {
            ArrayIntCompressed existing = this.pages.get(page);
            if (existing != null) {
                return existing;
            }
            int ps = page < this.size / 1000000 ? 1000000 : this.size % 1000000;
            ArrayIntCompressed newArray = new ArrayIntCompressed(ps, 31 - this.mostSignificantBit, 0);
            existing = this.pages.putIfAbsent(page, newArray);
            return existing != null ? existing : newArray;
        }

        public IIndexReader.IOne2OneIndex writeTo(File indexFile) throws IOException {
            return new IntIndexStreamer().writeTo(indexFile, new IteratorInt(){
                int index = 0;

                public boolean hasNext() {
                    return this.index < size;
                }

                public int next() {
                    return this.get(this.index++);
                }
            });
        }

        public IIndexReader.IOne2OneIndex writeTo(DataOutputStream out, long position) throws IOException {
            return new IntIndexStreamer().writeTo(out, position, new IteratorInt(){
                int index = 0;

                public boolean hasNext() {
                    return this.index < size;
                }

                public int next() {
                    return this.get(this.index++);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(int index, int value) {
            ArrayIntCompressed array;
            ArrayIntCompressed arrayIntCompressed = array = this.getPage(index / 1000000);
            synchronized (arrayIntCompressed) {
                array.set(index % 1000000, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int get(int index) {
            ArrayIntCompressed array;
            ArrayIntCompressed arrayIntCompressed = array = this.getPage(index / 1000000);
            synchronized (arrayIntCompressed) {
                return array.get(index % 1000000);
            }
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void delete() {
            this.pages.clear();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public void unload() {
            throw new UnsupportedOperationException(Messages.IndexWriter_NotImplemented);
        }

        @Override
        public int[] getAll(int[] index) {
            throw new UnsupportedOperationException(Messages.IndexWriter_NotImplemented);
        }

        @Override
        public int[] getNext(int index, int length) {
            throw new UnsupportedOperationException(Messages.IndexWriter_NotImplemented);
        }
    }

    public static class IntIndexCollectorUncompressed {
        int[] dataElements;

        public IntIndexCollectorUncompressed(int size) {
            this.dataElements = new int[size];
        }

        public void set(int index, int value) {
            this.dataElements[index] = value;
        }

        public int get(int index) {
            return this.dataElements[index];
        }

        public IIndexReader.IOne2OneIndex writeTo(File indexFile) throws IOException {
            return new IntIndexStreamer().writeTo(indexFile, this.dataElements);
        }
    }

    static class IntIndexIterator
    implements IteratorInt {
        IntIndex<?> intArray;
        long nextIndex = 0L;

        public IntIndexIterator(IntIndex<?> intArray) {
            this.intArray = intArray;
        }

        public int next() {
            return this.intArray.get(this.nextIndex++);
        }

        public boolean hasNext() {
            return this.nextIndex < this.intArray.size;
        }
    }

    public static class IntIndexStreamer
    extends IntIndex<SoftReference<ArrayIntCompressed>> {
        DataOutputStream out;
        ArrayLong pageStart;
        int[] page;
        int left;
        int pagesAdded;
        Exception storedException = null;
        OutOfMemoryError storedError = null;
        final ExecutorService compressor = IndexWriter.singleThreadedExecutor("IntIndexStreamer-Compressor");
        final ExecutorService writer = IndexWriter.singleThreadedExecutor("IntIndexStreamer-Writer");

        public IIndexReader.IOne2OneIndex writeTo(File indexFile, IteratorInt iterator) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.openStream(out, 0L);
            this.addAll(iterator);
            this.closeStream();
            out.close();
            return this.getReader(indexFile);
        }

        public IIndexReader.IOne2OneIndex writeTo(File indexFile, int[] array) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.openStream(out, 0L);
            this.addAll(array);
            this.closeStream();
            out.close();
            return this.getReader(indexFile);
        }

        public IIndexReader.IOne2OneIndex writeTo(DataOutputStream out, long position, IteratorInt iterator) throws IOException {
            this.openStream(out, position);
            this.addAll(iterator);
            this.closeStream();
            return this.getReader(null);
        }

        public IIndexReader.IOne2OneIndex writeTo(DataOutputStream out, long position, int[] array) throws IOException {
            this.openStream(out, position);
            this.addAll(array);
            this.closeStream();
            return this.getReader(null);
        }

        void openStream(DataOutputStream out, long position) {
            this.out = out;
            this.init(0, 1000000);
            this.page = new int[this.pageSize];
            this.pageStart = new ArrayLong();
            this.pageStart.add(position);
            this.left = this.page.length;
        }

        long closeStream() throws IOException {
            try {
                if (this.left < this.page.length) {
                    this.addPage();
                } else {
                    new WriterTask(null);
                }
            }
            catch (IOException e) {
                try {
                    this.compressor.shutdownNow();
                    this.compressor.awaitTermination(100L, TimeUnit.SECONDS);
                    this.writer.shutdownNow();
                    this.writer.awaitTermination(100L, TimeUnit.SECONDS);
                    throw e;
                }
                catch (InterruptedException ie) {
                    throw new IOException(ie);
                }
            }
            try {
                this.compressor.shutdown();
                this.compressor.awaitTermination(100L, TimeUnit.SECONDS);
                this.writer.shutdown();
                this.writer.awaitTermination(100L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
            int jj = 0;
            while (jj < this.pageStart.size()) {
                this.out.writeLong(this.pageStart.get(jj));
                ++jj;
            }
            this.out.writeInt(this.pageSize);
            int s = this.size <= Integer.MAX_VALUE ? (int)this.size : -((int)((this.size + (long)this.pageSize - 1L) % (long)this.pageSize + 1L));
            this.out.writeInt(s);
            this.page = null;
            this.out = null;
            return this.pageStart.lastElement() + 8L * (long)this.pageStart.size() + 8L - this.pageStart.firstElement();
        }

        IndexReader.IntIndexReader getReader(File indexFile) {
            return new IndexReader.IntIndexReader(indexFile, (Pages<SoftReference<ArrayIntCompressed>>)this.pages, this.size, this.pageSize, this.pageStart.toArray());
        }

        void addAll(IteratorInt iterator) throws IOException {
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }

        void add(int value) throws IOException {
            if (this.left == 0) {
                this.addPage();
            }
            this.page[this.page.length - this.left--] = value;
            ++this.size;
        }

        void addAll(int[] values) throws IOException {
            this.addAll(values, 0, values.length);
        }

        void addAll(int[] values, int offset, int length) throws IOException {
            while (length > 0) {
                if (this.left == 0) {
                    this.addPage();
                }
                int chunk = Math.min(this.left, length);
                System.arraycopy(values, offset, this.page, this.page.length - this.left, chunk);
                this.left -= chunk;
                this.size += (long)chunk;
                length -= chunk;
                offset += chunk;
            }
        }

        long addAllWithLengthFirst(int[] values, int offset, int length) throws IOException {
            long startPos = this.size;
            this.add(length);
            this.addAll(values, offset, length);
            return startPos;
        }

        private void addPage() throws IOException {
            Future<byte[]> compressionResult = this.compressor.submit(new CompressionTask(this.page, this.left, this.pagesAdded));
            this.writer.execute(new WriterTask(compressionResult));
            ++this.pagesAdded;
            this.page = new int[this.page.length];
            this.left = this.page.length;
        }

        @Override
        protected ArrayIntCompressed getPage(int page) {
            throw new UnsupportedOperationException();
        }

        private class CompressionTask
        implements Callable<byte[]> {
            final int[] page;
            final int left;
            final int pageNumber;

            public CompressionTask(int[] page, int left, int pageNumber) {
                this.page = page;
                this.left = left;
                this.pageNumber = pageNumber;
            }

            @Override
            public byte[] call() {
                ArrayIntCompressed array = new ArrayIntCompressed(this.page, 0, this.page.length - this.left);
                IntIndexStreamer.this.pages.put(this.pageNumber, new SoftReference<ArrayIntCompressed>(array));
                return array.toByteArray();
            }
        }

        private class WriterTask
        implements Runnable {
            final Future<byte[]> byteData;

            public WriterTask(Future<byte[]> byteData) throws IOException {
                this.byteData = byteData;
                if (IntIndexStreamer.this.storedException != null) {
                    throw new IOException(Messages.IndexWriter_StoredException, IntIndexStreamer.this.storedException);
                }
                if (IntIndexStreamer.this.storedError != null) {
                    throw new IOException(Messages.IndexWriter_StoredError, IntIndexStreamer.this.storedError);
                }
            }

            @Override
            public void run() {
                try {
                    byte[] buffer = this.byteData.get();
                    IntIndexStreamer.this.out.write(buffer);
                    int written = buffer.length;
                    IntIndexStreamer.this.pageStart.add(IntIndexStreamer.this.pageStart.lastElement() + (long)written);
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    IntIndexStreamer.this.storedException = e;
                }
                catch (OutOfMemoryError e) {
                    IntIndexStreamer.this.storedError = e;
                }
            }
        }
    }

    public static interface KeyWriter {
        public void storeKey(int var1, Serializable var2);
    }

    public static class LongArray1NWriter {
        int[] header;
        File indexFile;
        DataOutputStream out;
        LongIndexStreamer body;

        public LongArray1NWriter(int size, File indexFile) throws IOException {
            this.header = new int[size];
            this.indexFile = indexFile;
            this.out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.body = new LongIndexStreamer();
            this.body.openStream(this.out, 0L);
        }

        public void log(int index, long[] values) throws IOException {
            this.set(index, values, 0, values.length);
        }

        protected void set(int index, long[] values, int offset, int length) throws IOException {
            this.header[index] = this.body.size() + 1;
            this.body.add(length);
            this.body.addAll(values, offset, length);
        }

        public void flush() throws IOException {
            long divider = this.body.closeStream();
            new IntIndexStreamer().writeTo(this.out, divider, this.header).close();
            this.out.writeLong(divider);
            this.out.close();
            this.out = null;
        }

        public void cancel() {
            try {
                try {
                    if (this.out != null) {
                        this.out.close();
                        if (this.body != null) {
                            this.body.closeStream();
                        }
                        this.body = null;
                        this.out = null;
                    }
                }
                catch (IOException iOException) {
                    if (this.indexFile.exists() && !this.indexFile.delete()) {
                        logger.log(Level.WARNING, Messages.SnapshotFactoryImpl_UnableToDeleteIndexFile, this.indexFile.toString());
                    }
                }
            }
            finally {
                if (this.indexFile.exists() && !this.indexFile.delete()) {
                    logger.log(Level.WARNING, Messages.SnapshotFactoryImpl_UnableToDeleteIndexFile, this.indexFile.toString());
                }
            }
        }

        public File getIndexFile() {
            return this.indexFile;
        }
    }

    static abstract class LongIndex {
        private static final int DEPTH = 10;
        int pageSize;
        int size;
        HashMapIntObject<Object> pages;
        HashMapIntLong binarySearchCache = new HashMapIntLong(1024);

        protected LongIndex() {
        }

        protected LongIndex(int size) {
            this.init(size, 500000);
        }

        protected void init(int size, int pageSize) {
            this.size = size;
            this.pageSize = pageSize;
            this.pages = new HashMapIntObject(size / pageSize + 1);
        }

        public long get(int index) {
            ArrayLongCompressed array = this.getPage(index / this.pageSize);
            return array.get(index % this.pageSize);
        }

        public long[] getNext(int index, int length) {
            long[] answer = new long[length];
            int page = index / this.pageSize;
            int pageIndex = index % this.pageSize;
            ArrayLongCompressed array = this.getPage(page);
            int ii = 0;
            while (ii < length) {
                answer[ii] = array.get(pageIndex++);
                if (pageIndex >= this.pageSize && ii + 1 < length) {
                    array = this.getPage(++page);
                    pageIndex = 0;
                }
                ++ii;
            }
            return answer;
        }

        public int reverse(long value) {
            int low = 0;
            int high = this.size - 1;
            int depth = 0;
            int page = -1;
            ArrayLongCompressed array = null;
            while (low <= high) {
                long midVal;
                int mid = low + high >>> 1;
                if (depth++ < 10) {
                    try {
                        midVal = this.binarySearchCache.get(mid);
                    }
                    catch (NoSuchElementException e) {
                        int p = mid / this.pageSize;
                        if (p != page) {
                            page = p;
                            array = this.getPage(page);
                        }
                        midVal = array.get(mid % this.pageSize);
                        this.binarySearchCache.put(mid, midVal);
                    }
                } else {
                    int p = mid / this.pageSize;
                    if (p != page) {
                        page = p;
                        array = this.getPage(page);
                    }
                    midVal = array.get(mid % this.pageSize);
                }
                if (midVal < value) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > value) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        public void set(int index, long value) {
            ArrayLongCompressed array = this.getPage(index / this.pageSize);
            array.set(index % this.pageSize, value);
        }

        protected abstract ArrayLongCompressed getPage(int var1);

        public synchronized void unload() {
            this.pages = new HashMapIntObject(this.size / this.pageSize + 1);
            this.binarySearchCache = new HashMapIntLong(1024);
        }

        public int size() {
            return this.size;
        }

        public IteratorLong iterator() {
            return new LongIndexIterator(this);
        }
    }

    public static class LongIndexCollector
    extends LongIndex {
        final int mostSignificantBit;
        final int size;
        final int pageSize = 500000;
        final ConcurrentHashMap<Integer, ArrayLongCompressed> pages = new ConcurrentHashMap();

        public LongIndexCollector(int size, int mostSignificantBit) {
            ((LongIndex)this).size = size;
            ((LongIndex)this).pageSize = 500000;
            this.size = size;
            this.mostSignificantBit = mostSignificantBit;
        }

        @Override
        protected ArrayLongCompressed getPage(int page) {
            ArrayLongCompressed existing = this.pages.get(page);
            if (existing != null) {
                return existing;
            }
            int ps = page < this.size / 500000 ? 500000 : this.size % 500000;
            ArrayLongCompressed newArray = new ArrayLongCompressed(ps, 63 - this.mostSignificantBit, 0);
            existing = this.pages.putIfAbsent(page, newArray);
            return existing != null ? existing : newArray;
        }

        public IIndexReader.IOne2LongIndex writeTo(File indexFile) throws IOException {
            HashMapIntObject output = new HashMapIntObject(this.pages.size());
            for (Map.Entry<Integer, ArrayLongCompressed> entry : this.pages.entrySet()) {
                output.put(entry.getKey().intValue(), (Object)entry.getValue());
            }
            return new LongIndexStreamer().writeTo(indexFile, this.size, (HashMapIntObject<Object>)output, 500000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(int index, long value) {
            ArrayLongCompressed array;
            ArrayLongCompressed arrayLongCompressed = array = this.getPage(index / 500000);
            synchronized (arrayLongCompressed) {
                array.set(index % 500000, value);
            }
        }
    }

    public static class LongIndexCollectorUncompressed {
        long[] dataElements;

        public LongIndexCollectorUncompressed(int size) {
            this.dataElements = new long[size];
        }

        public void set(int index, long value) {
            this.dataElements[index] = value;
        }

        public long get(int index) {
            return this.dataElements[index];
        }

        public IIndexReader.IOne2LongIndex writeTo(File indexFile) throws IOException {
            return new LongIndexStreamer().writeTo(indexFile, this.dataElements);
        }
    }

    static class LongIndexIterator
    implements IteratorLong {
        LongIndex longArray;
        int nextIndex = 0;

        public LongIndexIterator(LongIndex longArray) {
            this.longArray = longArray;
        }

        public long next() {
            return this.longArray.get(this.nextIndex++);
        }

        public boolean hasNext() {
            return this.nextIndex < this.longArray.size();
        }
    }

    public static class LongIndexStreamer
    extends LongIndex {
        DataOutputStream out;
        ArrayLong pageStart;
        long[] page;
        int left;
        int pagesAdded;
        Exception storedException = null;
        OutOfMemoryError storedError = null;
        final ExecutorService compressor = IndexWriter.singleThreadedExecutor("LongIndexStreamer-Compressor");
        final ExecutorService writer = IndexWriter.singleThreadedExecutor("LongIndexStreamer-Writer");

        public LongIndexStreamer() {
        }

        public LongIndexStreamer(File indexFile) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.openStream(out, 0L);
        }

        public void close() throws IOException {
            DataOutputStream out = this.out;
            this.closeStream();
            out.close();
        }

        public IIndexReader.IOne2LongIndex writeTo(File indexFile, int size, HashMapIntObject<Object> pages, int pageSize) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.openStream(out, 0L);
            int noOfPages = size / pageSize + (size % pageSize > 0 ? 1 : 0);
            int ii = 0;
            while (ii < noOfPages) {
                int len;
                ArrayLongCompressed a = (ArrayLongCompressed)pages.get(ii);
                int n = len = ii + 1 < noOfPages ? pageSize : size % pageSize;
                if (a == null) {
                    this.addAll(new long[len]);
                } else {
                    int jj = 0;
                    while (jj < len) {
                        this.add(a.get(jj));
                        ++jj;
                    }
                }
                ++ii;
            }
            this.closeStream();
            out.close();
            return this.getReader(indexFile);
        }

        public IIndexReader.IOne2LongIndex writeTo(File indexFile, long[] array) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.openStream(out, 0L);
            this.addAll(array);
            this.closeStream();
            out.close();
            return this.getReader(indexFile);
        }

        public IIndexReader.IOne2LongIndex writeTo(File indexFile, IteratorLong iterator) throws IOException {
            FileOutputStream fos = new FileOutputStream(indexFile);
            try {
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fos));
                this.openStream(out, 0L);
                this.addAll(iterator);
                this.closeStream();
                out.flush();
                IndexReader.LongIndexReader longIndexReader = this.getReader(indexFile);
                return longIndexReader;
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }

        public IIndexReader.IOne2LongIndex writeTo(File indexFile, ArrayLong array) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.openStream(out, 0L);
            this.addAll(array);
            this.closeStream();
            out.close();
            return this.getReader(indexFile);
        }

        IIndexReader.IOne2LongIndex writeTo(DataOutputStream out, long position, IteratorLong iterator) throws IOException {
            this.openStream(out, position);
            this.addAll(iterator);
            this.closeStream();
            return this.getReader(null);
        }

        void openStream(DataOutputStream out, long position) {
            this.out = out;
            this.init(0, 500000);
            this.page = new long[this.pageSize];
            this.pageStart = new ArrayLong();
            this.pageStart.add(position);
            this.left = this.page.length;
        }

        long closeStream() throws IOException {
            try {
                if (this.left < this.page.length) {
                    this.addPage();
                } else {
                    new WriterTask(null);
                }
            }
            catch (IOException e) {
                try {
                    this.compressor.shutdownNow();
                    this.compressor.awaitTermination(100L, TimeUnit.SECONDS);
                    this.writer.shutdownNow();
                    this.writer.awaitTermination(100L, TimeUnit.SECONDS);
                    throw e;
                }
                catch (InterruptedException ie) {
                    throw new IOException(ie);
                }
            }
            try {
                this.compressor.shutdown();
                this.compressor.awaitTermination(100L, TimeUnit.SECONDS);
                this.writer.shutdown();
                this.writer.awaitTermination(100L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                throw new IOException(ie);
            }
            int jj = 0;
            while (jj < this.pageStart.size()) {
                this.out.writeLong(this.pageStart.get(jj));
                ++jj;
            }
            this.out.writeInt(this.pageSize);
            this.out.writeInt(this.size);
            this.page = null;
            this.out = null;
            return this.pageStart.lastElement() + 8L * (long)this.pageStart.size() + 8L - this.pageStart.firstElement();
        }

        IndexReader.LongIndexReader getReader(File indexFile) throws IOException {
            return new IndexReader.LongIndexReader(indexFile, (HashMapIntObject<Object>)this.pages, this.size, this.pageSize, this.pageStart.toArray());
        }

        public void addAll(IteratorLong iterator) throws IOException {
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }

        public void addAll(ArrayLong array) throws IOException {
            IteratorLong e = array.iterator();
            while (e.hasNext()) {
                this.add(e.next());
            }
        }

        public void add(long value) throws IOException {
            if (this.left == 0) {
                this.addPage();
            }
            this.page[this.page.length - this.left--] = value;
            ++this.size;
        }

        public void addAll(long[] values) throws IOException {
            this.addAll(values, 0, values.length);
        }

        public void addAll(long[] values, int offset, int length) throws IOException {
            while (length > 0) {
                if (this.left == 0) {
                    this.addPage();
                }
                int chunk = Math.min(this.left, length);
                System.arraycopy(values, offset, this.page, this.page.length - this.left, chunk);
                this.left -= chunk;
                this.size += chunk;
                length -= chunk;
                offset += chunk;
            }
        }

        private void addPage() throws IOException {
            Future<byte[]> compressionResult = this.compressor.submit(new CompressionTask(this.page, this.left, this.pagesAdded));
            this.writer.execute(new WriterTask(compressionResult));
            ++this.pagesAdded;
            this.page = new long[this.page.length];
            this.left = this.page.length;
        }

        @Override
        protected ArrayLongCompressed getPage(int page) {
            throw new UnsupportedOperationException();
        }

        private class CompressionTask
        implements Callable<byte[]> {
            final long[] page;
            final int left;
            final int pageNumber;

            public CompressionTask(long[] page, int left, int pageNumber) {
                this.page = page;
                this.left = left;
                this.pageNumber = pageNumber;
            }

            @Override
            public byte[] call() {
                ArrayLongCompressed array = new ArrayLongCompressed(this.page, 0, this.page.length - this.left);
                LongIndexStreamer.this.pages.put(this.pageNumber, new SoftReference<ArrayLongCompressed>(array));
                return array.toByteArray();
            }
        }

        private class WriterTask
        implements Runnable {
            final Future<byte[]> byteData;

            public WriterTask(Future<byte[]> byteData) throws IOException {
                this.byteData = byteData;
                if (LongIndexStreamer.this.storedException != null) {
                    throw new IOException(Messages.IndexWriter_StoredException, LongIndexStreamer.this.storedException);
                }
                if (LongIndexStreamer.this.storedError != null) {
                    throw new IOException(Messages.IndexWriter_StoredError, LongIndexStreamer.this.storedError);
                }
            }

            @Override
            public void run() {
                try {
                    byte[] buffer = this.byteData.get();
                    LongIndexStreamer.this.out.write(buffer);
                    int written = buffer.length;
                    LongIndexStreamer.this.pageStart.add(LongIndexStreamer.this.pageStart.lastElement() + (long)written);
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    LongIndexStreamer.this.storedException = e;
                }
                catch (OutOfMemoryError e) {
                    LongIndexStreamer.this.storedError = e;
                }
            }
        }
    }

    static class Pages<V> {
        int size;
        Object[] elements;

        public Pages(int initialSize) {
            this.elements = new Object[initialSize];
            this.size = 0;
        }

        private void ensureCapacity(int minCapacity) {
            int oldCapacity = this.elements.length;
            if (minCapacity > oldCapacity) {
                int newCapacity = IndexWriter.newCapacity(oldCapacity, minCapacity);
                if (newCapacity < minCapacity) {
                    throw new OutOfMemoryError(MessageUtil.format((String)Messages.IndexWriter_Error_ObjectArrayLength, (Object[])new Object[]{minCapacity, newCapacity}));
                }
                Object[] copy = new Object[newCapacity];
                System.arraycopy(this.elements, 0, copy, 0, Math.min(this.elements.length, newCapacity));
                this.elements = copy;
            }
        }

        public V get(int key) {
            return (V)(key >= this.elements.length ? null : this.elements[key]);
        }

        public void put(int key, V value) {
            this.ensureCapacity(key + 1);
            this.elements[key] = value;
            this.size = Math.max(this.size, key + 1);
        }

        public int size() {
            return this.size;
        }
    }

    static class PosIndexStreamer
    extends LongIndexStreamer {
        IIndexReader.IOne2OneIndex writeTo2(DataOutputStream out, long position, IteratorLong iterator) throws IOException {
            this.openStream(out, position);
            this.addAll(iterator);
            this.closeStream();
            Pages<SoftReference<ArrayIntCompressed>> pages2 = new Pages<SoftReference<ArrayIntCompressed>>(this.pages.size());
            Iterator it = this.pages.entries();
            while (it.hasNext()) {
                SoftReference sr;
                Object rr;
                HashMapIntObject.Entry e = (HashMapIntObject.Entry)it.next();
                Object o = e.getValue();
                if (!(o instanceof SoftReference) || !((rr = (sr = (SoftReference)o).get()) instanceof ArrayLongCompressed)) continue;
                ArrayLongCompressed f = (ArrayLongCompressed)rr;
                pages2.put(e.getKey(), new SoftReference<ArrayIntLongCompressed>(new ArrayIntLongCompressed(f)));
            }
            return new IndexReader.PositionIndexReader(null, pages2, this.size, this.pageSize, this.pageStart.toArray());
        }
    }

    public static class SizeIndexCollectorUncompressed
    extends IntIndexCollectorUncompressed {
        public SizeIndexCollectorUncompressed(int size) {
            super(size);
        }

        public static int compress(long y) {
            int ret = y < 0L ? -1 : (y <= Integer.MAX_VALUE ? (int)y : (y <= 0x400000000L ? (int)(y / 8L) + 0x70000000 : -268435456));
            return ret;
        }

        public static long expand(int x) {
            long ret = x >= -1 ? (long)x : (x < -268435456 ? ((long)x & Integer.MAX_VALUE) * 8L + 0x80000000L : 0x400000000L);
            return ret;
        }

        public void set(int index, long value) {
            this.set(index, SizeIndexCollectorUncompressed.compress(value));
        }

        public long getSize(int index) {
            int v = this.get(index);
            return SizeIndexCollectorUncompressed.expand(v);
        }

        @Override
        public IIndexReader.IOne2SizeIndex writeTo(File indexFile) throws IOException {
            return new IndexReader.SizeIndexReader(new IntIndexStreamer().writeTo(indexFile, this.dataElements));
        }
    }
}

