/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.diagnostics;

import java.lang.management.ManagementFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.diagnostics.DiagnosticsAction;
import org.eclipse.mat.ui.internal.diagnostics.actions.HotSpotJVMHeapDump;
import org.eclipse.mat.ui.internal.diagnostics.actions.J9JVMHeapDump;
import org.eclipse.mat.ui.internal.diagnostics.actions.J9JVMSystemDump;
import org.eclipse.mat.ui.internal.diagnostics.actions.J9JVMThreadDump;
import org.eclipse.mat.ui.internal.diagnostics.actions.ThreadMXBeanDump;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class DiagnosticsSelectionWizardPage
extends WizardPage {
    private Table actionsTable;

    public DiagnosticsSelectionWizardPage() {
        super("diagnostics_selection");
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.DiagnosticsSelectionWizardPage_DialogName);
        this.setDescription(Messages.DiagnosticsSelectionWizardPage_DialogDescription);
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        Label l1 = new Label(top, 0);
        l1.setText(Messages.DiagnosticsSelectionWizardPage_ChooseProcess);
        GridDataFactory.swtDefaults().span(1, 1).applyTo((Control)l1);
        Composite tableComposite = new Composite(top, 0);
        GridDataFactory.fillDefaults().grab(true, true).indent(0, 0).applyTo((Control)tableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.actionsTable = new Table(tableComposite, 68100);
        this.actionsTable.setHeaderVisible(true);
        this.actionsTable.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 1).minSize(0, 100).applyTo((Control)this.actionsTable);
        this.actionsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiagnosticsSelectionWizardPage.this.selectionChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DiagnosticsSelectionWizardPage.this.getWizard().performFinish();
            }
        });
        TableColumn column = new TableColumn(this.actionsTable, 16384);
        column.setText(Messages.DiagnosticsSelectionWizardPage_ColumnDescription);
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(100, 250));
        tableComposite.layout();
        tableComposite.pack();
        this.actionsTable.setFocus();
        this.setControl((Control)top);
        this.loadTableItems();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.mat.ui.help.diagnostics");
    }

    private void loadTableItems() {
        this.addTableItem(Messages.DiagnosticsAction_ThreadMXBeanDump_Description, new ThreadMXBeanDump());
        try {
            Class.forName("com.ibm.jvm.Dump").getMethod("triggerDump", String.class);
            this.addTableItem(Messages.DiagnosticsAction_J9JVMThreadDump_Description, new J9JVMThreadDump());
            this.addTableItem(Messages.DiagnosticsAction_J9JVMHeapDump_Description, new J9JVMHeapDump());
            this.addTableItem(Messages.DiagnosticsAction_J9JVMSystemDump_Description, new J9JVMSystemDump());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class<?> dumpcls = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            ManagementFactory.newPlatformMXBeanProxy(ManagementFactory.getPlatformMBeanServer(), "com.sun.management:type=HotSpotDiagnostic", dumpcls);
            this.addTableItem(Messages.DiagnosticsAction_HotSpotJVMHeapDump_Description, new HotSpotJVMHeapDump());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addTableItem(String description, DiagnosticsAction action) {
        TableItem item = new TableItem(this.actionsTable, 0);
        item.setText(0, description);
        item.setData((Object)action);
    }

    private void selectionChanged() {
        this.getContainer().updateButtons();
    }

    public void performHelp() {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp("org.eclipse.mat.ui.help.diagnostics");
    }

    public boolean isPageComplete() {
        return this.actionsTable.getSelectionIndex() != -1;
    }

    public DiagnosticsAction getSelectedAction() {
        return (DiagnosticsAction)this.actionsTable.getItem(this.actionsTable.getSelectionIndex()).getData();
    }
}

