/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Menu;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;

@Category(value="__hidden__")
@CommandName(value="class_references")
@Icon(value="/META-INF/icons/heapobjects/class.gif")
@Menu(value={@Menu.Entry(icon="/META-INF/icons/class_refs_outbound.gif"), @Menu.Entry(options="-inbound", icon="/META-INF/icons/class_refs_inbound.gif")})
@HelpUrl(value="/org.eclipse.mat.ui.help/reference/querymatrix.html#ref_querymatrix__show_objects_by_class")
public class ClassReferrersQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public boolean inbound = false;

    public IResult execute(IProgressListener listener) throws Exception {
        return this.inbound ? new InboundClasses(this.snapshot, this.objects.getIds(listener)) : new OutboundClasses(this.snapshot, this.objects.getIds(listener));
    }

    private static class ClassNode {
        int classId;
        ArrayInt objects = new ArrayInt();
        int type = 0;
        String label;
        Bytes shallowHeap = new Bytes(0L);
        ClassNode parent;

        public int hashCode() {
            return Objects.hash(this.classId, this.parent);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassNode other = (ClassNode)obj;
            return this.classId == other.classId && Objects.equals(this.parent, other.parent);
        }

        private ClassNode(int classId, ClassNode parent) {
            this.classId = classId;
            this.parent = parent;
        }
    }

    public static class InboundClasses
    extends Tree {
        public InboundClasses(ISnapshot snapshot, int[] objectIds) {
            super(snapshot, objectIds);
        }

        @Override
        protected int[] children(ClassNode node) throws SnapshotException {
            return this.snapshot.getInboundRefererIds(node.objects.toArray(), (IProgressListener)new VoidProgressListener());
        }

        public URL getIcon(Object row) {
            ClassNode node = (ClassNode)row;
            if (node.type == 0) {
                return Icons.CLASS_IN;
            }
            if (node.type == 1) {
                return Icons.CLASS_IN_MIXED;
            }
            return Icons.CLASS_IN_OLD;
        }
    }

    public static class OutboundClasses
    extends Tree {
        public OutboundClasses(ISnapshot snapshot, int[] objectIds) {
            super(snapshot, objectIds);
        }

        @Override
        protected int[] children(ClassNode node) throws SnapshotException {
            return this.snapshot.getOutboundReferentIds(node.objects.toArray(), (IProgressListener)new VoidProgressListener());
        }

        public URL getIcon(Object row) {
            ClassNode node = (ClassNode)row;
            if (node.type == 0) {
                return Icons.CLASS_OUT;
            }
            if (node.type == 1) {
                return Icons.CLASS_OUT_MIXED;
            }
            return Icons.CLASS_OUT_OLD;
        }
    }

    private static abstract class Tree
    implements IResultTree,
    IIconProvider {
        protected ISnapshot snapshot;
        private List<ClassNode> treeNodes;

        public Tree(ISnapshot snapshot, int[] objectIds) {
            this.snapshot = snapshot;
            this.treeNodes = this.prepare(objectIds, null);
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public final Column[] getColumns() {
            return new Column[]{new Column(Messages.Column_ClassName), new Column(Messages.Column_Objects, Integer.TYPE), new Column(Messages.Column_ShallowHeap, Bytes.class).sorting(Column.SortDirection.DESC)};
        }

        public final List<?> getElements() {
            return this.treeNodes;
        }

        private final List<ClassNode> prepare(int[] ids, ClassNode parent) {
            try {
                HashMapIntObject class2node = new HashMapIntObject();
                int ii = 0;
                while (ii < ids.length) {
                    int objectId = ids[ii];
                    IClass clazz = this.snapshot.getClassOf(objectId);
                    ClassNode node = (ClassNode)class2node.get(clazz.getObjectId());
                    if (node == null) {
                        node = new ClassNode(clazz.getObjectId(), parent);
                        node.label = clazz.getName();
                        class2node.put(node.classId, (Object)node);
                    }
                    node.objects.add(objectId);
                    node.shallowHeap = node.shallowHeap.add(this.snapshot.getHeapSize(objectId));
                    ++ii;
                }
                return Arrays.asList((ClassNode[])class2node.getAllValues((Object[])new ClassNode[0]));
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }

        public final List<ClassNode> getChildren(Object parent) {
            try {
                int[] childrenIds = this.children((ClassNode)parent);
                List<ClassNode> answer = this.prepare(childrenIds, (ClassNode)parent);
                for (ClassNode classNode : answer) {
                    this.checkDeadEnd(classNode);
                }
                return answer;
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }

        protected abstract int[] children(ClassNode var1) throws SnapshotException;

        public final boolean hasChildren(Object element) {
            return true;
        }

        public final Object getColumnValue(Object row, int columnIndex) {
            ClassNode node = (ClassNode)row;
            switch (columnIndex) {
                case 0: {
                    return node.label;
                }
                case 1: {
                    return node.objects.size();
                }
                case 2: {
                    return node.shallowHeap;
                }
            }
            return null;
        }

        public final IContextObject getContext(final Object row) {
            return new IContextObjectSet(){

                public int getObjectId() {
                    return ((ClassNode)row).classId;
                }

                public int[] getObjectIds() {
                    return ((ClassNode)row).objects.toArray();
                }

                public String getOQL() {
                    return null;
                }
            };
        }

        public synchronized void checkDeadEnd(ClassNode node) {
            if (node.parent == null) {
                return;
            }
            SetInt ids = new SetInt();
            int i = 0;
            while (i < node.objects.size()) {
                ids.add(node.objects.get(i));
                ++i;
            }
            ClassNode parentNode = node;
            while (parentNode.parent != null && !ids.isEmpty()) {
                parentNode = parentNode.parent;
                if (parentNode.classId != node.classId) continue;
                int i2 = 0;
                while (i2 < parentNode.objects.size()) {
                    ids.remove(parentNode.objects.get(i2));
                    ++i2;
                }
            }
            node.type = ids.isEmpty() ? 2 : (ids.size() != node.objects.size() ? 1 : 0);
        }
    }

    public static interface Type {
        public static final int NEW = 0;
        public static final int MIXED = 1;
        public static final int OLD_FAD = 2;
    }
}

