/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.snapshot;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.mat.collect.HashMapIntLong;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.model.XSnapshotInfo;

public class RetainedSizeCache
implements IIndexReader {
    private String filename;
    private HashMapIntLong id2size;
    private boolean isDirty = false;
    private static final Logger logger = Logger.getLogger(RetainedSizeCache.class.getName());

    public RetainedSizeCache(File f) {
        this.filename = f.getAbsolutePath();
        this.doRead(f, false);
    }

    public RetainedSizeCache(XSnapshotInfo snapshotInfo) {
        this.filename = String.valueOf(snapshotInfo.getPrefix()) + "i2sv2.index";
        this.readId2Size(snapshotInfo.getPrefix());
    }

    public long get(int key) {
        try {
            return this.id2size.get(key);
        }
        catch (NoSuchElementException e) {
            return 0L;
        }
    }

    public void put(int key, long value) {
        this.id2size.put(key, value);
        this.isDirty = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() {
        if (!this.isDirty) {
            return;
        }
        File file = new File(this.filename);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileOutputStream fos = new FileOutputStream(file);
                try {
                    try (DataOutputStream out = new DataOutputStream(fos);){
                        int[] nArray = this.id2size.getAllKeys();
                        int n = nArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int key = nArray[n2];
                            out.writeInt(key);
                            out.writeLong(this.id2size.get(key));
                            ++n2;
                        }
                        out.close();
                        this.isDirty = false;
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, Messages.RetainedSizeCache_Warning_IgnoreError, e);
        }
    }

    private void doRead(File file, boolean readOldFormat) {
        boolean delete = false;
        int initialCapacity = (int)Math.min(file.length() / 8L, 2147483627L);
        this.id2size = new HashMapIntLong(initialCapacity);
        try {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));){
                    while (in.available() > 0) {
                        int key = in.readInt();
                        long value = in.readLong();
                        if (value < 0L && readOldFormat) {
                            value = -(value - -9223372036854775807L);
                        }
                        this.id2size.put(key, value);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                logger.log(Level.WARNING, Messages.RetainedSizeCache_ErrorReadingRetainedSizes, e);
                this.id2size.clear();
                delete = true;
                if (delete && !file.delete()) {
                    logger.log(Level.WARNING, Messages.SnapshotFactoryImpl_UnableToDeleteIndexFile, file.toString());
                }
            }
        }
        finally {
            if (delete && !file.delete()) {
                logger.log(Level.WARNING, Messages.SnapshotFactoryImpl_UnableToDeleteIndexFile, file.toString());
            }
        }
    }

    private void readId2Size(String prefix) {
        File file = new File(this.filename);
        if (file.exists()) {
            this.doRead(file, false);
        } else {
            File legacyFile = new File(String.valueOf(prefix) + "i2s.index");
            if (legacyFile.exists()) {
                this.doRead(legacyFile, true);
            } else {
                this.id2size = new HashMapIntLong();
            }
        }
    }

    @Override
    public int size() {
        return this.id2size.size();
    }

    @Override
    public void unload() throws IOException {
        this.close();
    }

    @Override
    public void delete() {
        this.close();
        File file = new File(this.filename);
        if (!file.delete()) {
            logger.log(Level.WARNING, Messages.SnapshotFactoryImpl_UnableToDeleteIndexFile, file.toString());
        }
    }
}

