/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.parser.internal.SnapshotImpl;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.InstanceImpl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IClassLoader;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.registry.ClassSpecificNameResolverRegistry;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.VoidProgressListener;

public class ClassLoaderImpl
extends InstanceImpl
implements IClassLoader {
    private static final long serialVersionUID = 1L;
    public static final String NO_LABEL = "__none__";
    private volatile transient List<IClass> definedClasses = null;

    public ClassLoaderImpl(int objectId, long address, ClassImpl clazz, List<Field> fields) {
        super(objectId, address, clazz, fields);
    }

    @Override
    protected synchronized void readFully() {
        if (this.getObjectAddress() == 0L) {
            this.setFields(new ArrayList<Field>());
        } else {
            super.readFully();
        }
    }

    @Override
    public String getClassSpecificName() {
        try {
            int objectId = this.getObjectId();
            String label = this.source.getClassLoaderLabel(objectId);
            if (NO_LABEL.equals(label) && (label = ClassSpecificNameResolverRegistry.resolve((IObject)this)) != null) {
                this.source.setClassLoaderLabel(objectId, label);
            }
            return label;
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof SnapshotException) {
                return ClassSpecificNameResolverRegistry.resolve((IObject)this);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IClass> getDefinedClasses() throws SnapshotException {
        List<IClass> result = this.definedClasses;
        if (result == null) {
            ClassLoaderImpl classLoaderImpl = this;
            synchronized (classLoaderImpl) {
                result = this.definedClasses;
                if (result == null) {
                    this.definedClasses = result = ClassLoaderImpl.doGetDefinedClasses(this.source, this.getObjectId());
                }
            }
        }
        return result;
    }

    public long getRetainedHeapSizeOfObjects(boolean calculateIfNotAvailable, boolean calculateMinRetainedSize, IProgressListener listener) throws SnapshotException {
        return ClassLoaderImpl.doGetRetainedHeapSizeOfObjects(this.source, this.getObjectId(), calculateIfNotAvailable, calculateMinRetainedSize, listener);
    }

    public static final List<IClass> doGetDefinedClasses(ISnapshot dump, int classLoaderId) throws SnapshotException {
        ArrayList<IClass> answer = new ArrayList<IClass>();
        for (IClass clasz : dump.getClasses()) {
            if (clasz.getClassLoaderId() != classLoaderId) continue;
            answer.add(clasz);
        }
        return answer;
    }

    public static final long doGetRetainedHeapSizeOfObjects(ISnapshot dump, int classLoaderId, boolean calculateIfNotAvailable, boolean calculateMinRetainedSize, IProgressListener listener) throws SnapshotException {
        long answer = ((SnapshotImpl)dump).getRetainedSizeCache().get(classLoaderId);
        if (answer > 0L || !calculateIfNotAvailable) {
            return answer;
        }
        if (answer < 0L && calculateMinRetainedSize) {
            return answer;
        }
        if (listener == null) {
            listener = new VoidProgressListener();
        }
        ArrayInt objectIds = new ArrayInt();
        objectIds.add(classLoaderId);
        for (IClass clasz : ClassLoaderImpl.doGetDefinedClasses(dump, classLoaderId)) {
            objectIds.add(clasz.getObjectId());
            objectIds.addAll(clasz.getObjectIds());
        }
        long retainedSize = 0L;
        if (!calculateMinRetainedSize) {
            int[] retainedSet = dump.getRetainedSet(objectIds.toArray(), listener);
            if (listener.isCanceled()) {
                return 0L;
            }
            retainedSize = dump.getHeapSize(retainedSet);
        } else {
            retainedSize = dump.getMinRetainedSize(objectIds.toArray(), listener);
            if (listener.isCanceled()) {
                return 0L;
            }
        }
        if (calculateMinRetainedSize) {
            retainedSize = -retainedSize;
        }
        ((SnapshotImpl)dump).getRetainedSizeCache().put(classLoaderId, retainedSize);
        return retainedSize;
    }
}

