/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtil {
    private static Info[] knownCollections = new Info[]{new Info("java.util.AbstractList", null, null), new Info("java.util.Collections$EmptyList", "", null), new Info("java.util.ArrayList", -9, "size", "elementData"), new IBM6ArrayListInfo("java.util.ArrayList", 8, "firstIndex", "lastIndex", "array"), new IBM6ArrayListInfo("java.util.ArrayDeque", 8, "front", "rear", "elements"), new Info("java.util.LinkedList", -9, "size", "header."), new Info("java.util.LinkedList", 8, "size", "voidLink."), new Info("java.util.HashMap", -9, "size", "table", "key", "value"), new Info("java.util.HashMap", 8, "elementCount", "elementData", "key", "value"), new Info("java.util.LinkedHashMap", 4, "size", "table", "key", "value"), new Info("com.ibm.jvm.util.HashMapRT", 12, "size", "table", "key", "value"), new Info("java.util.IdentityHashMap", 6, "size", "table"), new Info("java.util.IdentityHashMap", 8, "size", "elementData"), new Info("java.util.Collections$EmptySet", "", null), new Info("java.util.Collections$EmptyMap", "", null), new Info("java.util.HashSet", -9, "map.size", "map.table", "key", "value"), new Info("java.util.HashSet", 8, "backingMap.elementCount", "backingMap.elementData", "key", "value"), new Info("java.util.LinkedHashSet", 4, "map.size", "map.table", "key", "value"), new Info("java.util.TreeMap", "size", null), new Info("java.util.TreeSet", -9, "m.size", null), new Info("java.util.TreeSet", 8, "backingMap.size", null), new Info("java.util.Hashtable", -13, "count", "table", "key", "value"), new Info("java.util.Hashtable", 12, "elementCount", "elementData", "key", "value"), new Info("java.util.Properties", 4, "elementCount", "elementData", "key", "value"), new Info("java.util.Vector", "elementCount", "elementData"), new Info("java.util.WeakHashMap", -9, "size", "table", "referent", "value"), new Info("java.util.WeakHashMap", 8, "elementCount", "elementData", "referent", "value"), new Info("java.util.PriorityQueue", 4, "size", "queue"), new Info("java.util.PriorityQueue", 8, "size", "elements"), new Info("java.lang.ThreadLocal$ThreadLocalMap", 14, "size", "table", "referent", "value"), new Info("java.util.concurrent.ConcurrentHashMap$Segment", "count", "table", "key", "value"), new Info("com.sap.engine.lib.util.AbstractDataStructure", null, null), new Info("java.util.concurrent.CopyOnWriteArrayList", "", "array"), new Info("java.util.concurrent.CopyOnWriteArraySet", "", "al.array")};

    public static List<Info> getKnownCollections(ISnapshot snapshot) throws SnapshotException {
        int version = CollectionUtil.resolveVersion(snapshot);
        ArrayList<Info> answer = new ArrayList<Info>(knownCollections.length);
        Info[] infoArray = knownCollections;
        int n = knownCollections.length;
        int n2 = 0;
        while (n2 < n) {
            Info info = infoArray[n2];
            if ((info.version & version) == version) {
                answer.add(info);
            }
            ++n2;
        }
        return answer;
    }

    public static HashMapIntObject<Info> getKnownMaps(ISnapshot snapshot) throws SnapshotException {
        HashMapIntObject answer = new HashMapIntObject();
        for (Info info : CollectionUtil.getKnownCollections(snapshot)) {
            Collection<IClass> classes;
            if (!info.isMap() || (classes = snapshot.getClassesByName(info.getClassName(), true)) == null) continue;
            for (IClass clasz : classes) {
                answer.put(clasz.getObjectId(), (Object)info);
            }
        }
        return answer;
    }

    public static Info getInfo(IObject object) throws SnapshotException {
        List<Info> known = CollectionUtil.getKnownCollections(object.getSnapshot());
        int len = known.size();
        int ii = len - 1;
        while (ii > 0) {
            Info info = known.get(ii);
            if (object.getClazz().doesExtend(info.getClassName())) {
                return info;
            }
            --ii;
        }
        return null;
    }

    public static int getNumberOfNoNullArrayElements(IObjectArray arrayObject) {
        ISnapshot snapshot = arrayObject.getSnapshot();
        try {
            int[] outs = snapshot.getOutboundReferentIds(arrayObject.getObjectId());
            if (outs.length == 1 || outs.length == arrayObject.getLength() + 1) {
                return outs.length - 1;
            }
        }
        catch (SnapshotException snapshotException) {}
        long[] elements = arrayObject.getReferenceArray();
        int result = 0;
        int i = 0;
        while (i < elements.length) {
            if (elements[i] != 0L) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    private CollectionUtil() {
    }

    private static int resolveVersion(ISnapshot snapshot) throws SnapshotException {
        Collection<IClass> classes = snapshot.getClassesByName("com.ibm.misc.JavaRuntimeVersion", false);
        if (classes != null && !classes.isEmpty()) {
            return 4;
        }
        classes = snapshot.getClassesByName("com.ibm.oti.vm.BootstrapClassLoader", false);
        if (classes != null && !classes.isEmpty()) {
            return 8;
        }
        classes = snapshot.getClassesByName("com.ibm.jvm.Trace", false);
        if (classes != null && !classes.isEmpty()) {
            return 2;
        }
        return 1;
    }

    private static class IBM6ArrayListInfo
    extends Info {
        private String firstIndex;

        public IBM6ArrayListInfo(String className, int version, String firstIndex, String lastIndex, String arrayField) {
            super(className, version, lastIndex, arrayField);
            this.firstIndex = firstIndex;
        }

        public int getSize(IObject collection) throws SnapshotException {
            int lastIndex = super.getSize(collection);
            if (lastIndex <= 0) {
                return lastIndex;
            }
            Integer firstIndex = (Integer)collection.resolveValue(this.firstIndex);
            return lastIndex - (firstIndex == null ? 0 : firstIndex);
        }
    }

    public static class Info {
        private String className;
        private int version;
        private String sizeField;
        private String arrayField;
        private String keyField;
        private String valueField;

        Info(String className, int version, String sizeField, String arrayField) {
            this(className, version, sizeField, arrayField, null, null);
        }

        public Info(String className, String sizeField, String arrayField) {
            this(className, sizeField, arrayField, null, null);
        }

        Info(String className, int version, String sizeField, String arrayField, String keyField, String valueField) {
            this.className = className;
            this.version = version;
            this.sizeField = sizeField;
            this.arrayField = arrayField;
            this.keyField = keyField;
            this.valueField = valueField;
        }

        public Info(String className, String sizeField, String arrayField, String keyField, String valueField) {
            this(className, -1, sizeField, arrayField, keyField, valueField);
        }

        public String getClassName() {
            return this.className;
        }

        public boolean hasSize() {
            return this.sizeField != null;
        }

        public int getSize(IObject collection) throws SnapshotException {
            Integer value = (Integer)collection.resolveValue(this.sizeField);
            if (value == null) {
                IObject header;
                if (this.hasBackingArray()) {
                    IObjectArray array = this.getBackingArray(collection);
                    if (array != null) {
                        if (!this.isMap()) {
                            int count = CollectionUtil.getNumberOfNoNullArrayElements(array);
                            value = count;
                        } else {
                            int count = this.getMapSize(collection, array);
                            value = count;
                        }
                    }
                } else if (this.arrayField != null && (header = this.resolveNextFields(collection)) != null) {
                    int count = this.getMapSize(collection, header);
                    value = count;
                }
            }
            return value == null ? 0 : value;
        }

        private int getMapSize(IObject collection, IObject array) throws SnapshotException {
            int count = 0;
            ISnapshot snapshot = array.getSnapshot();
            BitField seen = new BitField(snapshot.getSnapshotInfo().getNumberOfObjects());
            ArrayInt extra = new ArrayInt();
            seen.set(array.getObjectId());
            int[] nArray = snapshot.getOutboundReferentIds(array.getObjectId());
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (!snapshot.isClass(i) && !seen.get(i)) {
                    extra.clear();
                    extra.add(i);
                    seen.set(i);
                    int k = 0;
                    while (k < extra.size()) {
                        int j = extra.get(k);
                        while (j >= 0) {
                            ++count;
                            j = this.resolveNextSameField(snapshot, j, seen, extra);
                        }
                        ++k;
                    }
                }
                ++n2;
            }
            return count;
        }

        private IInstance resolveNextField(IObject source) throws SnapshotException {
            ISnapshot snapshot = source.getSnapshot();
            IInstance ret = null;
            int[] nArray = snapshot.getOutboundReferentIds(source.getObjectId());
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                IObject o;
                int i = nArray[n2];
                if (!snapshot.isArray(i) && !snapshot.isClass(i) && (o = snapshot.getObject(i)) instanceof IInstance) {
                    if (ret != null) {
                        ret = null;
                        break;
                    }
                    ret = (IInstance)o;
                }
                ++n2;
            }
            return ret;
        }

        int resolveNextSameField(ISnapshot snapshot, int sourceId, BitField seen, ArrayInt extra) throws SnapshotException {
            int ret = -1;
            IClass c1 = snapshot.getClassOf(sourceId);
            int[] nArray = snapshot.getOutboundReferentIds(sourceId);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClass c2;
                int i = nArray[n2];
                if (!snapshot.isArray(i) && !snapshot.isClass(i) && c1.equals(c2 = snapshot.getClassOf(i)) && !seen.get(i)) {
                    seen.set(i);
                    if (ret == -1) {
                        ret = i;
                    } else {
                        extra.add(i);
                    }
                }
                ++n2;
            }
            return ret;
        }

        public boolean hasBackingArray() {
            return this.arrayField != null && !this.arrayField.endsWith(".");
        }

        public IObjectArray getBackingArray(IObject collection) throws SnapshotException {
            Object obj = collection.resolveValue(this.arrayField);
            IObjectArray ret = null;
            if (obj instanceof IObjectArray) {
                ret = (IObjectArray)obj;
                return ret;
            }
            if (obj instanceof IObject) {
                String msg = MessageUtil.format((String)Messages.CollectionUtil_BadBackingArray, (Object[])new Object[]{this.arrayField, collection.getTechnicalName(), ((IObject)obj).getTechnicalName()});
                throw new SnapshotException(msg);
            }
            if (obj != null) {
                String msg = MessageUtil.format((String)Messages.CollectionUtil_BadBackingArray, (Object[])new Object[]{this.arrayField, collection.getTechnicalName(), obj.toString()});
                throw new SnapshotException(msg);
            }
            IObject next = this.resolveNextFields(collection);
            if (next == null) {
                return null;
            }
            ISnapshot snapshot = next.getSnapshot();
            int[] nArray = snapshot.getOutboundReferentIds(next.getObjectId());
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                IObject o;
                int i = nArray[n2];
                if (snapshot.isArray(i) && (o = snapshot.getObject(i)) instanceof IObjectArray) {
                    if (ret != null) {
                        return null;
                    }
                    ret = (IObjectArray)o;
                }
                ++n2;
            }
            return ret;
        }

        IObject resolveNextFields(IObject collection) throws SnapshotException {
            IObject next = collection;
            int i = this.arrayField.indexOf(46);
            while (i >= 0 && next != null) {
                next = this.resolveNextField(next);
                i = this.arrayField.indexOf(46, i + 1);
            }
            return next;
        }

        public String getBackingArrayField() {
            return this.arrayField;
        }

        public boolean isMap() {
            return this.keyField != null;
        }

        public String getEntryKeyField() {
            return this.keyField;
        }

        public String getEntryValueField() {
            return this.valueField;
        }
    }

    private static interface Version {
        public static final int SUN = 1;
        public static final int IBM14 = 2;
        public static final int IBM15 = 4;
        public static final int IBM16 = 8;
    }
}

