/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.threads;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.IRequestDetailsResolver;
import org.eclipse.mat.snapshot.extension.IThreadDetailsResolver;
import org.eclipse.mat.snapshot.extension.IThreadInfo;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ThreadToLocalReference;
import org.eclipse.mat.snapshot.registry.RequestDetailResolverRegistry;
import org.eclipse.mat.snapshot.registry.ThreadDetailResolverRegistry;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadInfoImpl
implements IThreadInfo {
    private static final Column COL_NAME = new Column(Messages.ThreadInfoImpl_Column_Name);
    private static final Column COL_INSTANCE = new Column(Messages.ThreadInfoImpl_Column_Instance);
    private static final Column COL_SHALLOW = new Column(Messages.Column_ShallowHeap, Integer.TYPE);
    private static final Column COL_RETAINED = new Column(Messages.Column_RetainedHeap, Long.TYPE);
    private static final Column COL_CONTEXTCL = new Column(Messages.ThreadInfoImpl_Column_ContextClassLoader);
    private static final List<Column> defaultColumns = Arrays.asList(COL_NAME, COL_INSTANCE, COL_SHALLOW, COL_RETAINED, COL_CONTEXTCL);
    private IObject subject;
    private String name;
    private String instance;
    private long shallowHeap;
    private long retainedHeap;
    private String contextClassLoader;
    private int contextClassLoaderId;
    private Map<Column, Object> properties = new HashMap<Column, Object>();
    private List<String> keywords = new ArrayList<String>();
    private CompositeResult details;
    private CompositeResult requests;

    static ThreadInfoImpl build(IObject thread, boolean readFully, IProgressListener listener) throws SnapshotException {
        ThreadInfoImpl info = new ThreadInfoImpl();
        info.subject = thread;
        ThreadInfoImpl.extractGeneralAttribtes(info);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        ThreadInfoImpl.extractFromDetailsResolver(info, readFully, listener);
        if (readFully) {
            ThreadInfoImpl.extractFromRequestResolver(info, listener);
        }
        return info;
    }

    private static void extractFromRequestResolver(ThreadInfoImpl info, IProgressListener listener) throws SnapshotException {
        int[] localVars;
        ISnapshot snapshot = info.subject.getSnapshot();
        int[] nArray = localVars = ThreadInfoImpl.getLocalVarsForThread(info.subject);
        int n = localVars.length;
        int n2 = 0;
        while (n2 < n) {
            int localId = nArray[n2];
            String className = snapshot.getClassOf(localId).getName();
            IRequestDetailsResolver resolver = (IRequestDetailsResolver)RequestDetailResolverRegistry.instance().lookup(className);
            if (resolver != null) {
                resolver.complement(snapshot, info, localVars, localId, listener);
            }
            ++n2;
        }
    }

    private static int[] getLocalVarsForThread(IObject thread) throws SnapshotException {
        List<NamedReference> refs = thread.getOutboundReferences();
        ArrayInt result = new ArrayInt();
        for (NamedReference ref : refs) {
            if (!(ref instanceof ThreadToLocalReference)) continue;
            result.add(ref.getObjectId());
        }
        return result.toArray();
    }

    private static void extractGeneralAttribtes(ThreadInfoImpl info) throws SnapshotException {
        info.name = info.subject.getClassSpecificName();
        info.instance = info.subject.getTechnicalName();
        info.shallowHeap = info.subject.getUsedHeapSize();
        info.retainedHeap = info.subject.getRetainedHeapSize();
        IObject contextClassLoader = (IObject)info.subject.resolveValue("contextClassLoader");
        if (contextClassLoader != null) {
            info.contextClassLoader = contextClassLoader.getClassSpecificName();
            if (info.contextClassLoader == null) {
                info.contextClassLoader = contextClassLoader.getTechnicalName();
            }
            info.contextClassLoaderId = contextClassLoader.getObjectId();
        }
    }

    private static void extractFromDetailsResolver(ThreadInfoImpl info, boolean readFully, IProgressListener listener) throws SnapshotException {
        for (IThreadDetailsResolver resolver : ThreadDetailResolverRegistry.instance().delegates()) {
            if (readFully) {
                resolver.complementDeep(info, listener);
                continue;
            }
            resolver.complementShallow(info, listener);
        }
    }

    static List<Column> getColumns() {
        ArrayList<Column> answer = new ArrayList<Column>();
        answer.addAll(defaultColumns);
        for (IThreadDetailsResolver resolver : ThreadDetailResolverRegistry.instance().delegates()) {
            Column[] cols = resolver.getColumns();
            if (cols == null) continue;
            int ii = 0;
            while (ii < cols.length) {
                answer.add(cols[ii]);
                ++ii;
            }
        }
        return answer;
    }

    private ThreadInfoImpl() {
    }

    @Override
    public IObject getThreadObject() {
        return this.subject;
    }

    @Override
    public int getThreadId() {
        return this.subject.getObjectId();
    }

    public String getName() {
        return this.name;
    }

    public String getInstance() {
        return this.instance;
    }

    public long getShallowHeap() {
        return this.shallowHeap;
    }

    public long getRetainedHeap() {
        return this.retainedHeap;
    }

    public String getContextClassLoader() {
        return this.contextClassLoader;
    }

    @Override
    public int getContextClassLoaderId() {
        return this.contextClassLoaderId;
    }

    @Override
    public void addDetails(String name, IResult detail) {
        if (this.details == null) {
            this.details = new CompositeResult(new IResult[0]);
        }
        this.details.addResult(name, detail);
    }

    public CompositeResult getDetails() {
        return this.details;
    }

    @Override
    public void addKeyword(String keyword) {
        this.keywords.add(keyword);
    }

    @Override
    public Collection<String> getKeywords() {
        return this.keywords;
    }

    @Override
    public void setValue(Column column, Object value) {
        this.properties.put(column, value);
    }

    @Override
    public void addRequest(String summary, IResult detail) {
        if (this.requests == null) {
            this.requests = new CompositeResult(new IResult[0]);
        }
        this.requests.addResult(summary, detail);
    }

    @Override
    public CompositeResult getRequests() {
        return this.requests;
    }

    public Object getValue(Column column) {
        if (column == COL_NAME) {
            return this.getName();
        }
        if (column == COL_INSTANCE) {
            return this.getInstance();
        }
        if (column == COL_SHALLOW) {
            return this.getShallowHeap();
        }
        if (column == COL_RETAINED) {
            return this.getRetainedHeap();
        }
        if (column == COL_CONTEXTCL) {
            return this.getContextClassLoader();
        }
        return this.properties.get(column);
    }
}

