/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.snapshot.inspections;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ISelectionProvider;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Menu;
import org.eclipse.mat.snapshot.IPathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CommandName(value="path2gc")
@Icon(value="/META-INF/icons/path2gc.gif")
@Menu(value={@Menu.Entry(options="-excludes \"\""), @Menu.Entry(options="-excludes java.lang.ref.WeakReference:referent"), @Menu.Entry(options="-excludes java.lang.ref.SoftReference:referent"), @Menu.Entry(options="-excludes java.lang.ref.PhantomReference:referent"), @Menu.Entry(options="-excludes java.lang.ref.WeakReference:referent java.lang.ref.SoftReference:referent"), @Menu.Entry(options="-excludes java.lang.ref.PhantomReference:referent java.lang.ref.SoftReference:referent"), @Menu.Entry(options="-excludes java.lang.ref.PhantomReference:referent java.lang.ref.WeakReference:referent"), @Menu.Entry(options="-excludes java.lang.ref.Reference:referent")})
public class Path2GCRootsQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none", advice=Argument.Advice.HEAP_OBJECT)
    public int object;
    @Argument(isMandatory=false)
    public List<String> excludes = Arrays.asList("java.lang.ref.WeakReference:referent", "java.lang.ref.SoftReference:referent");
    @Argument(isMandatory=false)
    public int numberOfPaths = 30;

    public IResult execute(IProgressListener listener) throws Exception {
        Map<IClass, Set<String>> excludeMap = Path2GCRootsQuery.convert(this.snapshot, this.excludes);
        IPathsFromGCRootsComputer computer = this.snapshot.getPathsFromGCRoots(this.object, excludeMap);
        Tree result = new Tree(this.snapshot, this.object, computer);
        result.addInitialPaths(Math.max(1, this.numberOfPaths), listener);
        return result;
    }

    protected static Map<IClass, Set<String>> convert(ISnapshot snapshot, List<String> excludes) throws SnapshotException {
        HashMap excludeMap = null;
        if (excludes != null && !excludes.isEmpty()) {
            excludeMap = new HashMap();
            Iterator<String> iterator = excludes.iterator();
            while (iterator.hasNext()) {
                String entry;
                String pattern = entry = iterator.next();
                HashSet<String> fields = null;
                int colon = entry.indexOf(58);
                if (colon >= 0) {
                    fields = new HashSet<String>();
                    StringTokenizer tokens = new StringTokenizer(entry.substring(colon + 1), ",");
                    while (tokens.hasMoreTokens()) {
                        fields.add(tokens.nextToken());
                    }
                    pattern = pattern.substring(0, colon);
                }
                for (IClass clazz : snapshot.getClassesByName(Pattern.compile(pattern), true)) {
                    excludeMap.put(clazz, fields);
                }
            }
        }
        return excludeMap;
    }

    private static class ChildNode
    extends Node {
        Node parent;
        String attribute;

        private ChildNode(Node parent, int objectId) {
            super(objectId);
            this.parent = parent;
        }
    }

    private static class Node {
        int objectId;
        List<Node> children;
        String label;
        String gcRoots;
        long shallowHeap;
        long retainedHeap;
        boolean isExpanded;
        boolean isSelected;

        public Node(int objectId) {
            this.objectId = objectId;
            this.shallowHeap = -1L;
            this.retainedHeap = -1L;
        }

        Node getChild(int childId) {
            Node child = null;
            if (this.children == null) {
                this.children = new ArrayList<Node>();
            } else {
                for (Node c : this.children) {
                    if (c.objectId != childId) continue;
                    child = c;
                    break;
                }
            }
            return child;
        }

        Node addChild(int childId) {
            ChildNode child = new ChildNode(this, childId);
            this.children.add(child);
            return child;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Tree
    implements IResultTree,
    IIconProvider,
    IDecorator,
    ISelectionProvider {
        ISnapshot snapshot;
        IPathsFromGCRootsComputer computer;
        Node root;
        int noOfPathsFound;

        public Tree(ISnapshot snapshot, int objectId, IPathsFromGCRootsComputer computer) {
            this.snapshot = snapshot;
            this.computer = computer;
            this.root = new Node(objectId);
            this.noOfPathsFound = 0;
        }

        public List<?> addNextPath() throws SnapshotException {
            if (this.computer == null) {
                return null;
            }
            int[] path = this.computer.getNextShortestPath();
            if (path == null) {
                this.computer = null;
                return null;
            }
            ArrayList<Node> ancestors = new ArrayList<Node>();
            boolean fatherToBeFound = false;
            ++this.noOfPathsFound;
            Node current = this.root;
            int pos = 1;
            while (pos < path.length) {
                Node child = current.getChild(path[pos]);
                if (child == null) {
                    child = current.addChild(path[pos]);
                    if (!fatherToBeFound) {
                        ancestors.add(current);
                    }
                    fatherToBeFound = true;
                } else {
                    ancestors.add(current);
                }
                current = child;
                ++pos;
            }
            return ancestors;
        }

        public boolean morePathsAvailable() {
            return this.computer != null;
        }

        public int getNumberOfPaths() {
            return this.noOfPathsFound;
        }

        private void addInitialPaths(int noOfNextPaths, IProgressListener listener) throws SnapshotException {
            if (this.computer == null) {
                return;
            }
            this.root.isExpanded = true;
            int ii = 0;
            while (ii < noOfNextPaths) {
                int[] path = this.computer.getNextShortestPath();
                if (path == null) {
                    this.computer = null;
                    break;
                }
                this.add(path, ii == 0);
                if (listener.isCanceled()) {
                    return;
                }
                ++ii;
            }
        }

        private void add(int[] path, boolean expandAndSelect) {
            ++this.noOfPathsFound;
            Node current = this.root;
            int pos = 1;
            while (pos < path.length) {
                Node child = current.getChild(path[pos]);
                if (child == null) {
                    child = current.addChild(path[pos]);
                }
                if (expandAndSelect) {
                    child.isExpanded = true;
                }
                current = child;
                ++pos;
            }
            if (expandAndSelect) {
                current.isSelected = true;
            }
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public final Column[] getColumns() {
            return new Column[]{new Column(Messages.Column_ClassName).decorator((IDecorator)this), new Column(Messages.Column_ShallowHeap, Long.TYPE).noTotals(), new Column(Messages.Column_RetainedHeap, Long.TYPE).noTotals()};
        }

        public List<?> getElements() {
            ArrayList<Node> answer = new ArrayList<Node>(1);
            answer.add(this.root);
            return answer;
        }

        public List<?> getChildren(Object parent) {
            return ((Node)parent).children;
        }

        public boolean hasChildren(Object element) {
            return ((Node)element).children != null;
        }

        public final Object getColumnValue(Object row, int columnIndex) {
            try {
                Node node = (Node)row;
                switch (columnIndex) {
                    case 0: {
                        if (node.label == null) {
                            IObject obj = this.snapshot.getObject(node.objectId);
                            node.label = obj.getDisplayName();
                            node.shallowHeap = obj.getUsedHeapSize();
                        }
                        return node.label;
                    }
                    case 1: {
                        if (node.shallowHeap == -1L) {
                            node.shallowHeap = this.snapshot.getHeapSize(node.objectId);
                        }
                        return node.shallowHeap;
                    }
                    case 2: {
                        if (node.retainedHeap == -1L) {
                            node.retainedHeap = this.snapshot.getRetainedHeapSize(node.objectId);
                        }
                        return node.retainedHeap;
                    }
                }
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        public final IContextObject getContext(final Object row) {
            return new IContextObject(){

                public int getObjectId() {
                    return ((Node)row).objectId;
                }
            };
        }

        public URL getIcon(Object row) {
            if (row instanceof ChildNode) {
                return Icons.inbound(this.snapshot, ((Node)row).objectId);
            }
            return Icons.forObject(this.snapshot, ((Node)row).objectId);
        }

        public boolean isExpanded(Object row) {
            return ((Node)row).isExpanded;
        }

        public boolean isSelected(Object row) {
            return ((Node)row).isSelected;
        }

        public final String prefix(Object row) {
            if (row instanceof ChildNode) {
                ChildNode node = (ChildNode)row;
                if (node.attribute == null) {
                    this.fillInAttribute(node);
                }
                return node.attribute;
            }
            return null;
        }

        private void fillInAttribute(ChildNode node) {
            try {
                IObject heapObject = this.snapshot.getObject(node.objectId);
                long parentAddress = this.snapshot.mapIdToAddress(node.parent.objectId);
                StringBuilder s = new StringBuilder(64);
                List<NamedReference> refs = heapObject.getOutboundReferences();
                for (NamedReference reference : refs) {
                    if (reference.getObjectAddress() != parentAddress) continue;
                    if (s.length() > 0) {
                        s.append(", ");
                    }
                    s.append(reference.getName());
                }
                node.attribute = s.toString();
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }

        public final String suffix(Object row) {
            try {
                Node node = (Node)row;
                if (node.gcRoots == null && this.snapshot.isGCRoot(node.objectId)) {
                    node.gcRoots = GCRootInfo.getTypeSetAsString(this.snapshot.getGCRootInfo(node.objectId));
                }
                return node.gcRoots;
            }
            catch (SnapshotException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

