/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.compare;

import com.ibm.icu.text.DecimalFormat;
import java.net.URL;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompareTablesQuery
implements IQuery {
    @Argument
    public IResultTable[] tables;
    @Argument(isMandatory=false)
    public Mode mode = Mode.ABSOLUTE;

    public IResult execute(IProgressListener listener) throws Exception {
        if (this.tables == null) {
            return null;
        }
        if (this.tables.length == 1) {
            return this.tables[0];
        }
        IResultTable base = this.tables[0];
        Column[] baseColumns = base.getColumns();
        Column key = baseColumns[0];
        ArrayList<ComparedColumn> attributes = new ArrayList<ComparedColumn>();
        int i = 1;
        while (i < baseColumns.length) {
            int[] indexes = new int[this.tables.length];
            int j = 0;
            while (j < indexes.length) {
                indexes[j] = this.getColumnIndex(baseColumns[i].getLabel(), this.tables[j]);
                ++j;
            }
            attributes.add(new ComparedColumn(baseColumns[i], indexes, true));
            ++i;
        }
        return new TableComparisonResult(this.mergeKeys(), key, attributes, this.mode);
    }

    private int getColumnIndex(String name, IResultTable table) {
        Column[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            if (columns[i].getLabel().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private List<ComparedRow> mergeKeys() {
        HashMap<Object, Object[]> map = new HashMap<Object, Object[]>();
        int i = 0;
        while (i < this.tables.length) {
            int j = 0;
            while (j < this.tables[i].getRowCount()) {
                Object row = this.tables[i].getRow(j);
                Object key = this.tables[i].getColumnValue(row, 0);
                Object[] rows = (Object[])map.get(key);
                if (rows == null) {
                    rows = new Object[this.tables.length];
                    map.put(key, rows);
                }
                rows[i] = row;
                ++j;
            }
            ++i;
        }
        ArrayList<ComparedRow> result = new ArrayList<ComparedRow>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            result.add(new ComparedRow(entry.getKey(), (Object[])entry.getValue()));
        }
        return result;
    }

    public class ComparedColumn {
        Column description;
        int[] columnIndexes;
        boolean displayed;

        public ComparedColumn(Column description, int[] columnIndexes, boolean displayed) {
            this.displayed = displayed;
            this.description = description;
            this.columnIndexes = columnIndexes;
        }

        public Column getDescription() {
            return this.description;
        }

        public void setDescription(Column description) {
            this.description = description;
        }

        public int[] getColumnIndexes() {
            return this.columnIndexes;
        }

        public void setColumnIndexes(int[] columnIndexes) {
            this.columnIndexes = columnIndexes;
        }

        public boolean isDisplayed() {
            return this.displayed;
        }

        public void setDisplayed(boolean displayed) {
            this.displayed = displayed;
        }
    }

    class ComparedRow {
        Object key;
        Object[] rows;

        public ComparedRow(Object key, Object[] rows) {
            this.key = key;
            this.rows = rows;
        }

        public Object getKey() {
            return this.key;
        }

        public void setKey(Object key) {
            this.key = key;
        }

        public Object[] getRows() {
            return this.rows;
        }

        public void setRows(Object[] rows) {
            this.rows = rows;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        ABSOLUTE("ABSOLUTE"),
        DIFF_TO_FIRST("DIFF_TO_FIRST"),
        DIFF_TO_PREVIOUS("DIFF_TO_PREVIOUS");

        String label;

        private Mode(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TableComparisonResult
    implements IResultTable,
    IIconProvider {
        private Column key;
        private List<ComparedRow> rows;
        private List<ComparedColumn> comparedColumns;
        private List<ComparedColumn> displayedColumns;
        private Column[] columns;
        private Mode mode;

        public TableComparisonResult(List<ComparedRow> rows, Column key, List<ComparedColumn> comparedColumns, Mode mode) {
            this.key = key;
            this.mode = mode;
            this.rows = rows;
            this.comparedColumns = comparedColumns;
            this.updateColumns();
            this.setMode(mode);
        }

        public Object getRow(int rowId) {
            return this.rows.get(rowId);
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public List<ComparedColumn> getComparedColumns() {
            return this.comparedColumns;
        }

        public void setComparedColumns(List<ComparedColumn> comparedColumns) {
            this.comparedColumns = comparedColumns;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            ComparedRow cr = (ComparedRow)row;
            if (columnIndex == 0) {
                return cr.getKey();
            }
            int comparedColumnIdx = (columnIndex - 1) / CompareTablesQuery.this.tables.length;
            int tableIdx = (columnIndex - 1) % CompareTablesQuery.this.tables.length;
            if (tableIdx == 0) {
                return this.getAbsoluteValue(cr, comparedColumnIdx, tableIdx);
            }
            switch (this.mode) {
                case ABSOLUTE: {
                    return this.getAbsoluteValue(cr, comparedColumnIdx, tableIdx);
                }
                case DIFF_TO_FIRST: {
                    return this.getDiffToFirst(cr, comparedColumnIdx, tableIdx);
                }
                case DIFF_TO_PREVIOUS: {
                    return this.getDiffToPrevious(cr, comparedColumnIdx, tableIdx);
                }
            }
            return null;
        }

        public Column[] getColumns() {
            return this.columns;
        }

        public IContextObject getContext(Object row) {
            return null;
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        private Object getAbsoluteValue(ComparedRow cr, int comparedColumnIdx, int tableIdx) {
            Object tableRow = cr.getRows()[tableIdx];
            if (tableRow == null) {
                return null;
            }
            int tableColumnIdx = this.displayedColumns.get(comparedColumnIdx).getColumnIndexes()[tableIdx];
            if (tableColumnIdx == -1) {
                return null;
            }
            return CompareTablesQuery.this.tables[tableIdx].getColumnValue(tableRow, tableColumnIdx);
        }

        private Object getDiffToFirst(ComparedRow cr, int comparedColumnIdx, int tableIdx) {
            Object tableRow = cr.getRows()[tableIdx];
            if (tableRow == null) {
                return null;
            }
            int tableColumnIdx = this.displayedColumns.get(comparedColumnIdx).getColumnIndexes()[tableIdx];
            if (tableColumnIdx == -1) {
                return null;
            }
            Object value = CompareTablesQuery.this.tables[tableIdx].getColumnValue(tableRow, tableColumnIdx);
            Object firstTableValue = this.getAbsoluteValue(cr, comparedColumnIdx, 0);
            if (value == null && firstTableValue == null) {
                return null;
            }
            if (value == null && firstTableValue instanceof Number) {
                return null;
            }
            if (value instanceof Number && firstTableValue == null) {
                return value;
            }
            if (value instanceof Number && firstTableValue instanceof Number) {
                return this.computeDiff((Number)firstTableValue, (Number)value);
            }
            return null;
        }

        private Object getDiffToPrevious(ComparedRow cr, int comparedColumnIdx, int tableIdx) {
            Object tableRow = cr.getRows()[tableIdx];
            if (tableRow == null) {
                return null;
            }
            int tableColumnIdx = this.displayedColumns.get(comparedColumnIdx).getColumnIndexes()[tableIdx];
            if (tableColumnIdx == -1) {
                return null;
            }
            Object value = CompareTablesQuery.this.tables[tableIdx].getColumnValue(tableRow, tableColumnIdx);
            Object previousTableValue = this.getAbsoluteValue(cr, comparedColumnIdx, tableIdx - 1);
            if (value == null && previousTableValue == null) {
                return null;
            }
            if (value == null && previousTableValue instanceof Number) {
                return null;
            }
            if (value instanceof Number && previousTableValue == null) {
                return value;
            }
            if (value instanceof Number && previousTableValue instanceof Number) {
                return this.computeDiff((Number)previousTableValue, (Number)value);
            }
            return null;
        }

        private Object computeDiff(Number o1, Number o2) {
            if (o1 instanceof Long && o2 instanceof Long) {
                return o2.longValue() - o1.longValue();
            }
            if (o1 instanceof Integer && o2 instanceof Integer) {
                return o2.intValue() - o1.intValue();
            }
            if (o1 instanceof Short && o2 instanceof Short) {
                return o2.shortValue() - o1.shortValue();
            }
            if (o1 instanceof Byte && o2 instanceof Byte) {
                return o2.byteValue() - o1.byteValue();
            }
            if (o1 instanceof Float && o2 instanceof Float) {
                return Float.valueOf(o2.floatValue() - o1.floatValue());
            }
            if (o1 instanceof Double && o2 instanceof Double) {
                return o2.doubleValue() - o1.doubleValue();
            }
            return null;
        }

        public URL getIcon(Object row) {
            return MemoryAnalyserPlugin.ISharedImages.class.getResource("icons/compare.gif");
        }

        public Mode getMode() {
            return this.mode;
        }

        public void setMode(Mode mode) {
            this.mode = mode;
            this.setFormatter();
        }

        private void setFormatter() {
            int i = 1;
            DecimalFormat formatter = new DecimalFormat("+#,##0;-#,##0");
            for (ComparedColumn comparedColumn : this.displayedColumns) {
                Column c = comparedColumn.description;
                int j = 0;
                while (j < comparedColumn.getColumnIndexes().length) {
                    if (this.mode != Mode.ABSOLUTE && j > 0) {
                        this.columns[i].formatting((Format)formatter);
                    } else {
                        this.columns[i].formatting(c.getFormatter());
                    }
                    ++i;
                    ++j;
                }
            }
        }

        public void updateColumns() {
            ArrayList<Column> result = new ArrayList<Column>();
            result.add(new Column(this.key.getLabel(), this.key.getType(), this.key.getAlign(), null, this.key.getFormatter(), null));
            this.displayedColumns = new ArrayList<ComparedColumn>();
            for (ComparedColumn comparedColumn : this.comparedColumns) {
                Column c = comparedColumn.description;
                if (!comparedColumn.isDisplayed()) continue;
                this.displayedColumns.add(comparedColumn);
                int j = 0;
                while (j < comparedColumn.getColumnIndexes().length) {
                    result.add(new Column(String.valueOf(c.getLabel()) + " #" + (j + 1), c.getType(), c.getAlign(), c.getSortDirection(), c.getFormatter(), null));
                    ++j;
                }
            }
            this.columns = result.toArray(new Column[result.size()]);
            this.setFormatter();
        }
    }
}

