/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.model;

import java.io.Serializable;
import java.util.Comparator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayLong;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.SnapshotImpl;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.registry.ClassSpecificNameResolverRegistry;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractObjectImpl
implements IObject,
Serializable {
    private static final long serialVersionUID = 2451875423035843852L;
    protected transient SnapshotImpl source;
    protected ClassImpl classInstance;
    private long address;
    private int objectId;

    public AbstractObjectImpl(int objectId, long address, ClassImpl classInstance) {
        this.objectId = objectId;
        this.address = address;
        this.classInstance = classInstance;
    }

    public long getObjectAddress() {
        return this.address;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public void setObjectAddress(long address) {
        this.address = address;
    }

    public void setObjectId(int objectId) {
        this.objectId = objectId;
    }

    public ClassImpl getClazz() {
        return this.classInstance;
    }

    public long getClassAddress() {
        return this.classInstance.getObjectAddress();
    }

    public int getClassId() {
        return this.classInstance.getObjectId();
    }

    public void setClassInstance(ClassImpl classInstance) {
        this.classInstance = classInstance;
    }

    public void setSnapshot(ISnapshot dump) {
        this.source = (SnapshotImpl)dump;
    }

    public ISnapshot getSnapshot() {
        return this.source;
    }

    public abstract long getUsedHeapSize();

    public long getRetainedHeapSize() {
        try {
            return this.source.getRetainedHeapSize(this.getObjectId());
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract ArrayLong getReferences();

    public String toString() {
        StringBuffer s = new StringBuffer(256);
        s.append(this.getClazz().getName());
        s.append(" [");
        this.appendFields(s);
        s.append("]");
        return s.toString();
    }

    protected StringBuffer appendFields(StringBuffer buf) {
        return buf.append("id=0x").append(Long.toHexString(this.getObjectAddress()));
    }

    public String getClassSpecificName() {
        return ClassSpecificNameResolverRegistry.resolve((IObject)this);
    }

    public String getTechnicalName() {
        StringBuilder builder = new StringBuilder(256);
        builder.append(this.getClazz().getName());
        builder.append(" @ 0x");
        builder.append(Long.toHexString(this.getObjectAddress()));
        return builder.toString();
    }

    public String getDisplayName() {
        String label = this.getClassSpecificName();
        if (label == null) {
            return this.getTechnicalName();
        }
        StringBuilder s = new StringBuilder(256).append(this.getTechnicalName()).append("  ");
        if (label.length() <= 256) {
            s.append(label);
        } else {
            s.append(label.substring(0, 256));
            s.append("...");
        }
        return s.toString();
    }

    public final Object resolveValue(String name) throws SnapshotException {
        int p = name.indexOf(46);
        String n = p < 0 ? name : name.substring(0, p);
        Field f = this.internalGetField(n);
        if (f == null || f.getValue() == null) {
            return null;
        }
        if (p < 0) {
            Object answer = f.getValue();
            if (answer instanceof ObjectReference) {
                answer = ((ObjectReference)answer).getObject();
            }
            return answer;
        }
        if (!(f.getValue() instanceof ObjectReference)) {
            String msg = MessageUtil.format((String)Messages.AbstractObjectImpl_Error_FieldIsNotReference, (Object[])new Object[]{n, this.getTechnicalName(), name.substring(p + 1)});
            throw new SnapshotException(msg);
        }
        ObjectReference ref = (ObjectReference)f.getValue();
        if (ref == null) {
            return null;
        }
        int objectId = ref.getObjectId();
        if (objectId < 0) {
            String msg = MessageUtil.format((String)Messages.AbstractObjectImpl_Error_FieldContainsIllegalReference, (Object[])new Object[]{n, this.getTechnicalName(), Long.toHexString(ref.getObjectAddress())});
            throw new SnapshotException(msg);
        }
        return this.source.getObject(objectId).resolveValue(name.substring(p + 1));
    }

    protected abstract Field internalGetField(String var1);

    public GCRootInfo[] getGCRootInfo() throws SnapshotException {
        return this.source.getGCRootInfo(this.getObjectId());
    }

    public boolean equals(Object obj) {
        return obj instanceof IObject && this.objectId == ((IObject)obj).getObjectId();
    }

    public int hashCode() {
        return this.objectId;
    }

    @Deprecated
    public static Comparator<AbstractObjectImpl> getComparatorForTechnicalName() {
        return null;
    }

    @Deprecated
    public static Comparator<AbstractObjectImpl> getComparatorForClassSpecificName() {
        return null;
    }

    @Deprecated
    public static Comparator<AbstractObjectImpl> getComparatorForUsedHeapSize() {
        return null;
    }

    protected static long alignUpTo8(long n) {
        return n % 8L == 0L ? n : n + 8L - n % 8L;
    }
}

