/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.acquire;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.acquire.HeapDumpProviderDescriptor;
import org.eclipse.mat.internal.acquire.HeapDumpProviderRegistry;
import org.eclipse.mat.internal.acquire.VmInfoDescriptor;
import org.eclipse.mat.query.annotations.descriptors.IAnnotatedObjectDescriptor;
import org.eclipse.mat.query.registry.AnnotatedObjectArgumentsSet;
import org.eclipse.mat.snapshot.acquire.VmInfo;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.acquire.ProviderConfigurationDialog;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcquireDialog
extends WizardPage {
    private static final String LAST_DIRECTORY_KEY = String.valueOf(AcquireDialog.class.getName()) + ".lastDir";
    private Table localVMsTable;
    private Text folderText;
    private Button configureButton;
    private Button refreshButton;
    private Collection<HeapDumpProviderDescriptor> providerDescriptors;
    private List<ProcessSelectionListener> listeners = new ArrayList<ProcessSelectionListener>();

    public AcquireDialog(Collection<HeapDumpProviderDescriptor> dumpProviders) {
        super("acq");
        this.providerDescriptors = dumpProviders;
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.AcquireDialog_DialogName);
        this.setDescription(Messages.AcquireDialog_DialogDescription);
        final Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(2, false));
        Label l1 = new Label(top, 0);
        l1.setText(Messages.AcquireDialog_ChooseProcess);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)l1);
        this.localVMsTable = new Table(top, 68100);
        this.localVMsTable.setHeaderVisible(true);
        this.localVMsTable.setLinesVisible(true);
        GridDataFactory.fillDefaults().grab(true, true).span(1, 1).minSize(0, 100).applyTo((Control)this.localVMsTable);
        this.localVMsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcquireDialog.this.getContainer().updateButtons();
                String proposedFileName = AcquireDialog.this.getProcess().getProposedFileName();
                if (proposedFileName == null) {
                    proposedFileName = "java_%pid%";
                }
                proposedFileName = proposedFileName.replace("%pid%", String.valueOf(AcquireDialog.this.getProcess().getPid()));
                proposedFileName = String.valueOf(AcquireDialog.this.getSelectedDirectory()) + File.separatorChar + proposedFileName;
                AcquireDialog.this.folderText.setText(proposedFileName);
                for (ProcessSelectionListener listener : AcquireDialog.this.listeners) {
                    listener.processSelected(AcquireDialog.this.getProcessArgumentsSet());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (AcquireDialog.this.getWizard().performFinish()) {
                    AcquireDialog.this.getShell().close();
                }
            }
        });
        TableColumn column = new TableColumn(this.localVMsTable, 131072);
        column.setText(Messages.AcquireDialog_ColumnDescription);
        column.setWidth(150);
        column = new TableColumn(this.localVMsTable, 16384);
        column.setText(Messages.AcquireDialog_ColumnPID);
        column.setWidth(40);
        column = new TableColumn(this.localVMsTable, 16384);
        column.setText(Messages.AcquireDialog_HeapDumpProviderColumnHeader);
        column.setWidth(200);
        this.refreshTable();
        Composite buttons = new Composite(top, 0);
        buttons.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().span(1, 1).applyTo((Control)buttons);
        this.refreshButton = new Button(buttons, 0);
        this.refreshButton.setText(Messages.AcquireDialog_RefreshButtonLabel);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.refreshButton);
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AcquireDialog.this.refreshTable();
            }
        });
        this.configureButton = new Button(buttons, 0);
        this.configureButton.setText(Messages.AcquireDialog_ConfigureButtonLabel);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.configureButton);
        this.configureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProviderConfigurationDialog configDialog = new ProviderConfigurationDialog(AcquireDialog.this.getShell());
                if (configDialog.open() == 0) {
                    AcquireDialog.this.refreshTable();
                }
            }
        });
        Label saveLocationLabel = new Label(top, 0);
        saveLocationLabel.setText(Messages.AcquireDialog_SaveLocation);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)saveLocationLabel);
        this.folderText = new Text(top, 2048);
        GridDataFactory.fillDefaults().minSize(300, 0).grab(true, false).applyTo((Control)this.folderText);
        String lastDir = Platform.getPreferencesService().getString("org.eclipse.mat.ui", LAST_DIRECTORY_KEY, "", null);
        if (lastDir == null || lastDir.trim().equals("")) {
            lastDir = System.getProperty("user.home");
        }
        this.folderText.setText(lastDir);
        this.folderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcquireDialog.this.getContainer().updateButtons();
            }
        });
        Button b = new Button(top, 0);
        b.setText(Messages.AcquireDialog_BrowseButton);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(top.getShell());
                String folder = dialog.open();
                if (folder != null && folder.length() > 0) {
                    AcquireDialog.this.folderText.setText(folder);
                }
            }
        });
        this.localVMsTable.setFocus();
        this.setControl((Control)top);
    }

    private void refreshTable() {
        this.localVMsTable.removeAll();
        List<VmInfo> vms = this.getAvailableVms();
        if (vms != null) {
            for (VmInfo process : vms) {
                try {
                    VmInfoDescriptor descriptor = VmInfoDescriptor.createDescriptor((VmInfo)process);
                    TableItem item = new TableItem(this.localVMsTable, 0);
                    item.setText(0, process.getDescription());
                    item.setText(1, Integer.toString(process.getPid()));
                    item.setText(2, this.getProviderDescriptor(process).getName());
                    item.setData((Object)new AnnotatedObjectArgumentsSet((IAnnotatedObjectDescriptor)descriptor));
                }
                catch (SnapshotException e) {
                    Logger.getLogger("org.eclipse.mat.ui").log(Level.SEVERE, "Problems refreshing process list", e);
                }
            }
        }
    }

    private List<VmInfo> getAvailableVms() {
        ArrayList<VmInfo> vms = new ArrayList<VmInfo>();
        for (HeapDumpProviderDescriptor providerDescriptor : this.providerDescriptors) {
            List<? extends VmInfo> providerVMs;
            GetVMListRunnable getListOperation = new GetVMListRunnable(providerDescriptor, (IRunnableContext)this.getContainer());
            if (!getListOperation.run().isOK() || (providerVMs = getListOperation.getResult()) == null) continue;
            vms.addAll(providerVMs);
        }
        return vms;
    }

    public boolean canFlipToNextPage() {
        return this.localVMsTable.getSelectionIndex() != -1 && this.folderText.getText().length() > 0;
    }

    public boolean isPageComplete() {
        return this.canFlipToNextPage() && this.getProcessArgumentsSet().getDescriptor().getArguments().size() == 0;
    }

    public AnnotatedObjectArgumentsSet getProcessArgumentsSet() {
        if (this.localVMsTable.getSelectionIndex() == -1) {
            return null;
        }
        AnnotatedObjectArgumentsSet argumentsSet = (AnnotatedObjectArgumentsSet)this.localVMsTable.getSelection()[0].getData();
        return argumentsSet;
    }

    public VmInfo getProcess() {
        if (this.localVMsTable.getSelectionIndex() == -1) {
            return null;
        }
        AnnotatedObjectArgumentsSet argumentsSet = (AnnotatedObjectArgumentsSet)this.localVMsTable.getSelection()[0].getData();
        VmInfoDescriptor descriptor = (VmInfoDescriptor)argumentsSet.getDescriptor();
        return descriptor.getVmInfo();
    }

    public String getSelectedPath() {
        return this.folderText.getText();
    }

    private String getSelectedDirectory() {
        String selectedPath = this.folderText.getText();
        if (selectedPath == null) {
            return "";
        }
        File f = new File(selectedPath);
        if (f.exists() && f.isDirectory()) {
            return selectedPath;
        }
        int i = selectedPath.lastIndexOf(File.separatorChar);
        return i == -1 ? selectedPath : selectedPath.substring(0, i);
    }

    public void saveSettings() {
        new InstanceScope().getNode("org.eclipse.mat.ui").put(LAST_DIRECTORY_KEY, this.getSelectedDirectory());
    }

    private HeapDumpProviderDescriptor getProviderDescriptor(VmInfo vmInfo) {
        return HeapDumpProviderRegistry.instance().getHeapDumpProvider(vmInfo.getHeapDumpProvider().getClass());
    }

    synchronized void addProcessSelectionListener(ProcessSelectionListener listener) {
        this.listeners.add(listener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GetVMListRunnable
    implements IRunnableWithProgress {
        private IStatus status;
        private IRunnableContext context;
        private List<? extends VmInfo> result;
        private HeapDumpProviderDescriptor provider;

        public GetVMListRunnable(HeapDumpProviderDescriptor provider, IRunnableContext context) {
            this.provider = provider;
            this.context = context;
        }

        public List<? extends VmInfo> getResult() {
            return this.result;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            this.status = this.doOperation(monitor);
        }

        private IStatus doOperation(IProgressMonitor monitor) {
            ProgressMonitorWrapper listener = new ProgressMonitorWrapper(monitor);
            try {
                this.result = this.provider.getHeapDumpProvider().getAvailableVMs((IProgressListener)listener);
                if (listener.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
            }
            catch (Exception e) {
                return ErrorHelper.createErrorStatus(e);
            }
            return Status.OK_STATUS;
        }

        public final IStatus run() {
            try {
                this.context.run(true, true, (IRunnableWithProgress)this);
            }
            catch (Exception e) {
                this.status = ErrorHelper.createErrorStatus(Messages.AcquireSnapshotAction_UnexpectedException, e);
            }
            if (!this.status.isOK() && this.status != Status.CANCEL_STATUS) {
                Logger.getLogger("org.eclipse.mat.ui").log(Level.INFO, MessageUtil.format((String)"Error getting list of VMs with [{0}] provider", (Object[])new Object[]{this.provider.getName()}), this.status.getException());
            }
            return this.status;
        }
    }

    static interface ProcessSelectionListener {
        public void processSelected(AnnotatedObjectArgumentsSet var1);
    }
}

