/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.panes;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.CommandLine;
import org.eclipse.mat.query.registry.QueryObjectLink;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.query.results.DisplayFileResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.actions.OpenHelpPageAction;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.ui.util.QueryContextMenu;
import org.eclipse.mat.util.HTMLUtils;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.actions.ActionFactory;

public class QueryTextResultPane
extends AbstractEditorPane
implements ISelectionProvider,
LocationListener {
    private Browser browser;
    private IStructuredSelection selection;
    private List<ISelectionChangedListener> listeners = Collections.synchronizedList(new ArrayList());
    QueryContextMenu contextMenu;
    QueryResult queryResult;
    private Menu menu;

    public void createPartControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new FillLayout());
        this.browser = new Browser(top, 0);
        this.browser.addLocationListener((LocationListener)this);
        this.contextMenu = new QueryContextMenu((AbstractEditorPane)this, new ContextProvider(null){

            public IContextObject getContext(Object obj) {
                return (IContextObject)obj;
            }
        });
    }

    public void initWithArgument(Object argument) {
        if (!(argument instanceof QueryResult)) {
            return;
        }
        this.queryResult = (QueryResult)argument;
        if (this.queryResult.getSubject() instanceof TextResult) {
            TextResult textResult = (TextResult)this.queryResult.getSubject();
            if (textResult.isHtml()) {
                this.browser.setText(textResult.getText());
            } else {
                String html = "<pre>" + HTMLUtils.escapeText((String)textResult.getText()) + "</pre>";
                this.browser.setText(html);
            }
        } else if (this.queryResult.getSubject() instanceof DisplayFileResult) {
            try {
                DisplayFileResult r = (DisplayFileResult)this.queryResult.getSubject();
                this.browser.setUrl(r.getFile().toURI().toURL().toExternalForm());
            }
            catch (MalformedURLException e) {
                ErrorHelper.logThrowableAndShowMessage(e);
            }
        } else {
            this.browser.setText(String.valueOf(this.queryResult.getSubject()));
        }
        this.firePropertyChange(1);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        if (this.queryResult.getQuery() != null && this.queryResult.getQuery().getHelpUrl() != null) {
            manager.appendToGroup("help", (IAction)new OpenHelpPageAction(this.queryResult.getQuery().getHelpUrl()));
        }
        super.contributeToToolBar(manager);
    }

    public void setFocus() {
        this.site.getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), null);
        this.site.getActionBars().updateActionBars();
        this.browser.setFocus();
    }

    public ISelection getSelection() {
        return this.selection != null ? this.selection : StructuredSelection.EMPTY;
    }

    public void changing(LocationEvent event) {
        QueryObjectLink url = QueryObjectLink.parse((String)event.location);
        if (url == null) {
            return;
        }
        switch (url.getType()) {
            case OBJECT: {
                this.onObjectLinkEvent(event, url);
                break;
            }
            case QUERY: {
                this.onQueryLinkEvent(event, url);
                break;
            }
        }
    }

    private void onObjectLinkEvent(LocationEvent event, QueryObjectLink url) {
        try {
            final int objectId = this.getEditor().getQueryContext().mapToObjectId(url.getTarget());
            if (objectId < 0) {
                return;
            }
            this.selection = new StructuredSelection((Object)new IContextObject(){

                public int getObjectId() {
                    return objectId;
                }
            });
            for (ISelectionChangedListener l : new ArrayList<ISelectionChangedListener>(this.listeners)) {
                l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
            }
            PopupMenu m = new PopupMenu();
            this.contextMenu.addContextActions(m, this.selection, null);
            if (this.menu != null && !this.menu.isDisposed()) {
                this.menu.dispose();
            }
            this.menu = m.createMenu(this.getEditorSite().getActionBars().getStatusLineManager(), (Control)this.browser);
            this.menu.setVisible(true);
            event.doit = false;
        }
        catch (Exception e) {
            ErrorHelper.logThrowableAndShowMessage(e, MessageUtil.format((String)Messages.QueryTextResultPane_UnableToMapAddress, (Object[])new Object[]{url.getTarget()}));
        }
    }

    private void onQueryLinkEvent(LocationEvent event, QueryObjectLink url) {
        try {
            ArgumentSet set = CommandLine.parse((IQueryContext)this.getQueryContext(), (String)url.getTarget());
            QueryExecution.execute(this.getEditor(), this.getPaneState(), null, set, false, true);
        }
        catch (SnapshotException e) {
            ErrorHelper.logThrowableAndShowMessage(e);
        }
        event.doit = false;
    }

    public void changed(LocationEvent event) {
    }

    public String getTitle() {
        return this.queryResult != null ? this.queryResult.getTitle() : Messages.QueryTextResultPane_Text;
    }

    public Image getTitleImage() {
        Image image = this.queryResult != null ? MemoryAnalyserPlugin.getDefault().getImage(this.queryResult.getQuery()) : null;
        return image != null ? image : MemoryAnalyserPlugin.getImage("icons/query_browser.gif");
    }

    public String getTitleToolTip() {
        return this.queryResult != null ? this.queryResult.getTitleToolTip() : null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        super.dispose();
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
    }
}

