/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot;

import java.io.File;
import java.io.Serializable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.SnapshotHistoryService;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public abstract class ParseHeapDumpJob
extends Job {
    private final IPath path;

    public ParseHeapDumpJob(IPath path) {
        super(MessageUtil.format((String)Messages.ParseHeapDumpJob_ParsingHeapDumpFrom, (Object[])new Object[]{path.toOSString()}));
        this.path = path;
        this.setUser(true);
        this.setRule(new ParseRule(path));
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.setProperty(IProgressConstants.PROPERTY_IN_DIALOG, Boolean.TRUE);
        try {
            SnapshotHistoryService.getInstance().addVisitedPath("org.eclipse.mat.ui.editors.HeapEditor", this.path.toOSString());
            final ISnapshot snapshot = SnapshotFactory.openSnapshot((File)this.path.toFile(), (IProgressListener)new ProgressMonitorWrapper(monitor));
            if (snapshot == null) {
                return Status.CANCEL_STATUS;
            }
            SnapshotInfo source = snapshot.getSnapshotInfo();
            SnapshotInfo destination = new SnapshotInfo(source.getPath(), source.getPrefix(), source.getJvmInfo(), source.getIdentifierSize(), source.getCreationDate(), source.getNumberOfObjects(), source.getNumberOfGCRoots(), source.getNumberOfClasses(), source.getNumberOfClassLoaders(), source.getUsedHeapSize());
            Serializable format = source.getProperty("$heapFormat");
            if (format != null) {
                destination.setProperty("$heapFormat", format);
            }
            SnapshotHistoryService.getInstance().addVisitedPath("org.eclipse.mat.ui.editors.HeapEditor", this.path.toOSString(), (Serializable)destination);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ParseHeapDumpJob.this.finished(snapshot);
                }
            });
            return Status.OK_STATUS;
        }
        catch (IProgressListener.OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (SnapshotException e) {
            return ErrorHelper.createErrorStatus(e);
        }
    }

    public boolean isModal() {
        Boolean isModal = (Boolean)this.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
        if (isModal == null) {
            return false;
        }
        return isModal;
    }

    protected abstract void finished(ISnapshot var1);

    class ParseRule
    implements ISchedulingRule {
        IPath path;

        public ParseRule(IPath filename) {
            this.path = filename;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof ParseRule && ((ParseRule)rule).path.equals((Object)this.path);
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return this.contains(rule);
        }
    }
}

