/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.snapshot.HeapObjectContextArgument;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.DetailResultProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IStructuredResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.CategoryDescriptor;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.AbstractPaneJob;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.browser.QueryBrowserPopup;
import org.eclipse.mat.ui.snapshot.actions.CopyActions;
import org.eclipse.mat.ui.util.Copy;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.IPolicy;
import org.eclipse.mat.ui.util.PaneState;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryContextMenu {
    private MultiPaneEditor editor;
    private List<ContextProvider> contextProvider;
    private List<DetailResultProvider> resultProvider;
    private QueryResult queryResult;
    private static final Pattern PATH_PATTERN = Pattern.compile("^[^ ]*\\.([A-Z][\\p{Alnum}$]([^ .])*.*)$");

    public QueryContextMenu(AbstractEditorPane pane, QueryResult result) {
        this(pane.getEditor(), result);
    }

    public QueryContextMenu(MultiPaneEditor editor, QueryResult result) {
        this.editor = editor;
        this.queryResult = result;
        if (!(result.getSubject() instanceof IStructuredResult)) {
            throw new UnsupportedOperationException(Messages.QueryContextMenu_SubjectMustBeOfType);
        }
        this.resultProvider = result.getResultMetaData().getDetailResultProviders();
        this.contextProvider = result.getResultMetaData().getContextProviders();
        if (this.contextProvider.isEmpty()) {
            this.contextProvider = new ArrayList<ContextProvider>(1);
            this.contextProvider.add(result.getDefaultContextProvider());
        }
    }

    public QueryContextMenu(MultiPaneEditor editor, ContextProvider provider) {
        this.editor = editor;
        this.resultProvider = new ArrayList<DetailResultProvider>(0);
        this.contextProvider = new ArrayList<ContextProvider>(1);
        this.contextProvider.add(provider);
    }

    public QueryContextMenu(AbstractEditorPane pane, ContextProvider provider) {
        this(pane.getEditor(), provider);
    }

    public final void addContextActions(PopupMenu manager, IStructuredSelection selection, Control control) {
        if (selection.isEmpty()) {
            return;
        }
        this.resultMenu(manager, selection);
        String label = null;
        for (ContextProvider p : this.contextProvider) {
            ArrayList<IContextObject> menuContext = new ArrayList<IContextObject>();
            for (Object selected : selection) {
                IContextObject ctx = p.getContext(selected);
                if (ctx == null) continue;
                menuContext.add(ctx);
            }
            if (menuContext.isEmpty()) continue;
            PopupMenu menu = manager;
            String menuLabel = p.getLabel();
            if (menuLabel != null) {
                menu = new PopupMenu(menuLabel);
                manager.add(menu);
            }
            if (label == null) {
                label = this.getLabel(selection);
            }
            this.queryMenu(menu, menuContext, label);
            this.systemMenu(menu, control);
            this.customMenu(menu, menuContext, p, label);
        }
    }

    private String getLabel(IStructuredSelection selection) {
        Column col;
        IStructuredResult result;
        Object value;
        String label = this.queryResult == null ? Messages.QueryContextMenu_context : (selection.size() == 1 ? ((value = (result = (IStructuredResult)this.queryResult.getSubject()).getColumnValue(selection.getFirstElement(), 0)) == null ? MessageUtil.format((String)Messages.QueryContextMenu_selectionOf, (Object[])new Object[]{this.queryResult.getQuery() != null ? this.queryResult.getQuery().getName() : this.queryResult.getCommand()}) : ((col = result.getColumns()[0]).getFormatter() != null ? MessageUtil.format((String)Messages.QueryContextMenu_selectionOf, (Object[])new Object[]{"'" + col.getFormatter().format(value) + "'"}) : MessageUtil.format((String)Messages.QueryContextMenu_selectionOf, (Object[])new Object[]{"'" + QueryContextMenu.fixLabel(String.valueOf(value)) + "'"}))) : (this.queryResult.getQuery() != null ? MessageUtil.format((String)Messages.QueryContextMenu_selectionOf, (Object[])new Object[]{this.queryResult.getQuery().getName()}) : MessageUtil.format((String)Messages.QueryContextMenu_selectionOf, (Object[])new Object[]{this.queryResult.getCommand()})));
        return label;
    }

    private void resultMenu(PopupMenu menu, IStructuredSelection selection) {
        if (selection.size() == 1) {
            boolean hasContextResultProviderMenu = false;
            for (final DetailResultProvider r : this.resultProvider) {
                Object firstElement;
                boolean hasResult = r.hasResult(firstElement = selection.getFirstElement());
                if (!hasResult) continue;
                final PaneState originator = this.editor.getActiveEditor().getPaneState();
                menu.add(new Action(r.getLabel()){

                    public void run() {
                        new AbstractPaneJob(MessageUtil.format((String)Messages.QueryContextMenu_Processing, (Object[])new Object[]{r.getLabel()}), null){

                            protected IStatus doRun(IProgressMonitor monitor) {
                                try {
                                    IResult result = r.getResult(firstElement, (IProgressListener)new ProgressMonitorWrapper(monitor));
                                    QueryResult qr = new QueryResult(null, MessageUtil.format((String)Messages.QueryContextMenu_Details, (Object[])new Object[]{r.getLabel()}), result);
                                    QueryExecution.displayResult(QueryContextMenu.this.editor, originator, null, qr, false);
                                    return Status.OK_STATUS;
                                }
                                catch (SnapshotException e) {
                                    return ErrorHelper.createErrorStatus(e);
                                }
                            }
                        }.schedule();
                    }
                });
                hasContextResultProviderMenu = true;
            }
            if (hasContextResultProviderMenu) {
                menu.addSeparator();
            }
        }
    }

    private void queryMenu(PopupMenu menu, List<IContextObject> menuContext, String label) {
        final Policy policy = new Policy(menuContext, label);
        this.addCategories(menu, QueryRegistry.instance().getRootCategory(), menuContext, label, policy);
        Action queryBrowser = new Action(Messages.QueryDropDownMenuAction_SearchQueries){

            public void run() {
                new QueryBrowserPopup(QueryContextMenu.this.editor, false, policy).open();
            }
        };
        queryBrowser.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/query_browser.gif"));
        queryBrowser.setToolTipText(Messages.QueryDropDownMenuAction_SeachQueriesByName);
        queryBrowser.setActionDefinitionId("org.eclipse.mat.ui.query.browser.QueryBrowser2");
        menu.add(queryBrowser);
    }

    private void addCategories(PopupMenu menu, CategoryDescriptor root, List<IContextObject> menuContext, String label, IPolicy policy) {
        for (Object item : root.getChildren()) {
            QueryDescriptor query;
            if (item instanceof CategoryDescriptor) {
                CategoryDescriptor sub = (CategoryDescriptor)item;
                PopupMenu subManager = new PopupMenu(sub.getName());
                menu.add(subManager);
                this.addCategories(subManager, sub, menuContext, label, policy);
                continue;
            }
            if (!(item instanceof QueryDescriptor) || !policy.accept(query = (QueryDescriptor)item)) continue;
            menu.add(new QueryAction(this.editor, query, policy));
        }
    }

    private void systemMenu(PopupMenu menu, final Control control) {
        if (control == null) {
            return;
        }
        try {
            ResourceBundle rb = ResourceBundle.getBundle(String.valueOf(CopyActions.Address.class.getPackage().getName()) + ".annotations", Locale.getDefault(), CopyActions.Address.class.getClassLoader());
            String value = rb.getString(String.valueOf(CopyActions.Address.class.getSimpleName()) + ".category");
            int position = value.indexOf("|");
            String menuName = position < 0 ? value : value.substring(position + 1);
            Action copySelectionAction = new Action(){

                public String getText() {
                    return Messages.QueryContextMenu_Selection;
                }

                public void run() {
                    Copy.copyToClipboard(control);
                }
            };
            copySelectionAction.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/copy.gif"));
            copySelectionAction.setToolTipText(Messages.QueryContextMenu_CopySelectionToTheClipboard);
            menu.getChildMenu(menuName).add(copySelectionAction);
        }
        catch (MissingResourceException e) {
            ErrorHelper.logThrowable(e);
        }
    }

    protected void customMenu(PopupMenu menu, List<IContextObject> menuContext, ContextProvider provider, String label) {
    }

    private static String fixLabel(String label) {
        Matcher matcher = PATH_PATTERN.matcher(label);
        label = matcher.matches() ? matcher.group(1) : label;
        return label.length() > 100 ? String.valueOf(label.substring(0, 100)) + "..." : label;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Policy
    implements IPolicy {
        private final boolean multiRowSelection;
        private final boolean multiObjectSelection;
        private Class<? extends IContextObject> type;
        private List<IContextObject> context;
        private String label;

        public Policy(List<IContextObject> menuContext, String selectionLabel) {
            this.multiRowSelection = menuContext.size() > 1;
            this.multiObjectSelection = this.multiRowSelection || menuContext.get(0) instanceof IContextObjectSet;
            this.type = IContextObjectSet.class;
            for (IContextObject obj : menuContext) {
                if (IContextObjectSet.class.isAssignableFrom(obj.getClass())) continue;
                this.type = IContextObject.class;
                break;
            }
            this.context = menuContext;
            this.label = selectionLabel;
        }

        @Override
        public boolean accept(QueryDescriptor query) {
            boolean heapObjectArgExists = false;
            boolean heapObjectArgIsMultiple = false;
            boolean contextObjectArgExists = false;
            boolean contextObjectArgIsMultiple = false;
            for (ArgumentDescriptor argument : query.getArguments()) {
                if (this.isHeapObject(argument)) {
                    heapObjectArgExists = true;
                    heapObjectArgIsMultiple = heapObjectArgIsMultiple || argument.isMultiple() || IHeapObjectArgument.class.isAssignableFrom(argument.getType());
                    continue;
                }
                if (!argument.getType().isAssignableFrom(this.type)) continue;
                contextObjectArgExists = true;
                boolean bl = contextObjectArgIsMultiple = contextObjectArgIsMultiple || argument.isMultiple();
            }
            if (!heapObjectArgExists && !contextObjectArgExists) {
                return false;
            }
            if (heapObjectArgExists && !heapObjectArgIsMultiple && this.multiObjectSelection) {
                return false;
            }
            return !contextObjectArgExists || contextObjectArgIsMultiple || !this.multiRowSelection;
        }

        private boolean isHeapObject(ArgumentDescriptor argument) {
            Class argType = argument.getType();
            if (argType.isAssignableFrom(Integer.TYPE) && argument.getAdvice() == Argument.Advice.HEAP_OBJECT) {
                return true;
            }
            if (argType.isAssignableFrom(IObject.class)) {
                return true;
            }
            return argType.isAssignableFrom(IHeapObjectArgument.class);
        }

        @Override
        public void fillInObjectArguments(ISnapshot snapshot, QueryDescriptor query, ArgumentSet set) {
            Class<Integer> intClass = Integer.TYPE;
            for (ArgumentDescriptor argument : query.getArguments()) {
                if (intClass.isAssignableFrom(argument.getType()) && argument.getAdvice() == Argument.Advice.HEAP_OBJECT || IObject.class.isAssignableFrom(argument.getType()) || IHeapObjectArgument.class.isAssignableFrom(argument.getType())) {
                    set.setArgumentValue(argument, (Object)new HeapObjectContextArgument(snapshot, this.context, this.label));
                    continue;
                }
                if (IContextObjectSet.class.isAssignableFrom(argument.getType())) {
                    if (argument.isMultiple()) {
                        set.setArgumentValue(argument, this.context);
                        continue;
                    }
                    set.setArgumentValue(argument, (Object)this.context.get(0));
                    continue;
                }
                if (!IContextObject.class.isAssignableFrom(argument.getType())) continue;
                if (argument.isMultiple()) {
                    set.setArgumentValue(argument, this.context);
                    continue;
                }
                set.setArgumentValue(argument, (Object)this.context.get(0));
            }
        }
    }

    private static final class QueryAction
    extends Action {
        MultiPaneEditor editor;
        QueryDescriptor query;
        IPolicy policy;

        public QueryAction(MultiPaneEditor editor, QueryDescriptor query, IPolicy policy) {
            super(query.getName());
            this.editor = editor;
            this.query = query;
            this.policy = policy;
            this.setToolTipText(query.getShortDescription());
            this.setImageDescriptor(MemoryAnalyserPlugin.getDefault().getImageDescriptor(query));
        }

        public void run() {
            try {
                ISnapshot snapshot = (ISnapshot)this.editor.getQueryContext().get(ISnapshot.class, null);
                ArgumentSet set = this.query.createNewArgumentSet(this.editor.getQueryContext());
                this.policy.fillInObjectArguments(snapshot, this.query, set);
                QueryExecution.execute(this.editor, this.editor.getActiveEditor().getPaneState(), null, set, !this.query.isShallow(), false);
            }
            catch (SnapshotException e) {
                ErrorHelper.logThrowableAndShowMessage(e);
            }
        }
    }
}

