/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.dtfj;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageStackFrame;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.icu.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.dtfj.DTFJIndexBuilder;
import org.eclipse.mat.dtfj.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.snapshot.extension.IThreadDetailsResolver;
import org.eclipse.mat.snapshot.extension.IThreadInfo;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.IProgressListener;

class ThreadDetailsResolver1
implements IThreadDetailsResolver {
    DecimalFormat hex = new DecimalFormat(){
        private static final long serialVersionUID = -420084952258370133L;

        public StringBuffer format(long val, StringBuffer buf, FieldPosition fieldPosition) {
            fieldPosition.setBeginIndex(buf.length());
            buf.append("0x").append(Long.toHexString(val));
            fieldPosition.setEndIndex(buf.length());
            return buf;
        }

        public StringBuffer format(double val, StringBuffer buf, FieldPosition fieldPosition) {
            return this.format((long)val, buf, fieldPosition);
        }
    };

    ThreadDetailsResolver1() {
    }

    public Column[] getColumns() {
        return new Column[]{new Column(Messages.ThreadDetailsResolver_DTFJ_Name), new Column(Messages.ThreadDetailsResolver_JNIEnv, Long.class).noTotals().formatting((Format)this.hex), new Column(Messages.ThreadDetailsResolver_Priority, Integer.class).noTotals(), new Column(Messages.ThreadDetailsResolver_State), new Column(Messages.ThreadDetailsResolver_State_value, Integer.class).noTotals().formatting((Format)this.hex), new Column(Messages.ThreadDetailsResolver_Native_id)};
    }

    public void complementShallow(IThreadInfo thread, IProgressListener listener) throws SnapshotException {
        JavaThread jt = this.getJavaThread(thread, listener);
        if (jt != null) {
            Column[] cols = this.getColumns();
            try {
                thread.setValue(cols[0], (Object)jt.getName());
            }
            catch (CorruptDataException corruptDataException) {}
            try {
                ImagePointer ip = jt.getJNIEnv();
                if (ip != null) {
                    thread.setValue(cols[1], (Object)ip.getAddress());
                }
            }
            catch (CorruptDataException corruptDataException) {}
            try {
                thread.setValue(cols[2], (Object)jt.getPriority());
            }
            catch (CorruptDataException corruptDataException) {}
            try {
                int state = jt.getState();
                String stateName = this.printableState(state);
                thread.setValue(cols[3], (Object)stateName);
                thread.setValue(cols[4], (Object)state);
            }
            catch (CorruptDataException corruptDataException) {}
            try {
                ImageThread it = jt.getImageThread();
                String id = it.getID();
                thread.setValue(cols[5], (Object)id);
            }
            catch (DataUnavailable dataUnavailable) {
            }
            catch (CorruptDataException corruptDataException) {}
        }
    }

    private String printableState(int state) {
        ArrayList<String> al = new ArrayList<String>();
        if ((state & 1) != 0) {
            al.add(Messages.ThreadDetailsResolver_alive);
        }
        if ((state & 0x400) != 0) {
            al.add(Messages.ThreadDetailsResolver_blocked_on_monitor_enter);
        }
        if ((state & 0x400000) != 0) {
            al.add(Messages.ThreadDetailsResolver_in_native);
        }
        if ((state & 0x100) != 0) {
            al.add(Messages.ThreadDetailsResolver_in_object_wait);
        }
        if ((state & 0x200000) != 0) {
            al.add(Messages.ThreadDetailsResolver_interrupted);
        }
        if ((state & 0x200) != 0) {
            al.add(Messages.ThreadDetailsResolver_parked);
        }
        if ((state & 4) != 0) {
            al.add(Messages.ThreadDetailsResolver_runnable);
        }
        if ((state & 0x40) != 0) {
            al.add(Messages.ThreadDetailsResolver_sleeping);
        }
        if ((state & 0x100000) != 0) {
            al.add(Messages.ThreadDetailsResolver_suspended);
        }
        if ((state & 2) != 0) {
            al.add(Messages.ThreadDetailsResolver_terminated);
        }
        if ((state & 0x10000000) != 0) {
            al.add(Messages.ThreadDetailsResolver_vendor1);
        }
        if ((state & 0x20000000) != 0) {
            al.add(Messages.ThreadDetailsResolver_vendor2);
        }
        if ((state & 0x40000000) != 0) {
            al.add(Messages.ThreadDetailsResolver_vendor3);
        }
        if ((state & 0x80) != 0) {
            al.add(Messages.ThreadDetailsResolver_waiting);
        }
        if ((state & 0x10) != 0) {
            al.add(Messages.ThreadDetailsResolver_waiting_indefinitely);
        }
        if ((state & 0x20) != 0) {
            al.add(Messages.ThreadDetailsResolver_waiting_with_timeout);
        }
        return al.toString();
    }

    private JavaThread getJavaThread(IThreadInfo thread, IProgressListener listener) throws SnapshotException {
        IObject object = thread.getThreadObject();
        JavaRuntime jr = (JavaRuntime)object.getSnapshot().getSnapshotAddons(JavaRuntime.class);
        if (jr != null) {
            Iterator it = jr.getThreads();
            while (it.hasNext()) {
                JavaThread jt;
                long addr;
                Object o = it.next();
                if (!(o instanceof JavaThread) || (addr = DTFJIndexBuilder.getThreadAddress(jt = (JavaThread)o, listener)) != object.getObjectAddress()) continue;
                return jt;
            }
        }
        return null;
    }

    public void complementDeep(IThreadInfo thread, IProgressListener listener) throws SnapshotException {
        this.complementShallow(thread, listener);
        JavaThread jt = this.getJavaThread(thread, listener);
        if (jt != null) {
            try {
                ImageThread it = jt.getImageThread();
                StringBuilder sb = new StringBuilder();
                Iterator sfs = it.getStackFrames();
                while (sfs.hasNext()) {
                    Object o = sfs.next();
                    if (!(o instanceof ImageStackFrame)) continue;
                    ImageStackFrame sf = (ImageStackFrame)o;
                    try {
                        sb.append(sf.getProcedureName());
                    }
                    catch (CorruptDataException e) {
                        sb.append(e.toString());
                    }
                    sb.append('\n');
                }
                TextResult tr = new TextResult(sb.toString());
                thread.addDetails(Messages.ThreadDetailsResolver_Native_stack, (IResult)tr);
            }
            catch (DataUnavailable dataUnavailable) {
            }
            catch (CorruptDataException corruptDataException) {}
        }
    }
}

