/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.index;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayIntCompressed;
import org.eclipse.mat.collect.ArrayLongCompressed;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexWriter;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.io.SimpleBufferedRandomAccessInputStream;

public abstract class IndexReader {
    public static final boolean DEBUG = false;

    static class InboundReader
    extends IntIndex1NSortedReader
    implements IIndexReader.IOne2ManyObjectsIndex {
        public InboundReader(File indexFile) throws IOException {
            super(indexFile);
        }

        public InboundReader(File indexFile, IIndexReader.IOne2OneIndex header, IIndexReader.IOne2OneIndex body) throws IOException {
            super(indexFile, header, body);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getObjectsOf(Serializable key) throws SnapshotException, IOException {
            if (key == null) {
                return new int[0];
            }
            if (key instanceof long[]) {
                long[] pos = (long[])key;
                InboundReader inboundReader = this;
                synchronized (inboundReader) {
                    return this.body.getNext(pos[0], (int)pos[1]);
                }
            }
            int[] pos = (int[])key;
            InboundReader inboundReader = this;
            synchronized (inboundReader) {
                return this.body.getNext(pos[0], pos[1]);
            }
        }
    }

    static class IntIndex1NReader
    implements IIndexReader.IOne2ManyIndex {
        File indexFile;
        SimpleBufferedRandomAccessInputStream in;
        IntIndexReader header;
        IntIndexReader body;

        public IntIndex1NReader(File indexFile) throws IOException {
            try {
                this.indexFile = indexFile;
                this.open();
                long indexLength = indexFile.length();
                this.in.seek(indexLength - 8L);
                long divider = this.in.readLong();
                this.header = new PositionIndexReader(this.in, divider, indexLength - divider - 8L);
                this.body = new IntIndexReader(this.in, 0L, divider);
                this.body.LOCK = this.header.LOCK;
            }
            catch (RuntimeException e) {
                this.close();
                throw e;
            }
        }

        public IntIndex1NReader(File indexFile, IIndexReader.IOne2OneIndex header, IIndexReader.IOne2OneIndex body) {
            this.indexFile = indexFile;
            this.header = (IntIndexReader)header;
            this.body = (IntIndexReader)body;
            this.body.LOCK = this.header.LOCK;
            this.open();
        }

        public int[] get(int index) {
            long p = this.header.getPos(index);
            int length = this.body.get(p);
            return this.body.getNext(p + 1L, length);
        }

        protected synchronized void open() {
            try {
                if (this.in == null) {
                    this.in = new SimpleBufferedRandomAccessInputStream(new RandomAccessFile(this.indexFile, "r"));
                    if (this.header != null) {
                        this.header.in = this.in;
                    }
                    if (this.body != null) {
                        this.body.in = this.in;
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public synchronized void close() {
            this.header.unload();
            this.body.unload();
            if (this.in != null) {
                try {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        this.in = null;
                        if (this.header != null) {
                            this.header.in = null;
                        }
                        if (this.body != null) {
                            this.body.in = null;
                        }
                    }
                }
                finally {
                    this.in = null;
                    if (this.header != null) {
                        this.header.in = null;
                    }
                    if (this.body != null) {
                        this.body.in = null;
                    }
                }
            }
        }

        public void unload() throws IOException {
            this.header.unload();
            this.body.unload();
        }

        public int size() {
            return this.header.size();
        }

        public void delete() {
            this.close();
            if (this.indexFile != null) {
                this.indexFile.delete();
            }
        }
    }

    public static class IntIndex1NSortedReader
    extends IntIndex1NReader {
        public IntIndex1NSortedReader(File indexFile) throws IOException {
            super(indexFile);
        }

        public IntIndex1NSortedReader(File indexFile, IIndexReader.IOne2OneIndex header, IIndexReader.IOne2OneIndex body) throws IOException {
            super(indexFile, header, body);
        }

        public int[] get(int index) {
            long p1;
            long p0;
            if (index + 1 < this.header.size()) {
                p0 = this.header.getPos(index++);
                p1 = this.header.getPos(index);
                if (p0 == 0L) {
                    return new int[0];
                }
                ++index;
                while (p1 < p0 && index < this.header.size()) {
                    p1 = this.header.getPos(index);
                    ++index;
                }
                if (p1 < p0) {
                    p1 = this.body.size + 1L;
                }
            } else {
                p0 = this.header.getPos(index);
                if (p0 == 0L) {
                    return new int[0];
                }
                p1 = this.body.size + 1L;
            }
            return this.body.getNext(p0 - 1L, (int)(p1 - p0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntIndexReader
    extends IndexWriter.IntIndex<SoftReference<ArrayIntCompressed>>
    implements IIndexReader.IOne2OneIndex {
        public Object LOCK = new Object();
        File indexFile;
        public SimpleBufferedRandomAccessInputStream in;
        long[] pageStart;

        IntIndexReader(File indexFile, IndexWriter.Pages<SoftReference<ArrayIntCompressed>> pages, long size, int pageSize, long[] pageStart) {
            this.size = size;
            this.pageSize = pageSize;
            this.pages = pages;
            this.indexFile = indexFile;
            this.pageStart = pageStart;
            if (indexFile != null) {
                this.open();
            }
        }

        public IntIndexReader(File indexFile, IndexWriter.Pages<SoftReference<ArrayIntCompressed>> pages, int size, int pageSize, long[] pageStart) {
            this(indexFile, pages, (long)size, pageSize, pageStart);
        }

        public IntIndexReader(File indexFile) throws IOException {
            this(new SimpleBufferedRandomAccessInputStream(new RandomAccessFile(indexFile, "r")), 0L, indexFile.length());
            this.indexFile = indexFile;
        }

        public IntIndexReader(SimpleBufferedRandomAccessInputStream in, long start, long length) throws IOException {
            int pages;
            this.in = in;
            this.in.seek(start + length - 16L);
            long lastOffset = this.in.readLong();
            int pageSize = this.in.readInt();
            int size = this.in.readInt();
            if (size >= 0) {
                this.init(size, pageSize);
                pages = size / pageSize + (size % pageSize > 0 ? 2 : 1);
            } else {
                pages = (int)((start + length - 8L - lastOffset) / 8L);
                long sizeL = ((long)pages - 2L) * (long)pageSize - (long)size;
                this.init(sizeL, pageSize);
            }
            this.pageStart = new long[pages];
            this.in.seek(start + length - 8L - (long)(this.pageStart.length * 8));
            this.in.readLongArray(this.pageStart);
        }

        private synchronized void open() {
            try {
                if (this.in != null) {
                    return;
                }
                if (this.indexFile == null) {
                    throw new IOException(Messages.IndexReader_Error_IndexIsEmbedded);
                }
                this.in = new SimpleBufferedRandomAccessInputStream(new RandomAccessFile(this.indexFile, "r"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public synchronized void close() {
            this.unload();
            if (this.in != null) {
                try {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        this.in = null;
                    }
                }
                finally {
                    this.in = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ArrayIntCompressed getPage(int page) {
            ArrayIntCompressed array;
            SoftReference ref = (SoftReference)this.pages.get(page);
            ArrayIntCompressed arrayIntCompressed = array = ref == null ? null : (ArrayIntCompressed)ref.get();
            if (array == null) {
                Object object = this.LOCK;
                synchronized (object) {
                    ref = (SoftReference)this.pages.get(page);
                    ArrayIntCompressed arrayIntCompressed2 = array = ref == null ? null : (ArrayIntCompressed)ref.get();
                    if (array == null) {
                        try {
                            byte[] buffer = null;
                            this.in.seek(this.pageStart[page]);
                            buffer = new byte[(int)(this.pageStart[page + 1] - this.pageStart[page])];
                            if (this.in.read(buffer) != buffer.length) {
                                throw new IOException();
                            }
                            array = new ArrayIntCompressed(buffer);
                            IndexWriter.Pages pages = this.pages;
                            synchronized (pages) {
                                this.pages.put(page, new SoftReference<ArrayIntCompressed>(array));
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            return array;
        }

        @Override
        public void delete() {
            this.close();
            if (this.indexFile != null) {
                this.indexFile.delete();
            }
        }
    }

    public static class LongIndex1NReader
    implements IIndexReader {
        File indexFile;
        SimpleBufferedRandomAccessInputStream in;
        IntIndexReader header;
        LongIndexReader body;

        public LongIndex1NReader(File indexFile) throws IOException {
            this.indexFile = indexFile;
            this.open();
            long indexLength = indexFile.length();
            this.in.seek(indexLength - 8L);
            long divider = this.in.readLong();
            this.header = new IntIndexReader(this.in, divider, indexLength - divider - 8L);
            this.body = new LongIndexReader(this.in, 0L, divider);
            this.body.LOCK = this.header.LOCK;
        }

        public long[] get(int index) {
            int p = this.header.get(index);
            if (p == 0) {
                return new long[0];
            }
            int length = (int)this.body.get(p - 1);
            return this.body.getNext(p, length);
        }

        protected synchronized void open() {
            try {
                if (this.in == null) {
                    this.in = new SimpleBufferedRandomAccessInputStream(new RandomAccessFile(this.indexFile, "r"));
                    if (this.header != null) {
                        this.header.in = this.in;
                    }
                    if (this.body != null) {
                        this.body.in = this.in;
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public synchronized void close() {
            this.unload();
            if (this.in != null) {
                try {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        this.body.in = null;
                        this.header.in = null;
                        this.in = null;
                    }
                }
                finally {
                    this.body.in = null;
                    this.header.in = null;
                    this.in = null;
                }
            }
        }

        public void unload() {
            this.header.unload();
            this.body.unload();
        }

        public int size() {
            return this.header.size();
        }

        public void delete() {
            this.close();
            if (this.indexFile != null) {
                this.indexFile.delete();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongIndexReader
    extends IndexWriter.LongIndex
    implements IIndexReader.IOne2LongIndex {
        Object LOCK = new Object();
        File indexFile;
        SimpleBufferedRandomAccessInputStream in;
        long[] pageStart;

        public LongIndexReader(File indexFile, HashMapIntObject<Object> pages, int size, int pageSize, long[] pageStart) throws IOException {
            this.size = size;
            this.pageSize = pageSize;
            this.pages = pages;
            this.indexFile = indexFile;
            this.pageStart = pageStart;
            this.open();
        }

        public LongIndexReader(File indexFile) throws IOException {
            this(new SimpleBufferedRandomAccessInputStream(new RandomAccessFile(indexFile, "r")), 0L, indexFile.length());
            this.indexFile = indexFile;
            this.open();
        }

        protected LongIndexReader(SimpleBufferedRandomAccessInputStream in, long start, long length) throws IOException {
            this.in = in;
            this.in.seek(start + length - 8L);
            int pageSize = this.in.readInt();
            int size = this.in.readInt();
            this.init(size, pageSize);
            int pages = size / pageSize + (size % pageSize > 0 ? 2 : 1);
            this.pageStart = new long[pages];
            this.in.seek(start + length - 8L - (long)(this.pageStart.length * 8));
            this.in.readLongArray(this.pageStart);
        }

        private synchronized void open() throws IOException {
            if (this.in != null) {
                return;
            }
            if (this.indexFile == null) {
                throw new IOException(Messages.IndexReader_Error_IndexIsEmbedded);
            }
            this.in = new SimpleBufferedRandomAccessInputStream(new RandomAccessFile(this.indexFile, "r"));
        }

        @Override
        public synchronized void close() {
            this.unload();
            if (this.in != null) {
                try {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        this.in = null;
                    }
                }
                finally {
                    this.in = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ArrayLongCompressed getPage(int page) {
            ArrayLongCompressed array;
            SoftReference ref = (SoftReference)this.pages.get(page);
            ArrayLongCompressed arrayLongCompressed = array = ref == null ? null : (ArrayLongCompressed)ref.get();
            if (array == null) {
                Object object = this.LOCK;
                synchronized (object) {
                    ref = (SoftReference)this.pages.get(page);
                    ArrayLongCompressed arrayLongCompressed2 = array = ref == null ? null : (ArrayLongCompressed)ref.get();
                    if (array == null) {
                        try {
                            byte[] buffer = null;
                            this.in.seek(this.pageStart[page]);
                            buffer = new byte[(int)(this.pageStart[page + 1] - this.pageStart[page])];
                            if (this.in.read(buffer) != buffer.length) {
                                throw new IOException();
                            }
                            array = new ArrayLongCompressed(buffer);
                            HashMapIntObject hashMapIntObject = this.pages;
                            synchronized (hashMapIntObject) {
                                this.pages.put(page, new SoftReference<ArrayLongCompressed>(array));
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            return array;
        }

        @Override
        public void delete() {
            this.close();
            if (this.indexFile != null) {
                this.indexFile.delete();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PositionIndexReader
    extends IntIndexReader {
        public PositionIndexReader(File indexFile) throws IOException {
            super(indexFile);
        }

        public PositionIndexReader(SimpleBufferedRandomAccessInputStream in, long start, long length) throws IOException {
            super(in, start, length);
        }

        public PositionIndexReader(File indexFile, IndexWriter.Pages<SoftReference<ArrayIntCompressed>> pages, int size, int pageSize, long[] pageStart) {
            super(indexFile, pages, (long)size, pageSize, pageStart);
        }

        @Override
        long getPos(int index) {
            int page = this.page(index);
            int offset = this.offset(index);
            IndexWriter.ArrayIntLongCompressed a = this.getPage(page);
            return a.getPos(offset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected IndexWriter.ArrayIntLongCompressed getPage(int page) {
            ArrayIntCompressed array;
            SoftReference ref = (SoftReference)this.pages.get(page);
            ArrayIntCompressed arrayIntCompressed = array = ref == null ? null : (ArrayIntCompressed)ref.get();
            if (array instanceof IndexWriter.ArrayIntLongCompressed) {
                return (IndexWriter.ArrayIntLongCompressed)array;
            }
            Object object = this.LOCK;
            synchronized (object) {
                if (array == null) {
                    array = super.getPage(page);
                }
                IndexWriter.ArrayIntLongCompressed ret = new IndexWriter.ArrayIntLongCompressed(array);
                IndexWriter.Pages pages = this.pages;
                synchronized (pages) {
                    this.pages.put(page, new SoftReference<IndexWriter.ArrayIntLongCompressed>(ret));
                }
                return ret;
            }
        }
    }

    public static class SizeIndexReader
    implements IIndexReader.IOne2SizeIndex {
        private IIndexReader.IOne2OneIndex idx;

        public SizeIndexReader(File indexFile) throws IOException {
            this(new IntIndexReader(indexFile));
        }

        public SizeIndexReader(IIndexReader.IOne2OneIndex idx) {
            this.idx = idx;
        }

        public long getSize(int index) {
            return IndexWriter.SizeIndexCollectorUncompressed.expand(this.get(index));
        }

        public int get(int index) {
            return this.idx.get(index);
        }

        public int[] getAll(int[] index) {
            return this.idx.getAll(index);
        }

        public int[] getNext(int index, int length) {
            return this.idx.getNext(index, length);
        }

        public void close() throws IOException {
            this.idx.close();
        }

        public void delete() {
            this.idx.delete();
        }

        public int size() {
            return this.idx.size();
        }

        public void unload() throws IOException {
            this.idx.unload();
        }
    }
}

