/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayUtils;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexManager;
import org.eclipse.mat.parser.index.IndexWriter;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.SnapshotImpl;
import org.eclipse.mat.parser.internal.util.IntStack;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.SimpleMonitor;

public class DominatorTree {
    public static void calculate(SnapshotImpl snapshot, IProgressListener listener) throws SnapshotException, IOException {
        new Calculator(snapshot, listener).compute();
    }

    static class Calculator {
        SnapshotImpl snapshot;
        SimpleMonitor monitor;
        IIndexReader.IOne2ManyIndex inboundIndex;
        IIndexReader.IOne2ManyIndex outboundIndex;
        int[] gcRootsArray;
        private BitField gcRootsSet;
        int[] bucket;
        private int r;
        private int n;
        private int[] dom;
        private int[] parent;
        private int[] anchestor;
        private int[] vertex;
        private int[] label;
        private int[] semi;
        private static int ROOT_VALUE = -1;
        private static int[] ROOT_VALUE_ARR = new int[]{ROOT_VALUE};

        public Calculator(SnapshotImpl snapshot, IProgressListener listener) throws SnapshotException {
            this.snapshot = snapshot;
            this.inboundIndex = snapshot.getIndexManager().inbound();
            this.outboundIndex = snapshot.getIndexManager().outbound();
            this.monitor = new SimpleMonitor(Messages.DominatorTree_CalculatingDominatorTree, listener, new int[]{300, 300, 200, 200, 200});
            this.gcRootsArray = snapshot.getGCRoots();
            this.gcRootsSet = new BitField(snapshot.getSnapshotInfo().getNumberOfObjects());
            int[] nArray = this.gcRootsArray;
            int n = this.gcRootsArray.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                this.gcRootsSet.set(id);
                ++n2;
            }
            IndexManager manager = this.snapshot.getIndexManager();
            try {
                manager.a2size().unload();
                manager.o2address().unload();
                manager.o2class().unload();
            }
            catch (IOException e) {
                throw new SnapshotException((Throwable)e);
            }
            this.n = snapshot.getSnapshotInfo().getNumberOfObjects() + 1;
            this.r = 1;
            this.dom = new int[this.n + 1];
            this.parent = new int[this.n + 1];
            this.anchestor = new int[this.n + 1];
            this.vertex = new int[this.n + 1];
            this.label = new int[this.n + 1];
            this.semi = new int[this.n + 1];
            this.bucket = new int[this.n + 1];
            Arrays.fill(this.bucket, -1);
        }

        public void compute() throws IOException, SnapshotException, IProgressListener.OperationCanceledException {
            int w;
            IProgressListener progressListener0 = this.monitor.nextMonitor();
            progressListener0.beginTask(Messages.DominatorTree_DominatorTreeCalculation, 3);
            this.n = 0;
            this.dfs(this.r);
            this.snapshot.getIndexManager().outbound().unload();
            IProgressListener progressListener = this.monitor.nextMonitor();
            progressListener.beginTask(Messages.DominatorTree_ComputingDominators, this.n / 1000);
            int i = this.n;
            while (i >= 2) {
                int v;
                w = this.vertex[i];
                int[] nArray = this.getPredecessors(w);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int u;
                    v = nArray[n2];
                    if ((v += 2) >= 0 && this.semi[u = this.eval(v)] < this.semi[w]) {
                        this.semi[w] = this.semi[u];
                    }
                    ++n2;
                }
                this.bucket[w] = this.bucket[this.vertex[this.semi[w]]];
                this.bucket[this.vertex[this.semi[w]]] = w;
                this.link(this.parent[w], w);
                v = this.bucket[this.parent[w]];
                while (v != -1) {
                    int u = this.eval(v);
                    this.dom[v] = this.semi[u] < this.semi[v] ? u : this.parent[w];
                    v = this.bucket[v];
                }
                this.bucket[this.parent[w]] = -1;
                if (i % 1000 == 0) {
                    if (progressListener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    progressListener.worked(1);
                }
                --i;
            }
            i = 2;
            while (i <= this.n) {
                w = this.vertex[i];
                if (this.dom[w] != this.vertex[this.semi[w]]) {
                    this.dom[w] = this.dom[this.dom[w]];
                }
                ++i;
            }
            this.dom[this.r] = 0;
            progressListener.done();
            this.bucket = null;
            this.semi = null;
            this.label = null;
            this.vertex = null;
            this.anchestor = null;
            this.parent = null;
            this.snapshot.getIndexManager().inbound().unload();
            if (progressListener0.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            this.snapshot.getIndexManager().setReader(IndexManager.Index.DOMINATOR, new IndexWriter.IntIndexStreamer().writeTo(IndexManager.Index.DOMINATOR.getFile(this.snapshot.getSnapshotInfo().getPrefix()), new IteratorInt(){
                int nextIndex = 2;

                public boolean hasNext() {
                    return this.nextIndex < Calculator.this.dom.length;
                }

                public int next() {
                    return Calculator.this.dom[this.nextIndex++];
                }
            }));
            int[] objectIds = new int[this.snapshot.getSnapshotInfo().getNumberOfObjects() + 2];
            int i2 = 0;
            while (i2 < objectIds.length) {
                objectIds[i2] = i2 - 2;
                ++i2;
            }
            objectIds[0] = -2;
            objectIds[1] = ROOT_VALUE;
            progressListener0.worked(1);
            ArrayUtils.sort((int[])this.dom, (int[])objectIds, (int)2, (int)(this.dom.length - 2));
            progressListener0.worked(1);
            FlatDominatorTree tree = new FlatDominatorTree(this.snapshot, this.dom, objectIds, ROOT_VALUE);
            if (progressListener0.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            this.writeIndexFiles(tree);
            progressListener0.done();
        }

        private void dfs(int root) throws UnsupportedOperationException {
            IProgressListener progressListener = this.monitor.nextMonitor();
            progressListener.beginTask(Messages.DominatorTree_DepthFirstSearch, this.snapshot.getSnapshotInfo().getNumberOfObjects() >> 16);
            int capacity = 2048;
            int size = 0;
            int[] currentElementStack = new int[capacity];
            int[] currentSuccessorStack = new int[capacity];
            Object[] successorsStack = new Object[capacity];
            int v = root;
            int[] successors = this.gcRootsArray;
            int currentSuccessor = 0;
            currentElementStack[size] = root;
            successorsStack[size] = successors;
            currentSuccessorStack[size] = currentSuccessor;
            ++size;
            while (size > 0) {
                v = currentElementStack[size - 1];
                successors = (int[])successorsStack[size - 1];
                currentSuccessor = currentSuccessorStack[size - 1];
                if (this.semi[v] == 0) {
                    this.semi[v] = ++this.n;
                    this.vertex[this.n] = v;
                    this.label[v] = v;
                    this.anchestor[v] = 0;
                }
                if (currentSuccessor < successors.length) {
                    int w = successors[currentSuccessor++] + 2;
                    currentSuccessorStack[size - 1] = currentSuccessor;
                    if (this.semi[w] != 0) continue;
                    this.parent[w] = v;
                    successors = this.outboundIndex.get(w - 2);
                    if (size == capacity) {
                        int newCapacity = capacity << 1;
                        int[] newArr = new int[newCapacity];
                        System.arraycopy(currentElementStack, 0, newArr, 0, capacity);
                        currentElementStack = newArr;
                        newArr = new int[newCapacity];
                        System.arraycopy(currentSuccessorStack, 0, newArr, 0, capacity);
                        currentSuccessorStack = newArr;
                        Object[] newSuccessorsArr = new Object[newCapacity];
                        System.arraycopy(successorsStack, 0, newSuccessorsArr, 0, capacity);
                        successorsStack = newSuccessorsArr;
                        capacity = newCapacity;
                    }
                    currentElementStack[size] = w;
                    successorsStack[size] = successors;
                    currentSuccessorStack[size] = 0;
                    ++size;
                    if ((this.n & 0xFFFF) != 0) continue;
                    if (progressListener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    progressListener.worked(1);
                    continue;
                }
                --size;
            }
            progressListener.done();
        }

        private int[] getPredecessors(int v) {
            if (this.gcRootsSet.get(v -= 2)) {
                return ROOT_VALUE_ARR;
            }
            return this.inboundIndex.get(v);
        }

        private void compress(int v) {
            IntStack stack = new IntStack();
            while (this.anchestor[this.anchestor[v]] != 0) {
                stack.push(v);
                v = this.anchestor[v];
            }
            while (stack.size() > 0) {
                v = stack.pop();
                if (this.semi[this.label[this.anchestor[v]]] < this.semi[this.label[v]]) {
                    this.label[v] = this.label[this.anchestor[v]];
                }
                this.anchestor[v] = this.anchestor[this.anchestor[v]];
            }
        }

        private int eval(int v) {
            if (this.anchestor[v] == 0) {
                return v;
            }
            this.compress(v);
            return this.label[v];
        }

        private void link(int v, int w) {
            this.anchestor[w] = v;
        }

        private void writeIndexFiles(FlatDominatorTree tree) throws IOException {
            IndexWriter.IntArray1NWriter writer = new IndexWriter.IntArray1NWriter(this.dom.length - 1, IndexManager.Index.DOMINATED.getFile(this.snapshot.getSnapshotInfo().getPrefix()));
            int numberOfObjects = this.snapshot.getSnapshotInfo().getNumberOfObjects();
            IProgressListener progressListener = this.monitor.nextMonitor();
            progressListener.beginTask(Messages.DominatorTree_CreateDominatorsIndexFile, numberOfObjects / 1000);
            int i = -1;
            while (i < numberOfObjects) {
                int[] successors = tree.getSuccessorsArr(i);
                tree.sortByTotalSize(successors);
                writer.log(i + 1, successors);
                if (i % 1000 == 0) {
                    if (progressListener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    progressListener.worked(1);
                }
                ++i;
            }
            this.snapshot.getIndexManager().setReader(IndexManager.Index.DOMINATED, writer.flush());
            progressListener.done();
        }

        public class FlatDominatorTree {
            private static final int TEMP_ARR_LENGTH = 1000000;
            int[] dom;
            int[] elements;
            long[] ts;
            SnapshotImpl dump;
            long[] tempLongArray = new long[1000000];
            int[] tempIntArray = new int[1000000];

            FlatDominatorTree(SnapshotImpl dump, int[] dom, int[] elements, int root) throws SnapshotException, IOException {
                this.dump = dump;
                this.dom = dom;
                this.elements = elements;
                this.ts = new long[dom.length];
                this.calculateTotalSizesIterative(root);
            }

            public SuccessorsEnum getSuccessorsEnum(int i) {
                return new SuccessorsEnum(i);
            }

            public int[] getSuccessorsArr(int parentId) {
                int j = Arrays.binarySearch(this.dom, parentId += 2);
                if (j < 0) {
                    return new int[0];
                }
                int i = j;
                while (i > 1 && this.dom[i - 1] == parentId) {
                    --i;
                }
                while (j < this.dom.length && this.dom[j] == parentId) {
                    ++j;
                }
                int length = j - i;
                int[] result = new int[length];
                System.arraycopy(this.elements, i, result, 0, length);
                return result;
            }

            public void sortByTotalSize(int[] objectIds) {
                int length = objectIds.length;
                long[] totalSizes = new long[length];
                int i = 0;
                while (i < length) {
                    totalSizes[i] = this.ts[objectIds[i] + 2];
                    ++i;
                }
                if (totalSizes.length > 1) {
                    if (totalSizes.length > 1000000) {
                        ArrayUtils.sortDesc((long[])totalSizes, (int[])objectIds);
                    } else {
                        ArrayUtils.sortDesc((long[])totalSizes, (int[])objectIds, (long[])this.tempLongArray, (int[])this.tempIntArray);
                    }
                }
            }

            public void calculateTotalSizesIterative(int e) throws SnapshotException, IOException {
                IndexWriter.LongIndexCollector retained = new IndexWriter.LongIndexCollector(this.dump.getSnapshotInfo().getNumberOfObjects(), IndexWriter.mostSignificantBit(this.dump.getSnapshotInfo().getUsedHeapSize()));
                int capacity = 2048;
                int size = 0;
                int[] stack = new int[capacity];
                SuccessorsEnum[] succStack = new SuccessorsEnum[capacity];
                int currentEntry = e;
                SuccessorsEnum currentSucc = this.getSuccessorsEnum(currentEntry);
                stack[size] = currentEntry;
                succStack[size] = currentSucc;
                ++size;
                IProgressListener progressListener = Calculator.this.monitor.nextMonitor();
                progressListener.beginTask(Messages.DominatorTree_CalculateRetainedSizes, this.dump.getSnapshotInfo().getNumberOfObjects() / 1000);
                int counter = 0;
                while (size > 0) {
                    currentEntry = stack[size - 1];
                    currentSucc = succStack[size - 1];
                    if (currentSucc.hasMoreElements()) {
                        int nextChild = currentSucc.nextElement();
                        currentSucc = this.getSuccessorsEnum(nextChild);
                        long l = this.ts[nextChild + 2] = nextChild < 0 ? 0L : Calculator.this.snapshot.getHeapSize(nextChild);
                        if (size == capacity) {
                            int newCapacity = capacity << 1;
                            int[] newArr = new int[newCapacity];
                            System.arraycopy(stack, 0, newArr, 0, capacity);
                            stack = newArr;
                            SuccessorsEnum[] newSuccessorsArr = new SuccessorsEnum[newCapacity];
                            System.arraycopy(succStack, 0, newSuccessorsArr, 0, capacity);
                            succStack = newSuccessorsArr;
                            capacity = newCapacity;
                        }
                        stack[size] = nextChild;
                        succStack[size] = currentSucc;
                        ++size;
                        continue;
                    }
                    if (--size > 0) {
                        int n = stack[size - 1] + 2;
                        this.ts[n] = this.ts[n] + this.ts[currentEntry + 2];
                    }
                    if (currentEntry < 0) continue;
                    retained.set(currentEntry, this.ts[currentEntry + 2]);
                    if (++counter % 1000 != 0) continue;
                    if (progressListener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    progressListener.worked(1);
                }
                this.dump.getIndexManager().setReader(IndexManager.Index.O2RETAINED, retained.writeTo(IndexManager.Index.O2RETAINED.getFile(this.dump.getSnapshotInfo().getPrefix())));
                retained = null;
                progressListener.done();
            }

            class SuccessorsEnum {
                int parent;
                int nextIndex;

                SuccessorsEnum(int parent) {
                    this.parent = parent;
                    this.nextIndex = this.findFirstChildIndex(parent + 2);
                }

                public boolean hasMoreElements() {
                    return this.nextIndex > 0;
                }

                public int nextElement() {
                    if (this.nextIndex < 0) {
                        throw new NoSuchElementException();
                    }
                    int res = FlatDominatorTree.this.elements[this.nextIndex++];
                    if (this.nextIndex >= FlatDominatorTree.this.dom.length || FlatDominatorTree.this.dom[this.nextIndex] != this.parent + 2) {
                        this.nextIndex = -1;
                    }
                    return res;
                }

                int findFirstChildIndex(int el) {
                    int i = Arrays.binarySearch(FlatDominatorTree.this.dom, el);
                    while (i > 1 && FlatDominatorTree.this.dom[i - 1] == el) {
                        --i;
                    }
                    return i;
                }
            }
        }
    }
}

