/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.SnapshotHistoryService;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.ProgressMonitorWrapper;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParseHeapDumpJob
extends Job {
    private final IPath path;
    private final Map<String, String> arguments;

    private static Map<String, String> defaultArguments() {
        IPreferenceStore prefs = MemoryAnalyserPlugin.getDefault().getPreferenceStore();
        if (prefs.getBoolean("keep_unreachable_objects")) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("keep_unreachable_objects", Boolean.TRUE.toString());
            return args;
        }
        return Collections.emptyMap();
    }

    public ParseHeapDumpJob(IPath path) {
        this(path, ParseHeapDumpJob.defaultArguments());
    }

    public ParseHeapDumpJob(IPath path, Map<String, String> args) {
        super(MessageUtil.format((String)Messages.ParseHeapDumpJob_ParsingHeapDumpFrom, (Object[])new Object[]{path.toOSString()}));
        this.path = path;
        this.arguments = args;
        this.setUser(true);
        this.setRule(new ParseRule(path));
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.setProperty(IProgressConstants.PROPERTY_IN_DIALOG, Boolean.TRUE);
        try {
            SnapshotHistoryService.getInstance().addVisitedPath("org.eclipse.mat.ui.editors.HeapEditor", this.path.toOSString());
            final ISnapshot snapshot = SnapshotFactory.openSnapshot((File)this.path.toFile(), this.arguments, (IProgressListener)new ProgressMonitorWrapper(monitor));
            if (snapshot == null) {
                return Status.CANCEL_STATUS;
            }
            SnapshotInfo source = snapshot.getSnapshotInfo();
            SnapshotInfo destination = new SnapshotInfo(source.getPath(), source.getPrefix(), source.getJvmInfo(), source.getIdentifierSize(), source.getCreationDate(), source.getNumberOfObjects(), source.getNumberOfGCRoots(), source.getNumberOfClasses(), source.getNumberOfClassLoaders(), source.getUsedHeapSize());
            this.copyPropertyIfSet(source, destination, "$heapFormat");
            this.copyPropertyIfSet(source, destination, "$useCompressedOops");
            SnapshotHistoryService.getInstance().addVisitedPath("org.eclipse.mat.ui.editors.HeapEditor", this.path.toOSString(), (Serializable)destination);
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ParseHeapDumpJob.this.finished(snapshot);
                }
            });
            return Status.OK_STATUS;
        }
        catch (IProgressListener.OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (SnapshotException e) {
            return ErrorHelper.createErrorStatus(e);
        }
    }

    private void copyPropertyIfSet(SnapshotInfo source, SnapshotInfo destination, String key) {
        Serializable value = source.getProperty(key);
        if (value != null) {
            destination.setProperty(key, value);
        }
    }

    public boolean isModal() {
        Boolean isModal = (Boolean)this.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
        if (isModal == null) {
            return false;
        }
        return isModal;
    }

    protected abstract void finished(ISnapshot var1);

    class ParseRule
    implements ISchedulingRule {
        IPath path;

        public ParseRule(IPath filename) {
            this.path = filename;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof ParseRule && ((ParseRule)rule).path.equals((Object)this.path);
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return this.contains(rule);
        }
    }
}

