/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.actions;

import java.util.List;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.OQL;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

@Icon(value="/icons/copy.gif")
public class CopyOQL
implements IQuery {
    @Argument
    public List<IContextObjectSet> elements;
    @Argument
    public Display display;

    public IResult execute(IProgressListener listener) throws Exception {
        final StringBuilder buf = new StringBuilder(128);
        String lineSeparator = System.getProperty("line.separator");
        for (IContextObjectSet element : this.elements) {
            String buf1 = element.getOQL();
            if (buf1 == null) continue;
            OQL.union((StringBuilder)buf, (String)buf1);
        }
        buf.append(lineSeparator);
        this.display.asyncExec(new Runnable(){

            public void run() {
                Clipboard clipboard = new Clipboard(CopyOQL.this.display);
                clipboard.setContents(new Object[]{buf.toString()}, new Transfer[]{TextTransfer.getInstance()});
                clipboard.dispose();
            }
        });
        throw new IProgressListener.OperationCanceledException();
    }
}

