/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes.oql.contentAssist;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.ContentAssistElement;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.ContextExtractor;
import org.eclipse.mat.ui.snapshot.panes.oql.contentAssist.SuggestionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQLContentAssistantProcessor
implements IContentAssistProcessor {
    private SuggestionProvider suggestionProvider;
    private ContextExtractor extractor;

    public OQLContentAssistantProcessor(SuggestionProvider suggestionProvider, ContextExtractor extractor) {
        this.suggestionProvider = suggestionProvider;
        this.extractor = extractor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer arg0, int arg1) {
        String context = this.extractor.getPrefix(arg0, arg1);
        List<ContentAssistElement> suggestions = this.suggestionProvider.getSuggestions(context);
        return this.buildResult(suggestions, arg1, context.length());
    }

    public IContextInformation[] computeContextInformation(ITextViewer arg0, int arg1) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'.', '\"'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return "ARF!!!";
    }

    private ICompletionProposal[] buildResult(List<ContentAssistElement> suggestions, int currentCursor, int replaceLength) {
        if (suggestions == null) {
            throw new IllegalArgumentException("Cannot produce a suggestion. List is null");
        }
        ICompletionProposal[] retProposals = new ICompletionProposal[suggestions.size()];
        Iterator<ContentAssistElement> it = suggestions.iterator();
        int c = 0;
        while (it.hasNext()) {
            ContentAssistElement cp = it.next();
            String classname = cp.getClassName();
            CompletionProposal completion = new CompletionProposal(classname, currentCursor - replaceLength, replaceLength, currentCursor - replaceLength + classname.length());
            retProposals[c] = completion;
            ++c;
        }
        return retProposals;
    }
}

