/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="find_strings")
public class FindStringsQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(isMandatory=false)
    public IHeapObjectArgument objects;
    @Argument
    public Pattern pattern;

    public IResult execute(IProgressListener listener) throws Exception {
        ArrayInt result;
        block13: {
            listener.subTask(Messages.FindStringsQuery_SearchingStrings);
            result = new ArrayInt();
            Collection<IClass> classes = this.snapshot.getClassesByName("java.lang.String", false);
            if (this.objects == null) {
                if (classes != null) {
                    for (IClass clasz : classes) {
                        int[] objectIds;
                        int[] nArray = objectIds = clasz.getObjectIds();
                        int n = objectIds.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int id = nArray[n2];
                            if (!listener.isCanceled()) {
                                String value = this.snapshot.getObject(id).getClassSpecificName();
                                if (value != null && this.pattern.matcher(value).matches()) {
                                    result.add(id);
                                }
                                ++n2;
                                continue;
                            }
                            break block13;
                        }
                    }
                }
            } else if (classes != null && !classes.isEmpty()) {
                IClass javaLangString = classes.iterator().next();
                Iterator iterator = this.objects.iterator();
                while (iterator.hasNext()) {
                    int[] objectIds;
                    int[] nArray = objectIds = (int[])iterator.next();
                    int n = objectIds.length;
                    int n3 = 0;
                    while (n3 < n) {
                        int id = nArray[n3];
                        if (!listener.isCanceled()) {
                            String value;
                            IObject instance;
                            if (!this.snapshot.isArray(id) && !this.snapshot.isClass(id) && !this.snapshot.isClassLoader(id) && javaLangString.equals((instance = this.snapshot.getObject(id)).getClazz()) && this.pattern.matcher(value = instance.getClassSpecificName()).matches()) {
                                result.add(id);
                            }
                            ++n3;
                            continue;
                        }
                        break block13;
                    }
                }
            }
        }
        if (listener.isCanceled() && result.isEmpty()) {
            throw new IProgressListener.OperationCanceledException();
        }
        return new ObjectListResult.Outbound(this.snapshot, result.toArray());
    }
}

