/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ibmvm.acquire;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.ibmvm.acquire.BaseProvider;
import org.eclipse.mat.ibmvm.acquire.IBMExecVmInfo;
import org.eclipse.mat.ibmvm.acquire.Messages;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.snapshot.acquire.IHeapDumpProvider;
import org.eclipse.mat.snapshot.acquire.VmInfo;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="IBM Dump (using helper VM)")
public class IBMExecDumpProvider
extends BaseProvider {
    private static final String PLUGIN_ID = "org.eclipse.mat.ibmdump";
    private static final String JAVA_EXEC = "java";
    private static boolean abort = false;
    @Argument
    public File javaexecutable;
    @Argument(isMandatory=false)
    public String[] vmoptions = new String[]{"-version:1.6"};
    private static final String last_directory_key = String.valueOf(IBMExecDumpProvider.class.getName()) + ".lastDir";
    private static String savedJavaDir;
    private static File execJar;

    /*
     * Exception decompiling
     */
    public File acquireDump(VmInfo info, File preferredLocation, IProgressListener listener) throws SnapshotException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[CATCHBLOCK], 22[UNCONDITIONALDOLOOP]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File javaExec(String dir) {
        return IBMExecDumpProvider.jvmExec(dir, JAVA_EXEC);
    }

    static File jvmExec(String javaDir, String exec) {
        File javaExec = javaDir != null ? new File(javaDir, exec) : new File(exec);
        return javaExec;
    }

    public List<VmInfo> getAvailableVMs(IProgressListener listener) {
        String javaDir;
        if (abort) {
            return null;
        }
        File javaExec = this.javaexecutable;
        if (javaExec != null) {
            javaDir = javaExec.getParent();
        } else {
            javaDir = IBMExecDumpProvider.getJavaDir();
            if (javaDir == null) {
                javaDir = this.defaultJavaDir();
            }
            javaExec = this.javaExec(javaDir);
        }
        List<VmInfo> ret = this.execGetVMs(javaExec, listener);
        if (ret != null) {
            IBMExecDumpProvider.setJavaDir(javaDir);
            this.javaexecutable = javaExec;
        }
        return ret;
    }

    private String defaultJavaDir() {
        String path = System.getenv("PATH");
        if (path != null) {
            String[] stringArray = path.split(File.pathSeparator);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                File dir = new File(p);
                File parentDir = dir.getParentFile();
                File dll = new File(dir, "dgcollector.dll");
                if (dll.exists()) {
                    return dir.getPath();
                }
                dll = new File(p, "dgcollector.so");
                if (dll.exists()) {
                    return dir.getPath();
                }
                dir = new File(parentDir, "jre");
                dll = new File(dir = new File(dir, "bin"), "dgcollector.dll");
                if (dll.exists()) {
                    return dir.getPath();
                }
                dll = new File(p, "dgcollector.so");
                if (dll.exists()) {
                    return dir.getPath();
                }
                ++n2;
            }
        }
        String home = System.getProperty("java.home");
        return new File(home, "bin").getPath();
    }

    private static synchronized String getJavaDir() {
        String home = Platform.getPreferencesService().getString(PLUGIN_ID, last_directory_key, savedJavaDir, null);
        return home;
    }

    private static synchronized void setJavaDir(String home) {
        if (!home.equals(savedJavaDir)) {
            IEclipsePreferences prefs = new InstanceScope().getNode(PLUGIN_ID);
            prefs.put(last_directory_key, home);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
            savedJavaDir = home;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<VmInfo> execGetVMs(File javaExec, IProgressListener listener) {
        ArrayList<VmInfo> ar = new ArrayList<VmInfo>();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        Process p = null;
        String execPath = javaExec.getPath();
        try {
            String jar = IBMExecDumpProvider.getExecJar().getAbsolutePath();
            ArrayList<String> args = new ArrayList<String>(4);
            args.add(execPath);
            if (this.vmoptions != null) {
                args.addAll(Arrays.asList(this.vmoptions));
            }
            args.add("-jar");
            args.add(jar);
            pb.command(args);
            p = pb.start();
            StringBuffer err = new StringBuffer();
            StringBuffer in = new StringBuffer();
            InputStreamReader os = new InputStreamReader(p.getInputStream());
            try {
                InputStreamReader es = new InputStreamReader(p.getErrorStream());
                try {
                    String[] ss;
                    int rc = 0;
                    while (true) {
                        if (os.ready()) {
                            in.append((char)os.read());
                            continue;
                        }
                        while (es.ready()) {
                            err.append((char)es.read());
                        }
                        try {
                            rc = p.exitValue();
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            Thread.sleep(100L);
                            continue;
                        }
                        break;
                    }
                    if (rc != 0) {
                        listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.getString("IBMExecDumpProvider.ProblemListingVMsRC"), (Object[])new Object[]{execPath, rc, err.toString()}), null);
                        ArrayList<VmInfo> arrayList = ar = null;
                        return arrayList;
                    }
                    String[] stringArray = ss = in.toString().split("[\\n\\r]+");
                    int n = ss.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        String[] s2 = s.split(INFO_SEPARATOR, 4);
                        if (s2.length >= 4 && !s2[3].contains(IBMExecDumpProvider.getExecJar().getName())) {
                            IBMExecVmInfo ifo = new IBMExecVmInfo(s2[0], s2[3], true, null, this);
                            ifo.javaexecutable = javaExec;
                            ifo.vmoptions = this.vmoptions;
                            ifo.type = this.defaultType;
                            ifo.compress = this.defaultCompress;
                            if (s2[2].length() > 0) {
                                ifo.dumpdir = new File(s2[2]);
                            }
                            ar.add(ifo);
                        }
                        ++n2;
                    }
                    return ar;
                }
                finally {
                    es.close();
                }
            }
            finally {
                os.close();
            }
        }
        catch (IOException e) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.getString("IBMExecDumpProvider.ProblemListingVMs"), (Object[])new Object[]{execPath}), (Throwable)e);
            return null;
        }
        catch (InterruptedException e) {
            listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.getString("IBMExecDumpProvider.ProblemListingVMs"), (Object[])new Object[]{execPath}), (Throwable)e);
            return null;
        }
    }

    static synchronized File getExecJar() throws IOException {
        if (execJar == null || !execJar.canRead()) {
            String jarname = "org.eclipse.mat.ibmexecdumps";
            String[] classesNames = new String[]{"org.eclipse.mat.ibmvm.acquire.IBMDumpProvider", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$AgentLoader", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$FileComparator", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$NewFileFilter", "org.eclipse.mat.ibmvm.acquire.IBMDumpProvider$StderrProgressListener", "org.eclipse.mat.ibmvm.acquire.BaseProvider", "org.eclipse.mat.ibmvm.acquire.IBMHeapDumpProvider", "org.eclipse.mat.ibmvm.acquire.IBMSystemDumpProvider", "org.eclipse.mat.ibmvm.acquire.IBMJavaDumpProvider", "org.eclipse.mat.ibmvm.acquire.IBMVmInfo", "org.eclipse.mat.ibmvm.acquire.AgentLoader2", "org.eclipse.mat.ibmvm.acquire.DumpType", "org.eclipse.mat.ibmvm.agent.DumpAgent"};
            Class[] classes = new Class[]{SnapshotException.class, IHeapDumpProvider.class, VmInfo.class, IProgressListener.class, IProgressListener.OperationCanceledException.class, IProgressListener.Severity.class, Messages.class};
            execJar = IBMExecDumpProvider.makeJar(jarname, "Main-Class: ", classesNames, classes);
        }
        return execJar;
    }
}

