/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.oql.compiler;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.mat.parser.internal.oql.ICompiler;
import org.eclipse.mat.parser.internal.oql.compiler.ArrayIndexExpression;
import org.eclipse.mat.parser.internal.oql.compiler.EvaluationContext;
import org.eclipse.mat.parser.internal.oql.compiler.Expression;
import org.eclipse.mat.parser.internal.oql.compiler.Function;
import org.eclipse.mat.parser.internal.oql.compiler.MethodCallExpression;
import org.eclipse.mat.parser.internal.oql.compiler.Operation;
import org.eclipse.mat.parser.internal.oql.compiler.PathExpression;
import org.eclipse.mat.parser.internal.oql.compiler.Query;
import org.eclipse.mat.parser.internal.oql.compiler.QueryExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerImpl
implements ICompiler {
    @Override
    public Object and(Object[] arguments) {
        return new Operation.And(Arrays.asList(arguments).toArray(new Expression[arguments.length]));
    }

    @Override
    public Object or(Object[] arguments) {
        return new Operation.Or(Arrays.asList(arguments).toArray(new Expression[arguments.length]));
    }

    @Override
    public Object equal(Object left, Object right) {
        return new Operation.Equal((Expression)left, (Expression)right);
    }

    @Override
    public Object notEqual(Object left, Object right) {
        return new Operation.NotEqual((Expression)left, (Expression)right);
    }

    @Override
    public Object greaterThan(Object left, Object right) {
        return new Operation.GreaterThan((Expression)left, (Expression)right);
    }

    @Override
    public Object greaterThanOrEqual(Object left, Object right) {
        return new Operation.GreaterThanOrEqual((Expression)left, (Expression)right);
    }

    @Override
    public Object lessThan(Object left, Object right) {
        return new Operation.LessThan((Expression)left, (Expression)right);
    }

    @Override
    public Object lessThanOrEqual(Object left, Object right) {
        return new Operation.LessThanOrEqual((Expression)left, (Expression)right);
    }

    @Override
    public Object like(Object ex, String regex) {
        return new Operation.Like((Expression)ex, regex);
    }

    @Override
    public Object notLike(Object ex, String regex) {
        return new Operation.NotLike((Expression)ex, regex);
    }

    @Override
    public Object in(Object left, Object right) {
        return new Operation.In((Expression)left, (Expression)right);
    }

    @Override
    public Object notIn(Object left, Object right) {
        return new Operation.NotIn((Expression)left, (Expression)right);
    }

    @Override
    public Object instanceOf(Object left, String className) {
        return new Operation.InstanceOf((Expression)left, className);
    }

    @Override
    public Object literal(Object object) {
        return new ConstantExpression(object);
    }

    @Override
    public Object nullLiteral() {
        return new ConstantExpression(ConstantExpression.NULL);
    }

    @Override
    public Object path(List<Object> attributes) {
        return new PathExpression(attributes);
    }

    @Override
    public Object method(String name, List<Expression> parameters, boolean isFirstInPath) {
        Function f;
        if (isFirstInPath && parameters.size() == 1 && (f = this.function(name, parameters.get(0))) != null) {
            return f;
        }
        return new MethodCallExpression(name, parameters);
    }

    public Function function(String name, Object subject) {
        if ("toHex".equals(name)) {
            return new Function.ToHex((Expression)subject);
        }
        if ("toString".equals(name)) {
            return new Function.ToString((Expression)subject);
        }
        if ("inbounds".equals(name)) {
            return new Function.Inbounds((Expression)subject);
        }
        if ("outbounds".equals(name)) {
            return new Function.Outbounds((Expression)subject);
        }
        if ("dominators".equals(name)) {
            return new Function.Dominators((Expression)subject);
        }
        if ("classof".equals(name)) {
            return new Function.ClassOf((Expression)subject);
        }
        if ("dominatorof".equals(name)) {
            return new Function.DominatorOf((Expression)subject);
        }
        return null;
    }

    @Override
    public Object subQuery(Query q) {
        return new QueryExpression(q);
    }

    @Override
    public Object divide(Object left, Object right) {
        return new Operation.Divide((Expression)left, (Expression)right);
    }

    @Override
    public Object minus(Object left, Object right) {
        return new Operation.Minus((Expression)left, (Expression)right);
    }

    @Override
    public Object multiply(Object left, Object right) {
        return new Operation.Multiply((Expression)left, (Expression)right);
    }

    @Override
    public Object plus(Object left, Object right) {
        return new Operation.Plus((Expression)left, (Expression)right);
    }

    @Override
    public Object array(Object index) {
        return new ArrayIndexExpression(Collections.singletonList((Expression)index));
    }

    static class ConstantExpression
    extends Expression {
        public static final Object NULL = new Object();
        Object literal;

        public ConstantExpression(Object literal) {
            this.literal = literal;
        }

        public Object compute(EvaluationContext ctx) {
            return this.literal;
        }

        public boolean isContextDependent(EvaluationContext ctx) {
            return false;
        }

        public String toString() {
            if (this.literal instanceof String) {
                return "\"" + this.literal + "\"";
            }
            if (this.literal instanceof Character) {
                return "'" + this.literal + "'";
            }
            if (this.literal instanceof Integer) {
                return this.literal.toString();
            }
            if (this.literal instanceof Long) {
                return this.literal + "L";
            }
            if (this.literal == NULL) {
                return "null";
            }
            return String.valueOf(this.literal);
        }
    }
}

