/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.oql.compiler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.oql.compiler.CompilerImpl;
import org.eclipse.mat.parser.internal.oql.compiler.EvaluationContext;
import org.eclipse.mat.parser.internal.oql.compiler.Expression;
import org.eclipse.mat.parser.internal.oql.compiler.PathExpression;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.PatternUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodCallExpression
extends Expression {
    String name;
    List<Expression> parameters;

    public MethodCallExpression(String name, List<Expression> parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    @Override
    public Object compute(EvaluationContext ctx) throws SnapshotException, IProgressListener.OperationCanceledException {
        List<?> subject = ctx.getSubject();
        if (subject == null) {
            return null;
        }
        if (subject.getClass().isArray()) {
            subject = PathExpression.asList(subject);
        }
        Object[] arguments = new Object[this.parameters.size()];
        int ii = 0;
        while (ii < arguments.length) {
            arguments[ii] = this.parameters.get(ii).compute(ctx);
            ++ii;
        }
        if (subject instanceof IObject && "toString".equals(this.name) && this.parameters.isEmpty()) {
            String name = ((IObject)subject).getClassSpecificName();
            return name != null ? name : ((IObject)subject).getTechnicalName();
        }
        ArrayList<Method> extraMethods = new ArrayList<Method>();
        Class<?> subjectClass = subject.getClass();
        Method[] methods = subjectClass.getMethods();
        if (!Modifier.isPublic(subjectClass.getModifiers())) {
            Class<?> c;
            int n;
            int n2;
            Class<?>[] classArray;
            Class<?> superClass = subjectClass;
            while (superClass != null) {
                classArray = superClass.getInterfaces();
                n2 = classArray.length;
                n = 0;
                while (n < n2) {
                    c = classArray[n];
                    this.firstChoiceMethods(extraMethods, c, arguments);
                    ++n;
                }
                superClass = superClass.getSuperclass();
            }
            this.firstChoiceMethods(extraMethods, subjectClass, arguments);
            superClass = subjectClass;
            while (superClass != null) {
                classArray = superClass.getInterfaces();
                n2 = classArray.length;
                n = 0;
                while (n < n2) {
                    c = classArray[n];
                    extraMethods.addAll(Arrays.asList(c.getMethods()));
                    ++n;
                }
                superClass = superClass.getSuperclass();
            }
        } else {
            this.firstChoiceMethods(extraMethods, subjectClass, arguments);
        }
        if (extraMethods.size() > 0) {
            extraMethods.addAll(Arrays.asList(methods));
            extraMethods = new ArrayList<Method>(new LinkedHashSet<Method>(extraMethods));
            methods = extraMethods.toArray(new Method[extraMethods.size()]);
        }
        int ii2 = 0;
        while (ii2 < methods.length) {
            block25: {
                Class<?>[] parameterTypes;
                if (methods[ii2].getName().equals(this.name) && (parameterTypes = methods[ii2].getParameterTypes()).length == arguments.length) {
                    Object[] savedArgs = null;
                    int jj = 0;
                    while (jj < arguments.length) {
                        if (arguments[jj] == CompilerImpl.ConstantExpression.NULL) {
                            arguments[jj] = null;
                        }
                        if (arguments[jj] != null && !this.isConvertible(parameterTypes[jj], arguments[jj])) {
                            if (!parameterTypes[jj].isAssignableFrom(Pattern.class)) {
                                if (savedArgs != null) {
                                    int ia = 0;
                                    while (ia < savedArgs.length) {
                                        if (savedArgs[ia] != null) {
                                            arguments[ia] = savedArgs[ia];
                                        }
                                        ++ia;
                                    }
                                }
                                break block25;
                            }
                            if (savedArgs == null) {
                                savedArgs = new Object[arguments.length];
                            }
                            savedArgs[jj] = arguments[jj];
                            arguments[jj] = Pattern.compile(PatternUtil.smartFix((String)String.valueOf(arguments[jj]), (boolean)false));
                        }
                        ++jj;
                    }
                    try {
                        return methods[ii2].invoke(subject, arguments);
                    }
                    catch (IllegalArgumentException e) {
                        throw new SnapshotException((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new SnapshotException((Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new SnapshotException((Throwable)e);
                    }
                }
            }
            ++ii2;
        }
        throw new SnapshotException(MessageUtil.format((String)Messages.MethodCallExpression_Error_MethodNotFound, (Object[])new Object[]{this.name, subject}));
    }

    private void firstChoiceMethods(List<Method> extraMethods, Class<? extends Object> subjectClass, Object[] arguments) {
        Method m1;
        Class[] argumentTypes1 = new Class[arguments.length];
        Class[] argumentTypes2 = new Class[arguments.length];
        int i = 0;
        boolean unbox = false;
        Object[] objectArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Object args = objectArray[n2];
            if (args != null) {
                argumentTypes1[i] = args.getClass();
            }
            if (argumentTypes1[i] == Boolean.class) {
                argumentTypes2[i] = Boolean.TYPE;
                unbox = true;
            }
            if (argumentTypes1[i] == Byte.class) {
                argumentTypes2[i] = Byte.TYPE;
                unbox = true;
            } else if (argumentTypes1[i] == Short.class) {
                argumentTypes2[i] = Short.TYPE;
                unbox = true;
            } else if (argumentTypes1[i] == Character.class) {
                argumentTypes2[i] = Character.TYPE;
                unbox = true;
            } else if (argumentTypes1[i] == Integer.class) {
                argumentTypes2[i] = Integer.TYPE;
                unbox = true;
            } else if (argumentTypes1[i] == Long.class) {
                argumentTypes2[i] = Long.TYPE;
                unbox = true;
            } else if (argumentTypes1[i] == Float.class) {
                argumentTypes2[i] = Float.TYPE;
                unbox = true;
            } else if (argumentTypes1[i] == Double.class) {
                argumentTypes2[i] = Double.TYPE;
                unbox = true;
            } else {
                argumentTypes2[i] = argumentTypes1[i];
            }
            ++i;
            ++n2;
        }
        try {
            m1 = subjectClass.getMethod(this.name, argumentTypes1);
            extraMethods.add(m1);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (unbox) {
            try {
                m1 = subjectClass.getMethod(this.name, argumentTypes2);
                extraMethods.add(m1);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
    }

    private boolean isConvertible(Class<?> parameterType, Object argument) {
        Class<?> argumentType = argument.getClass();
        if (parameterType.isAssignableFrom(argumentType)) {
            return true;
        }
        if (argumentType == Boolean.class && (parameterType == Boolean.TYPE || parameterType == Boolean.class)) {
            return true;
        }
        if (argumentType == Byte.class && (parameterType == Byte.TYPE || parameterType == Byte.class || parameterType == Short.TYPE || parameterType == Short.class || parameterType == Integer.TYPE || parameterType == Integer.class || parameterType == Long.TYPE || parameterType == Long.class || parameterType == Float.TYPE || parameterType == Float.class || parameterType == Double.TYPE || parameterType == Double.class)) {
            return true;
        }
        if (argumentType == Short.class && (parameterType == Short.TYPE || parameterType == Short.class || parameterType == Integer.TYPE || parameterType == Integer.class || parameterType == Long.TYPE || parameterType == Long.class || parameterType == Float.TYPE || parameterType == Float.class || parameterType == Double.TYPE || parameterType == Double.class)) {
            return true;
        }
        if (argumentType == Character.class && (parameterType == Character.TYPE || parameterType == Character.class || parameterType == Integer.TYPE || parameterType == Integer.class || parameterType == Long.TYPE || parameterType == Long.class || parameterType == Float.TYPE || parameterType == Float.class || parameterType == Double.TYPE || parameterType == Double.class)) {
            return true;
        }
        if (argumentType == Integer.class && (parameterType == Integer.TYPE || parameterType == Integer.class || parameterType == Long.TYPE || parameterType == Long.class || parameterType == Float.TYPE || parameterType == Float.class || parameterType == Double.TYPE || parameterType == Double.class)) {
            return true;
        }
        if (argumentType == Long.class && (parameterType == Long.TYPE || parameterType == Long.class || parameterType == Float.TYPE || parameterType == Float.class || parameterType == Double.TYPE || parameterType == Double.class)) {
            return true;
        }
        if (argumentType == Float.class && (parameterType == Float.TYPE || parameterType == Float.class || parameterType == Double.TYPE || parameterType == Double.class)) {
            return true;
        }
        return argumentType == Double.class && (parameterType == Double.TYPE || parameterType == Double.class);
    }

    @Override
    public boolean isContextDependent(EvaluationContext ctx) {
        for (Expression element : this.parameters) {
            boolean isContextDependent = element.isContextDependent(ctx);
            if (!isContextDependent) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append(this.name);
        buf.append("(");
        Iterator<Expression> iter = this.parameters.iterator();
        while (iter.hasNext()) {
            Expression element = iter.next();
            buf.append(element);
            if (!iter.hasNext()) continue;
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }
}

