/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.internal.collectionextract.HashedMapCollectionExtractorBase;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.MessageUtil;

public class HashMapCollectionExtractor
extends HashedMapCollectionExtractorBase {
    public HashMapCollectionExtractor(String sizeField, String arrayField, String keyField, String valueField) {
        super(sizeField, arrayField, keyField, valueField);
    }

    public boolean hasExtractableContents() {
        return true;
    }

    public boolean hasExtractableArray() {
        return false;
    }

    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        return null;
    }

    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        ISnapshot snapshot = coll.getSnapshot();
        String collectionName = coll.getDisplayName();
        ArrayInt entries = new ArrayInt();
        IObject table = this.getTable(coll);
        if (table != null) {
            int[] outbounds = snapshot.getOutboundReferentIds(table.getObjectId());
            int ii = 0;
            while (ii < outbounds.length) {
                this.collectEntry(entries, coll.getObjectId(), collectionName, outbounds[ii], snapshot);
                ++ii;
            }
        }
        return entries.toArray();
    }

    public Integer getCapacity(IObject coll) throws SnapshotException {
        IObject table = this.getTable(coll);
        if (table != null && table instanceof IObjectArray) {
            return ((IObjectArray)table).getLength();
        }
        return null;
    }

    private IObject getTable(IObject coll) throws SnapshotException {
        Field tableField;
        IInstance map;
        IObjectArray ba = this.getBackingArray(coll);
        if (ba != null) {
            return ba;
        }
        String arrayField = this.arrayField;
        int p = arrayField.lastIndexOf(46);
        if (p == arrayField.length() - 1 && p > 0) {
            arrayField = arrayField.substring(0, p);
            p = arrayField.lastIndexOf(46);
        } else {
            p = arrayField.length();
        }
        IObject arr = (IObject)coll.resolveValue(arrayField.substring(0, p));
        if (arr instanceof IObjectArray) {
            return arr;
        }
        IInstance iInstance = map = p < 0 ? (IInstance)coll : (IInstance)arr;
        if (map != null && (tableField = map.getField(p < 0 ? arrayField : arrayField.substring(p + 1))) != null) {
            ObjectReference tableFieldValue = (ObjectReference)tableField.getValue();
            return tableFieldValue != null ? tableFieldValue.getObject() : null;
        }
        return null;
    }

    private void collectEntry(ArrayInt entries, int collectionId, String collectionName, int entryId, ISnapshot snapshot) throws SnapshotException {
        while (entryId >= 0) {
            if (snapshot.isClass(entryId)) {
                return;
            }
            if (snapshot.getClassOf(entryId).getName().equals("java.lang.Object")) {
                return;
            }
            IInstance entry = (IInstance)snapshot.getObject(entryId);
            boolean nextFieldProcessed = false;
            int nextEntryId = -1;
            for (Field field : entry.getFields()) {
                if (nextFieldProcessed || !"next".equals(field.getName())) continue;
                nextFieldProcessed = true;
                if (field.getValue() == null) continue;
                nextEntryId = ((ObjectReference)field.getValue()).getObjectId();
            }
            entries.add(entryId);
            entryId = nextEntryId;
        }
    }

    public Integer getNumberOfNotNullElements(IObject collection) throws SnapshotException {
        IObjectArray arrayObject = this.extractBackingArray(collection);
        if (arrayObject == null) {
            return 0;
        }
        return ExtractionUtils.getNumberOfNotNullArrayElements(arrayObject);
    }

    public IObjectArray getBackingArray(IObject coll) throws SnapshotException {
        if (this.arrayField == null) {
            return null;
        }
        Object obj = coll.resolveValue(this.arrayField);
        IObjectArray ret = null;
        if (obj instanceof IObjectArray) {
            ret = (IObjectArray)obj;
            return ret;
        }
        if (obj instanceof IObject) {
            String msg = MessageUtil.format((String)Messages.CollectionUtil_BadBackingArray, (Object[])new Object[]{this.arrayField, coll.getTechnicalName(), ((IObject)obj).getTechnicalName()});
            throw new SnapshotException(msg);
        }
        if (obj != null) {
            String msg = MessageUtil.format((String)Messages.CollectionUtil_BadBackingArray, (Object[])new Object[]{this.arrayField, coll.getTechnicalName(), obj.toString()});
            throw new SnapshotException(msg);
        }
        IObject next = this.resolveNextFields(coll);
        if (next == null) {
            return null;
        }
        ISnapshot snapshot = next.getSnapshot();
        int[] nArray = snapshot.getOutboundReferentIds(next.getObjectId());
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            IObject o;
            int i = nArray[n2];
            if (snapshot.isArray(i) && (o = snapshot.getObject(i)) instanceof IObjectArray) {
                if (ret != null) {
                    return null;
                }
                ret = (IObjectArray)o;
            }
            ++n2;
        }
        return ret;
    }
}

