/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.oql.compiler;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.parser.internal.oql.compiler.EvaluationContext;
import org.eclipse.mat.parser.internal.oql.compiler.Expression;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayIndexExpression
extends Expression {
    List<Expression> parameters;

    public ArrayIndexExpression(List<Expression> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Object compute(EvaluationContext ctx) throws SnapshotException, IProgressListener.OperationCanceledException {
        Object subject = ctx.getSubject();
        if (subject == null) {
            return null;
        }
        Object[] arguments = new Object[this.parameters.size()];
        int ii = 0;
        while (ii < arguments.length) {
            arguments[ii] = this.parameters.get(ii).compute(ctx);
            ++ii;
        }
        Object indexObj = arguments[0];
        int index = this.evalIndex(indexObj);
        boolean range = arguments.length > 1;
        int index2 = index;
        if (range) {
            index2 = this.evalIndex(arguments[1]);
        }
        if (subject.getClass().isArray()) {
            int len = Array.getLength(subject);
            if (range) {
                int i1 = this.normalize(index, len, 0);
                int i2 = this.normalize(index2, len, 1);
                return new ArraySubList(subject, i1, i2);
            }
            if (index >= len) {
                return null;
            }
            if (index < 0) {
                return null;
            }
            return Array.get(subject, index);
        }
        if (subject instanceof List) {
            List l = (List)subject;
            int len = l.size();
            if (range) {
                int i1 = this.normalize(index, len, 0);
                int i2 = this.normalize(index2, len, 1);
                return ((List)subject).subList(i1, i2);
            }
            if (index >= len) {
                return null;
            }
            if (index < 0) {
                return null;
            }
            return ((List)subject).get(index);
        }
        if (subject instanceof IPrimitiveArray) {
            IPrimitiveArray array = (IPrimitiveArray)subject;
            int len = array.getLength();
            if (range) {
                int i1 = this.normalize(index, len, 0);
                int i2 = this.normalize(index2, len, 1);
                return new PrimitiveArraySubList(array, i1, i2);
            }
            if (index >= len) {
                return null;
            }
            if (index < 0) {
                return null;
            }
            return array.getValueAt(index);
        }
        if (subject instanceof IObjectArray) {
            IObjectArray array = (IObjectArray)subject;
            int len = array.getLength();
            if (range) {
                int i1 = this.normalize(index, len, 0);
                int i2 = this.normalize(index2, len, 1);
                return new ObjectArraySubList(array, i1, i2);
            }
            if (index >= len) {
                return null;
            }
            if (index < 0) {
                return null;
            }
            long addr = array.getReferenceArray(index, 1)[0];
            if (addr == 0L) {
                return null;
            }
            ISnapshot snapshot = array.getSnapshot();
            int objectId = snapshot.mapAddressToId(addr);
            return snapshot.getObject(objectId);
        }
        throw new IllegalArgumentException(subject + this.toString() + ": " + subject.getClass());
    }

    private int evalIndex(Object indexObj) {
        if (!(indexObj instanceof Integer || indexObj instanceof Short || indexObj instanceof Byte)) {
            throw new IllegalArgumentException(String.valueOf(this.toString()) + ": " + (indexObj != null ? indexObj.getClass() : null));
        }
        int index = ((Number)indexObj).intValue();
        return index;
    }

    private int normalize(int i, int s, int a) {
        if (i < 0) {
            i += s;
        }
        if ((i += a) > s) {
            i = s;
        }
        if (i < 0) {
            i = 0;
        }
        return i;
    }

    @Override
    public boolean isContextDependent(EvaluationContext ctx) {
        for (Expression element : this.parameters) {
            boolean isContextDependent = element.isContextDependent(ctx);
            if (!isContextDependent) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("[");
        Iterator<Expression> iter = this.parameters.iterator();
        while (iter.hasNext()) {
            Expression element = iter.next();
            buf.append(element);
            if (!iter.hasNext()) continue;
            buf.append(":");
        }
        buf.append("]");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArraySubList
    extends AbstractList<Object> {
        private final Object subject;
        private final int i1;
        private final int i2;

        private ArraySubList(Object subject, int i1, int i2) {
            this.subject = subject;
            this.i1 = i1;
            this.i2 = i2;
        }

        @Override
        public Object get(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            return Array.get(this.subject, this.i1 + index);
        }

        @Override
        public int size() {
            return this.i2 - this.i1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectArraySubList
    extends AbstractList<Object> {
        private final IObjectArray array;
        private final int i1;
        private final int i2;

        public ObjectArraySubList(IObjectArray array, int i1, int i2) {
            this.array = array;
            this.i1 = i1;
            this.i2 = i2;
        }

        @Override
        public Object get(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            long addr = this.array.getReferenceArray(this.i1 + index, 1)[0];
            if (addr == 0L) {
                return null;
            }
            ISnapshot snapshot = this.array.getSnapshot();
            try {
                int objectId = snapshot.mapAddressToId(addr);
                return snapshot.getObject(objectId);
            }
            catch (SnapshotException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public int size() {
            return this.i2 - this.i1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrimitiveArraySubList
    extends AbstractList<Object> {
        private final IPrimitiveArray array;
        private final int i1;
        private final int i2;

        private PrimitiveArraySubList(IPrimitiveArray array, int i1, int i2) {
            this.array = array;
            this.i1 = i1;
            this.i2 = i2;
        }

        @Override
        public Object get(int index) {
            if (index < 0 || index >= this.size()) {
                throw new IndexOutOfBoundsException(Integer.toString(index));
            }
            return this.array.getValueAt(this.i1 + index);
        }

        @Override
        public int size() {
            return this.i2 - this.i1;
        }
    }
}

