/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.threads;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.inspections.threads.ThreadInfoImpl;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.DetailResultProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IStackFrame;
import org.eclipse.mat.snapshot.model.IThreadStack;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="thread_overview")
@Icon(value="/META-INF/icons/threads.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingthreads.html")
public class ThreadOverviewQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(isMandatory=false, flag="none")
    public IHeapObjectArgument objects;
    private static URL THREAD_ICON_URL = Icons.getURL("threads.gif");
    public static final String CLASS_THREAD = "java.lang.Thread";

    public IResult execute(IProgressListener listener) throws Exception {
        listener.subTask(Messages.ThreadOverviewQuery_SearchingThreads);
        ArrayList<ThreadOverviewNode> result = new ArrayList<ThreadOverviewNode>();
        if (this.objects != null) {
            Iterator iterator = this.objects.iterator();
            while (iterator.hasNext()) {
                int[] objectIds;
                int[] nArray = objectIds = (int[])iterator.next();
                int n = objectIds.length;
                int n2 = 0;
                while (n2 < n) {
                    int objectId = nArray[n2];
                    if (ThreadOverviewQuery.isThread(this.snapshot, objectId)) {
                        result.add(this.buildThreadOverviewNode(objectId, listener));
                    }
                    ++n2;
                }
            }
        } else {
            Collection<IClass> classes = this.snapshot.getClassesByName(CLASS_THREAD, true);
            if (classes != null) {
                for (IClass clasz : classes) {
                    int[] nArray = clasz.getObjectIds();
                    int n = nArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        int id = nArray[n3];
                        result.add(this.buildThreadOverviewNode(id, listener));
                        ++n3;
                    }
                }
            }
        }
        Collections.sort(result, new Comparator<ThreadOverviewNode>(){

            @Override
            public int compare(ThreadOverviewNode o1, ThreadOverviewNode o2) {
                return o1.threadInfo.getRetainedHeap().getValue() > o2.threadInfo.getRetainedHeap().getValue() ? -1 : (o1.threadInfo.getRetainedHeap().getValue() == o2.threadInfo.getRetainedHeap().getValue() ? 0 : 1);
            }
        });
        if (result.isEmpty()) {
            return null;
        }
        return new ThreadInfoList(this.snapshot, result);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isThread(ISnapshot snapshot, int objectId) throws SnapshotException {
        block1: {
            obj = snapshot.getObject(objectId);
            cls = obj.getClazz();
            if (cls == null) break block1;
            className = cls.getName();
            if (!"java.lang.Thread".equals(className)) ** GOTO lbl10
            return true;
lbl-1000:
            // 1 sources

            {
                className = (cls = cls.getSuperClass()).getName();
                if (!"java.lang.Thread".equals(className)) continue;
                return true;
lbl10:
                // 2 sources

                ** while (cls.hasSuperClass())
            }
        }
        return false;
    }

    private ThreadOverviewNode buildThreadOverviewNode(int objectId, IProgressListener listener) throws SnapshotException {
        IStackFrame[] frames;
        ThreadOverviewNode result = new ThreadOverviewNode();
        result.threadInfo = ThreadInfoImpl.build(this.snapshot.getObject(objectId), false, listener);
        result.stack = this.snapshot.getThreadStack(objectId);
        if (result.stack != null && (frames = result.stack.getStackFrames()) != null) {
            SetInt roots = new SetInt();
            IStackFrame[] iStackFrameArray = frames;
            int n = frames.length;
            int n2 = 0;
            while (n2 < n) {
                IStackFrame IStackFrame2 = iStackFrameArray[n2];
                int[] objects = IStackFrame2.getLocalObjectsIds();
                if (objects != null) {
                    int[] nArray = objects;
                    int n3 = objects.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int i = nArray[n4];
                        roots.add(i);
                        ++n4;
                    }
                }
                ++n2;
            }
            result.stackRoots = roots.toArray();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThreadInfoList
    implements IResultTree,
    IIconProvider,
    IDecorator {
        ISnapshot snapshot;
        List<ThreadOverviewNode> infos;
        Column[] columns;
        HashMapIntObject<Object> root2element;
        ObjectListResult.Outbound objectList;
        int[] colMap;

        public ThreadInfoList(ISnapshot snapshot, List<ThreadOverviewNode> infos) {
            this.snapshot = snapshot;
            this.infos = infos;
            ArrayList<ThreadInfoImpl> threadInfos = new ArrayList<ThreadInfoImpl>(infos.size());
            ArrayInt roots = new ArrayInt();
            for (ThreadOverviewNode node : infos) {
                threadInfos.add(node.threadInfo);
                if (node.stackRoots == null) continue;
                roots.addAll(node.stackRoots);
            }
            this.columns = ThreadInfoImpl.getUsedColumns(threadInfos).toArray(new Column[0]);
            this.columns[0].decorator((IDecorator)this).comparing((Comparator)new NoCompareComparator());
            this.root2element = new HashMapIntObject();
            this.objectList = new ObjectListResult.Outbound(snapshot, roots.toArray());
            for (ThreadOverviewNode o : this.objectList.getElements()) {
                this.root2element.put(this.objectList.getContext(o).getObjectId(), (Object)o);
            }
            this.colMap = new int[this.columns.length];
            Column[] objColumns = this.objectList.getColumns();
            int i = 0;
            while (i < this.columns.length) {
                this.colMap[i] = i == 0 ? 0 : -1;
                int j = 0;
                while (j < objColumns.length) {
                    if (this.columns[i].equals((Object)objColumns[j])) {
                        this.colMap[i] = j;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }

        public ResultMetaData getResultMetaData() {
            return new ResultMetaData.Builder().addDetailResult(new DetailResultProvider(Messages.ThreadOverviewQuery_ThreadDetails){

                public boolean hasResult(Object row) {
                    if (!(row instanceof ThreadOverviewNode)) {
                        return false;
                    }
                    try {
                        InspectionAssert.heapFormatIsNot(ThreadInfoList.this.snapshot, "phd");
                        return true;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        return false;
                    }
                }

                public URL getIcon() {
                    try {
                        return SnapshotQuery.lookup("thread_details", ThreadInfoList.this.snapshot).getDescriptor().getIcon();
                    }
                    catch (SnapshotException snapshotException) {
                        return null;
                    }
                }

                public IResult getResult(Object row, IProgressListener listener) throws SnapshotException {
                    int threadId = ((ThreadOverviewNode)row).threadInfo.getThreadId();
                    return SnapshotQuery.lookup("thread_details", ThreadInfoList.this.snapshot).setArgument("threadIds", threadId).execute(listener);
                }
            }).build();
        }

        public Column[] getColumns() {
            return this.columns;
        }

        public Object getColumnValue(Object row, int columnIndex) {
            if (row instanceof ThreadOverviewNode) {
                ThreadOverviewNode info = (ThreadOverviewNode)row;
                return info.threadInfo.getValue(this.columns[columnIndex]);
            }
            if (row instanceof IStackFrame) {
                switch (columnIndex) {
                    case 0: {
                        IStackFrame frame = (IStackFrame)row;
                        return frame.getText();
                    }
                }
            } else {
                int newColumnIndex = this.colMap[columnIndex];
                if (newColumnIndex >= 0) {
                    return this.objectList.getColumnValue(row, newColumnIndex);
                }
            }
            return null;
        }

        public IContextObject getContext(final Object row) {
            if (row instanceof ThreadOverviewNode) {
                return new IContextObject(){

                    public int getObjectId() {
                        return ((ThreadOverviewNode)row).threadInfo.getThreadId();
                    }
                };
            }
            if (row instanceof IStackFrame) {
                return null;
            }
            return this.objectList.getContext(row);
        }

        public URL getIcon(Object row) {
            if (row instanceof ThreadOverviewNode) {
                return THREAD_ICON_URL;
            }
            if (row instanceof IStackFrame) {
                return null;
            }
            return this.objectList.getIcon(row);
        }

        public String prefix(Object row) {
            if (row instanceof ThreadOverviewNode) {
                return null;
            }
            if (row instanceof IStackFrame) {
                return null;
            }
            String prefix = this.objectList.prefix(row);
            return prefix == null ? Messages.ThreadStackQuery_Label_Local : prefix;
        }

        public String suffix(Object row) {
            if (row instanceof ThreadOverviewNode) {
                return null;
            }
            if (row instanceof IStackFrame) {
                return null;
            }
            return this.objectList.suffix(row);
        }

        public List<?> getElements() {
            return this.infos;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ThreadOverviewNode) {
                IThreadStack stack = ((ThreadOverviewNode)element).stack;
                if (stack == null) {
                    return false;
                }
                IStackFrame[] frames = stack.getStackFrames();
                return frames != null && frames.length > 0;
            }
            if (element instanceof IStackFrame) {
                IStackFrame frame = (IStackFrame)element;
                int[] objectIds = frame.getLocalObjectsIds();
                return objectIds != null && objectIds.length > 0;
            }
            return this.objectList.hasChildren(element);
        }

        public List<?> getChildren(Object parent) {
            IStackFrame frame;
            int[] localIds;
            if (parent instanceof ThreadOverviewNode) {
                IStackFrame[] frames = ((ThreadOverviewNode)parent).stack.getStackFrames();
                return Arrays.asList(frames);
            }
            if (parent instanceof IStackFrame && (localIds = (frame = (IStackFrame)parent).getLocalObjectsIds()) != null) {
                return this.asList(localIds);
            }
            return this.objectList.getChildren(parent);
        }

        private List<?> asList(int[] objectIds) {
            ArrayList<Object> answer = new ArrayList<Object>(objectIds.length);
            int[] nArray = objectIds;
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                answer.add(this.root2element.get(id));
                ++n2;
            }
            return answer;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class NoCompareComparator
        implements Comparator<Object> {
            NoCompareComparator() {
            }

            @Override
            public int compare(Object o1, Object o2) {
                return 0;
            }
        }
    }

    private class ThreadOverviewNode {
        private ThreadInfoImpl threadInfo;
        private IThreadStack stack;
        private int[] stackRoots;

        private ThreadOverviewNode() {
        }
    }
}

